/*
 * (C) Copyright 2007-2013
 * Allwinner Technology Co., Ltd. <www.allwinnertech.com>
 * Jerry Wang <wangflord@allwinnertech.com>
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */
#include <config.h>
#include <common.h>
#include <malloc.h>
#include <asm/arch/queue.h>
#include "sprite_queue.h"

static queue  *Q;
/*
************************************************************************************************************
*
*                                             function
*
*    name          :
*
*    parmeters     :
*
*    return        :
*
*    note          :
*
*
************************************************************************************************************
*/
int sunxi_queue_init(void)
{
	Q = (queue *)malloc(sizeof(queue));
	if(!Q)
	{
		printf("malloc memory for sunxi queue failed\n");

		return -1;
	}
	initqueue(Q, SUNXI_BUFFER_QUEUE_COUNT, SUNXI_BUFFER_QUEUE_SIZE);

	return 0;
}
/*
************************************************************************************************************
*
*                                             function
*
*    name          :
*
*    parmeters     :
*
*    return        :
*
*    note          :
*
*
************************************************************************************************************
*/
void sunxi_queue_destroy(void)
{
	destroyqueue(Q);
}
/*
************************************************************************************************************
*
*                                             function
*
*    name          :
*
*    parmeters     :
*
*    return        :
*
*    note          :
*
*
************************************************************************************************************
*/
void sunxi_queue_reset(void)
{
	resetqueue(Q);
}
/*
************************************************************************************************************
*
*                                             function
*
*    name          :
*
*    parmeters     :
*
*    return        :
*
*    note          : 查询buffer是否为空
*
*
************************************************************************************************************
*/
int sunxi_queue_isempty(void)
{
	return isqueueempty(Q);
}
/*
************************************************************************************************************
*
*                                             function
*
*    name          :
*
*    parmeters     :
*
*    return        :
*
*    note          : 查询buffer是否已满
*
*
************************************************************************************************************
*/
int sunxi_queue_isfull(void)
{
	return isqueuefull(Q);
}
/*
************************************************************************************************************
*
*                                             function
*
*    name          :
*
*    parmeters     :
*
*    return        :
*
*    note          :  获取一个buffer
*
*
************************************************************************************************************
*/
int sunxi_inqueue_query(queue_data *qdata)
{
	return inqueue_query(Q, qdata);
}
/*
************************************************************************************************************
*
*                                             function
*
*    name          :
*
*    parmeters     :
*
*    return        :
*
*    note          :
*
*
************************************************************************************************************
*/
int sunxi_queue_in(void)
{
	return inqueue_ex(Q);
}
/*
************************************************************************************************************
*
*                                             function
*
*    name          :
*
*    parmeters     :
*
*    return        :
*
*    note          :
*
*
************************************************************************************************************
*/
int sunxi_outqueue_query(queue_data *qdata, queue_data *next_qdata)
{
	return outqueue_query(Q, qdata, next_qdata);
}
/*
************************************************************************************************************
*
*                                             function
*
*    name          :
*
*    parmeters     :
*
*    return        :
*
*    note          :
*
*
************************************************************************************************************
*/
int sunxi_queue_out(void)
{
	return outqueue_ex(Q);
}
