//*****************************************************************************
//  All Winner Micro, All Right Reserved. 2006-2012 Copyright (c)
//
//  File name   :        sat.c
//
//  Description :
//  History     : 2013-12-26 15:01:40
//
//******************************************************************************

#include "sat.h"

static __sa_reg *sat_dev[2];

static __u32 sat_csc_tab[24] =
{
	0x0400,0x0000,0x064D,0xF366,0x0400,0xFFFFFF41,0xFFFFFE21,0x053D,0x0400,0x076D,0x0000,0xF127,//yuv2rgb
	0x0400,0x0000,0x0000,0x0000,0x0000,0x0400,0x0000,0x0000,0x0000,0x0000,0x0400,0x0000 //rgb2rgb
};

__u8 TABLE_CB[5][256]={
	{0,0,1,2,3,4,5,6,7,8,9,9,10,11,12,13,14,15,16,17,18,19,19,20,21,22,23,24,25,26,27,28,29,30,31,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,102,103,105,106,107,108,109,110,111,112,113,115,116,117,118,119,121,122,123,124,126,129,130,131,132,133,134,136,137,138,139,140,142,143,144,145,146,147,148,149,150,152,153,154,155,156,157,158,159,160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,208,209,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,224,224,225,226,227,228,229,230,231,232,233,234,235,236,236,237,238,239,240,241,242,243,244,245,246,246,247,248,249,250,251,252,253,254,255},
	{0,0,1,2,3,4,5,6,7,8,9,9,10,11,12,13,13,14,15,16,17,18,18,19,20,21,22,23,24,25,26,27,28,29,30,30,31,32,33,34,35,36,36,37,38,39,40,41,42,43,44,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,81,82,83,84,85,86,87,89,90,91,92,94,95,96,97,98,99,100,101,102,103,105,106,107,108,108,109,111,111,113,114,115,116,117,118,120,121,122,124,126,129,130,132,133,135,136,138,139,140,141,142,144,145,146,147,149,150,151,152,153,154,156,157,158,159,160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,192,193,194,195,196,197,198,199,200,201,202,203,204,204,205,206,207,208,209,210,211,212,213,213,214,215,216,217,218,219,220,221,222,223,224,225,226,226,227,228,229,230,231,232,232,233,234,235,236,237,237,238,239,240,241,242,243,244,245,246,247,247,248,249,250,251,251,252,253,254,255},
	{0,0,1,2,3,4,5,6,7,8,8,9,9,10,11,12,12,13,14,15,16,17,17,18,19,20,21,22,22,23,24,25,26,27,28,28,29,30,31,32,33,34,34,35,36,37,38,39,40,40,41,42,43,44,45,46,47,48,49,49,50,51,52,53,54,55,56,57,58,59,60,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,78,79,80,82,83,84,85,87,88,90,91,93,94,95,96,97,98,100,101,102,102,104,105,106,107,107,108,110,110,112,112,113,114,115,116,118,120,121,123,125,128,130,132,134,136,137,139,140,141,143,144,145,147,148,149,151,152,153,154,155,156,158,159,160,161,162,163,164,165,167,168,169,170,171,172,173,174,175,176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,192,193,194,195,195,196,197,198,199,200,201,202,203,204,205,206,206,207,208,209,210,211,212,213,214,215,215,216,217,218,219,220,221,221,222,223,224,225,226,227,227,228,229,230,231,232,233,233,234,235,236,237,238,238,239,240,241,242,243,243,244,245,246,247,247,248,249,250,251,251,252,253,254,255},
	{0,0,1,2,3,4,5,5,6,7,8,8,9,10,10,11,12,13,13,14,15,16,16,17,18,19,20,21,21,22,23,24,25,26,26,27,28,29,29,30,31,32,33,33,34,35,36,37,38,38,39,40,41,42,43,44,45,46,47,47,48,49,50,51,52,53,53,54,55,56,57,58,59,60,61,61,62,64,64,65,66,67,68,69,70,71,72,73,75,76,77,79,80,81,82,84,85,87,88,90,92,93,94,95,96,98,99,100,100,102,103,104,105,105,106,108,108,110,110,111,112,113,114,116,118,120,122,124,128,130,132,134,137,138,140,142,143,145,146,147,149,150,151,153,154,155,157,158,159,160,162,163,164,165,166,167,168,170,171,172,173,174,175,176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,192,193,194,195,195,196,197,198,199,200,201,202,203,203,204,205,206,207,208,209,209,210,211,212,213,214,215,216,217,217,218,219,220,221,222,223,223,224,225,226,227,227,228,229,230,230,231,232,233,234,234,235,236,237,238,239,239,240,241,242,243,244,244,245,246,247,248,248,249,250,251,251,252,252,253,254,255},
	{0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255},
};

__u8 TABLE_CR[5][256]={
	{0,0,1,2,3,4,5,6,7,8,9,9,10,11,12,13,14,15,16,17,18,19,19,20,21,22,23,24,25,26,27,28,29,30,31,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,102,103,105,106,107,108,109,110,111,112,113,115,116,117,118,119,121,122,123,124,126,129,130,131,132,133,134,136,137,138,139,140,142,143,144,145,146,147,148,149,150,152,153,154,155,156,157,158,159,160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,208,209,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,224,224,225,226,227,228,229,230,231,232,233,234,235,236,236,237,238,239,240,241,242,243,244,245,246,246,247,248,249,250,251,252,253,254,255},
	{0,0,1,2,3,4,5,6,7,8,9,9,10,11,12,13,13,14,15,16,17,18,18,19,20,21,22,23,24,25,26,27,28,29,30,30,31,32,33,34,35,36,36,37,38,39,40,41,42,43,44,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,93,94,95,96,97,98,99,100,101,103,104,105,106,107,108,109,110,112,113,114,116,117,118,120,121,122,124,126,129,130,132,133,135,136,138,139,140,141,142,143,144,145,146,147,148,149,150,151,153,153,154,156,157,158,159,160,161,163,164,165,167,168,169,170,171,172,173,174,175,176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,192,193,194,195,196,197,198,199,200,201,202,203,204,204,205,206,207,208,209,210,211,212,213,213,214,215,216,217,218,219,220,221,222,223,224,225,226,226,227,228,229,230,231,232,232,233,234,235,236,237,237,238,239,240,241,242,243,244,245,246,247,247,248,249,250,251,251,252,253,254,255},
	{0,0,1,2,3,4,5,6,7,8,8,9,9,10,11,12,12,13,14,15,16,17,17,18,19,20,21,22,22,23,24,25,26,27,28,28,29,30,31,32,33,34,34,35,36,37,38,39,40,40,41,42,43,44,45,46,47,48,49,49,50,51,52,53,54,55,56,57,58,59,60,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,90,91,92,93,94,95,96,97,99,100,101,102,103,104,106,107,108,110,111,112,114,115,116,118,120,121,123,125,128,130,132,134,136,137,139,140,141,143,144,144,145,146,147,148,149,149,150,151,153,153,154,156,157,158,160,161,162,164,166,167,169,170,172,173,174,175,176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,192,193,194,195,195,196,197,198,199,200,201,202,203,204,205,206,206,207,208,209,210,211,212,213,214,215,215,216,217,218,219,220,221,221,222,223,224,225,226,227,227,228,229,230,231,232,233,233,234,235,236,237,238,238,239,240,241,242,243,243,244,245,246,247,247,248,249,250,251,251,252,253,254,255},
	{0,0,1,2,3,4,5,5,6,7,8,8,9,10,10,11,12,13,13,14,15,16,16,17,18,19,20,21,21,22,23,24,25,26,26,27,28,29,29,30,31,32,33,33,34,35,36,37,38,38,39,40,41,42,43,44,45,46,47,47,48,49,50,51,52,53,53,54,55,56,57,58,59,60,61,61,62,64,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,87,88,89,90,91,92,93,94,96,97,98,99,101,102,103,105,106,108,109,110,112,113,114,116,118,120,122,124,128,130,132,134,137,138,140,142,143,145,146,146,147,148,149,150,151,152,153,154,155,156,157,159,160,161,163,164,165,167,169,170,172,173,175,176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,192,193,194,195,195,196,197,198,199,200,201,202,203,203,204,205,206,207,208,209,209,210,211,212,213,214,215,216,217,217,218,219,220,221,222,223,223,224,225,226,227,227,228,229,230,230,231,232,233,234,234,235,236,237,238,239,239,240,241,242,243,244,244,245,246,247,248,248,249,250,251,251,252,252,253,254,255},
	{0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255},
};

__u8  enable_flag[2]={0,0};
__u32 Display_width[2]={0,0};
__u32 Display_height[2]={0,0};
__u32 Top[2]={0,0};
__u32 Left[2]={0,0};
__u32 Bot[2]={0,0};
__u32 Right[2]={0,0};

__s32 SAT_Set_Reg_Base(__u32 sel, __u32 base)
{
	sat_dev[sel] = (__sa_reg *)base;
	return 0;
}

__u32 SAT_Get_Reg_Base(__u32 sel)
{
	__u32 ret = 0;
	ret = (__u32)sat_dev[sel];
	return ret;
}

//*****************************************************************************************************************************
// function			: SAT_Enable_Disable( __u32 en)
// description		: sat enable or disable setting
// parameters		:
//					en (1:enable  0:disable)
// return			: 0 <success>
//					 -1 <failed>
//*****************************************************************************************************************************

__s32 SAT_Enable_Disable( __u32 sel,__u32 en)
{
	enable_flag[sel] = en;
	return 0;
}

//*****************************************************************************************************************************
// function			: SAT_Set_Display_Size( __u32 width,__u32 height)
// description		: sat display size parameter setting
// parameters		:
//					width <sat display width >
//					height <sat display height >
// return			: 0 <success>
//					 -1 <failed>
//*****************************************************************************************************************************

__s32 SAT_Set_Display_Size( __u32 sel,__u32 width,__u32 height)
{
	Display_width[sel] = width;
	Display_height[sel]= height;

	return 0;
}

//*****************************************************************************************************************************
// function			: SAT_Set_Winodw( __disp_rect_t *window)
// description		: sat clip window parameter setting
// parameters		:
//					window.x <sat clip window, left-top x coordinate of input image in pixels>
//					window.y <sat clip window, left-top y coordinate of input image in pixels>
//					window.width <sat clip window width in pixels>
//					window.height <sat clip window height in pixels>
// return			: 0 <success>
//					 -1 <failed>
//*****************************************************************************************************************************

__s32 SAT_Set_Window(__u32 sel, disp_window *window)
{
	//convert rectangle to register
	Top[sel] = window->y;
	Bot[sel] = window->y + window->height - 1;
	Left[sel] = window->x;
	Right[sel] = window->x + window->width - 1;

	return 0;
}

//*****************************************************************************************************************************
// function			: SAT_Set_Sync_Para(__u32 sel)
// description		: sat parameter configure
// parameters		:
//					sel
// return			: 0 <success>
//					 -1 <failed>
//*****************************************************************************************************************************

__s32 SAT_Set_Sync_Para(__u32 sel)
{
	__u32 i,sac_num,threshold_A,threshold_B,threshold_C;
	__u32 *ptcsctab;
    i=sac_num=threshold_A=threshold_B=threshold_C=0;

	sat_dev[sel]->saglobal.dwval = sat_dev[sel]->saglobal.dwval | 0x10000;

	sat_dev[sel]->sacsize.dwval = (sat_dev[sel]->sacsize.dwval & 0xf0000f0000) |
									(((Display_height[sel]-1) << 16) | (Display_width[sel]-1));
	sat_dev[sel]->sacwin0.dwval = sat_dev[sel]->sacwin0.dwval & 0xf000f000;
	sat_dev[sel]->sacwin1.dwval = (sat_dev[sel]->sacwin1.dwval & 0xf000f000) |
									(((Display_height[sel]-1) << 16) | (Display_width[sel]-1));

	sat_dev[sel]->lowsat.dwval = (sat_dev[sel]->lowsat.dwval >> 6) << 6 | 0x18;

	sat_dev[sel]->satwin0.dwval = (sat_dev[sel]->satwin0.dwval & 0xf000f000) | ((Top[sel] << 16) | Left[sel]);

	sat_dev[sel]->satwin1.dwval = (sat_dev[sel]->satwin1.dwval & 0xf000f000) | ((Bot[sel] << 16) | Right[sel]);

	if (enable_flag[sel]==1)
	{
		//  SAT/SAC/GLOBAL EN  OPEN
		sat_dev[sel]->saglobal.dwval = sat_dev[sel]->saglobal.dwval | 0x1;
		sat_dev[sel]->sacctrl.dwval = sat_dev[sel]->sacctrl.dwval | 0x1;
		sat_dev[sel]->satctrl.dwval = sat_dev[sel]->satctrl.dwval | 0x1;

		sac_num = sat_dev[sel]->R_num.dwval & 0x3f;
		threshold_A=(Display_width[sel]*Display_height[sel]*12)>>4;
		threshold_B=(Display_width[sel]*Display_height[sel]*8)>>4;
		threshold_C=(Display_width[sel]*Display_height[sel]*5)>>4;

		// csc
		ptcsctab = &(sat_csc_tab[0]);

		sat_dev[sel]->cscgcoff[0].dwval = ((sat_dev[sel]->cscgcoff[0].dwval >> 13) << 13) | ((*ptcsctab) & 0x1fff);
		sat_dev[sel]->cscgcoff[1].dwval = ((sat_dev[sel]->cscgcoff[1].dwval >> 13) << 13) | ((*(ptcsctab + 1)) & 0x1fff);
		sat_dev[sel]->cscgcoff[2].dwval = ((sat_dev[sel]->cscgcoff[2].dwval >> 13) << 13) | ((*(ptcsctab + 2)) & 0x1fff);
		sat_dev[sel]->cscgcon.dwval = ((sat_dev[sel]->cscgcon.dwval >> 14) << 14) | ((*(ptcsctab+3)) & 0x3fff);
		sat_dev[sel]->cscrcoff[0].dwval = ((sat_dev[sel]->cscrcoff[0].dwval >> 13) << 13) | ((*(ptcsctab + 4)) & 0x1fff);
		sat_dev[sel]->cscrcoff[1].dwval = ((sat_dev[sel]->cscrcoff[1].dwval >> 13) << 13) | ((*(ptcsctab + 5)) & 0x1fff);
		sat_dev[sel]->cscrcoff[2].dwval = ((sat_dev[sel]->cscrcoff[1].dwval >> 13) << 13) | ((*(ptcsctab + 6)) & 0x1fff);
		sat_dev[sel]->cscrcon.dwval = ((sat_dev[sel]->cscrcon.dwval >> 14) << 14) | ((*(ptcsctab + 7)) & 0x3fff);
		sat_dev[sel]->cscbcoff[0].dwval = ((sat_dev[sel]->cscbcoff[0].dwval >> 13) << 13) | ((*(ptcsctab + 8)) & 0x1fff);
		sat_dev[sel]->cscbcoff[1].dwval = ((sat_dev[sel]->cscbcoff[1].dwval >> 13) << 13) | ((*(ptcsctab + 9)) & 0x1fff);
		sat_dev[sel]->cscbcoff[2].dwval = ((sat_dev[sel]->cscbcoff[2].dwval >> 13) << 13) | ((*(ptcsctab + 10)) & 0x1fff);
		sat_dev[sel]->cscbcon.dwval = ((sat_dev[sel]->cscbcon.dwval >> 14) << 14) | ((*(ptcsctab + 11)) & 0x3fff);

		if (sac_num>threshold_A)
		{
			for(i=0;i<64;i++)
			{
				sat_dev[sel]->satcbtab[i].dwval 	  = TABLE_CB[0][4*i] | (TABLE_CB[3][4*i+1]<<8)
											      |(TABLE_CB[0][4*i+2]<<16) | (TABLE_CB[3][4*i+3]<<24);				
			}
			for(i=0;i<64;i++)
			{
				sat_dev[sel]->satcrtab[i].dwval 	  = TABLE_CR[0][4*i] | (TABLE_CR[3][4*i+1]<<8)
											      |(TABLE_CR[0][4*i+2]<<16) | (TABLE_CR[3][4*i+3]<<24);	
			}
		}
		else if(sac_num>threshold_B && sac_num<=threshold_A)
		{
			for(i=0;i<64;i++)
			{
				sat_dev[sel]->satcbtab[i].dwval 	  = TABLE_CB[1][4*i] | (TABLE_CB[2][4*i+1]<<8)
											      |(TABLE_CB[1][4*i+2]<<16) | (TABLE_CB[2][4*i+3]<<24);
			}
			for(i=0;i<64;i++)
			{
				sat_dev[sel]->satcrtab[i].dwval 	  = TABLE_CR[1][4*i] | (TABLE_CR[2][4*i+1]<<8)
											      |(TABLE_CR[1][4*i+2]<<16) | (TABLE_CR[2][4*i+3]<<24);				
			}
		}
		else if(sac_num>threshold_C && sac_num<=threshold_B)
		{
			for(i=0;i<64;i++)
			{
				sat_dev[sel]->satcbtab[i].dwval 	  = TABLE_CB[2][4*i] | (TABLE_CB[1][4*i+1]<<8)
											      |(TABLE_CB[2][4*i+2]<<16) | (TABLE_CB[1][4*i+3]<<24);
			}
			for(i=0;i<64;i++)
			{
				sat_dev[sel]->satcrtab[i].dwval 	  = TABLE_CR[2][4*i] | (TABLE_CR[1][4*i+1]<<8)
											      |(TABLE_CR[2][4*i+2]<<16) | (TABLE_CR[1][4*i+3]<<24);
			}
		}
		else
		{
			for(i=0;i<64;i++)
			{
				sat_dev[sel]->satcbtab[i].dwval 	  = TABLE_CB[3][4*i] | (TABLE_CB[0][4*i+1]<<8)
											      |(TABLE_CB[3][4*i+2]<<16) | (TABLE_CB[0][4*i+3]<<24);
			}
			for(i=0;i<64;i++)
			{
				sat_dev[sel]->satcrtab[i].dwval 	  = TABLE_CR[3][4*i] | (TABLE_CR[0][4*i+1]<<8)
											      |(TABLE_CR[3][4*i+2]<<16) | (TABLE_CR[0][4*i+3]<<24);
			}
		}
	}
	else
	{
		//  SAT/SAC/GLOBAL EN  OPEN
		sat_dev[sel]->saglobal.dwval = sat_dev[sel]->saglobal.dwval & 0xfffffffe;
		sat_dev[sel]->sacctrl.dwval = sat_dev[sel]->sacctrl.dwval & 0xfffffffe;
		sat_dev[sel]->satctrl.dwval = sat_dev[sel]->satctrl.dwval & 0xfffffffe;
	}

	sat_dev[sel]->saglobal.dwval = sat_dev[sel]->saglobal.dwval & 0xfffeffff;
	return 0;
}

