/*
 * (C) Copyright 2007-2013
 * Allwinner Technology Co., Ltd. <www.allwinnertech.com>
 * Jerry Wang <wangflord@allwinnertech.com>
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#ifndef	_DMA_H_
#define	_DMA_H_

#include <asm/arch/intc.h>

//================================
//======    DMA      =========
//================================

/* DMA   */
#define DMAC_CFG_CONTINUOUS_ENABLE              (0x01)
#define DMAC_CFG_CONTINUOUS_DISABLE             (0x00)

/* DMA ĿĶ  */
/* DMA ĿĶ  */
#define	DMAC_CFG_DEST_DATA_WIDTH_8BIT			(0x00)
#define	DMAC_CFG_DEST_DATA_WIDTH_16BIT			(0x01)
#define	DMAC_CFG_DEST_DATA_WIDTH_32BIT			(0x02)

/* DMA ĿĶ ͻģʽ */
#define	DMAC_CFG_DEST_1_BURST       			(0x00)
#define	DMAC_CFG_DEST_4_BURST		    		(0x01)
#define	DMAC_CFG_DEST_8_BURST					(0x02)

/* DMA ĿĶ ַ仯ģʽ */
#define	DMAC_CFG_DEST_ADDR_TYPE_LINEAR_MODE		(0x00)
#define	DMAC_CFG_DEST_ADDR_TYPE_IO_MODE 		(0x01)


/* DMA Դ  */
/* DMA Դ  */
#define	DMAC_CFG_SRC_DATA_WIDTH_8BIT			(0x00)
#define	DMAC_CFG_SRC_DATA_WIDTH_16BIT			(0x01)
#define	DMAC_CFG_SRC_DATA_WIDTH_32BIT			(0x02)

/* DMA Դ ͻģʽ */
#define	DMAC_CFG_SRC_1_BURST       				(0x00)
#define	DMAC_CFG_SRC_4_BURST		    		(0x01)
#define	DMAC_CFG_SRC_8_BURST		    		(0x02)

/* DMA Դ ַ仯ģʽ */
#define	DMAC_CFG_SRC_ADDR_TYPE_LINEAR_MODE		(0x00)
#define	DMAC_CFG_SRC_ADDR_TYPE_IO_MODE 			(0x01)


/* DMA ĿĶ  */
#define	DMAC_CFG_DEST_TYPE_SRAM					(0x00)
#define	DMAC_CFG_DEST_TYPE_DRAM		    		(0x01)

#define DMAC_CFG_DEST_TYPE_NAND					(5)

#define	DMAC_CFG_DEST_TYPE_CODEC	    		(15)

#define	DMAC_CFG_DEST_TYPE_OTG_EP1	    		(17)
#define	DMAC_CFG_DEST_TYPE_OTG_EP2	    		(18)
#define	DMAC_CFG_DEST_TYPE_OTG_EP3	    		(19)
#define	DMAC_CFG_DEST_TYPE_OTG_EP4	    		(20)
#define	DMAC_CFG_DEST_TYPE_OTG_EP5	    		(21)
/* DMA Դ  */
#define	DMAC_CFG_SRC_TYPE_SRAM					(0x00)
#define	DMAC_CFG_SRC_TYPE_DRAM		    	   	(0x01)

#define DMAC_CFG_SRC_TYPE_NAND					(5)

#define	DMAC_CFG_SRC_TYPE_CODEC	    			(15)

#define	DMAC_CFG_SRC_TYPE_OTG_EP1	    		(17)
#define	DMAC_CFG_SRC_TYPE_OTG_EP2	    		(18)
#define	DMAC_CFG_SRC_TYPE_OTG_EP3	    		(19)
#define	DMAC_CFG_SRC_TYPE_OTG_EP4	    		(20)
#define	DMAC_CFG_SRC_TYPE_OTG_EP5	    		(21)


typedef struct
{
	unsigned int config;
	unsigned int source_addr;
	unsigned int dest_addr;
	unsigned int byte_count;
	unsigned int commit_para;
	unsigned int link;
	unsigned int reserved[2];
}
sunxi_dma_start_t;


typedef struct
{
    unsigned int      src_drq_type     : 5;            //Դַ洢ͣDRAM, SPI,NANDȣμ  __ndma_drq_type_t
    unsigned int      src_addr_mode    : 1;            //ԭַ 0:ģʽ  1:ֲ
    unsigned int      src_burst_length : 2;            //һburst 0:1   1:4   2:8
    unsigned int      reserved0        : 1;
    unsigned int      src_data_width   : 2;            //ݴȣ0:һδ8bit1:һδ16bit2:һδ32bit3:
    unsigned int      reserved1        : 5;
    unsigned int      dst_drq_type     : 5;            //Ŀĵַ洢ͣDRAM, SPI,NAND
    unsigned int      dst_addr_mode    : 1;            //Ŀĵַ߲ͣ  0:ģʽ  1:ֲ
    unsigned int      dst_burst_length : 2;            //һburst 0Ӧ11Ӧ4,
    unsigned int      reserved2        : 1;
    unsigned int      dst_data_width   : 2;            //ݴȣ0:һδ8bit1:һδ16bit2:һδ32bit3:
    unsigned int      reserved3        : 5;
}
sunxi_dma_channal_config;

//for user request
typedef struct
{
	sunxi_dma_channal_config  cfg;
	unsigned int	loop_mode;
	unsigned int	data_block_size;
	unsigned int	wait_cyc;
}
sunxi_dma_setting_t;

extern    void          sunxi_dma_init(void);
extern    void          sunxi_dma_exit(void);

extern    unsigned int 	sunxi_dma_request			(unsigned int dmatype);
extern    int 			sunxi_dma_release			(unsigned int hdma);
extern    int 			sunxi_dma_setting			(unsigned int hdma, sunxi_dma_setting_t *cfg);
extern    int 			sunxi_dma_start			    (unsigned int hdma, unsigned int saddr, unsigned int daddr, unsigned int bytes);
extern    int 			sunxi_dma_stop			    (unsigned int hdma);
extern    int 			sunxi_dma_querystatus		(unsigned int hdma);

extern    int 			sunxi_dma_install_int(uint hdma, interrupt_handler_t dma_int_func, void *p);
extern    int 			sunxi_dma_disable_int(uint hdma);

extern    int 			sunxi_dma_enable_int(uint hdma);
extern    int 			sunxi_dma_free_int(uint hdma);

#endif	//_DMA_H_

/* end of _DMA_H_ */

