#ifndef __LINUX_FT5X02_INI_CONFIG_H__
#define __LINUX_FT5X02_INI_CONFIG_H


/*Init param register address*/
/*factory mode register*/
#define FT5x02_REG_TX_NUM				0x03
#define FT5x02_REG_RX_NUM				0x04
#define FT5x02_REG_VOLTAGE				0x05
#define FT5x02_REG_GAIN					0x07
#define FT5X02_REG_SCAN_SELECT		                0x4E
#define FT5x02_REG_TX_ORDER_START		        0x50
#define FT5x02_REG_TX_CAP_START		                0x78
#define FT5x02_REG_TX_OFFSET_START	                0xBF
#define FT5x02_REG_RX_ORDER_START		        0xea
#define FT5x02_REG_RX_CAP_START		                0xA0
#define FT5x02_REG_RX_OFFSET_START	                0xD3
#define FT5X02_REG_START_RX			        0x06
#define FT5X02_REG_ADC_TARGET_HIGH	                0x08
#define FT5X02_REG_ADC_TARGET_LOW	                0x09


#define FT5x02_REG_DEVICE_MODE		                0x00

/*work mode register*/
#define FT5X02_REG_THGROUP				(0x00+0x80)
#define FT5X02_REG_THPEAK 				(0x01+0x80)
#define FT5X02_REG_THCAL 				(0x02+0x80)
#define FT5X02_REG_THWATER 			        (0x03+0x80)
#define FT5X02_REG_THFALSE_TOUCH_PEAK 		        (0x04+0x80)
#define FT5X02_REG_THDIFF				(0x05+0x80)
#define FT5X02_REG_PWMODE_CTRL				(0x06+0x80)
#define FT5X02_REG_TIME_ENTER_MONITOR 		        (0x07+0x80)
#define FT5X02_REG_PERIOD_ACTIVE		        (0x08+0x80)
#define FT5X02_REG_PERIOD_MONITOR 			(0x09+0x80)
#define FT5X02_REG_POINTS_SUPPORTED			(0x0A+0x80)
#define FT5X02_REG_ESD_FILTER_FRAME			(0x11+0x80)
#define FT5x02_REG_RESOLUTION_X_H			(0x18+0x80)
#define FT5x02_REG_RESOLUTION_X_L		        (0x19+0x80)
#define FT5x02_REG_RESOLUTION_Y_H		        (0x1a+0x80)
#define FT5x02_REG_RESOLUTION_Y_L		        (0x1b+0x80)
#define FT5X02_REG_KX_H				        (0x1c+0x80)
#define FT5X02_REG_KX_L				        (0x1d+0x80)
#define FT5X02_REG_KY_H				        0x9e
#define FT5X02_REG_KY_L				        (0x1f+0x80)
#define FT5X02_REG_AUTO_CLB_MODE		        (0x20+0x80)
#define FT5X02_REG_LIB_VERSION_H		        (0x21+0x80)
#define FT5X02_REG_LIB_VERSION_L		        (0x22+0x80)
#define FT5X02_REG_CIPHER_ID			        (0x23+0x80)
#define FT5X02_REG_MODE				        (0x24+0x80)
#define FT5X02_REG_PMODE			        (0x25+0x80)
#define FT5X02_REG_FIRMWARE_ID				(0x26+0x80)
#define FT5X02_REG_STATE			        (0x27+0x80)
#define FT5X02_REG_CUSTOMER_ID				(0x28+0x80) 
#define FT5X02_REG_OTP_PARAM_ID				(0x2A+0x80)
#define FT5X02_REG_STATIC_TH				(0x2b+0x80)
#define FT5X02_REG_DRAW_LINE_TH				0xae
#define FT5X02_REG_FACE_DETECT_MODE			(0x33+0x80)
#define FT5X02_REG_MAX_TOUCH_VALUE_HIGH		        (0x34+0x80)
#define FT5X02_REG_MAX_TOUCH_VALUE_LOW		        (0x35+0x80)
#define FT5X02_REG_MOVSTH_I				(0x36+0x80)
#define FT5X02_REG_MOVSTH_N				(0x37+0x80)
#define FT5X02_REG_DIRECTION				(0x40+0x80)
#define FT5X02_REG_LEMDA_X				(0x41+0x80)
#define FT5X02_REG_LEMDA_Y				(0x42+0x80)
#define FT5X02_REG_FACE_DETECT_STATISTICS_TX_NUM	(0x43+0x80)
#define FT5X02_REG_FACE_DETECT_PRE_VALUE		(0x44+0x80)
#define FT5X02_REG_FACE_DETECT_NUM			(0x45+0x80)
#define FT5X02_REG_FACE_DETECT_LAST_TIME_H	        (0x46+0x80)
#define FT5X02_REG_FACE_DETECT_LAST_TIME_L	        (0x47+0x80)
#define FT5X02_REG_FACE_DETECT_ON		        (0x48+0x80)
#define FT5X02_REG_FACE_DETECT_OFF			(0x49+0x80)
#define FT5X02_REG_BIGAREA_PEAK_VALUE_MIN	        (0x4a+0x80)
#define FT5X02_REG_BIGAREA_DIFF_VALUE_OVER_NUM		(0x4b+0x80)	
#define FT5X02_REG_BIGAREA_POINT_AUTO_CLEAR_TIME_H	(0x4c+0x80)
#define FT5X02_REG_BIGAREA_POINT_AUTO_CLEAR_TIME_L	(0x4d+0x80)
#define FT5X02_REG_DIFFDATA_HADDLE_VALUE                0xce//(0x4e+0x80)
#define FT5X02_REG_ABNORMAL_DIFF_VALUE		        (0x4f+0x80)
#define FT5X02_REG_ABNORMAL_DIFF_NUM			(0x50+0x80)
#define FT5X02_REG_ABNORMAL_DIFF_LAST_FRAME	        (0x51+0x80)
#define FT5X02_REG_MID_SPEED_TH				(0x2C+0x80)
#define FT5X02_REG_HIGH_SPEED_TH			(0x2D+0x80)
#define FT5X02_REG_FILTER_FRAME_NOISE			(0x0B+0x80)	
#define FT5X02_REG_KX_LR_H			        (0x0C+0x80)	
#define FT5X02_REG_KX_LR_L			        (0x0D+0x80)	
#define FT5X02_REG_KY_UD_H			        0x8E//(0x0E+0x80)	
#define FT5X02_REG_KY_UD_L			        (0x0F+0x80)	
#define FT5X02_REG_POWERNOISE_FILTER_TH		        (0x10+0x80)


/**/
#define FT5x02_REG_TEST_MODE			        0x04
#define FT5x02_REG_TEST_MODE_2		                0x05
#define FT5x02_TX_TEST_MODE_1			        0x28
#define FT5x02_RX_TEST_MODE_1			        0x1E
#define FT5x02_FACTORYMODE_VALUE		        0x40
#define FT5x02_WORKMODE_VALUE		                0x00


/************************************************************************/
/* string                                                               */
/************************************************************************/
#define STRING_FT5X02_KX				"FT5X02_KX"
#define STRING_FT5X02_KY				"FT5X02_KY"
#define STRING_FT5X02_LEMDA_X			        "FT5X02_LEMDA_X"
#define STRING_FT5X02_LEMDA_Y			        "FT5X02_LEMDA_Y"
#define STRING_FT5X02_RESOLUTION_X	                "FT5X02_RESOLUTION_X"
#define STRING_FT5X02_RESOLUTION_Y	                "FT5X02_RESOLUTION_Y"
#define STRING_FT5X02_DIRECTION		                "FT5X02_DIRECTION"	/*0-tx is X direct. 1-rx is X direct.*/


/**/
#define STRING_FT5X02_FACE_DETECT_PRE_VALUE		"FT5X02_FACE_DETECT_PRE_VALUE"
#define STRING_FT5X02_FACE_DETECT_NUM			"FT5X02_FACE_DETECT_NUM"
#define STRING_FT5X02_BIGAREA_PEAK_VALUE_MIN		"FT5X02_BIGAREA_PEAK_VALUE_MIN"/*The min value to be decided as the big point*/
#define STRING_FT5X02_BIGAREA_DIFF_VALUE_OVER_NUM	"FT5X02_BIGAREA_DIFF_VALUE_OVER_NUM"/*The min big points of the big area*/
#define STRING_FT5X02_BIGAREA_POINT_AUTO_CLEAR_TIME	"FT5X02_BIGAREA_POINT_AUTO_CLEAR_TIME"/*3000ms*/
#define STRING_FT5X02_FACE_DETECT_LAST_TIME	        "FT5X02_FACE_DETECT_LAST_TIME"
#define STRING_FT5X02_MODE			        "FT5X02_MODE"
#define STRING_FT5X02_PMODE				"FT5X02_PMODE"
#define STRING_FT5X02_FIRMWARE_ID		        "FT5X02_FIRMWARE_ID"
#define STRING_FT5X02_STATE			        "FT5X02_STATE"
#define STRING_FT5X02_CUSTOMER_ID			"FT5X02_CUSTOMER_ID"
#define STRING_FT5X02_PERIOD_ACTIVE			"FT5X02_PERIOD_ACTIVE"
#define STRING_FT5X02_FACE_DETECT_STATISTICS_TX_NUM	"FT5X02_FACE_DETECT_STATISTICS_TX_NUM"

#define STRING_FT5X02_THGROUP		                "FT5X02_THGROUP"
#define STRING_FT5X02_THPEAK			        "FT5X02_THPEAK"
#define STRING_FT5X02_FACE_DETECT_MODE		        "FT5X02_FACE_DETECT_MODE"/*close*/
#define STRING_FT5X02_MAX_TOUCH_VALUE		        "FT5X02_MAX_TOUCH_VALUE"

#define STRING_FT5X02_THFALSE_TOUCH_PEAK 	        "FT5X02_THFALSE_TOUCH_PEAK"
#define STRING_FT5X02_THDIFF			        "FT5X02_THDIFF"
#define STRING_FT5X02_PWMODE_CTRL		        "FT5X02_PWMODE_CTRL"
#define STRING_FT5X02_TIME_ENTER_MONITOR 	        "FT5X02_TIME_ENTER_MONITOR"
#define STRING_FT5X02_PERIOD_MONITOR 		        "FT5X02_PERIOD_MONITOR"
#define STRING_FT5X02_AUTO_CLB_MODE		        "FT5X02_AUTO_CLB_MODE"
#define STRING_FT5X02_DRAW_LINE_TH		        "FT5X02_DRAW_LINE_TH"
#define STRING_FT5X02_DIFFDATA_HADDLE_VALUE	        "FT5X02_DIFFDATA_HADDLE_VALUE"


#define STRING_FT5X02_ABNORMAL_DIFF_VALUE	        "FT5X02_ABNORMAL_DIFF_VALUE"
#define STRING_FT5X02_ABNORMAL_DIFF_NUM			"FT5X02_ABNORMAL_DIFF_NUM"
#define STRING_FT5X02_ABNORMAL_DIFF_LAST_FRAME		"FT5X02_ABNORMAL_DIFF_LAST_FRAME"

#define STRING_FT5X02_POINTS_SUPPORTED		        "FT5X02_POINTS_SUPPORTED"

#define STRING_FT5X02_STATIC_TH				"FT5X02_STATIC_TH"
#define STRING_FT5X02_MID_SPEED_TH			"FT5X02_MID_SPEED_TH"
#define STRING_FT5X02_HIGH_SPEED_TH			"FT5X02_HIGH_SPEED_TH"
#define STRING_FT5X02_START_RX			        "FT5X02_START_RX"
#define STRING_FT5X02_ADC_TARGET		        "FT5X02_ADC_TARGET"
#define STRING_FT5X02_FILTER_FRAME_NOISE		"FT5X02_FILTER_FRAME_NOISE"
#define STRING_FT5X02_POWERNOISE_FILTER_TH	        "FT5X02_POWERNOISE_FILTER_TH"
#define STRING_FT5X02_KX_LR			        "FT5X02_KX_LR"
#define STRING_FT5X02_KY_UD			        "FT5X02_KY_UD"
#define STRING_FT5X02_ESD_FILTER_FRAME		        "FT5X02_ESD_FILTER_FRAME"

#define STRING_FT5X02_MOVSTH_I			        "FT5X02_MOVSTH_I"
#define STRING_FT5X02_MOVSTH_N				"FT5X02_MOVSTH_N"


#define STRING_ft5x02_tx_num	                        "FT5X02_tx_num"
#define STRING_ft5x02_rx_num	                        "FT5X02_rx_num"
#define STRING_ft5x02_gain		                "FT5X02_gain"
#define STRING_ft5x02_voltage	                        "FT5X02_voltage"
#define STRING_ft5x02_scanselect                        "FT5X02_scanselect"/*1-3M	2-4.5M 3-6.75M*/

#define STRING_ft5x02_tx_order 	                        "FT5X02_tx_order"
#define STRING_ft5x02_tx_offset	                        "FT5X02_tx_offset"
#define STRING_ft5x02_tx_cap 	                        "FT5X02_tx_cap"

#define STRING_ft5x02_rx_order 	                        "FT5X02_rx_order"
#define STRING_ft5x02_rx_offset 	                "FT5X02_rx_offset"
#define STRING_ft5x02_rx_cap 	                        "FT5X02_rx_cap"


struct Struct_Param_FT5X02 {
	short ft5x02_KX;
	short ft5x02_KY;
	unsigned char ft5x02_LEMDA_X;
	unsigned char ft5x02_LEMDA_Y;
	short ft5x02_RESOLUTION_X;
	short ft5x02_RESOLUTION_Y;
	unsigned char ft5x02_DIRECTION;
	
	unsigned char ft5x02_FACE_DETECT_PRE_VALUE;
	unsigned char ft5x02_FACE_DETECT_NUM;
	unsigned char ft5x02_BIGAREA_PEAK_VALUE_MIN;/*The min value to be decided as the big point*/
	unsigned char ft5x02_BIGAREA_DIFF_VALUE_OVER_NUM;/*The min big points of the big area*/
	short ft5x02_BIGAREA_POINT_AUTO_CLEAR_TIME;/*3000ms*/
	short ft5x02_FACE_DETECT_LAST_TIME;
	unsigned char ft5x02_MODE;
	unsigned char ft5x02_PMODE;
	unsigned char ft5x02_FIRMWARE_ID;
	unsigned char ft5x02_STATE;
	unsigned char ft5x02_CUSTOMER_ID;
	unsigned char ft5x02_PERIOD_ACTIVE;
	unsigned char  ft5x02_FACE_DETECT_STATISTICS_TX_NUM;

	short ft5x02_THGROUP;
	unsigned char ft5x02_THPEAK;
	unsigned char ft5x02_FACE_DETECT_MODE;
	short ft5x02_MAX_TOUCH_VALUE;

	unsigned char ft5x02_THFALSE_TOUCH_PEAK;
	unsigned char ft5x02_THDIFF;
	unsigned char ft5x02_PWMODE_CTRL;
	unsigned char ft5x02_TIME_ENTER_MONITOR;
	unsigned char ft5x02_PERIOD_MONITOR;
	unsigned char ft5x02_AUTO_CLB_MODE;
	unsigned char ft5x02_DRAW_LINE_TH;
	unsigned char ft5x02_DIFFDATA_HADDLE_VALUE;

	unsigned char ft5x02_ABNORMAL_DIFF_VALUE;
	unsigned char ft5x02_ABNORMAL_DIFF_NUM;
	unsigned char ft5x02_ABNORMAL_DIFF_LAST_FRAME;
	unsigned char ft5x02_POINTS_SUPPORTED;
		
	unsigned char ft5x02_STATIC_TH;
	unsigned char ft5x02_MID_SPEED_TH;
	unsigned char ft5x02_HIGH_SPEED_TH;
	unsigned char ft5x02_START_RX;
	short ft5x02_ADC_TARGET;
	unsigned char ft5x02_FILTER_FRAME_NOISE;
	unsigned char ft5x02_POWERNOISE_FILTER_TH;
	short ft5x02_KX_LR;
	short ft5x02_KY_UD;
	unsigned char ft5x02_ESD_FILTER_FRAME;
	unsigned char ft5x02_MOVSTH_I;
	unsigned char ft5x02_MOVSTH_N;
};

struct Struct_Param_FT5X02 g_param_ft5x02 = {
	FT5X02_KX,
	FT5X02_KY,
	FT5X02_LEMDA_X,
	FT5X02_LEMDA_Y,
	FT5X02_RESOLUTION_X,
	FT5X02_RESOLUTION_Y,
	FT5X02_DIRECTION,	/*0-tx is X direct. 1-rx is X direct.*/

	FT5X02_FACE_DETECT_PRE_VALUE,
	FT5X02_FACE_DETECT_NUM,
	FT5X02_BIGAREA_PEAK_VALUE_MIN,/*The min value to be decided as the big point*/
	FT5X02_BIGAREA_DIFF_VALUE_OVER_NUM,/*The min big points of the big area*/
	FT5X02_BIGAREA_POINT_AUTO_CLEAR_TIME,/*3000ms*/
	FT5X02_FACE_DETECT_LAST_TIME,
	FT5X02_MODE,
	FT5X02_PMODE,
	FT5X02_FIRMWARE_ID,
	FT5X02_STATE,
	FT5X02_CUSTOMER_ID,
	FT5X02_PERIOD_ACTIVE,
	FT5X02_FACE_DETECT_STATISTICS_TX_NUM,

	FT5X02_THGROUP,
	FT5X02_THPEAK,
	FT5X02_FACE_DETECT_MODE,/*close*/
	FT5X02_MAX_TOUCH_VALUE,

	FT5X02_THFALSE_TOUCH_PEAK,
	FT5X02_THDIFF,
	FT5X02_PWMODE_CTRL,
	FT5X02_TIME_ENTER_MONITOR,
	FT5X02_PERIOD_MONITOR,
	FT5X02_AUTO_CLB_MODE,
	FT5X02_DRAW_LINE_TH,
	FT5X02_DIFFDATA_HADDLE_VALUE,
	
	FT5X02_ABNORMAL_DIFF_VALUE, 
	FT5X02_ABNORMAL_DIFF_NUM,
	FT5X02_ABNORMAL_DIFF_LAST_FRAME,
	FT5X02_POINTS_SUPPORTED,
	
	FT5X02_STATIC_TH,
	FT5X02_MID_SPEED_TH,
	FT5X02_HIGH_SPEED_TH,
	FT5X02_START_RX,
	FT5X02_ADC_TARGET,
	FT5X02_FILTER_FRAME_NOISE,
	FT5X02_POWERNOISE_FILTER_TH,
	FT5X02_KX_LR,
	FT5X02_KY_UD,
	FT5X02_ESD_FILTER_FRAME,
	FT5X02_MOVSTH_I,
	FT5X02_MOVSTH_N,
};

char String_Param_FT5X02[][64] = {
	STRING_FT5X02_KX,
	STRING_FT5X02_KY,
	STRING_FT5X02_LEMDA_X,
	STRING_FT5X02_LEMDA_Y,
	STRING_FT5X02_RESOLUTION_X,
	STRING_FT5X02_RESOLUTION_Y,
	STRING_FT5X02_DIRECTION,
	STRING_FT5X02_FACE_DETECT_PRE_VALUE,
	STRING_FT5X02_FACE_DETECT_NUM,
	STRING_FT5X02_BIGAREA_PEAK_VALUE_MIN,/*The min value to be decided as the big point*/
	STRING_FT5X02_BIGAREA_DIFF_VALUE_OVER_NUM,/*The min big points of the big area*/
	STRING_FT5X02_BIGAREA_POINT_AUTO_CLEAR_TIME,/*3000ms*/
	STRING_FT5X02_FACE_DETECT_LAST_TIME,
	STRING_FT5X02_MODE,
	STRING_FT5X02_PMODE,
	STRING_FT5X02_FIRMWARE_ID,
	STRING_FT5X02_STATE,
	STRING_FT5X02_CUSTOMER_ID,
	STRING_FT5X02_PERIOD_ACTIVE,
	STRING_FT5X02_FACE_DETECT_STATISTICS_TX_NUM,

	STRING_FT5X02_THGROUP,
	STRING_FT5X02_THPEAK,
	STRING_FT5X02_FACE_DETECT_MODE,
	STRING_FT5X02_MAX_TOUCH_VALUE,

	STRING_FT5X02_THFALSE_TOUCH_PEAK,
	STRING_FT5X02_THDIFF,
	STRING_FT5X02_PWMODE_CTRL,
	STRING_FT5X02_TIME_ENTER_MONITOR,
	STRING_FT5X02_PERIOD_MONITOR,
	STRING_FT5X02_AUTO_CLB_MODE,
	STRING_FT5X02_DRAW_LINE_TH,
	STRING_FT5X02_DIFFDATA_HADDLE_VALUE,

	STRING_FT5X02_ABNORMAL_DIFF_VALUE,
	STRING_FT5X02_ABNORMAL_DIFF_NUM,
	STRING_FT5X02_ABNORMAL_DIFF_LAST_FRAME,
	STRING_FT5X02_POINTS_SUPPORTED,
	
	STRING_FT5X02_STATIC_TH	,
	STRING_FT5X02_MID_SPEED_TH,
	STRING_FT5X02_HIGH_SPEED_TH,
	STRING_FT5X02_START_RX,
	STRING_FT5X02_ADC_TARGET,
	STRING_FT5X02_FILTER_FRAME_NOISE,
	STRING_FT5X02_POWERNOISE_FILTER_TH,
	STRING_FT5X02_KX_LR,
	STRING_FT5X02_KY_UD,
	STRING_FT5X02_ESD_FILTER_FRAME,
	STRING_FT5X02_MOVSTH_I,
	STRING_FT5X02_MOVSTH_N,
	
	STRING_ft5x02_tx_num,
	STRING_ft5x02_rx_num,
	STRING_ft5x02_gain,
	STRING_ft5x02_voltage ,
	STRING_ft5x02_scanselect,

	STRING_ft5x02_tx_order,
	STRING_ft5x02_tx_offset,
	STRING_ft5x02_tx_cap,

	STRING_ft5x02_rx_order,
	STRING_ft5x02_rx_offset,
	STRING_ft5x02_rx_cap,
};

#define FT5X02_APP_NAME                 "FT5X02_param"

#define FT5X02_APP_LEGAL                "Legal_File"
#define FT5X02_APP_LEGAL_BYTE_1_STR     "BYTE_1"
#define FT5X02_APP_LEGAL_BYTE_2_STR     "BYTE_2"

#define FT5X02_APP_LEGAL_BYTE_1_VALUE   90
#define FT5X02_APP_LEGAL_BYTE_2_VALUE   182


#define FT5X02_INI_FILEPATH             "/sdcard/"

#endif
