#include "clk-sun9iw1.h"
/*
 * freq table from hardware, need follow rules
 * 1)   each table  named as 
 *      factor_pll1_tbl
 *      factor_pll2_tbl
 *      ...
 * 2) for each table line 
 *      a) follow the format PLLx(n,k,m,p,d1,d2,freq), and keep the factors order
 *      b) if any factor not used, skip it
 *      c) the factor is the value to write registers, not means factor+1
 *
 *      example
 *      PLL1(9, 0, 0, 2, 60000000) means PLL1(n,k,m,p,freq)  
 *      PLLVIDEO(3, 0, 96000000)       means PLLVIDEO(n,m,freq) 
 *
 */
 //N,P,freq
static struct sunxi_clk_factor_freq factor_pll1_tbl[] = {
PLLCPU(15	,0,	360000000U),
PLLCPU(16	,0,	384000000U),
PLLCPU(17	,0,	408000000U),
PLLCPU(18	,0,	432000000U),
PLLCPU(19	,0,	456000000U),
PLLCPU(20	,0,	480000000U),
PLLCPU(21	,0,	504000000U),
PLLCPU(22	,0,	528000000U),
PLLCPU(23	,0,	552000000U),
PLLCPU(24	,0,	576000000U),
PLLCPU(25	,0,	600000000U),
PLLCPU(26	,0,	624000000U),
PLLCPU(27	,0,	648000000U),
PLLCPU(28	,0,	672000000U),
PLLCPU(29	,0,	696000000U),
PLLCPU(30	,0,	720000000U),
PLLCPU(31	,0,	744000000U),
PLLCPU(32	,0,	768000000U),
PLLCPU(33	,0,	792000000U),
PLLCPU(34	,0,	816000000U),
PLLCPU(35	,0,	840000000U),
PLLCPU(36	,0,	864000000U),
PLLCPU(37	,0,	888000000U),
PLLCPU(38	,0,	912000000U),
PLLCPU(39	,0,	936000000U),
PLLCPU(40	,0,	960000000U),
PLLCPU(41	,0,	984000000U),
PLLCPU(42	,0,	1008000000U),
PLLCPU(43	,0,	1032000000U),
PLLCPU(44	,0,	1056000000U),
PLLCPU(45	,0,	1080000000U),
PLLCPU(46	,0,	1104000000U),
PLLCPU(47	,0,	1128000000U),
PLLCPU(48	,0,	1152000000U),
PLLCPU(49	,0,	1176000000U),
PLLCPU(50	,0,	1200000000U),
PLLCPU(51	,0,	1224000000U),
PLLCPU(52	,0,	1248000000U),
PLLCPU(53	,0,	1272000000U),
PLLCPU(54	,0,	1296000000U),
PLLCPU(55	,0,	1320000000U),
PLLCPU(56	,0,	1344000000U),
PLLCPU(57	,0,	1368000000U),
PLLCPU(58	,0,	1392000000U),
PLLCPU(59	,0,	1416000000U),
PLLCPU(60	,0,	1440000000U),
PLLCPU(61	,0,	1464000000U),
PLLCPU(62	,0,	1488000000U),
PLLCPU(63	,0,	1512000000U),
PLLCPU(64	,0,	1536000000U),
PLLCPU(65	,0,	1560000000U),
PLLCPU(66	,0,	1584000000U),
PLLCPU(67	,0,	1608000000U),
PLLCPU(68	,0,	1632000000U),
PLLCPU(69	,0,	1656000000U),
PLLCPU(70	,0,	1680000000U),
PLLCPU(71	,0,	1704000000U),
PLLCPU(72	,0,	1728000000U),
PLLCPU(73	,0,	1752000000U),
PLLCPU(74	,0,	1776000000U),
PLLCPU(75	,0,	1800000000U),
PLLCPU(76	,0,	1824000000U),
PLLCPU(77	,0,	1848000000U),
PLLCPU(78	,0,	1872000000U),
PLLCPU(79	,0,	1896000000U),
PLLCPU(80	,0,	1920000000U),
PLLCPU(81	,0,	1944000000U),
PLLCPU(82	,0,	1968000000U),
PLLCPU(83	,0,	1992000000U),
PLLCPU(84	,0,	2016000000U),
PLLCPU(85	,0,	2040000000U),
PLLCPU(86	,0,	2064000000U),
PLLCPU(87	,0,	2088000000U),
PLLCPU(88	,0,	2112000000U),
PLLCPU(89	,0,	2136000000U),
PLLCPU(90	,0,	2160000000U),
PLLCPU(91	,0,	2184000000U),
PLLCPU(92	,0,	2208000000U),
PLLCPU(93	,0,	2232000000U),
PLLCPU(94	,0,	2256000000U),
PLLCPU(95	,0,	2280000000U),
PLLCPU(96	,0,	2304000000U),
PLLCPU(97	,0,	2328000000U),
PLLCPU(98	,0,	2352000000U),
PLLCPU(99	,0,	2376000000U),
PLLCPU(100	,0,	2400000000U),
PLLCPU(101	,0,	2424000000U),
PLLCPU(102	,0,	2448000000U),
PLLCPU(103	,0,	2472000000U),
PLLCPU(104	,0,	2496000000U),
PLLCPU(105	,0,	2520000000U),
PLLCPU(106	,0,	2544000000U),
PLLCPU(107	,0,	2568000000U),
PLLCPU(108	,0,	2592000000U),
PLLCPU(109	,0,	2616000000U),
PLLCPU(110	,0,	2640000000U),
PLLCPU(111	,0,	2664000000U),
PLLCPU(112	,0,	2688000000U),
PLLCPU(113	,0,	2712000000U),
PLLCPU(114	,0,	2736000000U),
PLLCPU(115	,0,	2760000000U),
PLLCPU(116	,0,	2784000000U),
PLLCPU(117	,0,	2808000000U),
PLLCPU(118	,0,	2832000000U),
PLLCPU(119	,0,	2856000000U),
PLLCPU(120	,0,	2880000000U),
PLLCPU(121	,0,	2904000000U),
PLLCPU(122	,0,	2928000000U),
PLLCPU(123	,0,	2952000000U),
PLLCPU(124	,0,	2976000000U),
PLLCPU(125	,0,	3000000000U),
};

 //N,P,freq
static struct sunxi_clk_factor_freq factor_pll2_tbl[] = {
PLLCPU(15	,0,	360000000U),
PLLCPU(16	,0,	384000000U),
PLLCPU(17	,0,	408000000U),
PLLCPU(18	,0,	432000000U),
PLLCPU(19	,0,	456000000U),
PLLCPU(20	,0,	480000000U),
PLLCPU(21	,0,	504000000U),
PLLCPU(22	,0,	528000000U),
PLLCPU(23	,0,	552000000U),
PLLCPU(24	,0,	576000000U),
PLLCPU(25	,0,	600000000U),
PLLCPU(26	,0,	624000000U),
PLLCPU(27	,0,	648000000U),
PLLCPU(28	,0,	672000000U),
PLLCPU(29	,0,	696000000U),
PLLCPU(30	,0,	720000000U),
PLLCPU(31	,0,	744000000U),
PLLCPU(32	,0,	768000000U),
PLLCPU(33	,0,	792000000U),
PLLCPU(34	,0,	816000000U),
PLLCPU(35	,0,	840000000U),
PLLCPU(36	,0,	864000000U),
PLLCPU(37	,0,	888000000U),
PLLCPU(38	,0,	912000000U),
PLLCPU(39	,0,	936000000U),
PLLCPU(40	,0,	960000000U),
PLLCPU(41	,0,	984000000U),
PLLCPU(42	,0,	1008000000U),
PLLCPU(43	,0,	1032000000U),
PLLCPU(44	,0,	1056000000U),
PLLCPU(45	,0,	1080000000U),
PLLCPU(46	,0,	1104000000U),
PLLCPU(47	,0,	1128000000U),
PLLCPU(48	,0,	1152000000U),
PLLCPU(49	,0,	1176000000U),
PLLCPU(50	,0,	1200000000U),
PLLCPU(51	,0,	1224000000U),
PLLCPU(52	,0,	1248000000U),
PLLCPU(53	,0,	1272000000U),
PLLCPU(54	,0,	1296000000U),
PLLCPU(55	,0,	1320000000U),
PLLCPU(56	,0,	1344000000U),
PLLCPU(57	,0,	1368000000U),
PLLCPU(58	,0,	1392000000U),
PLLCPU(59	,0,	1416000000U),
PLLCPU(60	,0,	1440000000U),
PLLCPU(61	,0,	1464000000U),
PLLCPU(62	,0,	1488000000U),
PLLCPU(63	,0,	1512000000U),
PLLCPU(64	,0,	1536000000U),
PLLCPU(65	,0,	1560000000U),
PLLCPU(66	,0,	1584000000U),
PLLCPU(67	,0,	1608000000U),
PLLCPU(68	,0,	1632000000U),
PLLCPU(69	,0,	1656000000U),
PLLCPU(70	,0,	1680000000U),
PLLCPU(71	,0,	1704000000U),
PLLCPU(72	,0,	1728000000U),
PLLCPU(73	,0,	1752000000U),
PLLCPU(74	,0,	1776000000U),
PLLCPU(75	,0,	1800000000U),
PLLCPU(76	,0,	1824000000U),
PLLCPU(77	,0,	1848000000U),
PLLCPU(78	,0,	1872000000U),
PLLCPU(79	,0,	1896000000U),
PLLCPU(80	,0,	1920000000U),
PLLCPU(81	,0,	1944000000U),
PLLCPU(82	,0,	1968000000U),
PLLCPU(83	,0,	1992000000U),
PLLCPU(84	,0,	2016000000U),
PLLCPU(85	,0,	2040000000U),
PLLCPU(86	,0,	2064000000U),
PLLCPU(87	,0,	2088000000U),
PLLCPU(88	,0,	2112000000U),
PLLCPU(89	,0,	2136000000U),
PLLCPU(90	,0,	2160000000U),
PLLCPU(91	,0,	2184000000U),
PLLCPU(92	,0,	2208000000U),
PLLCPU(93	,0,	2232000000U),
PLLCPU(94	,0,	2256000000U),
PLLCPU(95	,0,	2280000000U),
PLLCPU(96	,0,	2304000000U),
PLLCPU(97	,0,	2328000000U),
PLLCPU(98	,0,	2352000000U),
PLLCPU(99	,0,	2376000000U),
PLLCPU(100	,0,	2400000000U),
PLLCPU(101	,0,	2424000000U),
PLLCPU(102	,0,	2448000000U),
PLLCPU(103	,0,	2472000000U),
PLLCPU(104	,0,	2496000000U),
PLLCPU(105	,0,	2520000000U),
PLLCPU(106	,0,	2544000000U),
PLLCPU(107	,0,	2568000000U),
PLLCPU(108	,0,	2592000000U),
PLLCPU(109	,0,	2616000000U),
PLLCPU(110	,0,	2640000000U),
PLLCPU(111	,0,	2664000000U),
PLLCPU(112	,0,	2688000000U),
PLLCPU(113	,0,	2712000000U),
PLLCPU(114	,0,	2736000000U),
PLLCPU(115	,0,	2760000000U),
PLLCPU(116	,0,	2784000000U),
PLLCPU(117	,0,	2808000000U),
PLLCPU(118	,0,	2832000000U),
PLLCPU(119	,0,	2856000000U),
PLLCPU(120	,0,	2880000000U),
PLLCPU(121	,0,	2904000000U),
PLLCPU(122	,0,	2928000000U),
PLLCPU(123	,0,	2952000000U),
PLLCPU(124	,0,	2976000000U),
PLLCPU(125	,0,	3000000000U),
};

 //N,input,output,freq
static struct sunxi_clk_factor_freq factor_pll4_tbl[] = {
PLLPERIPH0(30	,1	,1,	180000000U),
PLLPERIPH0(31	,1	,1,	186000000U),
PLLPERIPH0(32	,1	,1,	192000000U),
PLLPERIPH0(33	,1	,1,	198000000U),
PLLPERIPH0(17	,0	,1,	204000000U),
PLLPERIPH0(35	,1	,1,	210000000U),
PLLPERIPH0(18	,0	,1,	216000000U),
PLLPERIPH0(37	,1	,1,	222000000U),
PLLPERIPH0(19	,0	,1,	228000000U),
PLLPERIPH0(39	,1	,1,	234000000U),
PLLPERIPH0(20	,0	,1,	240000000U),
PLLPERIPH0(41	,1	,1,	246000000U),
PLLPERIPH0(21	,0	,1,	252000000U),
PLLPERIPH0(43	,1	,1,	258000000U),
PLLPERIPH0(22	,0	,1,	264000000U),
PLLPERIPH0(45	,1	,1,	270000000U),
PLLPERIPH0(23	,0	,1,	276000000U),
PLLPERIPH0(47	,1	,1,	282000000U),
PLLPERIPH0(24	,0	,1,	288000000U),
PLLPERIPH0(49	,1	,1,	294000000U),
PLLPERIPH0(25	,0	,1,	300000000U),
PLLPERIPH0(51	,1	,1,	306000000U),
PLLPERIPH0(26	,0	,1,	312000000U),
PLLPERIPH0(53	,1	,1,	318000000U),
PLLPERIPH0(27	,0	,1,	324000000U),
PLLPERIPH0(55	,1	,1,	330000000U),
PLLPERIPH0(28	,0	,1,	336000000U),
PLLPERIPH0(57	,1	,1,	342000000U),
PLLPERIPH0(29	,0	,1,	348000000U),
PLLPERIPH0(59	,1	,1,	354000000U),
PLLPERIPH0(30	,0	,1,	360000000U),
PLLPERIPH0(61	,1	,1,	366000000U),
PLLPERIPH0(31	,0	,1,	372000000U),
PLLPERIPH0(63	,1	,1,	378000000U),
PLLPERIPH0(32	,0	,1,	384000000U),
PLLPERIPH0(65	,1	,1,	390000000U),
PLLPERIPH0(33	,0	,1,	396000000U),
PLLPERIPH0(67	,1	,1,	402000000U),
PLLPERIPH0(34	,0	,1,	408000000U),
PLLPERIPH0(69	,1	,1,	414000000U),
PLLPERIPH0(35	,0	,1,	420000000U),
PLLPERIPH0(71	,1	,1,	426000000U),
PLLPERIPH0(36	,0	,1,	432000000U),
PLLPERIPH0(73	,1	,1,	438000000U),
PLLPERIPH0(37	,0	,1,	444000000U),
PLLPERIPH0(75	,1	,1,	450000000U),
PLLPERIPH0(38	,0	,1,	456000000U),
PLLPERIPH0(77	,1	,1,	462000000U),
PLLPERIPH0(39	,0	,1,	468000000U),
PLLPERIPH0(79	,1	,1,	474000000U),
PLLPERIPH0(40	,0	,1,	480000000U),
PLLPERIPH0(81	,1	,1,	486000000U),
PLLPERIPH0(41	,0	,1,	492000000U),
PLLPERIPH0(83	,1	,1,	498000000U),
PLLPERIPH0(42	,0	,1,	504000000U),
PLLPERIPH0(85	,1	,1,	510000000U),
PLLPERIPH0(86	,1	,1,	516000000U),
PLLPERIPH0(87	,1	,1,	522000000U),
PLLPERIPH0(44	,0	,1,	528000000U),
PLLPERIPH0(89	,1	,1,	534000000U),
PLLPERIPH0(45	,0	,1,	540000000U),
PLLPERIPH0(91	,1	,1,	546000000U),
PLLPERIPH0(46	,0	,1,	552000000U),
PLLPERIPH0(93	,1	,1,	558000000U),
PLLPERIPH0(47	,0	,1,	564000000U),
PLLPERIPH0(95	,1	,1,	570000000U),
PLLPERIPH0(48	,0	,1,	576000000U),
PLLPERIPH0(97	,1	,1,	582000000U),
PLLPERIPH0(49	,0	,1,	588000000U),
PLLPERIPH0(50	,0	,1,	600000000U),
PLLPERIPH0(101	,1	,1,	606000000U),
PLLPERIPH0(51	,0	,1,	612000000U),
PLLPERIPH0(103	,1	,1,	618000000U),
PLLPERIPH0(52	,0	,1,	624000000U),
PLLPERIPH0(105	,1	,1,	630000000U),
PLLPERIPH0(53	,0	,1,	636000000U),
PLLPERIPH0(107	,1	,1,	642000000U),
PLLPERIPH0(54	,0	,1,	648000000U),
PLLPERIPH0(109	,1	,1,	654000000U),
PLLPERIPH0(55	,0	,1,	660000000U),
PLLPERIPH0(111	,1	,1,	666000000U),
PLLPERIPH0(56	,0	,1,	672000000U),
PLLPERIPH0(113	,1	,1,	678000000U),
PLLPERIPH0(57	,0	,1,	684000000U),
PLLPERIPH0(115	,1	,1,	690000000U),
PLLPERIPH0(58	,0	,1,	696000000U),
PLLPERIPH0(117	,1	,1,	702000000U),
PLLPERIPH0(59	,0	,1,	708000000U),
PLLPERIPH0(119	,1	,1,	714000000U),
PLLPERIPH0(60	,0	,1,	720000000U),
PLLPERIPH0(121	,1	,1,	726000000U),
PLLPERIPH0(61	,0	,1,	732000000U),
PLLPERIPH0(123	,1	,1,	738000000U),
PLLPERIPH0(62	,0	,1,	744000000U),
PLLPERIPH0(125	,1	,1,	750000000U),
PLLPERIPH0(63	,0	,1,	756000000U),
PLLPERIPH0(127	,1	,1,	762000000U),
PLLPERIPH0(64	,0	,1,	768000000U),
PLLPERIPH0(129	,1	,1,	774000000U),
PLLPERIPH0(65	,0	,1,	780000000U),
PLLPERIPH0(131	,1	,1,	786000000U),
PLLPERIPH0(66	,0	,1,	792000000U),
PLLPERIPH0(133	,1	,1,	798000000U),
PLLPERIPH0(67	,0	,1,	804000000U),
PLLPERIPH0(135	,1	,1,	810000000U),
PLLPERIPH0(68	,0	,1,	816000000U),
PLLPERIPH0(137	,1	,1,	822000000U),
PLLPERIPH0(69	,0	,1,	828000000U),
PLLPERIPH0(139	,1	,1,	834000000U),
PLLPERIPH0(70	,0	,1,	840000000U),
PLLPERIPH0(141	,1	,1,	846000000U),
PLLPERIPH0(71	,0	,1,	852000000U),
PLLPERIPH0(143	,1	,1,	858000000U),
PLLPERIPH0(72	,0	,1,	864000000U),
PLLPERIPH0(145	,1	,1,	870000000U),
PLLPERIPH0(73	,0	,1,	876000000U),
PLLPERIPH0(147	,1	,1,	882000000U),
PLLPERIPH0(74	,0	,1,	888000000U),
PLLPERIPH0(149	,1	,1,	894000000U),
PLLPERIPH0(75	,0	,1,	900000000U),
PLLPERIPH0(151	,1	,1,	906000000U),
PLLPERIPH0(76	,0	,1,	912000000U),
PLLPERIPH0(153	,1	,1,	918000000U),
PLLPERIPH0(77	,0	,1,	924000000U),
PLLPERIPH0(155	,1	,1,	930000000U),
PLLPERIPH0(78	,0	,1,	936000000U),
PLLPERIPH0(157	,1	,1,	942000000U),
PLLPERIPH0(79	,0	,1,	948000000U),
PLLPERIPH0(159	,1	,1,	954000000U),
PLLPERIPH0(80	,0	,1,	960000000U),
PLLPERIPH0(161	,1	,1,	966000000U),
PLLPERIPH0(81	,0	,1,	972000000U),
PLLPERIPH0(163	,1	,1,	978000000U),
PLLPERIPH0(82	,0	,1,	984000000U),
PLLPERIPH0(165	,1	,1,	990000000U),
PLLPERIPH0(83	,0	,1,	996000000U),
PLLPERIPH0(167	,1	,1,	1002000000U),
PLLPERIPH0(84	,0	,1,	1008000000U),
PLLPERIPH0(169	,1	,1,	1014000000U),
PLLPERIPH0(85	,0	,1,	1020000000U),
PLLPERIPH0(171	,1	,1,	1026000000U),
PLLPERIPH0(86	,0	,1,	1032000000U),
PLLPERIPH0(173	,1	,1,	1038000000U),
PLLPERIPH0(87	,0	,1,	1044000000U),
PLLPERIPH0(175	,1	,1,	1050000000U),
PLLPERIPH0(88	,0	,1,	1056000000U),
PLLPERIPH0(177	,1	,1,	1062000000U),
PLLPERIPH0(89	,0	,1,	1068000000U),
PLLPERIPH0(179	,1	,1,	1074000000U),
PLLPERIPH0(90	,0	,1,	1080000000U),
PLLPERIPH0(181	,1	,1,	1086000000U),
PLLPERIPH0(91	,0	,1,	1092000000U),
PLLPERIPH0(183	,1	,1,	1098000000U),
PLLPERIPH0(92	,0	,1,	1104000000U),
PLLPERIPH0(93	,0	,1,	1116000000U),
PLLPERIPH0(187	,1	,1,	1122000000U),
PLLPERIPH0(94	,0	,1,	1128000000U),
PLLPERIPH0(189	,1	,1,	1134000000U),
PLLPERIPH0(95	,0	,1,	1140000000U),
PLLPERIPH0(191	,1	,1,	1146000000U),
PLLPERIPH0(96	,0	,1,	1152000000U),
PLLPERIPH0(193	,1	,1,	1158000000U),
PLLPERIPH0(97	,0	,1,	1164000000U),
PLLPERIPH0(195	,1	,1,	1170000000U),
PLLPERIPH0(98	,0	,1,	1176000000U),
PLLPERIPH0(197	,1	,1,	1182000000U),
PLLPERIPH0(99	,0	,1,	1188000000U),
PLLPERIPH0(199	,1	,1,	1194000000U),
PLLPERIPH0(100	,0	,1,	1200000000U),
PLLPERIPH0(201	,1	,1,	1206000000U),
PLLPERIPH0(101	,0	,1,	1212000000U),
PLLPERIPH0(203	,1	,1,	1218000000U),
PLLPERIPH0(102	,0	,1,	1224000000U),
PLLPERIPH0(205	,1	,1,	1230000000U),
PLLPERIPH0(103	,0	,1,	1236000000U),
PLLPERIPH0(207	,1	,1,	1242000000U),
PLLPERIPH0(104	,0	,1,	1248000000U),
PLLPERIPH0(209	,1	,1,	1254000000U),
PLLPERIPH0(105	,0	,1,	1260000000U),
PLLPERIPH0(211	,1	,1,	1266000000U),
PLLPERIPH0(106	,0	,1,	1272000000U),
PLLPERIPH0(213	,1	,1,	1278000000U),
PLLPERIPH0(107	,0	,1,	1284000000U),
PLLPERIPH0(215	,1	,1,	1290000000U),
PLLPERIPH0(108	,0	,1,	1296000000U),
PLLPERIPH0(217	,1	,1,	1302000000U),
PLLPERIPH0(109	,0	,1,	1308000000U),
PLLPERIPH0(219	,1	,1,	1314000000U),
PLLPERIPH0(110	,0	,1,	1320000000U),
PLLPERIPH0(221	,1	,1,	1326000000U),
PLLPERIPH0(111	,0	,1,	1332000000U),
PLLPERIPH0(223	,1	,1,	1338000000U),
PLLPERIPH0(112	,0	,1,	1344000000U),
PLLPERIPH0(225	,1	,1,	1350000000U),
PLLPERIPH0(113	,0	,1,	1356000000U),
PLLPERIPH0(227	,1	,1,	1362000000U),
PLLPERIPH0(114	,0	,1,	1368000000U),
PLLPERIPH0(229	,1	,1,	1374000000U),
PLLPERIPH0(115	,0	,1,	1380000000U),
PLLPERIPH0(231	,1	,1,	1386000000U),
PLLPERIPH0(116	,0	,1,	1392000000U),
PLLPERIPH0(233	,1	,1,	1398000000U),
PLLPERIPH0(117	,0	,1,	1404000000U),
PLLPERIPH0(235	,1	,1,	1410000000U),
PLLPERIPH0(118	,0	,1,	1416000000U),
PLLPERIPH0(237	,1	,1,	1422000000U),
PLLPERIPH0(119	,0	,1,	1428000000U),
PLLPERIPH0(239	,1	,1,	1434000000U),
PLLPERIPH0(120	,0	,1,	1440000000U),
PLLPERIPH0(241	,1	,1,	1446000000U),
PLLPERIPH0(121	,0	,1,	1452000000U),
PLLPERIPH0(243	,1	,1,	1458000000U),
PLLPERIPH0(122	,0	,1,	1464000000U),
PLLPERIPH0(245	,1	,1,	1470000000U),
PLLPERIPH0(123	,0	,1,	1476000000U),
PLLPERIPH0(247	,1	,1,	1482000000U),
PLLPERIPH0(124	,0	,1,	1488000000U),
PLLPERIPH0(249	,1	,1,	1494000000U),
PLLPERIPH0(125	,0	,1,	1500000000U),
PLLPERIPH0(126	,0	,1,	1512000000U),
PLLPERIPH0(127	,0	,1,	1524000000U),
PLLPERIPH0(128	,0	,1,	1536000000U),
PLLPERIPH0(129	,0	,1,	1548000000U),
PLLPERIPH0(130	,0	,1,	1560000000U),
PLLPERIPH0(131	,0	,1,	1572000000U),
PLLPERIPH0(132	,0	,1,	1584000000U),
PLLPERIPH0(133	,0	,1,	1596000000U),
PLLPERIPH0(134	,0	,1,	1608000000U),
PLLPERIPH0(135	,0	,1,	1620000000U),
PLLPERIPH0(136	,0	,1,	1632000000U),
PLLPERIPH0(137	,0	,1,	1644000000U),
PLLPERIPH0(138	,0	,1,	1656000000U),
PLLPERIPH0(139	,0	,1,	1668000000U),
PLLPERIPH0(140	,0	,1,	1680000000U),
PLLPERIPH0(141	,0	,1,	1692000000U),
PLLPERIPH0(142	,0	,1,	1704000000U),
PLLPERIPH0(143	,0	,1,	1716000000U),
PLLPERIPH0(144	,0	,1,	1728000000U),
PLLPERIPH0(145	,0	,1,	1740000000U),
PLLPERIPH0(146	,0	,1,	1752000000U),
PLLPERIPH0(147	,0	,1,	1764000000U),
PLLPERIPH0(148	,0	,1,	1776000000U),
PLLPERIPH0(149	,1	,0,	1788000000U),
PLLPERIPH0(150	,1	,0,	1800000000U),
PLLPERIPH0(151	,1	,0,	1812000000U),
PLLPERIPH0(152	,1	,0,	1824000000U),
PLLPERIPH0(153	,1	,0,	1836000000U),
PLLPERIPH0(154	,1	,0,	1848000000U),
PLLPERIPH0(155	,1	,0,	1860000000U),
PLLPERIPH0(156	,1	,0,	1872000000U),
PLLPERIPH0(157	,1	,0,	1884000000U),
PLLPERIPH0(158	,1	,0,	1896000000U),
PLLPERIPH0(159	,1	,0,	1908000000U),
PLLPERIPH0(160	,1	,0,	1920000000U),
PLLPERIPH0(161	,1	,0,	1932000000U),
PLLPERIPH0(162	,1	,0,	1944000000U),
PLLPERIPH0(163	,1	,0,	1956000000U),
PLLPERIPH0(164	,1	,0,	1968000000U),
PLLPERIPH0(165	,1	,0,	1980000000U),
PLLPERIPH0(166	,1	,0,	1992000000U),
PLLPERIPH0(167	,1	,0,	2004000000U),
PLLPERIPH0(168	,1	,0,	2016000000U),
PLLPERIPH0(169	,1	,0,	2028000000U),
PLLPERIPH0(170	,1	,0,	2040000000U),
PLLPERIPH0(171	,1	,0,	2052000000U),
PLLPERIPH0(172	,1	,0,	2064000000U),
PLLPERIPH0(173	,1	,0,	2076000000U),
PLLPERIPH0(174	,1	,0,	2088000000U),
PLLPERIPH0(175	,1	,0,	2100000000U),
PLLPERIPH0(176	,1	,0,	2112000000U),
PLLPERIPH0(177	,1	,0,	2124000000U),
PLLPERIPH0(178	,1	,0,	2136000000U),
PLLPERIPH0(179	,1	,0,	2148000000U),
PLLPERIPH0(180	,1	,0,	2160000000U),
PLLPERIPH0(181	,1	,0,	2172000000U),
PLLPERIPH0(182	,1	,0,	2184000000U),
PLLPERIPH0(183	,1	,0,	2196000000U),
PLLPERIPH0(184	,1	,0,	2208000000U),
PLLPERIPH0(185	,1	,0,	2220000000U),
PLLPERIPH0(186	,1	,0,	2232000000U),
PLLPERIPH0(187	,1	,0,	2244000000U),
PLLPERIPH0(188	,1	,0,	2256000000U),
PLLPERIPH0(189	,1	,0,	2268000000U),
PLLPERIPH0(190	,1	,0,	2280000000U),
PLLPERIPH0(191	,1	,0,	2292000000U),
PLLPERIPH0(192	,1	,0,	2304000000U),
PLLPERIPH0(193	,1	,0,	2316000000U),
PLLPERIPH0(194	,1	,0,	2328000000U),
PLLPERIPH0(195	,1	,0,	2340000000U),
PLLPERIPH0(196	,1	,0,	2352000000U),
PLLPERIPH0(197	,1	,0,	2364000000U),
PLLPERIPH0(198	,1	,0,	2376000000U),
PLLPERIPH0(199	,1	,0,	2388000000U),
PLLPERIPH0(200	,1	,0,	2400000000U),
PLLPERIPH0(201	,1	,0,	2412000000U),
PLLPERIPH0(202	,1	,0,	2424000000U),
PLLPERIPH0(203	,1	,0,	2436000000U),
PLLPERIPH0(204	,1	,0,	2448000000U),
PLLPERIPH0(205	,1	,0,	2460000000U),
PLLPERIPH0(206	,1	,0,	2472000000U),
PLLPERIPH0(207	,1	,0,	2484000000U),
PLLPERIPH0(208	,1	,0,	2496000000U),
PLLPERIPH0(209	,1	,0,	2508000000U),
PLLPERIPH0(210	,1	,0,	2520000000U),
PLLPERIPH0(211	,1	,0,	2532000000U),
PLLPERIPH0(212	,1	,0,	2544000000U),
PLLPERIPH0(213	,1	,0,	2556000000U),
PLLPERIPH0(214	,1	,0,	2568000000U),
PLLPERIPH0(215	,1	,0,	2580000000U),
PLLPERIPH0(216	,1	,0,	2592000000U),
PLLPERIPH0(217	,1	,0,	2604000000U),
PLLPERIPH0(218	,1	,0,	2616000000U),
PLLPERIPH0(219	,1	,0,	2628000000U),
PLLPERIPH0(220	,1	,0,	2640000000U),
PLLPERIPH0(221	,1	,0,	2652000000U),
PLLPERIPH0(222	,1	,0,	2664000000U),
PLLPERIPH0(223	,1	,0,	2676000000U),
PLLPERIPH0(224	,1	,0,	2688000000U),
PLLPERIPH0(225	,1	,0,	2700000000U),
PLLPERIPH0(226	,1	,0,	2712000000U),
PLLPERIPH0(227	,1	,0,	2724000000U),
PLLPERIPH0(228	,1	,0,	2736000000U),
PLLPERIPH0(229	,1	,0,	2748000000U),
PLLPERIPH0(230	,1	,0,	2760000000U),
PLLPERIPH0(231	,1	,0,	2772000000U),
PLLPERIPH0(232	,1	,0,	2784000000U),
PLLPERIPH0(233	,1	,0,	2796000000U),
PLLPERIPH0(234	,1	,0,	2808000000U),
PLLPERIPH0(235	,1	,0,	2820000000U),
PLLPERIPH0(236	,1	,0,	2832000000U),
PLLPERIPH0(237	,1	,0,	2844000000U),
PLLPERIPH0(238	,1	,0,	2856000000U),
PLLPERIPH0(239	,1	,0,	2868000000U),
PLLPERIPH0(240	,1	,0,	2880000000U),
PLLPERIPH0(241	,1	,0,	2892000000U),
PLLPERIPH0(242	,1	,0,	2904000000U),
PLLPERIPH0(243	,1	,0,	2916000000U),
PLLPERIPH0(244	,1	,0,	2928000000U),
PLLPERIPH0(245	,1	,0,	2940000000U),
PLLPERIPH0(246	,1	,0,	2952000000U),
PLLPERIPH0(247	,1	,0,	2964000000U),
PLLPERIPH0(124	,0	,0,	2976000000U),
PLLPERIPH0(125	,0	,0,	3000000000U),
PLLPERIPH0(126	,0	,0,	3024000000U),
PLLPERIPH0(127	,0	,0,	3048000000U),
PLLPERIPH0(128	,0	,0,	3072000000U),
};
 //N,input,output,freq
static struct sunxi_clk_factor_freq factor_pll5_tbl[] = {
PLLVE(18	,0	,1,	216000000U),
PLLVE(19	,0	,1,	228000000U),
PLLVE(20	,0	,1,	240000000U),
PLLVE(41	,1	,1,	246000000U),
PLLVE(21	,0	,1,	252000000U),
PLLVE(43	,1	,1,	258000000U),
PLLVE(22	,0	,1,	264000000U),
PLLVE(45	,1	,1,	270000000U),
PLLVE(23	,0	,1,	276000000U),
PLLVE(47	,1	,1,	282000000U),
PLLVE(24	,0	,1,	288000000U),
PLLVE(49	,1	,1,	294000000U),
PLLVE(25	,0	,1,	300000000U),
PLLVE(51	,1	,1,	306000000U),
PLLVE(26	,0	,1,	312000000U),
PLLVE(53	,1	,1,	318000000U),
PLLVE(27	,0	,1,	324000000U),
PLLVE(55	,1	,1,	330000000U),
PLLVE(28	,0	,1,	336000000U),
PLLVE(57	,1	,1,	342000000U),
PLLVE(29	,0	,1,	348000000U),
PLLVE(59	,1	,1,	354000000U),
PLLVE(30	,0	,1,	360000000U),
PLLVE(61	,1	,1,	366000000U),
PLLVE(31	,0	,1,	372000000U),
PLLVE(63	,1	,1,	378000000U),
PLLVE(32	,0	,1,	384000000U),
PLLVE(65	,1	,1,	390000000U),
PLLVE(33	,0	,1,	396000000U),
PLLVE(67	,1	,1,	402000000U),
PLLVE(34	,0	,1,	408000000U),
PLLVE(69	,1	,1,	414000000U),
PLLVE(35	,0	,1,	420000000U),
PLLVE(71	,1	,1,	426000000U),
PLLVE(36	,0	,1,	432000000U),
PLLVE(73	,1	,1,	438000000U),
PLLVE(37	,0	,1,	444000000U),
PLLVE(75	,1	,1,	450000000U),
PLLVE(38	,0	,1,	456000000U),
PLLVE(77	,1	,1,	462000000U),
PLLVE(39	,0	,1,	468000000U),
PLLVE(79	,1	,1,	474000000U),
PLLVE(40	,0	,1,	480000000U),
PLLVE(81	,1	,1,	486000000U),
PLLVE(41	,0	,1,	492000000U),
PLLVE(83	,1	,1,	498000000U),
PLLVE(42	,0	,1,	504000000U),
PLLVE(85	,1	,1,	510000000U),
PLLVE(43	,0	,1,	516000000U),
PLLVE(87	,1	,1,	522000000U),
PLLVE(44	,0	,1,	528000000U),
PLLVE(89	,1	,1,	534000000U),
PLLVE(45	,0	,1,	540000000U),
PLLVE(91	,1	,1,	546000000U),
PLLVE(46	,0	,1,	552000000U),
PLLVE(93	,1	,1,	558000000U),
PLLVE(47	,0	,1,	564000000U),
PLLVE(95	,1	,1,	570000000U),
PLLVE(48	,0	,1,	576000000U),
PLLVE(97	,1	,1,	582000000U),
PLLVE(49	,0	,1,	588000000U),
PLLVE(99	,1	,1,	594000000U),
PLLVE(50	,0	,1,	600000000U),
PLLVE(101	,1	,1,	606000000U),
PLLVE(51	,0	,1,	612000000U),
PLLVE(103	,1	,1,	618000000U),
PLLVE(52	,0	,1,	624000000U),
PLLVE(105	,1	,1,	630000000U),
PLLVE(53	,0	,1,	636000000U),
PLLVE(107	,1	,1,	642000000U),
PLLVE(54	,0	,1,	648000000U),
PLLVE(109	,1	,1,	654000000U),
PLLVE(55	,0	,1,	660000000U),
PLLVE(111	,1	,1,	666000000U),
PLLVE(56	,0	,1,	672000000U),
PLLVE(113	,1	,1,	678000000U),
PLLVE(57	,0	,1,	684000000U),
PLLVE(115	,1	,1,	690000000U),
PLLVE(58	,0	,1,	696000000U),
PLLVE(117	,1	,1,	702000000U),
PLLVE(59	,0	,1,	708000000U),
PLLVE(119	,1	,1,	714000000U),
PLLVE(60	,0	,1,	720000000U),
PLLVE(121	,1	,1,	726000000U),
PLLVE(61	,0	,1,	732000000U),
PLLVE(123	,1	,1,	738000000U),
PLLVE(62	,0	,1,	744000000U),
PLLVE(125	,1	,1,	750000000U),
PLLVE(63	,0	,1,	756000000U),
PLLVE(127	,1	,1,	762000000U),
PLLVE(64	,0	,1,	768000000U),
PLLVE(129	,1	,1,	774000000U),
PLLVE(65	,0	,1,	780000000U),
PLLVE(131	,1	,1,	786000000U),
PLLVE(66	,0	,1,	792000000U),
PLLVE(133	,1	,1,	798000000U),
PLLVE(67	,0	,1,	804000000U),
PLLVE(135	,1	,1,	810000000U),
PLLVE(68	,0	,1,	816000000U),
PLLVE(137	,1	,1,	822000000U),
PLLVE(69	,0	,1,	828000000U),
PLLVE(139	,1	,1,	834000000U),
PLLVE(70	,0	,1,	840000000U),
PLLVE(141	,1	,1,	846000000U),
PLLVE(71	,0	,1,	852000000U),
PLLVE(143	,1	,1,	858000000U),
PLLVE(72	,0	,1,	864000000U),
PLLVE(145	,1	,1,	870000000U),
PLLVE(73	,0	,1,	876000000U),
PLLVE(147	,1	,1,	882000000U),
PLLVE(74	,0	,1,	888000000U),
PLLVE(149	,1	,1,	894000000U),
PLLVE(75	,0	,1,	900000000U),
PLLVE(151	,1	,1,	906000000U),
PLLVE(76	,0	,1,	912000000U),
PLLVE(153	,1	,1,	918000000U),
PLLVE(77	,0	,1,	924000000U),
PLLVE(155	,1	,1,	930000000U),
PLLVE(78	,0	,1,	936000000U),
PLLVE(157	,1	,1,	942000000U),
PLLVE(79	,0	,1,	948000000U),
PLLVE(159	,1	,1,	954000000U),
PLLVE(80	,0	,1,	960000000U),
PLLVE(161	,1	,1,	966000000U),
PLLVE(81	,0	,1,	972000000U),
PLLVE(163	,1	,1,	978000000U),
PLLVE(82	,0	,1,	984000000U),
PLLVE(165	,1	,1,	990000000U),
PLLVE(83	,0	,1,	996000000U),
PLLVE(167	,1	,1,	1002000000U),
PLLVE(84	,0	,1,	1008000000U),
PLLVE(169	,1	,1,	1014000000U),
PLLVE(85	,0	,1,	1020000000U),
PLLVE(171	,1	,1,	1026000000U),
PLLVE(86	,0	,1,	1032000000U),
PLLVE(173	,1	,1,	1038000000U),
PLLVE(87	,0	,1,	1044000000U),
PLLVE(175	,1	,1,	1050000000U),
PLLVE(88	,0	,1,	1056000000U),
PLLVE(177	,1	,1,	1062000000U),
PLLVE(89	,0	,1,	1068000000U),
PLLVE(179	,1	,1,	1074000000U),
PLLVE(90	,0	,1,	1080000000U),
PLLVE(181	,1	,1,	1086000000U),
PLLVE(91	,0	,1,	1092000000U),
PLLVE(183	,1	,1,	1098000000U),
PLLVE(92	,0	,1,	1104000000U),
PLLVE(185	,1	,1,	1110000000U),
PLLVE(93	,0	,1,	1116000000U),
PLLVE(187	,1	,1,	1122000000U),
PLLVE(94	,0	,1,	1128000000U),
PLLVE(189	,1	,1,	1134000000U),
PLLVE(95	,0	,1,	1140000000U),
PLLVE(191	,1	,1,	1146000000U),
PLLVE(96	,0	,1,	1152000000U),
PLLVE(193	,1	,1,	1158000000U),
PLLVE(97	,0	,1,	1164000000U),
PLLVE(195	,1	,1,	1170000000U),
PLLVE(98	,0	,1,	1176000000U),
PLLVE(197	,1	,1,	1182000000U),
PLLVE(99	,0	,1,	1188000000U),
PLLVE(199	,1	,1,	1194000000U),
PLLVE(100	,0	,1,	1200000000U),
PLLVE(101	,0	,1,	1212000000U),
PLLVE(102	,0	,1,	1224000000U),
PLLVE(103	,0	,1,	1236000000U),
PLLVE(104	,0	,1,	1248000000U),
PLLVE(105	,0	,1,	1260000000U),
PLLVE(106	,0	,1,	1272000000U),
PLLVE(107	,0	,1,	1284000000U),
PLLVE(108	,0	,1,	1296000000U),
PLLVE(109	,0	,1,	1308000000U),
PLLVE(110	,0	,1,	1320000000U),
PLLVE(111	,0	,1,	1332000000U),
PLLVE(112	,0	,1,	1344000000U),
PLLVE(113	,0	,1,	1356000000U),
PLLVE(114	,0	,1,	1368000000U),
PLLVE(115	,0	,1,	1380000000U),
PLLVE(116	,0	,1,	1392000000U),
PLLVE(117	,0	,1,	1404000000U),
PLLVE(118	,0	,1,	1416000000U),
PLLVE(119	,0	,1,	1428000000U),
PLLVE(120	,0	,1,	1440000000U),
PLLVE(121	,0	,1,	1452000000U),
PLLVE(122	,0	,1,	1464000000U),
PLLVE(123	,0	,1,	1476000000U),
PLLVE(124	,0	,1,	1488000000U),
PLLVE(125	,0	,1,	1500000000U),
PLLVE(126	,0	,1,	1512000000U),
PLLVE(127	,0	,1,	1524000000U),
PLLVE(128	,0	,1,	1536000000U),
PLLVE(129	,0	,1,	1548000000U),
PLLVE(130	,0	,1,	1560000000U),
PLLVE(131	,1	,0,	1572000000U),
PLLVE(132	,1	,0,	1584000000U),
PLLVE(133	,1	,0,	1596000000U),
PLLVE(134	,1	,0,	1608000000U),
PLLVE(135	,1	,0,	1620000000U),
PLLVE(136	,1	,0,	1632000000U),
PLLVE(137	,1	,0,	1644000000U),
PLLVE(138	,1	,0,	1656000000U),
PLLVE(139	,1	,0,	1668000000U),
PLLVE(140	,1	,0,	1680000000U),
PLLVE(141	,1	,0,	1692000000U),
PLLVE(142	,1	,0,	1704000000U),
PLLVE(143	,1	,0,	1716000000U),
PLLVE(144	,1	,0,	1728000000U),
PLLVE(145	,1	,0,	1740000000U),
PLLVE(146	,1	,0,	1752000000U),
PLLVE(147	,1	,0,	1764000000U),
PLLVE(148	,1	,0,	1776000000U),
PLLVE(149	,1	,0,	1788000000U),
PLLVE(150	,1	,0,	1800000000U),
PLLVE(151	,1	,0,	1812000000U),
PLLVE(152	,1	,0,	1824000000U),
PLLVE(153	,1	,0,	1836000000U),
PLLVE(154	,1	,0,	1848000000U),
PLLVE(155	,1	,0,	1860000000U),
PLLVE(156	,1	,0,	1872000000U),
PLLVE(157	,1	,0,	1884000000U),
PLLVE(158	,1	,0,	1896000000U),
PLLVE(159	,1	,0,	1908000000U),
PLLVE(160	,1	,0,	1920000000U),
PLLVE(161	,1	,0,	1932000000U),
PLLVE(162	,1	,0,	1944000000U),
PLLVE(163	,1	,0,	1956000000U),
PLLVE(164	,1	,0,	1968000000U),
PLLVE(165	,1	,0,	1980000000U),
PLLVE(166	,1	,0,	1992000000U),
PLLVE(167	,1	,0,	2004000000U),
PLLVE(168	,1	,0,	2016000000U),
PLLVE(169	,1	,0,	2028000000U),
PLLVE(170	,1	,0,	2040000000U),
PLLVE(171	,1	,0,	2052000000U),
PLLVE(172	,1	,0,	2064000000U),
PLLVE(173	,1	,0,	2076000000U),
PLLVE(174	,1	,0,	2088000000U),
PLLVE(175	,1	,0,	2100000000U),
PLLVE(176	,1	,0,	2112000000U),
PLLVE(177	,1	,0,	2124000000U),
PLLVE(178	,1	,0,	2136000000U),
PLLVE(179	,1	,0,	2148000000U),
PLLVE(180	,1	,0,	2160000000U),
PLLVE(181	,1	,0,	2172000000U),
PLLVE(182	,1	,0,	2184000000U),
PLLVE(183	,1	,0,	2196000000U),
PLLVE(184	,1	,0,	2208000000U),
PLLVE(185	,1	,0,	2220000000U),
PLLVE(186	,1	,0,	2232000000U),
PLLVE(187	,1	,0,	2244000000U),
PLLVE(188	,1	,0,	2256000000U),
PLLVE(189	,1	,0,	2268000000U),
PLLVE(190	,1	,0,	2280000000U),
PLLVE(191	,1	,0,	2292000000U),
PLLVE(192	,1	,0,	2304000000U),
PLLVE(193	,1	,0,	2316000000U),
PLLVE(194	,1	,0,	2328000000U),
PLLVE(195	,1	,0,	2340000000U),
PLLVE(196	,1	,0,	2352000000U),
PLLVE(197	,1	,0,	2364000000U),
PLLVE(198	,1	,0,	2376000000U),
PLLVE(199	,1	,0,	2388000000U),
PLLVE(200	,1	,0,	2400000000U),
PLLVE(101	,0	,0,	2424000000U),
PLLVE(102	,0	,0,	2448000000U),
PLLVE(103	,0	,0,	2472000000U),
PLLVE(104	,0	,0,	2496000000U),
PLLVE(105	,0	,0,	2520000000U),
PLLVE(106	,0	,0,	2544000000U),
PLLVE(107	,0	,0,	2568000000U),
PLLVE(108	,0	,0,	2592000000U),
PLLVE(109	,0	,0,	2616000000U),
PLLVE(110	,0	,0,	2640000000U),
PLLVE(111	,0	,0,	2664000000U),
PLLVE(112	,0	,0,	2688000000U),
PLLVE(113	,0	,0,	2712000000U),
PLLVE(114	,0	,0,	2736000000U),
PLLVE(115	,0	,0,	2760000000U),
PLLVE(116	,0	,0,	2784000000U),
PLLVE(117	,0	,0,	2808000000U),
PLLVE(118	,0	,0,	2832000000U),
PLLVE(119	,0	,0,	2856000000U),
PLLVE(120	,0	,0,	2880000000U),
PLLVE(121	,0	,0,	2904000000U),
PLLVE(122	,0	,0,	2928000000U),
PLLVE(123	,0	,0,	2952000000U),
PLLVE(124	,0	,0,	2976000000U),
PLLVE(125	,0	,0,	3000000000U),
PLLVE(126	,0	,0,	3024000000U),
PLLVE(127	,0	,0,	3048000000U),
PLLVE(128	,0	,0,	3072000000U), 
};

 //N,input,output,freq
static struct sunxi_clk_factor_freq factor_pll6_tbl[] = {
PLLDDR(32	,1	,1,	192000000U),
PLLDDR(33	,1	,1,	198000000U),
PLLDDR(34	,1	,1,	204000000U),
PLLDDR(35	,1	,1,	210000000U),
PLLDDR(18	,0	,1,	216000000U),
PLLDDR(37	,1	,1,	222000000U),
PLLDDR(19	,0	,1,	228000000U),
PLLDDR(39	,1	,1,	234000000U),
PLLDDR(20	,0	,1,	240000000U),
PLLDDR(41	,1	,1,	246000000U),
PLLDDR(21	,0	,1,	252000000U),
PLLDDR(43	,1	,1,	258000000U),
PLLDDR(22	,0	,1,	264000000U),
PLLDDR(45	,1	,1,	270000000U),
PLLDDR(23	,0	,1,	276000000U),
PLLDDR(47	,1	,1,	282000000U),
PLLDDR(24	,0	,1,	288000000U),
PLLDDR(49	,1	,1,	294000000U),
PLLDDR(25	,0	,1,	300000000U),
PLLDDR(51	,1	,1,	306000000U),
PLLDDR(26	,0	,1,	312000000U),
PLLDDR(53	,1	,1,	318000000U),
PLLDDR(27	,0	,1,	324000000U),
PLLDDR(55	,1	,1,	330000000U),
PLLDDR(28	,1	,0,	336000000U),
PLLDDR(57	,1	,1,	342000000U),
PLLDDR(29	,1	,0,	348000000U),
PLLDDR(59	,1	,1,	354000000U),
PLLDDR(30	,0	,1,	360000000U),
PLLDDR(61	,1	,1,	366000000U),
PLLDDR(31	,0	,1,	372000000U),
PLLDDR(63	,1	,1,	378000000U),
PLLDDR(32	,0	,1,	384000000U),
PLLDDR(65	,1	,1,	390000000U),
PLLDDR(33	,0	,1,	396000000U),
PLLDDR(67	,1	,1,	402000000U),
PLLDDR(34	,0	,1,	408000000U),
PLLDDR(69	,1	,1,	414000000U),
PLLDDR(35	,0	,1,	420000000U),
PLLDDR(71	,1	,1,	426000000U),
PLLDDR(36	,0	,1,	432000000U),
PLLDDR(73	,1	,1,	438000000U),
PLLDDR(37	,0	,1,	444000000U),
PLLDDR(75	,1	,1,	450000000U),
PLLDDR(38	,0	,1,	456000000U),
PLLDDR(77	,1	,1,	462000000U),
PLLDDR(39	,0	,1,	468000000U),
PLLDDR(79	,1	,1,	474000000U),
PLLDDR(40	,0	,1,	480000000U),
PLLDDR(81	,1	,1,	486000000U),
PLLDDR(41	,0	,1,	492000000U),
PLLDDR(83	,1	,1,	498000000U),
PLLDDR(42	,0	,1,	504000000U),
PLLDDR(85	,1	,1,	510000000U),
PLLDDR(43	,0	,1,	516000000U),
PLLDDR(87	,1	,1,	522000000U),
PLLDDR(44	,0	,1,	528000000U),
PLLDDR(89	,1	,1,	534000000U),
PLLDDR(45	,0	,1,	540000000U),
PLLDDR(91	,1	,1,	546000000U),
PLLDDR(46	,0	,1,	552000000U),
PLLDDR(93	,1	,1,	558000000U),
PLLDDR(47	,0	,1,	564000000U),
PLLDDR(95	,1	,1,	570000000U),
PLLDDR(48	,0	,1,	576000000U),
PLLDDR(97	,1	,1,	582000000U),
PLLDDR(49	,0	,1,	588000000U),
PLLDDR(99	,1	,1,	594000000U),
PLLDDR(50	,0	,1,	600000000U),
PLLDDR(101	,1	,1,	606000000U),
PLLDDR(51	,0	,1,	612000000U),
PLLDDR(103	,1	,1,	618000000U),
PLLDDR(52	,0	,1,	624000000U),
PLLDDR(105	,1	,1,	630000000U),
PLLDDR(53	,0	,1,	636000000U),
PLLDDR(107	,1	,1,	642000000U),
PLLDDR(54	,0	,1,	648000000U),
PLLDDR(109	,1	,1,	654000000U),
PLLDDR(55	,0	,1,	660000000U),
PLLDDR(111	,1	,1,	666000000U),
PLLDDR(56	,0	,1,	672000000U),
PLLDDR(113	,1	,1,	678000000U),
PLLDDR(57	,0	,1,	684000000U),
PLLDDR(115	,1	,1,	690000000U),
PLLDDR(58	,0	,1,	696000000U),
PLLDDR(117	,1	,1,	702000000U),
PLLDDR(59	,0	,1,	708000000U),
PLLDDR(119	,1	,1,	714000000U),
PLLDDR(60	,0	,1,	720000000U),
PLLDDR(121	,1	,1,	726000000U),
PLLDDR(61	,0	,1,	732000000U),
PLLDDR(123	,1	,1,	738000000U),
PLLDDR(62	,0	,1,	744000000U),
PLLDDR(125	,1	,1,	750000000U),
PLLDDR(63	,0	,1,	756000000U),
PLLDDR(127	,1	,1,	762000000U),
PLLDDR(64	,0	,1,	768000000U),
PLLDDR(129	,1	,1,	774000000U),
PLLDDR(65	,0	,1,	780000000U),
PLLDDR(131	,1	,1,	786000000U),
PLLDDR(66	,0	,1,	792000000U),
PLLDDR(133	,1	,1,	798000000U),
PLLDDR(67	,0	,1,	804000000U),
PLLDDR(135	,1	,1,	810000000U),
PLLDDR(68	,0	,1,	816000000U),
PLLDDR(137	,1	,1,	822000000U),
PLLDDR(69	,0	,1,	828000000U),
PLLDDR(139	,1	,1,	834000000U),
PLLDDR(70	,0	,1,	840000000U),
PLLDDR(141	,1	,1,	846000000U),
PLLDDR(71	,0	,1,	852000000U),
PLLDDR(143	,1	,1,	858000000U),
PLLDDR(72	,0	,1,	864000000U),
PLLDDR(145	,1	,1,	870000000U),
PLLDDR(73	,0	,1,	876000000U),
PLLDDR(147	,1	,1,	882000000U),
PLLDDR(74	,0	,1,	888000000U),
PLLDDR(149	,1	,1,	894000000U),
PLLDDR(75	,0	,1,	900000000U),
PLLDDR(151	,1	,1,	906000000U),
PLLDDR(76	,0	,1,	912000000U),
PLLDDR(153	,1	,1,	918000000U),
PLLDDR(77	,0	,1,	924000000U),
PLLDDR(155	,1	,1,	930000000U),
PLLDDR(78	,0	,1,	936000000U),
PLLDDR(157	,1	,1,	942000000U),
PLLDDR(79	,0	,1,	948000000U),
PLLDDR(159	,1	,1,	954000000U),
PLLDDR(80	,0	,1,	960000000U),
PLLDDR(161	,1	,1,	966000000U),
PLLDDR(81	,0	,1,	972000000U),
PLLDDR(163	,1	,1,	978000000U),
PLLDDR(82	,0	,1,	984000000U),
PLLDDR(165	,1	,1,	990000000U),
PLLDDR(83	,0	,1,	996000000U),
PLLDDR(167	,1	,1,	1002000000U),
PLLDDR(84	,0	,1,	1008000000U),
PLLDDR(169	,1	,1,	1014000000U),
PLLDDR(85	,0	,1,	1020000000U),
PLLDDR(171	,1	,1,	1026000000U),
PLLDDR(86	,0	,1,	1032000000U),
PLLDDR(173	,1	,1,	1038000000U),
PLLDDR(87	,0	,1,	1044000000U),
PLLDDR(175	,1	,1,	1050000000U),
PLLDDR(88	,0	,1,	1056000000U),
PLLDDR(177	,1	,1,	1062000000U),
PLLDDR(89	,0	,1,	1068000000U),
PLLDDR(179	,1	,1,	1074000000U),
PLLDDR(90	,0	,1,	1080000000U),
PLLDDR(181	,1	,1,	1086000000U),
PLLDDR(91	,0	,1,	1092000000U),
PLLDDR(183	,1	,1,	1098000000U),
PLLDDR(92	,0	,1,	1104000000U),
PLLDDR(185	,1	,1,	1110000000U),
PLLDDR(93	,0	,1,	1116000000U),
PLLDDR(187	,1	,1,	1122000000U),
PLLDDR(94	,0	,1,	1128000000U),
PLLDDR(189	,1	,1,	1134000000U),
PLLDDR(95	,0	,1,	1140000000U),
PLLDDR(191	,1	,1,	1146000000U),
PLLDDR(96	,0	,1,	1152000000U),
PLLDDR(193	,1	,1,	1158000000U),
PLLDDR(97	,0	,1,	1164000000U),
PLLDDR(195	,1	,1,	1170000000U),
PLLDDR(98	,0	,1,	1176000000U),
PLLDDR(197	,1	,1,	1182000000U),
PLLDDR(99	,0	,1,	1188000000U),
PLLDDR(199	,1	,1,	1194000000U),
PLLDDR(100	,0	,1,	1200000000U),
PLLDDR(101	,0	,1,	1212000000U),
PLLDDR(102	,0	,1,	1224000000U),
PLLDDR(103	,0	,1,	1236000000U),
PLLDDR(104	,0	,1,	1248000000U),
PLLDDR(105	,0	,1,	1260000000U),
PLLDDR(106	,0	,1,	1272000000U),
PLLDDR(107	,0	,1,	1284000000U),
PLLDDR(108	,0	,1,	1296000000U),
PLLDDR(109	,0	,1,	1308000000U),
PLLDDR(110	,0	,1,	1320000000U),
PLLDDR(111	,0	,1,	1332000000U),
PLLDDR(112	,0	,1,	1344000000U),
PLLDDR(113	,0	,1,	1356000000U),
PLLDDR(114	,0	,1,	1368000000U),
PLLDDR(115	,0	,1,	1380000000U),
PLLDDR(116	,0	,1,	1392000000U),
PLLDDR(117	,0	,1,	1404000000U),
PLLDDR(118	,0	,1,	1416000000U),
PLLDDR(119	,0	,1,	1428000000U),
PLLDDR(120	,0	,1,	1440000000U),
PLLDDR(121	,0	,1,	1452000000U),
PLLDDR(122	,0	,1,	1464000000U),
PLLDDR(123	,0	,1,	1476000000U),
PLLDDR(124	,0	,1,	1488000000U),
PLLDDR(125	,0	,1,	1500000000U),
PLLDDR(126	,0	,1,	1512000000U),
PLLDDR(127	,1	,0,	1524000000U),
PLLDDR(128	,1	,0,	1536000000U),
PLLDDR(129	,1	,0,	1548000000U),
PLLDDR(130	,1	,0,	1560000000U),
PLLDDR(131	,1	,0,	1572000000U),
PLLDDR(132	,1	,0,	1584000000U),
PLLDDR(133	,1	,0,	1596000000U),
PLLDDR(134	,1	,0,	1608000000U),
PLLDDR(135	,1	,0,	1620000000U),
PLLDDR(136	,1	,0,	1632000000U),
PLLDDR(137	,1	,0,	1644000000U),
PLLDDR(138	,1	,0,	1656000000U),
PLLDDR(139	,1	,0,	1668000000U),
PLLDDR(140	,1	,0,	1680000000U),
PLLDDR(141	,1	,0,	1692000000U),
PLLDDR(142	,1	,0,	1704000000U),
PLLDDR(143	,1	,0,	1716000000U),
PLLDDR(144	,1	,0,	1728000000U),
PLLDDR(145	,1	,0,	1740000000U),
PLLDDR(146	,1	,0,	1752000000U),
PLLDDR(147	,1	,0,	1764000000U),
PLLDDR(148	,1	,0,	1776000000U),
PLLDDR(149	,1	,0,	1788000000U),
PLLDDR(150	,1	,0,	1800000000U),
PLLDDR(151	,1	,0,	1812000000U),
PLLDDR(152	,1	,0,	1824000000U),
PLLDDR(153	,1	,0,	1836000000U),
PLLDDR(154	,1	,0,	1848000000U),
PLLDDR(155	,1	,0,	1860000000U),
PLLDDR(156	,1	,0,	1872000000U),
PLLDDR(157	,1	,0,	1884000000U),
PLLDDR(158	,1	,0,	1896000000U),
PLLDDR(159	,1	,0,	1908000000U),
PLLDDR(160	,1	,0,	1920000000U),
PLLDDR(161	,1	,0,	1932000000U),
PLLDDR(162	,1	,0,	1944000000U),
PLLDDR(163	,1	,0,	1956000000U),
PLLDDR(164	,1	,0,	1968000000U),
PLLDDR(165	,1	,0,	1980000000U),
PLLDDR(166	,1	,0,	1992000000U),
PLLDDR(167	,1	,0,	2004000000U),
PLLDDR(168	,1	,0,	2016000000U),
PLLDDR(169	,1	,0,	2028000000U),
PLLDDR(170	,1	,0,	2040000000U),
PLLDDR(171	,1	,0,	2052000000U),
PLLDDR(172	,1	,0,	2064000000U),
PLLDDR(173	,1	,0,	2076000000U),
PLLDDR(174	,1	,0,	2088000000U),
PLLDDR(175	,1	,0,	2100000000U),
PLLDDR(176	,1	,0,	2112000000U),
PLLDDR(177	,1	,0,	2124000000U),
PLLDDR(178	,1	,0,	2136000000U),
PLLDDR(179	,1	,0,	2148000000U),
PLLDDR(180	,1	,0,	2160000000U),
PLLDDR(181	,1	,0,	2172000000U),
PLLDDR(182	,1	,0,	2184000000U),
PLLDDR(183	,1	,0,	2196000000U),
PLLDDR(184	,1	,0,	2208000000U),
PLLDDR(185	,1	,0,	2220000000U),
PLLDDR(186	,1	,0,	2232000000U),
PLLDDR(187	,1	,0,	2244000000U),
PLLDDR(188	,1	,0,	2256000000U),
PLLDDR(189	,1	,0,	2268000000U),
PLLDDR(190	,1	,0,	2280000000U),
PLLDDR(191	,1	,0,	2292000000U),
PLLDDR(192	,1	,0,	2304000000U),
PLLDDR(193	,1	,0,	2316000000U),
PLLDDR(194	,1	,0,	2328000000U),
PLLDDR(195	,1	,0,	2340000000U),
PLLDDR(196	,1	,0,	2352000000U),
PLLDDR(197	,1	,0,	2364000000U),
PLLDDR(198	,1	,0,	2376000000U),
PLLDDR(199	,1	,0,	2388000000U),
PLLDDR(200	,1	,0,	2400000000U),
PLLDDR(101	,0	,0,	2424000000U),
PLLDDR(102	,0	,0,	2448000000U),
PLLDDR(103	,0	,0,	2472000000U),
PLLDDR(104	,0	,0,	2496000000U),
PLLDDR(105	,0	,0,	2520000000U),
PLLDDR(106	,0	,0,	2544000000U),
PLLDDR(107	,0	,0,	2568000000U),
PLLDDR(108	,0	,0,	2592000000U),
PLLDDR(109	,0	,0,	2616000000U),
PLLDDR(110	,0	,0,	2640000000U),
PLLDDR(111	,0	,0,	2664000000U),
PLLDDR(112	,0	,0,	2688000000U),
PLLDDR(113	,0	,0,	2712000000U),
PLLDDR(114	,0	,0,	2736000000U),
PLLDDR(115	,0	,0,	2760000000U),
PLLDDR(116	,0	,0,	2784000000U),
PLLDDR(117	,0	,0,	2808000000U),
PLLDDR(118	,0	,0,	2832000000U),
PLLDDR(119	,0	,0,	2856000000U),
PLLDDR(120	,0	,0,	2880000000U),
PLLDDR(121	,0	,0,	2904000000U),
PLLDDR(122	,0	,0,	2928000000U),
PLLDDR(123	,0	,0,	2952000000U),
PLLDDR(124	,0	,0,	2976000000U),
PLLDDR(125	,0	,0,	3000000000U),
PLLDDR(126	,0	,0,	3024000000U),
PLLDDR(127	,0	,0,	3048000000U),
PLLDDR(128	,0	,0,	3072000000U),
PLLDDR(129	,0	,0,	3096000000U),
};

 //N,input,freq
static struct sunxi_clk_factor_freq factor_pll7_tbl[] = {
PLLVIDEO0(22	,1,	264000000U),
PLLVIDEO0(23	,1,	276000000U),
PLLVIDEO0(24	,1,	288000000U),
PLLVIDEO0(25	,1,	300000000U),
PLLVIDEO0(13	,0,	312000000U),
PLLVIDEO0(27	,1,	324000000U),
PLLVIDEO0(14	,0,	336000000U),
PLLVIDEO0(29	,1,	348000000U),
PLLVIDEO0(15	,0,	360000000U),
PLLVIDEO0(31	,1,	372000000U),
PLLVIDEO0(16	,0,	384000000U),
PLLVIDEO0(33	,1,	396000000U),
PLLVIDEO0(17	,0,	408000000U),
PLLVIDEO0(35	,1,	420000000U),
PLLVIDEO0(18	,0,	432000000U),
PLLVIDEO0(37	,1,	444000000U),
PLLVIDEO0(19	,0,	456000000U),
PLLVIDEO0(39	,1,	468000000U),
PLLVIDEO0(20	,0,	480000000U),
PLLVIDEO0(41	,1,	492000000U),
PLLVIDEO0(21	,0,	504000000U),
PLLVIDEO0(43	,1,	516000000U),
PLLVIDEO0(22	,0,	528000000U),
PLLVIDEO0(45	,1,	540000000U),
PLLVIDEO0(23	,0,	552000000U),
PLLVIDEO0(47	,1,	564000000U),
PLLVIDEO0(24	,0,	576000000U),
PLLVIDEO0(49	,1,	588000000U),
PLLVIDEO0(25	,0,	600000000U),
PLLVIDEO0(51	,1,	612000000U),
PLLVIDEO0(26	,0,	624000000U),
PLLVIDEO0(53	,1,	636000000U),
PLLVIDEO0(27	,0,	648000000U),
PLLVIDEO0(55	,1,	660000000U),
PLLVIDEO0(28	,0,	672000000U),
PLLVIDEO0(57	,1,	684000000U),
PLLVIDEO0(29	,0,	696000000U),
PLLVIDEO0(59	,1,	708000000U),
PLLVIDEO0(30	,0,	720000000U),
PLLVIDEO0(61	,1,	732000000U),
PLLVIDEO0(31	,0,	744000000U),
PLLVIDEO0(63	,1,	756000000U),
PLLVIDEO0(32	,0,	768000000U),
PLLVIDEO0(65	,1,	780000000U),
PLLVIDEO0(33	,0,	792000000U),
PLLVIDEO0(67	,1,	804000000U),
PLLVIDEO0(34	,0,	816000000U),
PLLVIDEO0(69	,1,	828000000U),
PLLVIDEO0(35	,0,	840000000U),
PLLVIDEO0(71	,1,	852000000U),
PLLVIDEO0(36	,0,	864000000U),
PLLVIDEO0(73	,1,	876000000U),
PLLVIDEO0(37	,0,	888000000U),
PLLVIDEO0(75	,1,	900000000U),
PLLVIDEO0(38	,0,	912000000U),
PLLVIDEO0(77	,1,	924000000U),
PLLVIDEO0(39	,0,	936000000U),
PLLVIDEO0(79	,1,	948000000U),
PLLVIDEO0(40	,0,	960000000U),
PLLVIDEO0(81	,1,	972000000U),
PLLVIDEO0(41	,0,	984000000U),
PLLVIDEO0(83	,1,	996000000U),
PLLVIDEO0(42	,0,	1008000000U),
PLLVIDEO0(85	,1,	1020000000U),
PLLVIDEO0(43	,0,	1032000000U),
PLLVIDEO0(87	,1,	1044000000U),
PLLVIDEO0(44	,0,	1056000000U),
PLLVIDEO0(89	,1,	1068000000U),
PLLVIDEO0(45	,0,	1080000000U),
PLLVIDEO0(91	,1,	1092000000U),
PLLVIDEO0(46	,0,	1104000000U),
PLLVIDEO0(93	,1,	1116000000U),
PLLVIDEO0(47	,0,	1128000000U),
PLLVIDEO0(95	,1,	1140000000U),
PLLVIDEO0(48	,0,	1152000000U),
PLLVIDEO0(97	,1,	1164000000U),
PLLVIDEO0(49	,0,	1176000000U),
PLLVIDEO0(99	,1,	1188000000U),
PLLVIDEO0(50	,0,	1200000000U),
PLLVIDEO0(101	,1,	1212000000U),
PLLVIDEO0(51	,0,	1224000000U),
PLLVIDEO0(103	,1,	1236000000U),
PLLVIDEO0(52	,0,	1248000000U),
PLLVIDEO0(105	,1,	1260000000U),
PLLVIDEO0(53	,0,	1272000000U),
PLLVIDEO0(107	,1,	1284000000U),
PLLVIDEO0(54	,0,	1296000000U),
PLLVIDEO0(109	,1,	1308000000U),
PLLVIDEO0(55	,0,	1320000000U),
PLLVIDEO0(111	,1,	1332000000U),
PLLVIDEO0(56	,0,	1344000000U),
PLLVIDEO0(113	,1,	1356000000U),
PLLVIDEO0(57	,0,	1368000000U),
PLLVIDEO0(115	,1,	1380000000U),
PLLVIDEO0(58	,0,	1392000000U),
PLLVIDEO0(117	,1,	1404000000U),
PLLVIDEO0(59	,0,	1416000000U),
PLLVIDEO0(119	,1,	1428000000U),
PLLVIDEO0(60	,0,	1440000000U),
PLLVIDEO0(121	,1,	1452000000U),
PLLVIDEO0(61	,0,	1464000000U),
PLLVIDEO0(123	,1,	1476000000U),
PLLVIDEO0(62	,0,	1488000000U),
PLLVIDEO0(125	,1,	1500000000U),
PLLVIDEO0(63	,0,	1512000000U),
PLLVIDEO0(127	,1,	1524000000U),
PLLVIDEO0(64	,0,	1536000000U),
PLLVIDEO0(129	,1,	1548000000U),
PLLVIDEO0(65	,0,	1560000000U),
PLLVIDEO0(131	,1,	1572000000U),
PLLVIDEO0(66	,0,	1584000000U),
PLLVIDEO0(133	,1,	1596000000U),
PLLVIDEO0(67	,0,	1608000000U),
PLLVIDEO0(135	,1,	1620000000U),
PLLVIDEO0(68	,0,	1632000000U),
PLLVIDEO0(137	,1,	1644000000U),
PLLVIDEO0(69	,0,	1656000000U),
PLLVIDEO0(139	,1,	1668000000U),
PLLVIDEO0(70	,0,	1680000000U),
PLLVIDEO0(141	,1,	1692000000U),
PLLVIDEO0(71	,0,	1704000000U),
PLLVIDEO0(143	,1,	1716000000U),
PLLVIDEO0(72	,0,	1728000000U),
PLLVIDEO0(145	,1,	1740000000U),
PLLVIDEO0(73	,0,	1752000000U),
PLLVIDEO0(147	,1,	1764000000U),
PLLVIDEO0(74	,0,	1776000000U),
PLLVIDEO0(149	,1,	1788000000U),
PLLVIDEO0(75	,0,	1800000000U),
PLLVIDEO0(151	,1,	1812000000U),
PLLVIDEO0(76	,0,	1824000000U),
PLLVIDEO0(153	,1,	1836000000U),
PLLVIDEO0(77	,0,	1848000000U),
PLLVIDEO0(155	,1,	1860000000U),
PLLVIDEO0(78	,0,	1872000000U),
PLLVIDEO0(157	,1,	1884000000U),
PLLVIDEO0(79	,0,	1896000000U),
PLLVIDEO0(159	,1,	1908000000U),
PLLVIDEO0(80	,0,	1920000000U),
PLLVIDEO0(161	,1,	1932000000U),
PLLVIDEO0(81	,0,	1944000000U),
PLLVIDEO0(163	,1,	1956000000U),
PLLVIDEO0(82	,0,	1968000000U),
PLLVIDEO0(165	,1,	1980000000U),
PLLVIDEO0(83	,0,	1992000000U),
PLLVIDEO0(167	,1,	2004000000U),
PLLVIDEO0(84	,0,	2016000000U),
PLLVIDEO0(169	,1,	2028000000U),
PLLVIDEO0(85	,0,	2040000000U),
PLLVIDEO0(171	,1,	2052000000U),
PLLVIDEO0(86	,0,	2064000000U),
PLLVIDEO0(173	,1,	2076000000U),
PLLVIDEO0(87	,0,	2088000000U),
PLLVIDEO0(175	,1,	2100000000U),
PLLVIDEO0(88	,0,	2112000000U),
PLLVIDEO0(177	,1,	2124000000U),
PLLVIDEO0(89	,0,	2136000000U),
PLLVIDEO0(179	,1,	2148000000U),
PLLVIDEO0(90	,0,	2160000000U),
PLLVIDEO0(181	,1,	2172000000U),
PLLVIDEO0(91	,0,	2184000000U),
PLLVIDEO0(183	,1,	2196000000U),
PLLVIDEO0(92	,0,	2208000000U),
PLLVIDEO0(185	,1,	2220000000U),
PLLVIDEO0(93	,0,	2232000000U),
PLLVIDEO0(187	,1,	2244000000U),
PLLVIDEO0(94	,0,	2256000000U),
PLLVIDEO0(189	,1,	2268000000U),
PLLVIDEO0(95	,0,	2280000000U),
PLLVIDEO0(191	,1,	2292000000U),
PLLVIDEO0(96	,0,	2304000000U),
PLLVIDEO0(193	,1,	2316000000U),
PLLVIDEO0(97	,0,	2328000000U),
PLLVIDEO0(195	,1,	2340000000U),
PLLVIDEO0(98	,0,	2352000000U),
PLLVIDEO0(197	,1,	2364000000U),
PLLVIDEO0(99	,0,	2376000000U),
PLLVIDEO0(199	,1,	2388000000U),
PLLVIDEO0(100	,0,	2400000000U),
PLLVIDEO0(101	,0,	2424000000U),
PLLVIDEO0(102	,0,	2448000000U),
PLLVIDEO0(103	,0,	2472000000U),
PLLVIDEO0(104	,0,	2496000000U),
PLLVIDEO0(105	,0,	2520000000U),
PLLVIDEO0(106	,0,	2544000000U),
PLLVIDEO0(107	,0,	2568000000U),
PLLVIDEO0(108	,0,	2592000000U),
PLLVIDEO0(109	,0,	2616000000U),
PLLVIDEO0(110	,0,	2640000000U),
PLLVIDEO0(111	,0,	2664000000U),
PLLVIDEO0(112	,0,	2688000000U),
PLLVIDEO0(113	,0,	2712000000U),
PLLVIDEO0(114	,0,	2736000000U),
PLLVIDEO0(115	,0,	2760000000U),
PLLVIDEO0(116	,0,	2784000000U),
PLLVIDEO0(117	,0,	2808000000U),
};

 //N,P,input,freq
static struct sunxi_clk_factor_freq factor_pll8_tbl[] = {
PLLVIDEO1(22	,0	,1,	264000000U),
PLLVIDEO1(23	,0	,1,	276000000U),
PLLVIDEO1(12	,0	,0,	288000000U),
PLLVIDEO1(198	,3	,1,	297000000U),
PLLVIDEO1(25	,0	,1,	300000000U),
PLLVIDEO1(13	,0	,0,	312000000U),
PLLVIDEO1(27	,0	,1,	324000000U),
PLLVIDEO1(14	,0	,0,	336000000U),
PLLVIDEO1(29	,0	,1,	348000000U),
PLLVIDEO1(15	,0	,0,	360000000U),
PLLVIDEO1(31	,0	,1,	372000000U),
PLLVIDEO1(16	,0	,0,	384000000U),
PLLVIDEO1(33	,0	,1,	396000000U),
PLLVIDEO1(17	,0	,0,	408000000U),
PLLVIDEO1(35	,0	,1,	420000000U),
PLLVIDEO1(18	,0	,0,	432000000U),
PLLVIDEO1(37	,0	,1,	444000000U),
PLLVIDEO1(19	,0	,0,	456000000U),
PLLVIDEO1(39	,0	,1,	468000000U),
PLLVIDEO1(20	,0	,0,	480000000U),
PLLVIDEO1(41	,0	,1,	492000000U),
PLLVIDEO1(21	,0	,0,	504000000U),
PLLVIDEO1(43	,0	,1,	516000000U),
PLLVIDEO1(22	,0	,0,	528000000U),
PLLVIDEO1(45	,0	,1,	540000000U),
PLLVIDEO1(23	,0	,0,	552000000U),
PLLVIDEO1(47	,0	,1,	564000000U),
PLLVIDEO1(24	,0	,0,	576000000U),
PLLVIDEO1(49	,0	,1,	588000000U),
PLLVIDEO1(25	,0	,0,	600000000U),
PLLVIDEO1(51	,0	,1,	612000000U),
PLLVIDEO1(26	,0	,0,	624000000U),
PLLVIDEO1(53	,0	,1,	636000000U),
PLLVIDEO1(27	,0	,0,	648000000U),
PLLVIDEO1(55	,0	,1,	660000000U),
PLLVIDEO1(28	,0	,0,	672000000U),
PLLVIDEO1(57	,0	,1,	684000000U),
PLLVIDEO1(29	,0	,0,	696000000U),
PLLVIDEO1(59	,0	,1,	708000000U),
PLLVIDEO1(30	,0	,0,	720000000U),
PLLVIDEO1(61	,0	,1,	732000000U),
PLLVIDEO1(31	,0	,0,	744000000U),
PLLVIDEO1(63	,0	,1,	756000000U),
PLLVIDEO1(32	,0	,0,	768000000U),
PLLVIDEO1(65	,0	,1,	780000000U),
PLLVIDEO1(33	,0	,0,	792000000U),
PLLVIDEO1(67	,0	,1,	804000000U),
PLLVIDEO1(34	,0	,0,	816000000U),
PLLVIDEO1(69	,0	,1,	828000000U),
PLLVIDEO1(35	,0	,0,	840000000U),
PLLVIDEO1(71	,0	,1,	852000000U),
PLLVIDEO1(36	,0	,0,	864000000U),
PLLVIDEO1(73	,0	,1,	876000000U),
PLLVIDEO1(37	,0	,0,	888000000U),
PLLVIDEO1(75	,0	,1,	900000000U),
PLLVIDEO1(38	,0	,0,	912000000U),
PLLVIDEO1(77	,0	,1,	924000000U),
PLLVIDEO1(39	,0	,0,	936000000U),
PLLVIDEO1(79	,0	,1,	948000000U),
PLLVIDEO1(40	,0	,0,	960000000U),
PLLVIDEO1(81	,0	,1,	972000000U),
PLLVIDEO1(41	,0	,0,	984000000U),
PLLVIDEO1(83	,0	,1,	996000000U),
PLLVIDEO1(42	,0	,0,	1008000000U),
PLLVIDEO1(85	,0	,1,	1020000000U),
PLLVIDEO1(43	,0	,0,	1032000000U),
PLLVIDEO1(87	,0	,1,	1044000000U),
PLLVIDEO1(44	,0	,0,	1056000000U),
PLLVIDEO1(89	,0	,1,	1068000000U),
PLLVIDEO1(45	,0	,0,	1080000000U),
PLLVIDEO1(91	,0	,1,	1092000000U),
PLLVIDEO1(46	,0	,0,	1104000000U),
PLLVIDEO1(93	,0	,1,	1116000000U),
PLLVIDEO1(47	,0	,0,	1128000000U),
PLLVIDEO1(95	,0	,1,	1140000000U),
PLLVIDEO1(48	,0	,0,	1152000000U),
PLLVIDEO1(97	,0	,1,	1164000000U),
PLLVIDEO1(49	,0	,0,	1176000000U),
PLLVIDEO1(99	,0	,1,	1188000000U),
PLLVIDEO1(50	,0	,0,	1200000000U),
PLLVIDEO1(101	,0	,1,	1212000000U),
PLLVIDEO1(51	,0	,0,	1224000000U),
PLLVIDEO1(103	,0	,1,	1236000000U),
PLLVIDEO1(52	,0	,0,	1248000000U),
PLLVIDEO1(105	,0	,1,	1260000000U),
PLLVIDEO1(53	,0	,0,	1272000000U),
PLLVIDEO1(107	,0	,1,	1284000000U),
PLLVIDEO1(54	,0	,0,	1296000000U),
PLLVIDEO1(109	,0	,1,	1308000000U),
PLLVIDEO1(55	,0	,0,	1320000000U),
PLLVIDEO1(111	,0	,1,	1332000000U),
PLLVIDEO1(56	,0	,0,	1344000000U),
PLLVIDEO1(113	,0	,1,	1356000000U),
PLLVIDEO1(57	,0	,0,	1368000000U),
PLLVIDEO1(115	,0	,1,	1380000000U),
PLLVIDEO1(58	,0	,0,	1392000000U),
PLLVIDEO1(117	,0	,1,	1404000000U),
PLLVIDEO1(59	,0	,0,	1416000000U),
PLLVIDEO1(119	,0	,1,	1428000000U),
PLLVIDEO1(60	,0	,0,	1440000000U),
PLLVIDEO1(121	,0	,1,	1452000000U),
PLLVIDEO1(61	,0	,0,	1464000000U),
PLLVIDEO1(123	,0	,1,	1476000000U),
PLLVIDEO1(62	,0	,0,	1488000000U),
PLLVIDEO1(125	,0	,1,	1500000000U),
PLLVIDEO1(63	,0	,0,	1512000000U),
PLLVIDEO1(127	,0	,1,	1524000000U),
PLLVIDEO1(64	,0	,0,	1536000000U),
PLLVIDEO1(129	,0	,1,	1548000000U),
PLLVIDEO1(65	,0	,0,	1560000000U),
PLLVIDEO1(131	,0	,1,	1572000000U),
PLLVIDEO1(66	,0	,0,	1584000000U),
PLLVIDEO1(133	,0	,1,	1596000000U),
PLLVIDEO1(67	,0	,0,	1608000000U),
PLLVIDEO1(135	,0	,1,	1620000000U),
PLLVIDEO1(68	,0	,0,	1632000000U),
PLLVIDEO1(137	,0	,1,	1644000000U),
PLLVIDEO1(69	,0	,0,	1656000000U),
PLLVIDEO1(139	,0	,1,	1668000000U),
PLLVIDEO1(70	,0	,0,	1680000000U),
PLLVIDEO1(141	,0	,1,	1692000000U),
PLLVIDEO1(71	,0	,0,	1704000000U),
PLLVIDEO1(143	,0	,1,	1716000000U),
PLLVIDEO1(72	,0	,0,	1728000000U),
PLLVIDEO1(145	,0	,1,	1740000000U),
PLLVIDEO1(73	,0	,0,	1752000000U),
PLLVIDEO1(147	,0	,1,	1764000000U),
PLLVIDEO1(74	,0	,0,	1776000000U),
PLLVIDEO1(149	,0	,1,	1788000000U),
PLLVIDEO1(75	,0	,0,	1800000000U),
PLLVIDEO1(151	,0	,1,	1812000000U),
PLLVIDEO1(76	,0	,0,	1824000000U),
PLLVIDEO1(153	,0	,1,	1836000000U),
PLLVIDEO1(77	,0	,0,	1848000000U),
PLLVIDEO1(155	,0	,1,	1860000000U),
PLLVIDEO1(78	,0	,0,	1872000000U),
PLLVIDEO1(157	,0	,1,	1884000000U),
PLLVIDEO1(79	,0	,0,	1896000000U),
PLLVIDEO1(159	,0	,1,	1908000000U),
PLLVIDEO1(80	,0	,0,	1920000000U),
PLLVIDEO1(161	,0	,1,	1932000000U),
PLLVIDEO1(81	,0	,0,	1944000000U),
PLLVIDEO1(163	,0	,1,	1956000000U),
PLLVIDEO1(82	,0	,0,	1968000000U),
PLLVIDEO1(165	,0	,1,	1980000000U),
PLLVIDEO1(83	,0	,0,	1992000000U),
PLLVIDEO1(167	,0	,1,	2004000000U),
PLLVIDEO1(84	,0	,0,	2016000000U),
PLLVIDEO1(169	,0	,1,	2028000000U),
PLLVIDEO1(85	,0	,0,	2040000000U),
PLLVIDEO1(171	,0	,1,	2052000000U),
PLLVIDEO1(86	,0	,0,	2064000000U),
PLLVIDEO1(173	,0	,1,	2076000000U),
PLLVIDEO1(87	,0	,0,	2088000000U),
PLLVIDEO1(175	,0	,1,	2100000000U),
PLLVIDEO1(88	,0	,0,	2112000000U),
PLLVIDEO1(177	,0	,1,	2124000000U),
PLLVIDEO1(89	,0	,0,	2136000000U),
PLLVIDEO1(179	,0	,1,	2148000000U),
PLLVIDEO1(90	,0	,0,	2160000000U),
PLLVIDEO1(181	,0	,1,	2172000000U),
PLLVIDEO1(91	,0	,0,	2184000000U),
PLLVIDEO1(183	,0	,1,	2196000000U),
PLLVIDEO1(92	,0	,0,	2208000000U),
PLLVIDEO1(185	,0	,1,	2220000000U),
PLLVIDEO1(93	,0	,0,	2232000000U),
PLLVIDEO1(187	,0	,1,	2244000000U),
PLLVIDEO1(94	,0	,0,	2256000000U),
PLLVIDEO1(189	,0	,1,	2268000000U),
PLLVIDEO1(95	,0	,0,	2280000000U),
PLLVIDEO1(191	,0	,1,	2292000000U),
PLLVIDEO1(96	,0	,0,	2304000000U),
PLLVIDEO1(193	,0	,1,	2316000000U),
PLLVIDEO1(97	,0	,0,	2328000000U),
PLLVIDEO1(195	,0	,1,	2340000000U),
PLLVIDEO1(98	,0	,0,	2352000000U),
PLLVIDEO1(197	,0	,1,	2364000000U),
PLLVIDEO1(99	,0	,0,	2376000000U),
PLLVIDEO1(199	,0	,1,	2388000000U),
PLLVIDEO1(100	,0	,0,	2400000000U),
PLLVIDEO1(101	,0	,0,	2424000000U),
PLLVIDEO1(102	,0	,0,	2448000000U),
PLLVIDEO1(103	,0	,0,	2472000000U),
PLLVIDEO1(104	,0	,0,	2496000000U),
PLLVIDEO1(105	,0	,0,	2520000000U),
PLLVIDEO1(106	,0	,0,	2544000000U),
PLLVIDEO1(107	,0	,0,	2568000000U),
PLLVIDEO1(108	,0	,0,	2592000000U),
PLLVIDEO1(109	,0	,0,	2616000000U),
PLLVIDEO1(110	,0	,0,	2640000000U),
PLLVIDEO1(111	,0	,0,	2664000000U),
PLLVIDEO1(112	,0	,0,	2688000000U),
PLLVIDEO1(113	,0	,0,	2712000000U),
PLLVIDEO1(114	,0	,0,	2736000000U),
PLLVIDEO1(115	,0	,0,	2760000000U),
};

 //N,input,output,freq
static struct sunxi_clk_factor_freq factor_pll9_tbl[] = {
PLLGPU(29	,1	,1,	174000000U),
PLLGPU(32	,1	,1,	192000000U),
PLLGPU(33	,1	,1,	198000000U),
PLLGPU(34	,1	,1,	204000000U),
PLLGPU(35	,1	,1,	210000000U),
PLLGPU(18	,0	,1,	216000000U),
PLLGPU(37	,1	,1,	222000000U),
PLLGPU(19	,0	,1,	228000000U),
PLLGPU(39	,1	,1,	234000000U),
PLLGPU(20	,0	,1,	240000000U),
PLLGPU(41	,1	,1,	246000000U),
PLLGPU(21	,0	,1,	252000000U),
PLLGPU(43	,1	,1,	258000000U),
PLLGPU(22	,0	,1,	264000000U),
PLLGPU(45	,1	,1,	270000000U),
PLLGPU(23	,0	,1,	276000000U),
PLLGPU(47	,1	,1,	282000000U),
PLLGPU(24	,0	,1,	288000000U),
PLLGPU(49	,1	,1,	294000000U),
PLLGPU(25	,0	,1,	300000000U),
PLLGPU(51	,1	,1,	306000000U),
PLLGPU(26	,0	,1,	312000000U),
PLLGPU(53	,1	,1,	318000000U),
PLLGPU(27	,0	,1,	324000000U),
PLLGPU(55	,1	,1,	330000000U),
PLLGPU(28	,0	,1,	336000000U),
PLLGPU(57	,1	,1,	342000000U),
PLLGPU(29	,0	,1,	348000000U),
PLLGPU(59	,1	,1,	354000000U),
PLLGPU(30	,0	,1,	360000000U),
PLLGPU(61	,1	,1,	366000000U),
PLLGPU(31	,0	,1,	372000000U),
PLLGPU(63	,1	,1,	378000000U),
PLLGPU(32	,0	,1,	384000000U),
PLLGPU(65	,1	,1,	390000000U),
PLLGPU(33	,0	,1,	396000000U),
PLLGPU(67	,1	,1,	402000000U),
PLLGPU(34	,0	,1,	408000000U),
PLLGPU(69	,1	,1,	414000000U),
PLLGPU(35	,0	,1,	420000000U),
PLLGPU(71	,1	,1,	426000000U),
PLLGPU(36	,0	,1,	432000000U),
PLLGPU(73	,1	,1,	438000000U),
PLLGPU(37	,0	,1,	444000000U),
PLLGPU(75	,1	,1,	450000000U),
PLLGPU(38	,0	,1,	456000000U),
PLLGPU(77	,1	,1,	462000000U),
PLLGPU(39	,0	,1,	468000000U),
PLLGPU(79	,1	,1,	474000000U),
PLLGPU(40	,0	,1,	480000000U),
PLLGPU(81	,1	,1,	486000000U),
PLLGPU(41	,0	,1,	492000000U),
PLLGPU(83	,1	,1,	498000000U),
PLLGPU(42	,0	,1,	504000000U),
PLLGPU(85	,1	,1,	510000000U),
PLLGPU(43	,0	,1,	516000000U),
PLLGPU(87	,1	,1,	522000000U),
PLLGPU(44	,0	,1,	528000000U),
PLLGPU(89	,1	,1,	534000000U),
PLLGPU(45	,0	,1,	540000000U),
PLLGPU(91	,1	,1,	546000000U),
PLLGPU(46	,0	,1,	552000000U),
PLLGPU(93	,1	,1,	558000000U),
PLLGPU(47	,0	,1,	564000000U),
PLLGPU(95	,1	,1,	570000000U),
PLLGPU(48	,0	,1,	576000000U),
PLLGPU(97	,1	,1,	582000000U),
PLLGPU(49	,0	,1,	588000000U),
PLLGPU(99	,1	,1,	594000000U),
PLLGPU(50	,0	,1,	600000000U),
PLLGPU(101	,1	,1,	606000000U),
PLLGPU(51	,0	,1,	612000000U),
PLLGPU(103	,1	,1,	618000000U),
PLLGPU(52	,0	,1,	624000000U),
PLLGPU(105	,1	,1,	630000000U),
PLLGPU(53	,0	,1,	636000000U),
PLLGPU(107	,1	,1,	642000000U),
PLLGPU(54	,0	,1,	648000000U),
PLLGPU(109	,1	,1,	654000000U),
PLLGPU(55	,0	,1,	660000000U),
PLLGPU(111	,1	,1,	666000000U),
PLLGPU(56	,0	,1,	672000000U),
PLLGPU(113	,1	,1,	678000000U),
PLLGPU(57	,0	,1,	684000000U),
PLLGPU(115	,1	,1,	690000000U),
PLLGPU(58	,0	,1,	696000000U),
PLLGPU(117	,1	,1,	702000000U),
PLLGPU(59	,0	,1,	708000000U),
PLLGPU(119	,1	,1,	714000000U),
PLLGPU(60	,0	,1,	720000000U),
PLLGPU(121	,1	,1,	726000000U),
PLLGPU(61	,0	,1,	732000000U),
PLLGPU(123	,1	,1,	738000000U),
PLLGPU(62	,0	,1,	744000000U),
PLLGPU(125	,1	,1,	750000000U),
PLLGPU(63	,0	,1,	756000000U),
PLLGPU(127	,1	,1,	762000000U),
PLLGPU(64	,0	,1,	768000000U),
PLLGPU(129	,1	,1,	774000000U),
PLLGPU(65	,0	,1,	780000000U),
PLLGPU(131	,1	,1,	786000000U),
PLLGPU(66	,0	,1,	792000000U),
PLLGPU(133	,1	,1,	798000000U),
PLLGPU(67	,0	,1,	804000000U),
PLLGPU(135	,1	,1,	810000000U),
PLLGPU(68	,0	,1,	816000000U),
PLLGPU(137	,1	,1,	822000000U),
PLLGPU(69	,0	,1,	828000000U),
PLLGPU(139	,1	,1,	834000000U),
PLLGPU(70	,0	,1,	840000000U),
PLLGPU(141	,1	,1,	846000000U),
PLLGPU(71	,0	,1,	852000000U),
PLLGPU(143	,1	,1,	858000000U),
PLLGPU(72	,0	,1,	864000000U),
PLLGPU(145	,1	,1,	870000000U),
PLLGPU(73	,0	,1,	876000000U),
PLLGPU(147	,1	,1,	882000000U),
PLLGPU(74	,0	,1,	888000000U),
PLLGPU(149	,1	,1,	894000000U),
PLLGPU(75	,0	,1,	900000000U),
PLLGPU(151	,1	,1,	906000000U),
PLLGPU(76	,0	,1,	912000000U),
PLLGPU(153	,1	,1,	918000000U),
PLLGPU(77	,0	,1,	924000000U),
PLLGPU(155	,1	,1,	930000000U),
PLLGPU(78	,0	,1,	936000000U),
PLLGPU(157	,1	,1,	942000000U),
PLLGPU(79	,0	,1,	948000000U),
PLLGPU(159	,1	,1,	954000000U),
PLLGPU(80	,0	,1,	960000000U),
PLLGPU(161	,1	,1,	966000000U),
PLLGPU(81	,0	,1,	972000000U),
PLLGPU(163	,1	,1,	978000000U),
PLLGPU(82	,0	,1,	984000000U),
PLLGPU(165	,1	,1,	990000000U),
PLLGPU(83	,0	,1,	996000000U),
PLLGPU(167	,1	,1,	1002000000U),
PLLGPU(84	,0	,1,	1008000000U),
PLLGPU(169	,1	,1,	1014000000U),
PLLGPU(85	,0	,1,	1020000000U),
PLLGPU(171	,1	,1,	1026000000U),
PLLGPU(86	,0	,1,	1032000000U),
PLLGPU(173	,1	,1,	1038000000U),
PLLGPU(87	,0	,1,	1044000000U),
PLLGPU(175	,1	,1,	1050000000U),
PLLGPU(88	,0	,1,	1056000000U),
PLLGPU(177	,1	,1,	1062000000U),
PLLGPU(89	,0	,1,	1068000000U),
PLLGPU(179	,1	,1,	1074000000U),
PLLGPU(90	,0	,1,	1080000000U),
PLLGPU(181	,1	,1,	1086000000U),
PLLGPU(91	,0	,1,	1092000000U),
PLLGPU(183	,1	,1,	1098000000U),
PLLGPU(92	,0	,1,	1104000000U),
PLLGPU(185	,1	,1,	1110000000U),
PLLGPU(93	,0	,1,	1116000000U),
PLLGPU(187	,1	,1,	1122000000U),
PLLGPU(94	,0	,1,	1128000000U),
PLLGPU(189	,1	,1,	1134000000U),
PLLGPU(95	,0	,1,	1140000000U),
PLLGPU(191	,1	,1,	1146000000U),
PLLGPU(96	,0	,1,	1152000000U),
PLLGPU(193	,1	,1,	1158000000U),
PLLGPU(97	,0	,1,	1164000000U),
PLLGPU(195	,1	,1,	1170000000U),
PLLGPU(98	,0	,1,	1176000000U),
PLLGPU(197	,1	,1,	1182000000U),
PLLGPU(99	,0	,1,	1188000000U),
PLLGPU(199	,1	,1,	1194000000U),
PLLGPU(100	,0	,1,	1200000000U),
PLLGPU(101	,0	,1,	1212000000U),
PLLGPU(102	,0	,1,	1224000000U),
PLLGPU(103	,0	,1,	1236000000U),
PLLGPU(104	,0	,1,	1248000000U),
PLLGPU(105	,0	,1,	1260000000U),
PLLGPU(106	,0	,1,	1272000000U),
PLLGPU(107	,0	,1,	1284000000U),
PLLGPU(108	,0	,1,	1296000000U),
PLLGPU(109	,0	,1,	1308000000U),
PLLGPU(110	,0	,1,	1320000000U),
PLLGPU(111	,0	,1,	1332000000U),
PLLGPU(112	,0	,1,	1344000000U),
PLLGPU(113	,0	,1,	1356000000U),
PLLGPU(114	,0	,1,	1368000000U),
PLLGPU(115	,0	,1,	1380000000U),
PLLGPU(116	,0	,1,	1392000000U),
PLLGPU(117	,0	,1,	1404000000U),
PLLGPU(118	,0	,1,	1416000000U),
PLLGPU(119	,0	,1,	1428000000U),
PLLGPU(120	,0	,1,	1440000000U),
PLLGPU(121	,0	,1,	1452000000U),
PLLGPU(122	,0	,1,	1464000000U),
PLLGPU(123	,0	,1,	1476000000U),
PLLGPU(124	,0	,1,	1488000000U),
PLLGPU(125	,0	,1,	1500000000U),
PLLGPU(126	,1	,0,	1512000000U),
PLLGPU(127	,1	,0,	1524000000U),
PLLGPU(128	,1	,0,	1536000000U),
PLLGPU(129	,1	,0,	1548000000U),
PLLGPU(130	,1	,0,	1560000000U),
PLLGPU(131	,1	,0,	1572000000U),
PLLGPU(132	,1	,0,	1584000000U),
PLLGPU(133	,1	,0,	1596000000U),
PLLGPU(134	,1	,0,	1608000000U),
PLLGPU(135	,1	,0,	1620000000U),
PLLGPU(136	,1	,0,	1632000000U),
PLLGPU(137	,1	,0,	1644000000U),
PLLGPU(138	,1	,0,	1656000000U),
PLLGPU(139	,1	,0,	1668000000U),
PLLGPU(140	,1	,0,	1680000000U),
PLLGPU(141	,1	,0,	1692000000U),
PLLGPU(142	,1	,0,	1704000000U),
PLLGPU(143	,1	,0,	1716000000U),
PLLGPU(144	,1	,0,	1728000000U),
PLLGPU(145	,1	,0,	1740000000U),
PLLGPU(146	,1	,0,	1752000000U),
PLLGPU(147	,1	,0,	1764000000U),
PLLGPU(148	,1	,0,	1776000000U),
PLLGPU(149	,1	,0,	1788000000U),
PLLGPU(150	,1	,0,	1800000000U),
PLLGPU(151	,1	,0,	1812000000U),
PLLGPU(152	,1	,0,	1824000000U),
PLLGPU(153	,1	,0,	1836000000U),
PLLGPU(154	,1	,0,	1848000000U),
PLLGPU(155	,1	,0,	1860000000U),
PLLGPU(156	,1	,0,	1872000000U),
PLLGPU(157	,1	,0,	1884000000U),
PLLGPU(158	,1	,0,	1896000000U),
PLLGPU(159	,1	,0,	1908000000U),
PLLGPU(160	,1	,0,	1920000000U),
PLLGPU(161	,1	,0,	1932000000U),
PLLGPU(162	,1	,0,	1944000000U),
PLLGPU(163	,1	,0,	1956000000U),
PLLGPU(164	,1	,0,	1968000000U),
PLLGPU(165	,1	,0,	1980000000U),
PLLGPU(166	,1	,0,	1992000000U),
PLLGPU(167	,1	,0,	2004000000U),
PLLGPU(168	,1	,0,	2016000000U),
PLLGPU(169	,1	,0,	2028000000U),
PLLGPU(170	,1	,0,	2040000000U),
PLLGPU(171	,1	,0,	2052000000U),
PLLGPU(172	,1	,0,	2064000000U),
PLLGPU(173	,1	,0,	2076000000U),
PLLGPU(174	,1	,0,	2088000000U),
PLLGPU(175	,1	,0,	2100000000U),
PLLGPU(176	,1	,0,	2112000000U),
PLLGPU(177	,1	,0,	2124000000U),
PLLGPU(178	,1	,0,	2136000000U),
PLLGPU(179	,1	,0,	2148000000U),
PLLGPU(180	,1	,0,	2160000000U),
PLLGPU(181	,1	,0,	2172000000U),
PLLGPU(182	,1	,0,	2184000000U),
PLLGPU(183	,1	,0,	2196000000U),
PLLGPU(184	,1	,0,	2208000000U),
PLLGPU(185	,1	,0,	2220000000U),
PLLGPU(186	,1	,0,	2232000000U),
PLLGPU(187	,1	,0,	2244000000U),
PLLGPU(188	,1	,0,	2256000000U),
PLLGPU(189	,1	,0,	2268000000U),
PLLGPU(190	,1	,0,	2280000000U),
PLLGPU(191	,1	,0,	2292000000U),
PLLGPU(192	,1	,0,	2304000000U),
PLLGPU(193	,1	,0,	2316000000U),
PLLGPU(194	,1	,0,	2328000000U),
PLLGPU(195	,1	,0,	2340000000U),
PLLGPU(196	,1	,0,	2352000000U),
PLLGPU(197	,1	,0,	2364000000U),
PLLGPU(198	,1	,0,	2376000000U),
PLLGPU(199	,1	,0,	2388000000U),
PLLGPU(200	,1	,0,	2400000000U),
PLLGPU(101	,0	,0,	2424000000U),
PLLGPU(102	,0	,0,	2448000000U),
PLLGPU(103	,0	,0,	2472000000U),
PLLGPU(104	,0	,0,	2496000000U),
PLLGPU(105	,0	,0,	2520000000U),
PLLGPU(106	,0	,0,	2544000000U),
PLLGPU(107	,0	,0,	2568000000U),
PLLGPU(108	,0	,0,	2592000000U),
PLLGPU(109	,0	,0,	2616000000U),
PLLGPU(110	,0	,0,	2640000000U),
PLLGPU(111	,0	,0,	2664000000U),
PLLGPU(112	,0	,0,	2688000000U),
PLLGPU(113	,0	,0,	2712000000U),
PLLGPU(114	,0	,0,	2736000000U),
PLLGPU(115	,0	,0,	2760000000U),
PLLGPU(116	,0	,0,	2784000000U),
PLLGPU(117	,0	,0,	2808000000U),
PLLGPU(118	,0	,0,	2832000000U),
PLLGPU(119	,0	,0,	2856000000U),
PLLGPU(120	,0	,0,	2880000000U),
PLLGPU(121	,0	,0,	2904000000U),
PLLGPU(122	,0	,0,	2928000000U),
PLLGPU(123	,0	,0,	2952000000U),
PLLGPU(124	,0	,0,	2976000000U),
PLLGPU(125	,0	,0,	3000000000U),
};

 //N,input,output,freq
static struct sunxi_clk_factor_freq factor_pll10_tbl[] = {
PLLDE(32	,1	,1,	192000000U),
PLLDE(33	,1	,1,	198000000U),
PLLDE(17	,0	,1,	204000000U),
PLLDE(35	,1	,1,	210000000U),
PLLDE(18	,0	,1,	216000000U),
PLLDE(37	,1	,1,	222000000U),
PLLDE(19	,0	,1,	228000000U),
PLLDE(39	,1	,1,	234000000U),
PLLDE(20	,0	,1,	240000000U),
PLLDE(41	,1	,1,	246000000U),
PLLDE(21	,0	,1,	252000000U),
PLLDE(43	,1	,1,	258000000U),
PLLDE(22	,0	,1,	264000000U),
PLLDE(45	,1	,1,	270000000U),
PLLDE(23	,0	,1,	276000000U),
PLLDE(47	,1	,1,	282000000U),
PLLDE(24	,0	,1,	288000000U),
PLLDE(49	,1	,1,	294000000U),
PLLDE(25	,0	,1,	300000000U),
PLLDE(51	,1	,1,	306000000U),
PLLDE(26	,0	,1,	312000000U),
PLLDE(53	,1	,1,	318000000U),
PLLDE(27	,0	,1,	324000000U),
PLLDE(55	,1	,1,	330000000U),
PLLDE(28	,0	,1,	336000000U),
PLLDE(57	,1	,1,	342000000U),
PLLDE(29	,0	,1,	348000000U),
PLLDE(59	,1	,1,	354000000U),
PLLDE(30	,0	,1,	360000000U),
PLLDE(61	,1	,1,	366000000U),
PLLDE(31	,0	,1,	372000000U),
PLLDE(63	,1	,1,	378000000U),
PLLDE(32	,0	,1,	384000000U),
PLLDE(65	,1	,1,	390000000U),
PLLDE(33	,0	,1,	396000000U),
PLLDE(67	,1	,1,	402000000U),
PLLDE(34	,0	,1,	408000000U),
PLLDE(69	,1	,1,	414000000U),
PLLDE(35	,0	,1,	420000000U),
PLLDE(71	,1	,1,	426000000U),
PLLDE(36	,0	,1,	432000000U),
PLLDE(73	,1	,1,	438000000U),
PLLDE(37	,0	,1,	444000000U),
PLLDE(75	,1	,1,	450000000U),
PLLDE(38	,0	,1,	456000000U),
PLLDE(77	,1	,1,	462000000U),
PLLDE(39	,0	,1,	468000000U),
PLLDE(79	,1	,1,	474000000U),
PLLDE(40	,0	,1,	480000000U),
PLLDE(81	,1	,1,	486000000U),
PLLDE(41	,0	,1,	492000000U),
PLLDE(83	,1	,1,	498000000U),
PLLDE(42	,0	,1,	504000000U),
PLLDE(85	,1	,1,	510000000U),
PLLDE(43	,0	,1,	516000000U),
PLLDE(87	,1	,1,	522000000U),
PLLDE(44	,0	,1,	528000000U),
PLLDE(89	,1	,1,	534000000U),
PLLDE(45	,0	,1,	540000000U),
PLLDE(91	,1	,1,	546000000U),
PLLDE(46	,0	,1,	552000000U),
PLLDE(93	,1	,1,	558000000U),
PLLDE(47	,0	,1,	564000000U),
PLLDE(95	,1	,1,	570000000U),
PLLDE(48	,0	,1,	576000000U),
PLLDE(97	,1	,1,	582000000U),
PLLDE(49	,0	,1,	588000000U),
PLLDE(99	,1	,1,	594000000U),
PLLDE(50	,0	,1,	600000000U),
PLLDE(101	,1	,1,	606000000U),
PLLDE(51	,0	,1,	612000000U),
PLLDE(103	,1	,1,	618000000U),
PLLDE(52	,0	,1,	624000000U),
PLLDE(105	,1	,1,	630000000U),
PLLDE(53	,0	,1,	636000000U),
PLLDE(107	,1	,1,	642000000U),
PLLDE(54	,0	,1,	648000000U),
PLLDE(109	,1	,1,	654000000U),
PLLDE(55	,0	,1,	660000000U),
PLLDE(111	,1	,1,	666000000U),
PLLDE(56	,0	,1,	672000000U),
PLLDE(113	,1	,1,	678000000U),
PLLDE(57	,0	,1,	684000000U),
PLLDE(115	,1	,1,	690000000U),
PLLDE(58	,0	,1,	696000000U),
PLLDE(117	,1	,1,	702000000U),
PLLDE(59	,0	,1,	708000000U),
PLLDE(119	,1	,1,	714000000U),
PLLDE(60	,0	,1,	720000000U),
PLLDE(121	,1	,1,	726000000U),
PLLDE(61	,0	,1,	732000000U),
PLLDE(123	,1	,1,	738000000U),
PLLDE(62	,0	,1,	744000000U),
PLLDE(125	,1	,1,	750000000U),
PLLDE(63	,0	,1,	756000000U),
PLLDE(127	,1	,1,	762000000U),
PLLDE(64	,0	,1,	768000000U),
PLLDE(129	,1	,1,	774000000U),
PLLDE(65	,0	,1,	780000000U),
PLLDE(131	,1	,1,	786000000U),
PLLDE(66	,0	,1,	792000000U),
PLLDE(133	,1	,1,	798000000U),
PLLDE(67	,0	,1,	804000000U),
PLLDE(135	,1	,1,	810000000U),
PLLDE(68	,0	,1,	816000000U),
PLLDE(137	,1	,1,	822000000U),
PLLDE(69	,0	,1,	828000000U),
PLLDE(139	,1	,1,	834000000U),
PLLDE(70	,0	,1,	840000000U),
PLLDE(141	,1	,1,	846000000U),
PLLDE(71	,0	,1,	852000000U),
PLLDE(143	,1	,1,	858000000U),
PLLDE(72	,0	,1,	864000000U),
PLLDE(145	,1	,1,	870000000U),
PLLDE(73	,0	,1,	876000000U),
PLLDE(147	,1	,1,	882000000U),
PLLDE(74	,0	,1,	888000000U),
PLLDE(149	,1	,1,	894000000U),
PLLDE(75	,0	,1,	900000000U),
PLLDE(151	,1	,1,	906000000U),
PLLDE(76	,0	,1,	912000000U),
PLLDE(153	,1	,1,	918000000U),
PLLDE(77	,0	,1,	924000000U),
PLLDE(155	,1	,1,	930000000U),
PLLDE(78	,0	,1,	936000000U),
PLLDE(157	,1	,1,	942000000U),
PLLDE(79	,0	,1,	948000000U),
PLLDE(159	,1	,1,	954000000U),
PLLDE(80	,0	,1,	960000000U),
PLLDE(161	,1	,1,	966000000U),
PLLDE(81	,0	,1,	972000000U),
PLLDE(163	,1	,1,	978000000U),
PLLDE(82	,0	,1,	984000000U),
PLLDE(165	,1	,1,	990000000U),
PLLDE(83	,0	,1,	996000000U),
PLLDE(167	,1	,1,	1002000000U),
PLLDE(84	,0	,1,	1008000000U),
PLLDE(169	,1	,1,	1014000000U),
PLLDE(85	,0	,1,	1020000000U),
PLLDE(171	,1	,1,	1026000000U),
PLLDE(86	,0	,1,	1032000000U),
PLLDE(173	,1	,1,	1038000000U),
PLLDE(87	,0	,1,	1044000000U),
PLLDE(175	,1	,1,	1050000000U),
PLLDE(88	,0	,1,	1056000000U),
PLLDE(177	,1	,1,	1062000000U),
PLLDE(89	,0	,1,	1068000000U),
PLLDE(179	,1	,1,	1074000000U),
PLLDE(90	,0	,1,	1080000000U),
PLLDE(181	,1	,1,	1086000000U),
PLLDE(91	,0	,1,	1092000000U),
PLLDE(183	,1	,1,	1098000000U),
PLLDE(92	,0	,1,	1104000000U),
PLLDE(185	,1	,1,	1110000000U),
PLLDE(93	,0	,1,	1116000000U),
PLLDE(187	,1	,1,	1122000000U),
PLLDE(94	,0	,1,	1128000000U),
PLLDE(189	,1	,1,	1134000000U),
PLLDE(95	,0	,1,	1140000000U),
PLLDE(191	,1	,1,	1146000000U),
PLLDE(96	,0	,1,	1152000000U),
PLLDE(193	,1	,1,	1158000000U),
PLLDE(97	,0	,1,	1164000000U),
PLLDE(195	,1	,1,	1170000000U),
PLLDE(98	,0	,1,	1176000000U),
PLLDE(197	,1	,1,	1182000000U),
PLLDE(99	,0	,1,	1188000000U),
PLLDE(199	,1	,1,	1194000000U),
PLLDE(100	,0	,1,	1200000000U),
PLLDE(101	,0	,1,	1212000000U),
PLLDE(102	,0	,1,	1224000000U),
PLLDE(103	,0	,1,	1236000000U),
PLLDE(104	,0	,1,	1248000000U),
PLLDE(105	,0	,1,	1260000000U),
PLLDE(106	,0	,1,	1272000000U),
PLLDE(107	,0	,1,	1284000000U),
PLLDE(108	,0	,1,	1296000000U),
PLLDE(109	,0	,1,	1308000000U),
PLLDE(110	,0	,1,	1320000000U),
PLLDE(111	,0	,1,	1332000000U),
PLLDE(112	,0	,1,	1344000000U),
PLLDE(113	,0	,1,	1356000000U),
PLLDE(114	,0	,1,	1368000000U),
PLLDE(115	,0	,1,	1380000000U),
PLLDE(116	,0	,1,	1392000000U),
PLLDE(117	,0	,1,	1404000000U),
PLLDE(118	,0	,1,	1416000000U),
PLLDE(119	,0	,1,	1428000000U),
PLLDE(120	,0	,1,	1440000000U),
PLLDE(121	,0	,1,	1452000000U),
PLLDE(122	,0	,1,	1464000000U),
PLLDE(123	,0	,1,	1476000000U),
PLLDE(124	,1	,0,	1488000000U),
PLLDE(125	,1	,0,	1500000000U),
PLLDE(126	,1	,0,	1512000000U),
PLLDE(127	,1	,0,	1524000000U),
PLLDE(128	,1	,0,	1536000000U),
PLLDE(129	,1	,0,	1548000000U),
PLLDE(130	,1	,0,	1560000000U),
PLLDE(131	,1	,0,	1572000000U),
PLLDE(132	,1	,0,	1584000000U),
PLLDE(133	,1	,0,	1596000000U),
PLLDE(134	,1	,0,	1608000000U),
PLLDE(135	,1	,0,	1620000000U),
PLLDE(136	,1	,0,	1632000000U),
PLLDE(137	,1	,0,	1644000000U),
PLLDE(138	,1	,0,	1656000000U),
PLLDE(139	,1	,0,	1668000000U),
PLLDE(140	,1	,0,	1680000000U),
PLLDE(141	,1	,0,	1692000000U),
PLLDE(142	,1	,0,	1704000000U),
PLLDE(143	,1	,0,	1716000000U),
PLLDE(144	,1	,0,	1728000000U),
PLLDE(145	,1	,0,	1740000000U),
PLLDE(146	,1	,0,	1752000000U),
PLLDE(147	,1	,0,	1764000000U),
PLLDE(148	,1	,0,	1776000000U),
PLLDE(149	,1	,0,	1788000000U),
PLLDE(150	,1	,0,	1800000000U),
PLLDE(151	,1	,0,	1812000000U),
PLLDE(152	,1	,0,	1824000000U),
PLLDE(153	,1	,0,	1836000000U),
PLLDE(154	,1	,0,	1848000000U),
PLLDE(155	,1	,0,	1860000000U),
PLLDE(156	,1	,0,	1872000000U),
PLLDE(157	,1	,0,	1884000000U),
PLLDE(158	,1	,0,	1896000000U),
PLLDE(159	,1	,0,	1908000000U),
PLLDE(160	,1	,0,	1920000000U),
PLLDE(161	,1	,0,	1932000000U),
PLLDE(162	,1	,0,	1944000000U),
PLLDE(163	,1	,0,	1956000000U),
PLLDE(164	,1	,0,	1968000000U),
PLLDE(165	,1	,0,	1980000000U),
PLLDE(166	,1	,0,	1992000000U),
PLLDE(167	,1	,0,	2004000000U),
PLLDE(168	,1	,0,	2016000000U),
PLLDE(169	,1	,0,	2028000000U),
PLLDE(170	,1	,0,	2040000000U),
PLLDE(171	,1	,0,	2052000000U),
PLLDE(172	,1	,0,	2064000000U),
PLLDE(173	,1	,0,	2076000000U),
PLLDE(174	,1	,0,	2088000000U),
PLLDE(175	,1	,0,	2100000000U),
PLLDE(176	,1	,0,	2112000000U),
PLLDE(177	,1	,0,	2124000000U),
PLLDE(178	,1	,0,	2136000000U),
PLLDE(179	,1	,0,	2148000000U),
PLLDE(180	,1	,0,	2160000000U),
PLLDE(181	,1	,0,	2172000000U),
PLLDE(182	,1	,0,	2184000000U),
PLLDE(183	,1	,0,	2196000000U),
PLLDE(184	,1	,0,	2208000000U),
PLLDE(185	,1	,0,	2220000000U),
PLLDE(186	,1	,0,	2232000000U),
PLLDE(187	,1	,0,	2244000000U),
PLLDE(188	,1	,0,	2256000000U),
PLLDE(189	,1	,0,	2268000000U),
PLLDE(190	,1	,0,	2280000000U),
PLLDE(191	,1	,0,	2292000000U),
PLLDE(192	,1	,0,	2304000000U),
PLLDE(193	,1	,0,	2316000000U),
PLLDE(194	,1	,0,	2328000000U),
PLLDE(195	,1	,0,	2340000000U),
PLLDE(196	,1	,0,	2352000000U),
PLLDE(197	,1	,0,	2364000000U),
PLLDE(198	,1	,0,	2376000000U),
PLLDE(199	,1	,0,	2388000000U),
PLLDE(200	,1	,0,	2400000000U),
PLLDE(101	,0	,0,	2424000000U),
PLLDE(102	,0	,0,	2448000000U),
PLLDE(103	,0	,0,	2472000000U),
PLLDE(104	,0	,0,	2496000000U),
PLLDE(105	,0	,0,	2520000000U),
PLLDE(106	,0	,0,	2544000000U),
PLLDE(107	,0	,0,	2568000000U),
PLLDE(108	,0	,0,	2592000000U),
PLLDE(109	,0	,0,	2616000000U),
PLLDE(110	,0	,0,	2640000000U),
PLLDE(111	,0	,0,	2664000000U),
PLLDE(112	,0	,0,	2688000000U),
PLLDE(113	,0	,0,	2712000000U),
PLLDE(114	,0	,0,	2736000000U),
PLLDE(115	,0	,0,	2760000000U),
PLLDE(116	,0	,0,	2784000000U),
PLLDE(117	,0	,0,	2808000000U),
PLLDE(118	,0	,0,	2832000000U),
PLLDE(119	,0	,0,	2856000000U),
PLLDE(120	,0	,0,	2880000000U),
PLLDE(121	,0	,0,	2904000000U),
PLLDE(122	,0	,0,	2928000000U),
PLLDE(123	,0	,0,	2952000000U),
PLLDE(124	,0	,0,	2976000000U),
};

 //N,input,output,freq
static struct sunxi_clk_factor_freq factor_pll11_tbl[] = {
PLLISP(35	,1	,1,	210000000U),
PLLISP(18	,0	,1,	216000000U),
PLLISP(37	,1	,1,	222000000U),
PLLISP(19	,0	,1,	228000000U),
PLLISP(39	,1	,1,	234000000U),
PLLISP(20	,0	,1,	240000000U),
PLLISP(41	,1	,1,	246000000U),
PLLISP(21	,0	,1,	252000000U),
PLLISP(43	,1	,1,	258000000U),
PLLISP(22	,0	,1,	264000000U),
PLLISP(45	,1	,1,	270000000U),
PLLISP(23	,0	,1,	276000000U),
PLLISP(47	,1	,1,	282000000U),
PLLISP(24	,0	,1,	288000000U),
PLLISP(49	,1	,1,	294000000U),
PLLISP(25	,0	,1,	300000000U),
PLLISP(51	,1	,1,	306000000U),
PLLISP(26	,0	,1,	312000000U),
PLLISP(53	,1	,1,	318000000U),
PLLISP(27	,0	,1,	324000000U),
PLLISP(55	,1	,1,	330000000U),
PLLISP(28	,0	,1,	336000000U),
PLLISP(57	,1	,1,	342000000U),
PLLISP(29	,0	,1,	348000000U),
PLLISP(59	,1	,1,	354000000U),
PLLISP(30	,0	,1,	360000000U),
PLLISP(61	,1	,1,	366000000U),
PLLISP(31	,0	,1,	372000000U),
PLLISP(63	,1	,1,	378000000U),
PLLISP(32	,0	,1,	384000000U),
PLLISP(65	,1	,1,	390000000U),
PLLISP(33	,0	,1,	396000000U),
PLLISP(67	,1	,1,	402000000U),
PLLISP(34	,0	,1,	408000000U),
PLLISP(69	,1	,1,	414000000U),
PLLISP(35	,0	,1,	420000000U),
PLLISP(71	,1	,1,	426000000U),
PLLISP(36	,0	,1,	432000000U),
PLLISP(73	,1	,1,	438000000U),
PLLISP(37	,0	,1,	444000000U),
PLLISP(75	,1	,1,	450000000U),
PLLISP(38	,0	,1,	456000000U),
PLLISP(77	,1	,1,	462000000U),
PLLISP(39	,0	,1,	468000000U),
PLLISP(79	,1	,1,	474000000U),
PLLISP(40	,0	,1,	480000000U),
PLLISP(81	,1	,1,	486000000U),
PLLISP(41	,0	,1,	492000000U),
PLLISP(83	,1	,1,	498000000U),
PLLISP(42	,0	,1,	504000000U),
PLLISP(85	,1	,1,	510000000U),
PLLISP(43	,0	,1,	516000000U),
PLLISP(87	,1	,1,	522000000U),
PLLISP(44	,0	,1,	528000000U),
PLLISP(89	,1	,1,	534000000U),
PLLISP(45	,0	,1,	540000000U),
PLLISP(91	,1	,1,	546000000U),
PLLISP(46	,0	,1,	552000000U),
PLLISP(93	,1	,1,	558000000U),
PLLISP(47	,0	,1,	564000000U),
PLLISP(95	,1	,1,	570000000U),
PLLISP(48	,0	,1,	576000000U),
PLLISP(97	,1	,1,	582000000U),
PLLISP(49	,0	,1,	588000000U),
PLLISP(99	,1	,1,	594000000U),
PLLISP(50	,0	,1,	600000000U),
PLLISP(101	,1	,1,	606000000U),
PLLISP(51	,0	,1,	612000000U),
PLLISP(103	,1	,1,	618000000U),
PLLISP(52	,0	,1,	624000000U),
PLLISP(105	,1	,1,	630000000U),
PLLISP(53	,0	,1,	636000000U),
PLLISP(107	,1	,1,	642000000U),
PLLISP(54	,0	,1,	648000000U),
PLLISP(109	,1	,1,	654000000U),
PLLISP(55	,0	,1,	660000000U),
PLLISP(111	,1	,1,	666000000U),
PLLISP(56	,0	,1,	672000000U),
PLLISP(113	,1	,1,	678000000U),
PLLISP(57	,0	,1,	684000000U),
PLLISP(115	,1	,1,	690000000U),
PLLISP(58	,0	,1,	696000000U),
PLLISP(117	,1	,1,	702000000U),
PLLISP(59	,0	,1,	708000000U),
PLLISP(119	,1	,1,	714000000U),
PLLISP(60	,0	,1,	720000000U),
PLLISP(121	,1	,1,	726000000U),
PLLISP(61	,0	,1,	732000000U),
PLLISP(123	,1	,1,	738000000U),
PLLISP(62	,0	,1,	744000000U),
PLLISP(125	,1	,1,	750000000U),
PLLISP(63	,0	,1,	756000000U),
PLLISP(127	,1	,1,	762000000U),
PLLISP(64	,0	,1,	768000000U),
PLLISP(129	,1	,1,	774000000U),
PLLISP(65	,0	,1,	780000000U),
PLLISP(131	,1	,1,	786000000U),
PLLISP(66	,0	,1,	792000000U),
PLLISP(133	,1	,1,	798000000U),
PLLISP(67	,0	,1,	804000000U),
PLLISP(135	,1	,1,	810000000U),
PLLISP(68	,0	,1,	816000000U),
PLLISP(137	,1	,1,	822000000U),
PLLISP(69	,0	,1,	828000000U),
PLLISP(139	,1	,1,	834000000U),
PLLISP(70	,0	,1,	840000000U),
PLLISP(141	,1	,1,	846000000U),
PLLISP(71	,0	,1,	852000000U),
PLLISP(143	,1	,1,	858000000U),
PLLISP(72	,0	,1,	864000000U),
PLLISP(145	,1	,1,	870000000U),
PLLISP(73	,0	,1,	876000000U),
PLLISP(147	,1	,1,	882000000U),
PLLISP(74	,0	,1,	888000000U),
PLLISP(149	,1	,1,	894000000U),
PLLISP(75	,0	,1,	900000000U),
PLLISP(151	,1	,1,	906000000U),
PLLISP(76	,0	,1,	912000000U),
PLLISP(153	,1	,1,	918000000U),
PLLISP(77	,0	,1,	924000000U),
PLLISP(155	,1	,1,	930000000U),
PLLISP(78	,0	,1,	936000000U),
PLLISP(157	,1	,1,	942000000U),
PLLISP(79	,0	,1,	948000000U),
PLLISP(159	,1	,1,	954000000U),
PLLISP(80	,0	,1,	960000000U),
PLLISP(161	,1	,1,	966000000U),
PLLISP(81	,0	,1,	972000000U),
PLLISP(163	,1	,1,	978000000U),
PLLISP(82	,0	,1,	984000000U),
PLLISP(165	,1	,1,	990000000U),
PLLISP(83	,0	,1,	996000000U),
PLLISP(167	,1	,1,	1002000000U),
PLLISP(84	,0	,1,	1008000000U),
PLLISP(169	,1	,1,	1014000000U),
PLLISP(85	,0	,1,	1020000000U),
PLLISP(171	,1	,1,	1026000000U),
PLLISP(86	,0	,1,	1032000000U),
PLLISP(173	,1	,1,	1038000000U),
PLLISP(87	,0	,1,	1044000000U),
PLLISP(175	,1	,1,	1050000000U),
PLLISP(88	,0	,1,	1056000000U),
PLLISP(177	,1	,1,	1062000000U),
PLLISP(89	,0	,1,	1068000000U),
PLLISP(179	,1	,1,	1074000000U),
PLLISP(90	,0	,1,	1080000000U),
PLLISP(181	,1	,1,	1086000000U),
PLLISP(91	,0	,1,	1092000000U),
PLLISP(183	,1	,1,	1098000000U),
PLLISP(92	,0	,1,	1104000000U),
PLLISP(185	,1	,1,	1110000000U),
PLLISP(93	,0	,1,	1116000000U),
PLLISP(187	,1	,1,	1122000000U),
PLLISP(94	,0	,1,	1128000000U),
PLLISP(189	,1	,1,	1134000000U),
PLLISP(95	,0	,1,	1140000000U),
PLLISP(191	,1	,1,	1146000000U),
PLLISP(96	,0	,1,	1152000000U),
PLLISP(193	,1	,1,	1158000000U),
PLLISP(97	,0	,1,	1164000000U),
PLLISP(195	,1	,1,	1170000000U),
PLLISP(98	,0	,1,	1176000000U),
PLLISP(197	,1	,1,	1182000000U),
PLLISP(99	,0	,1,	1188000000U),
PLLISP(199	,1	,1,	1194000000U),
PLLISP(100	,0	,1,	1200000000U),
PLLISP(101	,0	,1,	1212000000U),
PLLISP(102	,0	,1,	1224000000U),
PLLISP(103	,0	,1,	1236000000U),
PLLISP(104	,0	,1,	1248000000U),
PLLISP(105	,0	,1,	1260000000U),
PLLISP(106	,0	,1,	1272000000U),
PLLISP(107	,0	,1,	1284000000U),
PLLISP(108	,0	,1,	1296000000U),
PLLISP(109	,0	,1,	1308000000U),
PLLISP(110	,0	,1,	1320000000U),
PLLISP(111	,0	,1,	1332000000U),
PLLISP(112	,0	,1,	1344000000U),
PLLISP(113	,0	,1,	1356000000U),
PLLISP(114	,0	,1,	1368000000U),
PLLISP(115	,0	,1,	1380000000U),
PLLISP(116	,0	,1,	1392000000U),
PLLISP(117	,0	,1,	1404000000U),
PLLISP(118	,0	,1,	1416000000U),
PLLISP(119	,0	,1,	1428000000U),
PLLISP(120	,0	,1,	1440000000U),
PLLISP(121	,0	,1,	1452000000U),
PLLISP(122	,0	,1,	1464000000U),
PLLISP(123	,0	,1,	1476000000U),
PLLISP(124	,0	,1,	1488000000U),
PLLISP(125	,0	,1,	1500000000U),
PLLISP(126	,0	,1,	1512000000U),
PLLISP(127	,0	,1,	1524000000U),
PLLISP(128	,0	,1,	1536000000U),
PLLISP(129	,0	,1,	1548000000U),
PLLISP(130	,1	,0,	1560000000U),
PLLISP(131	,1	,0,	1572000000U),
PLLISP(132	,1	,0,	1584000000U),
PLLISP(133	,1	,0,	1596000000U),
PLLISP(134	,1	,0,	1608000000U),
PLLISP(135	,1	,0,	1620000000U),
PLLISP(136	,1	,0,	1632000000U),
PLLISP(137	,1	,0,	1644000000U),
PLLISP(138	,1	,0,	1656000000U),
PLLISP(139	,1	,0,	1668000000U),
PLLISP(140	,1	,0,	1680000000U),
PLLISP(141	,1	,0,	1692000000U),
PLLISP(142	,1	,0,	1704000000U),
PLLISP(143	,1	,0,	1716000000U),
PLLISP(144	,1	,0,	1728000000U),
PLLISP(145	,1	,0,	1740000000U),
PLLISP(146	,1	,0,	1752000000U),
PLLISP(147	,1	,0,	1764000000U),
PLLISP(148	,1	,0,	1776000000U),
PLLISP(149	,1	,0,	1788000000U),
PLLISP(150	,1	,0,	1800000000U),
PLLISP(151	,1	,0,	1812000000U),
PLLISP(152	,1	,0,	1824000000U),
PLLISP(153	,1	,0,	1836000000U),
PLLISP(154	,1	,0,	1848000000U),
PLLISP(155	,1	,0,	1860000000U),
PLLISP(156	,1	,0,	1872000000U),
PLLISP(157	,1	,0,	1884000000U),
PLLISP(158	,1	,0,	1896000000U),
PLLISP(159	,1	,0,	1908000000U),
PLLISP(160	,1	,0,	1920000000U),
PLLISP(161	,1	,0,	1932000000U),
PLLISP(162	,1	,0,	1944000000U),
PLLISP(163	,1	,0,	1956000000U),
PLLISP(164	,1	,0,	1968000000U),
PLLISP(165	,1	,0,	1980000000U),
PLLISP(166	,1	,0,	1992000000U),
PLLISP(167	,1	,0,	2004000000U),
PLLISP(168	,1	,0,	2016000000U),
PLLISP(169	,1	,0,	2028000000U),
PLLISP(170	,1	,0,	2040000000U),
PLLISP(171	,1	,0,	2052000000U),
PLLISP(172	,1	,0,	2064000000U),
PLLISP(173	,1	,0,	2076000000U),
PLLISP(174	,1	,0,	2088000000U),
PLLISP(175	,1	,0,	2100000000U),
PLLISP(176	,1	,0,	2112000000U),
PLLISP(177	,1	,0,	2124000000U),
PLLISP(178	,1	,0,	2136000000U),
PLLISP(179	,1	,0,	2148000000U),
PLLISP(180	,1	,0,	2160000000U),
PLLISP(181	,1	,0,	2172000000U),
PLLISP(182	,1	,0,	2184000000U),
PLLISP(183	,1	,0,	2196000000U),
PLLISP(184	,1	,0,	2208000000U),
PLLISP(185	,1	,0,	2220000000U),
PLLISP(186	,1	,0,	2232000000U),
PLLISP(187	,1	,0,	2244000000U),
PLLISP(188	,1	,0,	2256000000U),
PLLISP(189	,1	,0,	2268000000U),
PLLISP(190	,1	,0,	2280000000U),
PLLISP(191	,1	,0,	2292000000U),
PLLISP(192	,1	,0,	2304000000U),
PLLISP(193	,1	,0,	2316000000U),
PLLISP(194	,1	,0,	2328000000U),
PLLISP(195	,1	,0,	2340000000U),
PLLISP(196	,1	,0,	2352000000U),
PLLISP(197	,1	,0,	2364000000U),
PLLISP(198	,1	,0,	2376000000U),
PLLISP(199	,1	,0,	2388000000U),
PLLISP(200	,1	,0,	2400000000U),
PLLISP(101	,0	,0,	2424000000U),
PLLISP(102	,0	,0,	2448000000U),
PLLISP(103	,0	,0,	2472000000U),
PLLISP(104	,0	,0,	2496000000U),
PLLISP(105	,0	,0,	2520000000U),
PLLISP(106	,0	,0,	2544000000U),
PLLISP(107	,0	,0,	2568000000U),
PLLISP(108	,0	,0,	2592000000U),
PLLISP(109	,0	,0,	2616000000U),
PLLISP(110	,0	,0,	2640000000U),
PLLISP(111	,0	,0,	2664000000U),
PLLISP(112	,0	,0,	2688000000U),
PLLISP(113	,0	,0,	2712000000U),
PLLISP(114	,0	,0,	2736000000U),
PLLISP(115	,0	,0,	2760000000U),
PLLISP(116	,0	,0,	2784000000U),
PLLISP(117	,0	,0,	2808000000U),
PLLISP(118	,0	,0,	2832000000U),
PLLISP(119	,0	,0,	2856000000U),
PLLISP(120	,0	,0,	2880000000U),
PLLISP(121	,0	,0,	2904000000U),
PLLISP(122	,0	,0,	2928000000U),
PLLISP(123	,0	,0,	2952000000U),
PLLISP(124	,0	,0,	2976000000U),
PLLISP(125	,0	,0,	3000000000U),
PLLISP(126	,0	,0,	3024000000U),
PLLISP(127	,0	,0,	3048000000U),
PLLISP(128	,0	,0,	3072000000U),
PLLISP(129	,0	,0,	3096000000U),
};

 //N,input,output,freq
static struct sunxi_clk_factor_freq factor_pll12_tbl[] = {
PLLPERIPH1(35	,1	,1,	210000000U),
PLLPERIPH1(36	,1	,1,	216000000U),
PLLPERIPH1(37	,1	,1,	222000000U),
PLLPERIPH1(38	,1	,1,	228000000U),
PLLPERIPH1(39	,1	,1,	234000000U),
PLLPERIPH1(20	,0	,1,	240000000U),
PLLPERIPH1(41	,1	,1,	246000000U),
PLLPERIPH1(21	,0	,1,	252000000U),
PLLPERIPH1(43	,1	,1,	258000000U),
PLLPERIPH1(22	,0	,1,	264000000U),
PLLPERIPH1(45	,1	,1,	270000000U),
PLLPERIPH1(23	,0	,1,	276000000U),
PLLPERIPH1(47	,1	,1,	282000000U),
PLLPERIPH1(24	,0	,1,	288000000U),
PLLPERIPH1(49	,1	,1,	294000000U),
PLLPERIPH1(25	,0	,1,	300000000U),
PLLPERIPH1(51	,1	,1,	306000000U),
PLLPERIPH1(26	,0	,1,	312000000U),
PLLPERIPH1(53	,1	,1,	318000000U),
PLLPERIPH1(27	,0	,1,	324000000U),
PLLPERIPH1(55	,1	,1,	330000000U),
PLLPERIPH1(28	,0	,1,	336000000U),
PLLPERIPH1(57	,1	,1,	342000000U),
PLLPERIPH1(29	,0	,1,	348000000U),
PLLPERIPH1(59	,1	,1,	354000000U),
PLLPERIPH1(30	,0	,1,	360000000U),
PLLPERIPH1(61	,1	,1,	366000000U),
PLLPERIPH1(31	,0	,1,	372000000U),
PLLPERIPH1(63	,1	,1,	378000000U),
PLLPERIPH1(32	,0	,1,	384000000U),
PLLPERIPH1(65	,1	,1,	390000000U),
PLLPERIPH1(33	,0	,1,	396000000U),
PLLPERIPH1(67	,1	,1,	402000000U),
PLLPERIPH1(34	,0	,1,	408000000U),
PLLPERIPH1(69	,1	,1,	414000000U),
PLLPERIPH1(35	,0	,1,	420000000U),
PLLPERIPH1(71	,1	,1,	426000000U),
PLLPERIPH1(36	,0	,1,	432000000U),
PLLPERIPH1(73	,1	,1,	438000000U),
PLLPERIPH1(37	,0	,1,	444000000U),
PLLPERIPH1(75	,1	,1,	450000000U),
PLLPERIPH1(38	,0	,1,	456000000U),
PLLPERIPH1(77	,1	,1,	462000000U),
PLLPERIPH1(39	,0	,1,	468000000U),
PLLPERIPH1(79	,1	,1,	474000000U),
PLLPERIPH1(40	,0	,1,	480000000U),
PLLPERIPH1(81	,1	,1,	486000000U),
PLLPERIPH1(41	,0	,1,	492000000U),
PLLPERIPH1(83	,1	,1,	498000000U),
PLLPERIPH1(42	,0	,1,	504000000U),
PLLPERIPH1(85	,1	,1,	510000000U),
PLLPERIPH1(43	,0	,1,	516000000U),
PLLPERIPH1(87	,1	,1,	522000000U),
PLLPERIPH1(44	,0	,1,	528000000U),
PLLPERIPH1(89	,1	,1,	534000000U),
PLLPERIPH1(45	,0	,1,	540000000U),
PLLPERIPH1(91	,1	,1,	546000000U),
PLLPERIPH1(46	,0	,1,	552000000U),
PLLPERIPH1(93	,1	,1,	558000000U),
PLLPERIPH1(47	,0	,1,	564000000U),
PLLPERIPH1(95	,1	,1,	570000000U),
PLLPERIPH1(48	,0	,1,	576000000U),
PLLPERIPH1(97	,1	,1,	582000000U),
PLLPERIPH1(49	,0	,1,	588000000U),
PLLPERIPH1(99	,1	,1,	594000000U),
PLLPERIPH1(50	,0	,1,	600000000U),
PLLPERIPH1(101	,1	,1,	606000000U),
PLLPERIPH1(51	,0	,1,	612000000U),
PLLPERIPH1(103	,1	,1,	618000000U),
PLLPERIPH1(52	,0	,1,	624000000U),
PLLPERIPH1(105	,1	,1,	630000000U),
PLLPERIPH1(53	,0	,1,	636000000U),
PLLPERIPH1(107	,1	,1,	642000000U),
PLLPERIPH1(54	,0	,1,	648000000U),
PLLPERIPH1(109	,1	,1,	654000000U),
PLLPERIPH1(55	,0	,1,	660000000U),
PLLPERIPH1(111	,1	,1,	666000000U),
PLLPERIPH1(56	,0	,1,	672000000U),
PLLPERIPH1(113	,1	,1,	678000000U),
PLLPERIPH1(57	,0	,1,	684000000U),
PLLPERIPH1(115	,1	,1,	690000000U),
PLLPERIPH1(58	,0	,1,	696000000U),
PLLPERIPH1(117	,1	,1,	702000000U),
PLLPERIPH1(59	,0	,1,	708000000U),
PLLPERIPH1(119	,1	,1,	714000000U),
PLLPERIPH1(60	,0	,1,	720000000U),
PLLPERIPH1(121	,1	,1,	726000000U),
PLLPERIPH1(61	,0	,1,	732000000U),
PLLPERIPH1(123	,1	,1,	738000000U),
PLLPERIPH1(62	,0	,1,	744000000U),
PLLPERIPH1(125	,1	,1,	750000000U),
PLLPERIPH1(63	,0	,1,	756000000U),
PLLPERIPH1(127	,1	,1,	762000000U),
PLLPERIPH1(64	,0	,1,	768000000U),
PLLPERIPH1(129	,1	,1,	774000000U),
PLLPERIPH1(65	,0	,1,	780000000U),
PLLPERIPH1(131	,1	,1,	786000000U),
PLLPERIPH1(66	,0	,1,	792000000U),
PLLPERIPH1(133	,1	,1,	798000000U),
PLLPERIPH1(67	,0	,1,	804000000U),
PLLPERIPH1(135	,1	,1,	810000000U),
PLLPERIPH1(68	,0	,1,	816000000U),
PLLPERIPH1(137	,1	,1,	822000000U),
PLLPERIPH1(69	,0	,1,	828000000U),
PLLPERIPH1(139	,1	,1,	834000000U),
PLLPERIPH1(70	,0	,1,	840000000U),
PLLPERIPH1(141	,1	,1,	846000000U),
PLLPERIPH1(71	,0	,1,	852000000U),
PLLPERIPH1(143	,1	,1,	858000000U),
PLLPERIPH1(72	,0	,1,	864000000U),
PLLPERIPH1(145	,1	,1,	870000000U),
PLLPERIPH1(73	,0	,1,	876000000U),
PLLPERIPH1(147	,1	,1,	882000000U),
PLLPERIPH1(74	,0	,1,	888000000U),
PLLPERIPH1(149	,1	,1,	894000000U),
PLLPERIPH1(75	,0	,1,	900000000U),
PLLPERIPH1(151	,1	,1,	906000000U),
PLLPERIPH1(76	,0	,1,	912000000U),
PLLPERIPH1(153	,1	,1,	918000000U),
PLLPERIPH1(77	,0	,1,	924000000U),
PLLPERIPH1(155	,1	,1,	930000000U),
PLLPERIPH1(78	,0	,1,	936000000U),
PLLPERIPH1(157	,1	,1,	942000000U),
PLLPERIPH1(79	,0	,1,	948000000U),
PLLPERIPH1(159	,1	,1,	954000000U),
PLLPERIPH1(80	,0	,1,	960000000U),
PLLPERIPH1(161	,1	,1,	966000000U),
PLLPERIPH1(81	,0	,1,	972000000U),
PLLPERIPH1(163	,1	,1,	978000000U),
PLLPERIPH1(82	,0	,1,	984000000U),
PLLPERIPH1(165	,1	,1,	990000000U),
PLLPERIPH1(83	,0	,1,	996000000U),
PLLPERIPH1(167	,1	,1,	1002000000U),
PLLPERIPH1(84	,0	,1,	1008000000U),
PLLPERIPH1(169	,1	,1,	1014000000U),
PLLPERIPH1(85	,0	,1,	1020000000U),
PLLPERIPH1(171	,1	,1,	1026000000U),
PLLPERIPH1(86	,0	,1,	1032000000U),
PLLPERIPH1(173	,1	,1,	1038000000U),
PLLPERIPH1(87	,0	,1,	1044000000U),
PLLPERIPH1(175	,1	,1,	1050000000U),
PLLPERIPH1(88	,0	,1,	1056000000U),
PLLPERIPH1(177	,1	,1,	1062000000U),
PLLPERIPH1(89	,0	,1,	1068000000U),
PLLPERIPH1(179	,1	,1,	1074000000U),
PLLPERIPH1(90	,0	,1,	1080000000U),
PLLPERIPH1(181	,1	,1,	1086000000U),
PLLPERIPH1(91	,0	,1,	1092000000U),
PLLPERIPH1(183	,1	,1,	1098000000U),
PLLPERIPH1(92	,0	,1,	1104000000U),
PLLPERIPH1(185	,1	,1,	1110000000U),
PLLPERIPH1(93	,0	,1,	1116000000U),
PLLPERIPH1(187	,1	,1,	1122000000U),
PLLPERIPH1(94	,0	,1,	1128000000U),
PLLPERIPH1(189	,1	,1,	1134000000U),
PLLPERIPH1(95	,0	,1,	1140000000U),
PLLPERIPH1(191	,1	,1,	1146000000U),
PLLPERIPH1(96	,0	,1,	1152000000U),
PLLPERIPH1(193	,1	,1,	1158000000U),
PLLPERIPH1(97	,0	,1,	1164000000U),
PLLPERIPH1(195	,1	,1,	1170000000U),
PLLPERIPH1(98	,0	,1,	1176000000U),
PLLPERIPH1(197	,1	,1,	1182000000U),
PLLPERIPH1(99	,0	,1,	1188000000U),
PLLPERIPH1(199	,1	,1,	1194000000U),
PLLPERIPH1(100	,0	,1,	1200000000U),
PLLPERIPH1(101	,0	,1,	1212000000U),
PLLPERIPH1(102	,0	,1,	1224000000U),
PLLPERIPH1(103	,0	,1,	1236000000U),
PLLPERIPH1(104	,0	,1,	1248000000U),
PLLPERIPH1(105	,0	,1,	1260000000U),
PLLPERIPH1(106	,0	,1,	1272000000U),
PLLPERIPH1(107	,0	,1,	1284000000U),
PLLPERIPH1(108	,0	,1,	1296000000U),
PLLPERIPH1(109	,0	,1,	1308000000U),
PLLPERIPH1(110	,0	,1,	1320000000U),
PLLPERIPH1(111	,0	,1,	1332000000U),
PLLPERIPH1(112	,0	,1,	1344000000U),
PLLPERIPH1(113	,0	,1,	1356000000U),
PLLPERIPH1(114	,0	,1,	1368000000U),
PLLPERIPH1(115	,0	,1,	1380000000U),
PLLPERIPH1(116	,0	,1,	1392000000U),
PLLPERIPH1(117	,0	,1,	1404000000U),
PLLPERIPH1(118	,1	,0,	1416000000U),
PLLPERIPH1(119	,0	,1,	1428000000U),
PLLPERIPH1(120	,0	,1,	1440000000U),
PLLPERIPH1(121	,0	,1,	1452000000U),
PLLPERIPH1(122	,0	,1,	1464000000U),
PLLPERIPH1(123	,0	,1,	1476000000U),
PLLPERIPH1(124	,0	,1,	1488000000U),
PLLPERIPH1(125	,0	,1,	1500000000U),
PLLPERIPH1(126	,0	,1,	1512000000U),
PLLPERIPH1(127	,1	,0,	1524000000U),
PLLPERIPH1(128	,1	,0,	1536000000U),
PLLPERIPH1(129	,1	,0,	1548000000U),
PLLPERIPH1(130	,1	,0,	1560000000U),
PLLPERIPH1(131	,1	,0,	1572000000U),
PLLPERIPH1(132	,1	,0,	1584000000U),
PLLPERIPH1(133	,1	,0,	1596000000U),
PLLPERIPH1(134	,1	,0,	1608000000U),
PLLPERIPH1(135	,1	,0,	1620000000U),
PLLPERIPH1(136	,1	,0,	1632000000U),
PLLPERIPH1(137	,1	,0,	1644000000U),
PLLPERIPH1(138	,1	,0,	1656000000U),
PLLPERIPH1(139	,1	,0,	1668000000U),
PLLPERIPH1(140	,1	,0,	1680000000U),
PLLPERIPH1(141	,1	,0,	1692000000U),
PLLPERIPH1(142	,1	,0,	1704000000U),
PLLPERIPH1(143	,1	,0,	1716000000U),
PLLPERIPH1(144	,1	,0,	1728000000U),
PLLPERIPH1(145	,1	,0,	1740000000U),
PLLPERIPH1(146	,1	,0,	1752000000U),
PLLPERIPH1(147	,1	,0,	1764000000U),
PLLPERIPH1(148	,1	,0,	1776000000U),
PLLPERIPH1(149	,1	,0,	1788000000U),
PLLPERIPH1(150	,1	,0,	1800000000U),
PLLPERIPH1(151	,1	,0,	1812000000U),
PLLPERIPH1(152	,1	,0,	1824000000U),
PLLPERIPH1(153	,1	,0,	1836000000U),
PLLPERIPH1(154	,1	,0,	1848000000U),
PLLPERIPH1(155	,1	,0,	1860000000U),
PLLPERIPH1(156	,1	,0,	1872000000U),
PLLPERIPH1(157	,1	,0,	1884000000U),
PLLPERIPH1(158	,1	,0,	1896000000U),
PLLPERIPH1(159	,1	,0,	1908000000U),
PLLPERIPH1(160	,1	,0,	1920000000U),
PLLPERIPH1(161	,1	,0,	1932000000U),
PLLPERIPH1(162	,1	,0,	1944000000U),
PLLPERIPH1(163	,1	,0,	1956000000U),
PLLPERIPH1(164	,1	,0,	1968000000U),
PLLPERIPH1(165	,1	,0,	1980000000U),
PLLPERIPH1(166	,1	,0,	1992000000U),
PLLPERIPH1(167	,1	,0,	2004000000U),
PLLPERIPH1(168	,1	,0,	2016000000U),
PLLPERIPH1(169	,1	,0,	2028000000U),
PLLPERIPH1(170	,1	,0,	2040000000U),
PLLPERIPH1(171	,1	,0,	2052000000U),
PLLPERIPH1(172	,1	,0,	2064000000U),
PLLPERIPH1(173	,1	,0,	2076000000U),
PLLPERIPH1(174	,1	,0,	2088000000U),
PLLPERIPH1(175	,1	,0,	2100000000U),
PLLPERIPH1(176	,1	,0,	2112000000U),
PLLPERIPH1(177	,1	,0,	2124000000U),
PLLPERIPH1(178	,1	,0,	2136000000U),
PLLPERIPH1(179	,1	,0,	2148000000U),
PLLPERIPH1(180	,1	,0,	2160000000U),
PLLPERIPH1(181	,1	,0,	2172000000U),
PLLPERIPH1(182	,1	,0,	2184000000U),
PLLPERIPH1(183	,1	,0,	2196000000U),
PLLPERIPH1(184	,1	,0,	2208000000U),
PLLPERIPH1(185	,1	,0,	2220000000U),
PLLPERIPH1(186	,1	,0,	2232000000U),
PLLPERIPH1(187	,1	,0,	2244000000U),
PLLPERIPH1(188	,1	,0,	2256000000U),
PLLPERIPH1(189	,1	,0,	2268000000U),
PLLPERIPH1(190	,1	,0,	2280000000U),
PLLPERIPH1(191	,1	,0,	2292000000U),
PLLPERIPH1(192	,1	,0,	2304000000U),
PLLPERIPH1(193	,1	,0,	2316000000U),
PLLPERIPH1(194	,1	,0,	2328000000U),
PLLPERIPH1(195	,1	,0,	2340000000U),
PLLPERIPH1(196	,1	,0,	2352000000U),
PLLPERIPH1(197	,1	,0,	2364000000U),
PLLPERIPH1(198	,1	,0,	2376000000U),
PLLPERIPH1(199	,1	,0,	2388000000U),
PLLPERIPH1(200	,1	,0,	2400000000U),
PLLPERIPH1(101	,0	,0,	2424000000U),
PLLPERIPH1(102	,0	,0,	2448000000U),
PLLPERIPH1(103	,0	,0,	2472000000U),
PLLPERIPH1(104	,0	,0,	2496000000U),
PLLPERIPH1(105	,0	,0,	2520000000U),
PLLPERIPH1(106	,0	,0,	2544000000U),
PLLPERIPH1(107	,0	,0,	2568000000U),
PLLPERIPH1(108	,0	,0,	2592000000U),
PLLPERIPH1(109	,0	,0,	2616000000U),
PLLPERIPH1(110	,0	,0,	2640000000U),
PLLPERIPH1(111	,0	,0,	2664000000U),
PLLPERIPH1(112	,0	,0,	2688000000U),
PLLPERIPH1(113	,0	,0,	2712000000U),
PLLPERIPH1(114	,0	,0,	2736000000U),
PLLPERIPH1(115	,0	,0,	2760000000U),
PLLPERIPH1(116	,0	,0,	2784000000U),
PLLPERIPH1(117	,0	,0,	2808000000U),
PLLPERIPH1(118	,0	,0,	2832000000U),
PLLPERIPH1(119	,0	,0,	2856000000U),
PLLPERIPH1(120	,0	,0,	2880000000U),
PLLPERIPH1(121	,0	,0,	2904000000U),
PLLPERIPH1(122	,0	,0,	2928000000U),
PLLPERIPH1(123	,0	,0,	2952000000U),
PLLPERIPH1(124	,0	,0,	2976000000U),
PLLPERIPH1(125	,0	,0,	3000000000U),
};

static unsigned int pll1_max,pll2_max,pll4_max,pll5_max,pll6_max;
static unsigned int pll7_max,pll8_max,pll9_max,pll10_max,pll11_max,pll12_max;
static void sunxi_clk_factor_initlimits(void)
{
    pll1_max=factor_pll1_tbl[ARRAY_SIZE(factor_pll1_tbl)-1].freq;
    pll2_max=factor_pll2_tbl[ARRAY_SIZE(factor_pll2_tbl)-1].freq;

    pll4_max=factor_pll4_tbl[ARRAY_SIZE(factor_pll4_tbl)-1].freq;
    pll5_max=factor_pll5_tbl[ARRAY_SIZE(factor_pll5_tbl)-1].freq;
    pll6_max=factor_pll6_tbl[ARRAY_SIZE(factor_pll6_tbl)-1].freq;
    pll7_max=factor_pll7_tbl[ARRAY_SIZE(factor_pll7_tbl)-1].freq;
    pll8_max=factor_pll8_tbl[ARRAY_SIZE(factor_pll8_tbl)-1].freq;
    pll9_max=factor_pll9_tbl[ARRAY_SIZE(factor_pll9_tbl)-1].freq;
    pll10_max=factor_pll10_tbl[ARRAY_SIZE(factor_pll10_tbl)-1].freq;
    pll11_max=factor_pll11_tbl[ARRAY_SIZE(factor_pll11_tbl)-1].freq;    
    pll12_max=factor_pll11_tbl[ARRAY_SIZE(factor_pll11_tbl)-1].freq; 
}
