#include "clk-sun8iw9.h"
/*
 * freq table from hardware, need follow rules
 * 1)   each table  named as 
 *      factor_pll1_tbl
 *      factor_pll2_tbl
 *      ...
 * 2) for each table line 
 *      a) follow the format PLLx(n,k,m,p,d1,d2,freq), and keep the factors order
 *      b) if any factor not used, skip it
 *      c) the factor is the value to write registers, not means factor+1
 *
 *      example
 *      PLL1(9, 0, 0, 2, 60000000) means PLL1(n,k,m,p,freq)  
 *      PLLVIDEO(3, 0, 96000000)       means PLLVIDEO(n,m,freq) 
 *
 */


//#define PLLCPU(n,m,p,freq)  {F_N8X7_M0X2_P16x2(n,m, p),  freq}
struct sunxi_clk_factor_freq factor_pllcpu0_tbl[] = {
PLLCPU( 24,  2,  0,   200000000U),
PLLCPU( 66,  1,  2,   201000000U),
PLLCPU(100,  2,  2,   202000000U),
PLLCPU( 16,  0,  1,   204000000U),
PLLCPU(102,  2,  2,   206000000U),
PLLCPU( 68,  1,  2,   207000000U),
PLLCPU( 25,  2,  0,   208000000U),
PLLCPU( 34,  0,  2,   210000000U),
PLLCPU( 52,  2,  1,   212000000U),
PLLCPU( 70,  1,  2,   213000000U),
PLLCPU(106,  2,  2,   214000000U),
PLLCPU(  8,  0,  0,   216000000U),
PLLCPU(108,  2,  2,   218000000U),
PLLCPU( 72,  1,  2,   219000000U),
PLLCPU( 54,  2,  1,   220000000U),
PLLCPU( 36,  0,  2,   222000000U),
PLLCPU( 27,  2,  0,   224000000U),
PLLCPU( 74,  1,  2,   225000000U),
PLLCPU(112,  2,  2,   226000000U),
PLLCPU( 18,  0,  1,   228000000U),
PLLCPU(114,  2,  2,   230000000U),
PLLCPU( 76,  1,  2,   231000000U),
PLLCPU( 28,  2,  0,   232000000U),
PLLCPU( 38,  0,  2,   234000000U),
PLLCPU( 58,  2,  1,   236000000U),
PLLCPU( 78,  1,  2,   237000000U),
PLLCPU(118,  2,  2,   238000000U),
PLLCPU(  9,  0,  0,   240000000U),
PLLCPU(120,  2,  2,   242000000U),
PLLCPU( 80,  1,  2,   243000000U),
PLLCPU( 60,  2,  1,   244000000U),
PLLCPU( 40,  0,  2,   246000000U),
PLLCPU( 30,  2,  0,   248000000U),
PLLCPU( 82,  1,  2,   249000000U),
PLLCPU(124,  2,  2,   250000000U),
PLLCPU( 20,  0,  1,   252000000U),
PLLCPU(126,  2,  2,   254000000U),
PLLCPU( 84,  1,  2,   255000000U),
PLLCPU( 31,  2,  0,   256000000U),
PLLCPU( 42,  0,  2,   258000000U),
PLLCPU( 64,  2,  1,   260000000U),
PLLCPU( 86,  1,  2,   261000000U),
PLLCPU( 10,  0,  0,   264000000U),
PLLCPU( 88,  1,  2,   267000000U),
PLLCPU( 66,  2,  1,   268000000U),
PLLCPU( 44,  0,  2,   270000000U),
PLLCPU( 33,  2,  0,   272000000U),
PLLCPU( 90,  1,  2,   273000000U),
PLLCPU( 22,  0,  1,   276000000U),
PLLCPU( 92,  1,  2,   279000000U),
PLLCPU( 34,  2,  0,   280000000U),
PLLCPU( 46,  0,  2,   282000000U),
PLLCPU( 70,  2,  1,   284000000U),
PLLCPU( 94,  1,  2,   285000000U),
PLLCPU( 11,  0,  0,   288000000U),
PLLCPU( 96,  1,  2,   291000000U),
PLLCPU( 72,  2,  1,   292000000U),
PLLCPU( 48,  0,  2,   294000000U),
PLLCPU( 36,  2,  0,   296000000U),
PLLCPU( 98,  1,  2,   297000000U),
PLLCPU( 24,  0,  1,   300000000U),
PLLCPU(100,  1,  2,   303000000U),
PLLCPU( 37,  2,  0,   304000000U),
PLLCPU( 50,  0,  2,   306000000U),
PLLCPU( 76,  2,  1,   308000000U),
PLLCPU(102,  1,  2,   309000000U),
PLLCPU( 12,  0,  0,   312000000U),
PLLCPU(104,  1,  2,   315000000U),
PLLCPU( 78,  2,  1,   316000000U),
PLLCPU( 52,  0,  2,   318000000U),
PLLCPU( 39,  2,  0,   320000000U),
PLLCPU(106,  1,  2,   321000000U),
PLLCPU( 26,  0,  1,   324000000U),
PLLCPU(108,  1,  2,   327000000U),
PLLCPU( 40,  2,  0,   328000000U),
PLLCPU( 54,  0,  2,   330000000U),
PLLCPU( 82,  2,  1,   332000000U),
PLLCPU(110,  1,  2,   333000000U),
PLLCPU( 13,  0,  0,   336000000U),
PLLCPU(112,  1,  2,   339000000U),
PLLCPU( 84,  2,  1,   340000000U),
PLLCPU( 56,  0,  2,   342000000U),
PLLCPU( 42,  2,  0,   344000000U),
PLLCPU(114,  1,  2,   345000000U),
PLLCPU( 28,  0,  1,   348000000U),
PLLCPU(116,  1,  2,   351000000U),
PLLCPU( 43,  2,  0,   352000000U),
PLLCPU( 58,  0,  2,   354000000U),
PLLCPU( 88,  2,  1,   356000000U),
PLLCPU(118,  1,  2,   357000000U),
PLLCPU( 14,  0,  0,   360000000U),
PLLCPU(120,  1,  2,   363000000U),
PLLCPU( 90,  2,  1,   364000000U),
PLLCPU( 60,  0,  2,   366000000U),
PLLCPU( 45,  2,  0,   368000000U),
PLLCPU(122,  1,  2,   369000000U),
PLLCPU( 30,  0,  1,   372000000U),
PLLCPU(124,  1,  2,   375000000U),
PLLCPU( 46,  2,  0,   376000000U),
PLLCPU( 62,  0,  2,   378000000U),
PLLCPU( 94,  2,  1,   380000000U),
PLLCPU(126,  1,  2,   381000000U),
PLLCPU( 15,  0,  0,   384000000U),
PLLCPU( 96,  2,  1,   388000000U),
PLLCPU( 64,  0,  2,   390000000U),
PLLCPU( 48,  2,  0,   392000000U),
PLLCPU( 32,  0,  1,   396000000U),
PLLCPU( 49,  2,  0,   400000000U),
PLLCPU( 66,  0,  2,   402000000U),
PLLCPU(100,  2,  1,   404000000U),
PLLCPU( 16,  0,  0,   408000000U),
PLLCPU(102,  2,  1,   412000000U),
PLLCPU( 68,  0,  2,   414000000U),
PLLCPU( 51,  2,  0,   416000000U),
PLLCPU( 34,  0,  1,   420000000U),
PLLCPU( 52,  2,  0,   424000000U),
PLLCPU( 70,  0,  2,   426000000U),
PLLCPU(106,  2,  1,   428000000U),
PLLCPU( 17,  0,  0,   432000000U),
PLLCPU(108,  2,  1,   436000000U),
PLLCPU( 72,  0,  2,   438000000U),
PLLCPU( 54,  2,  0,   440000000U),
PLLCPU( 36,  0,  1,   444000000U),
PLLCPU( 55,  2,  0,   448000000U),
PLLCPU( 74,  0,  2,   450000000U),
PLLCPU(112,  2,  1,   452000000U),
PLLCPU( 18,  0,  0,   456000000U),
PLLCPU(114,  2,  1,   460000000U),
PLLCPU( 76,  0,  2,   462000000U),
PLLCPU( 57,  2,  0,   464000000U),
PLLCPU( 38,  0,  1,   468000000U),
PLLCPU( 58,  2,  0,   472000000U),
PLLCPU( 78,  0,  2,   474000000U),
PLLCPU(118,  2,  1,   476000000U),
PLLCPU( 19,  0,  0,   480000000U),
PLLCPU(120,  2,  1,   484000000U),
PLLCPU( 80,  0,  2,   486000000U),
PLLCPU( 60,  2,  0,   488000000U),
PLLCPU( 40,  0,  1,   492000000U),
PLLCPU( 61,  2,  0,   496000000U),
PLLCPU( 82,  0,  2,   498000000U),
PLLCPU(124,  2,  1,   500000000U),
PLLCPU( 20,  0,  0,   504000000U),
PLLCPU(126,  2,  1,   508000000U),
PLLCPU( 84,  0,  2,   510000000U),
PLLCPU( 63,  2,  0,   512000000U),
PLLCPU( 42,  0,  1,   516000000U),
PLLCPU( 64,  2,  0,   520000000U),
PLLCPU( 86,  0,  2,   522000000U),
PLLCPU( 21,  0,  0,   528000000U),
PLLCPU( 88,  0,  2,   534000000U),
PLLCPU( 66,  2,  0,   536000000U),
PLLCPU( 44,  0,  1,   540000000U),
PLLCPU( 67,  2,  0,   544000000U),
PLLCPU( 90,  0,  2,   546000000U),
PLLCPU( 22,  0,  0,   552000000U),
PLLCPU( 92,  0,  2,   558000000U),
PLLCPU( 69,  2,  0,   560000000U),
PLLCPU( 46,  0,  1,   564000000U),
PLLCPU( 70,  2,  0,   568000000U),
PLLCPU( 94,  0,  2,   570000000U),
PLLCPU( 23,  0,  0,   576000000U),
PLLCPU( 96,  0,  2,   582000000U),
PLLCPU( 72,  2,  0,   584000000U),
PLLCPU( 48,  0,  1,   588000000U),
PLLCPU( 73,  2,  0,   592000000U),
PLLCPU( 98,  0,  2,   594000000U),
PLLCPU( 24,  0,  0,   600000000U),
PLLCPU(100,  0,  2,   606000000U),
PLLCPU( 75,  2,  0,   608000000U),
PLLCPU( 50,  0,  1,   612000000U),
PLLCPU( 76,  2,  0,   616000000U),
PLLCPU(102,  0,  2,   618000000U),
PLLCPU( 25,  0,  0,   624000000U),
PLLCPU(104,  0,  2,   630000000U),
PLLCPU( 78,  2,  0,   632000000U),
PLLCPU( 52,  0,  1,   636000000U),
PLLCPU( 79,  2,  0,   640000000U),
PLLCPU(106,  0,  2,   642000000U),
PLLCPU( 26,  0,  0,   648000000U),
PLLCPU(108,  0,  2,   654000000U),
PLLCPU( 81,  2,  0,   656000000U),
PLLCPU( 54,  0,  1,   660000000U),
PLLCPU( 82,  2,  0,   664000000U),
PLLCPU(110,  0,  2,   666000000U),
PLLCPU( 27,  0,  0,   672000000U),
PLLCPU(112,  0,  2,   678000000U),
PLLCPU( 84,  2,  0,   680000000U),
PLLCPU( 56,  0,  1,   684000000U),
PLLCPU( 85,  2,  0,   688000000U),
PLLCPU(114,  0,  2,   690000000U),
PLLCPU( 28,  0,  0,   696000000U),
PLLCPU(116,  0,  2,   702000000U),
PLLCPU( 87,  2,  0,   704000000U),
PLLCPU( 58,  0,  1,   708000000U),
PLLCPU( 88,  2,  0,   712000000U),
PLLCPU(118,  0,  2,   714000000U),
PLLCPU( 29,  0,  0,   720000000U),
PLLCPU(120,  0,  2,   726000000U),
PLLCPU( 90,  2,  0,   728000000U),
PLLCPU( 60,  0,  1,   732000000U),
PLLCPU( 91,  2,  0,   736000000U),
PLLCPU(122,  0,  2,   738000000U),
PLLCPU( 30,  0,  0,   744000000U),
PLLCPU(124,  0,  2,   750000000U),
PLLCPU( 93,  2,  0,   752000000U),
PLLCPU( 62,  0,  1,   756000000U),
PLLCPU( 94,  2,  0,   760000000U),
PLLCPU(126,  0,  2,   762000000U),
PLLCPU( 31,  0,  0,   768000000U),
PLLCPU( 96,  2,  0,   776000000U),
PLLCPU( 64,  0,  1,   780000000U),
PLLCPU( 97,  2,  0,   784000000U),
PLLCPU( 32,  0,  0,   792000000U),
PLLCPU( 99,  2,  0,   800000000U),
PLLCPU( 66,  0,  1,   804000000U),
PLLCPU(100,  2,  0,   808000000U),
PLLCPU( 33,  0,  0,   816000000U),
PLLCPU(102,  2,  0,   824000000U),
PLLCPU( 68,  0,  1,   828000000U),
PLLCPU(103,  2,  0,   832000000U),
PLLCPU( 34,  0,  0,   840000000U),
PLLCPU(105,  2,  0,   848000000U),
PLLCPU( 70,  0,  1,   852000000U),
PLLCPU(106,  2,  0,   856000000U),
PLLCPU( 35,  0,  0,   864000000U),
PLLCPU(108,  2,  0,   872000000U),
PLLCPU( 72,  0,  1,   876000000U),
PLLCPU(109,  2,  0,   880000000U),
PLLCPU( 36,  0,  0,   888000000U),
PLLCPU(111,  2,  0,   896000000U),
PLLCPU( 74,  0,  1,   900000000U),
PLLCPU(112,  2,  0,   904000000U),
PLLCPU( 37,  0,  0,   912000000U),
PLLCPU(114,  2,  0,   920000000U),
PLLCPU( 76,  0,  1,   924000000U),
PLLCPU(115,  2,  0,   928000000U),
PLLCPU( 38,  0,  0,   936000000U),
PLLCPU(117,  2,  0,   944000000U),
PLLCPU( 78,  0,  1,   948000000U),
PLLCPU(118,  2,  0,   952000000U),
PLLCPU( 39,  0,  0,   960000000U),
PLLCPU(120,  2,  0,   968000000U),
PLLCPU( 80,  0,  1,   972000000U),
PLLCPU(121,  2,  0,   976000000U),
PLLCPU( 40,  0,  0,   984000000U),
PLLCPU(123,  2,  0,   992000000U),
PLLCPU( 82,  0,  1,   996000000U),
PLLCPU(124,  2,  0,  1000000000U),
PLLCPU( 41,  0,  0,  1008000000U),
PLLCPU(126,  2,  0,  1016000000U),
PLLCPU( 84,  0,  1,  1020000000U),
PLLCPU(127,  2,  0,  1024000000U),
PLLCPU( 42,  0,  0,  1032000000U),
PLLCPU( 86,  0,  1,  1044000000U),
PLLCPU( 43,  0,  0,  1056000000U),
PLLCPU( 88,  0,  1,  1068000000U),
PLLCPU( 44,  0,  0,  1080000000U),
PLLCPU( 90,  0,  1,  1092000000U),
PLLCPU( 45,  0,  0,  1104000000U),
PLLCPU( 92,  0,  1,  1116000000U),
PLLCPU( 46,  0,  0,  1128000000U),
PLLCPU( 94,  0,  1,  1140000000U),
PLLCPU( 47,  0,  0,  1152000000U),
PLLCPU( 96,  0,  1,  1164000000U),
PLLCPU( 48,  0,  0,  1176000000U),
PLLCPU( 98,  0,  1,  1188000000U),
PLLCPU( 49,  0,  0,  1200000000U),
PLLCPU(100,  0,  1,  1212000000U),
PLLCPU( 50,  0,  0,  1224000000U),
PLLCPU(102,  0,  1,  1236000000U),
PLLCPU( 51,  0,  0,  1248000000U),
PLLCPU(104,  0,  1,  1260000000U),
PLLCPU( 52,  0,  0,  1272000000U),
PLLCPU(106,  0,  1,  1284000000U),
PLLCPU( 53,  0,  0,  1296000000U),
PLLCPU(108,  0,  1,  1308000000U),
PLLCPU( 54,  0,  0,  1320000000U),
PLLCPU(110,  0,  1,  1332000000U),
PLLCPU( 55,  0,  0,  1344000000U),
PLLCPU(112,  0,  1,  1356000000U),
PLLCPU( 56,  0,  0,  1368000000U),
PLLCPU(114,  0,  1,  1380000000U),
PLLCPU( 57,  0,  0,  1392000000U),
PLLCPU(116,  0,  1,  1404000000U),
PLLCPU( 58,  0,  0,  1416000000U),
PLLCPU(118,  0,  1,  1428000000U),
PLLCPU( 59,  0,  0,  1440000000U),
PLLCPU(120,  0,  1,  1452000000U),
PLLCPU( 60,  0,  0,  1464000000U),
PLLCPU(122,  0,  1,  1476000000U),
PLLCPU( 61,  0,  0,  1488000000U),
PLLCPU(124,  0,  1,  1500000000U),
PLLCPU( 62,  0,  0,  1512000000U),
PLLCPU(126,  0,  1,  1524000000U),
PLLCPU( 63,  0,  0,  1536000000U),
PLLCPU( 64,  0,  0,  1560000000U),
PLLCPU( 65,  0,  0,  1584000000U),
PLLCPU( 66,  0,  0,  1608000000U),
PLLCPU( 67,  0,  0,  1632000000U),
PLLCPU( 68,  0,  0,  1656000000U),
PLLCPU( 69,  0,  0,  1680000000U),
PLLCPU( 70,  0,  0,  1704000000U),
PLLCPU( 71,  0,  0,  1728000000U),
PLLCPU( 72,  0,  0,  1752000000U),
PLLCPU( 73,  0,  0,  1776000000U),
PLLCPU( 74,  0,  0,  1800000000U),
PLLCPU( 75,  0,  0,  1824000000U),
PLLCPU( 76,  0,  0,  1848000000U),
PLLCPU( 77,  0,  0,  1872000000U),
PLLCPU( 78,  0,  0,  1896000000U),
};

struct sunxi_clk_factor_freq factor_pllcpu1_tbl[] = {
PLLCPU( 24,  2,  0,   200000000U),
PLLCPU( 66,  1,  2,   201000000U),
PLLCPU(100,  2,  2,   202000000U),
PLLCPU( 16,  0,  1,   204000000U),
PLLCPU(102,  2,  2,   206000000U),
PLLCPU( 68,  1,  2,   207000000U),
PLLCPU( 25,  2,  0,   208000000U),
PLLCPU( 34,  0,  2,   210000000U),
PLLCPU( 52,  2,  1,   212000000U),
PLLCPU( 70,  1,  2,   213000000U),
PLLCPU(106,  2,  2,   214000000U),
PLLCPU(  8,  0,  0,   216000000U),
PLLCPU(108,  2,  2,   218000000U),
PLLCPU( 72,  1,  2,   219000000U),
PLLCPU( 54,  2,  1,   220000000U),
PLLCPU( 36,  0,  2,   222000000U),
PLLCPU( 27,  2,  0,   224000000U),
PLLCPU( 74,  1,  2,   225000000U),
PLLCPU(112,  2,  2,   226000000U),
PLLCPU( 18,  0,  1,   228000000U),
PLLCPU(114,  2,  2,   230000000U),
PLLCPU( 76,  1,  2,   231000000U),
PLLCPU( 28,  2,  0,   232000000U),
PLLCPU( 38,  0,  2,   234000000U),
PLLCPU( 58,  2,  1,   236000000U),
PLLCPU( 78,  1,  2,   237000000U),
PLLCPU(118,  2,  2,   238000000U),
PLLCPU(  9,  0,  0,   240000000U),
PLLCPU(120,  2,  2,   242000000U),
PLLCPU( 80,  1,  2,   243000000U),
PLLCPU( 60,  2,  1,   244000000U),
PLLCPU( 40,  0,  2,   246000000U),
PLLCPU( 30,  2,  0,   248000000U),
PLLCPU( 82,  1,  2,   249000000U),
PLLCPU(124,  2,  2,   250000000U),
PLLCPU( 20,  0,  1,   252000000U),
PLLCPU(126,  2,  2,   254000000U),
PLLCPU( 84,  1,  2,   255000000U),
PLLCPU( 31,  2,  0,   256000000U),
PLLCPU( 42,  0,  2,   258000000U),
PLLCPU( 64,  2,  1,   260000000U),
PLLCPU( 86,  1,  2,   261000000U),
PLLCPU( 10,  0,  0,   264000000U),
PLLCPU( 88,  1,  2,   267000000U),
PLLCPU( 66,  2,  1,   268000000U),
PLLCPU( 44,  0,  2,   270000000U),
PLLCPU( 33,  2,  0,   272000000U),
PLLCPU( 90,  1,  2,   273000000U),
PLLCPU( 22,  0,  1,   276000000U),
PLLCPU( 92,  1,  2,   279000000U),
PLLCPU( 34,  2,  0,   280000000U),
PLLCPU( 46,  0,  2,   282000000U),
PLLCPU( 70,  2,  1,   284000000U),
PLLCPU( 94,  1,  2,   285000000U),
PLLCPU( 11,  0,  0,   288000000U),
PLLCPU( 96,  1,  2,   291000000U),
PLLCPU( 72,  2,  1,   292000000U),
PLLCPU( 48,  0,  2,   294000000U),
PLLCPU( 36,  2,  0,   296000000U),
PLLCPU( 98,  1,  2,   297000000U),
PLLCPU( 24,  0,  1,   300000000U),
PLLCPU(100,  1,  2,   303000000U),
PLLCPU( 37,  2,  0,   304000000U),
PLLCPU( 50,  0,  2,   306000000U),
PLLCPU( 76,  2,  1,   308000000U),
PLLCPU(102,  1,  2,   309000000U),
PLLCPU( 12,  0,  0,   312000000U),
PLLCPU(104,  1,  2,   315000000U),
PLLCPU( 78,  2,  1,   316000000U),
PLLCPU( 52,  0,  2,   318000000U),
PLLCPU( 39,  2,  0,   320000000U),
PLLCPU(106,  1,  2,   321000000U),
PLLCPU( 26,  0,  1,   324000000U),
PLLCPU(108,  1,  2,   327000000U),
PLLCPU( 40,  2,  0,   328000000U),
PLLCPU( 54,  0,  2,   330000000U),
PLLCPU( 82,  2,  1,   332000000U),
PLLCPU(110,  1,  2,   333000000U),
PLLCPU( 13,  0,  0,   336000000U),
PLLCPU(112,  1,  2,   339000000U),
PLLCPU( 84,  2,  1,   340000000U),
PLLCPU( 56,  0,  2,   342000000U),
PLLCPU( 42,  2,  0,   344000000U),
PLLCPU(114,  1,  2,   345000000U),
PLLCPU( 28,  0,  1,   348000000U),
PLLCPU(116,  1,  2,   351000000U),
PLLCPU( 43,  2,  0,   352000000U),
PLLCPU( 58,  0,  2,   354000000U),
PLLCPU( 88,  2,  1,   356000000U),
PLLCPU(118,  1,  2,   357000000U),
PLLCPU( 14,  0,  0,   360000000U),
PLLCPU(120,  1,  2,   363000000U),
PLLCPU( 90,  2,  1,   364000000U),
PLLCPU( 60,  0,  2,   366000000U),
PLLCPU( 45,  2,  0,   368000000U),
PLLCPU(122,  1,  2,   369000000U),
PLLCPU( 30,  0,  1,   372000000U),
PLLCPU(124,  1,  2,   375000000U),
PLLCPU( 46,  2,  0,   376000000U),
PLLCPU( 62,  0,  2,   378000000U),
PLLCPU( 94,  2,  1,   380000000U),
PLLCPU(126,  1,  2,   381000000U),
PLLCPU( 15,  0,  0,   384000000U),
PLLCPU( 96,  2,  1,   388000000U),
PLLCPU( 64,  0,  2,   390000000U),
PLLCPU( 48,  2,  0,   392000000U),
PLLCPU( 32,  0,  1,   396000000U),
PLLCPU( 49,  2,  0,   400000000U),
PLLCPU( 66,  0,  2,   402000000U),
PLLCPU(100,  2,  1,   404000000U),
PLLCPU( 16,  0,  0,   408000000U),
PLLCPU(102,  2,  1,   412000000U),
PLLCPU( 68,  0,  2,   414000000U),
PLLCPU( 51,  2,  0,   416000000U),
PLLCPU( 34,  0,  1,   420000000U),
PLLCPU( 52,  2,  0,   424000000U),
PLLCPU( 70,  0,  2,   426000000U),
PLLCPU(106,  2,  1,   428000000U),
PLLCPU( 17,  0,  0,   432000000U),
PLLCPU(108,  2,  1,   436000000U),
PLLCPU( 72,  0,  2,   438000000U),
PLLCPU( 54,  2,  0,   440000000U),
PLLCPU( 36,  0,  1,   444000000U),
PLLCPU( 55,  2,  0,   448000000U),
PLLCPU( 74,  0,  2,   450000000U),
PLLCPU(112,  2,  1,   452000000U),
PLLCPU( 18,  0,  0,   456000000U),
PLLCPU(114,  2,  1,   460000000U),
PLLCPU( 76,  0,  2,   462000000U),
PLLCPU( 57,  2,  0,   464000000U),
PLLCPU( 38,  0,  1,   468000000U),
PLLCPU( 58,  2,  0,   472000000U),
PLLCPU( 78,  0,  2,   474000000U),
PLLCPU(118,  2,  1,   476000000U),
PLLCPU( 19,  0,  0,   480000000U),
PLLCPU(120,  2,  1,   484000000U),
PLLCPU( 80,  0,  2,   486000000U),
PLLCPU( 60,  2,  0,   488000000U),
PLLCPU( 40,  0,  1,   492000000U),
PLLCPU( 61,  2,  0,   496000000U),
PLLCPU( 82,  0,  2,   498000000U),
PLLCPU(124,  2,  1,   500000000U),
PLLCPU( 20,  0,  0,   504000000U),
PLLCPU(126,  2,  1,   508000000U),
PLLCPU( 84,  0,  2,   510000000U),
PLLCPU( 63,  2,  0,   512000000U),
PLLCPU( 42,  0,  1,   516000000U),
PLLCPU( 64,  2,  0,   520000000U),
PLLCPU( 86,  0,  2,   522000000U),
PLLCPU( 21,  0,  0,   528000000U),
PLLCPU( 88,  0,  2,   534000000U),
PLLCPU( 66,  2,  0,   536000000U),
PLLCPU( 44,  0,  1,   540000000U),
PLLCPU( 67,  2,  0,   544000000U),
PLLCPU( 90,  0,  2,   546000000U),
PLLCPU( 22,  0,  0,   552000000U),
PLLCPU( 92,  0,  2,   558000000U),
PLLCPU( 69,  2,  0,   560000000U),
PLLCPU( 46,  0,  1,   564000000U),
PLLCPU( 70,  2,  0,   568000000U),
PLLCPU( 94,  0,  2,   570000000U),
PLLCPU( 23,  0,  0,   576000000U),
PLLCPU( 96,  0,  2,   582000000U),
PLLCPU( 72,  2,  0,   584000000U),
PLLCPU( 48,  0,  1,   588000000U),
PLLCPU( 73,  2,  0,   592000000U),
PLLCPU( 98,  0,  2,   594000000U),
PLLCPU( 24,  0,  0,   600000000U),
PLLCPU(100,  0,  2,   606000000U),
PLLCPU( 75,  2,  0,   608000000U),
PLLCPU( 50,  0,  1,   612000000U),
PLLCPU( 76,  2,  0,   616000000U),
PLLCPU(102,  0,  2,   618000000U),
PLLCPU( 25,  0,  0,   624000000U),
PLLCPU(104,  0,  2,   630000000U),
PLLCPU( 78,  2,  0,   632000000U),
PLLCPU( 52,  0,  1,   636000000U),
PLLCPU( 79,  2,  0,   640000000U),
PLLCPU(106,  0,  2,   642000000U),
PLLCPU( 26,  0,  0,   648000000U),
PLLCPU(108,  0,  2,   654000000U),
PLLCPU( 81,  2,  0,   656000000U),
PLLCPU( 54,  0,  1,   660000000U),
PLLCPU( 82,  2,  0,   664000000U),
PLLCPU(110,  0,  2,   666000000U),
PLLCPU( 27,  0,  0,   672000000U),
PLLCPU(112,  0,  2,   678000000U),
PLLCPU( 84,  2,  0,   680000000U),
PLLCPU( 56,  0,  1,   684000000U),
PLLCPU( 85,  2,  0,   688000000U),
PLLCPU(114,  0,  2,   690000000U),
PLLCPU( 28,  0,  0,   696000000U),
PLLCPU(116,  0,  2,   702000000U),
PLLCPU( 87,  2,  0,   704000000U),
PLLCPU( 58,  0,  1,   708000000U),
PLLCPU( 88,  2,  0,   712000000U),
PLLCPU(118,  0,  2,   714000000U),
PLLCPU( 29,  0,  0,   720000000U),
PLLCPU(120,  0,  2,   726000000U),
PLLCPU( 90,  2,  0,   728000000U),
PLLCPU( 60,  0,  1,   732000000U),
PLLCPU( 91,  2,  0,   736000000U),
PLLCPU(122,  0,  2,   738000000U),
PLLCPU( 30,  0,  0,   744000000U),
PLLCPU(124,  0,  2,   750000000U),
PLLCPU( 93,  2,  0,   752000000U),
PLLCPU( 62,  0,  1,   756000000U),
PLLCPU( 94,  2,  0,   760000000U),
PLLCPU(126,  0,  2,   762000000U),
PLLCPU( 31,  0,  0,   768000000U),
PLLCPU( 96,  2,  0,   776000000U),
PLLCPU( 64,  0,  1,   780000000U),
PLLCPU( 97,  2,  0,   784000000U),
PLLCPU( 32,  0,  0,   792000000U),
PLLCPU( 99,  2,  0,   800000000U),
PLLCPU( 66,  0,  1,   804000000U),
PLLCPU(100,  2,  0,   808000000U),
PLLCPU( 33,  0,  0,   816000000U),
PLLCPU(102,  2,  0,   824000000U),
PLLCPU( 68,  0,  1,   828000000U),
PLLCPU(103,  2,  0,   832000000U),
PLLCPU( 34,  0,  0,   840000000U),
PLLCPU(105,  2,  0,   848000000U),
PLLCPU( 70,  0,  1,   852000000U),
PLLCPU(106,  2,  0,   856000000U),
PLLCPU( 35,  0,  0,   864000000U),
PLLCPU(108,  2,  0,   872000000U),
PLLCPU( 72,  0,  1,   876000000U),
PLLCPU(109,  2,  0,   880000000U),
PLLCPU( 36,  0,  0,   888000000U),
PLLCPU(111,  2,  0,   896000000U),
PLLCPU( 74,  0,  1,   900000000U),
PLLCPU(112,  2,  0,   904000000U),
PLLCPU( 37,  0,  0,   912000000U),
PLLCPU(114,  2,  0,   920000000U),
PLLCPU( 76,  0,  1,   924000000U),
PLLCPU(115,  2,  0,   928000000U),
PLLCPU( 38,  0,  0,   936000000U),
PLLCPU(117,  2,  0,   944000000U),
PLLCPU( 78,  0,  1,   948000000U),
PLLCPU(118,  2,  0,   952000000U),
PLLCPU( 39,  0,  0,   960000000U),
PLLCPU(120,  2,  0,   968000000U),
PLLCPU( 80,  0,  1,   972000000U),
PLLCPU(121,  2,  0,   976000000U),
PLLCPU( 40,  0,  0,   984000000U),
PLLCPU(123,  2,  0,   992000000U),
PLLCPU( 82,  0,  1,   996000000U),
PLLCPU(124,  2,  0,  1000000000U),
PLLCPU( 41,  0,  0,  1008000000U),
PLLCPU(126,  2,  0,  1016000000U),
PLLCPU( 84,  0,  1,  1020000000U),
PLLCPU(127,  2,  0,  1024000000U),
PLLCPU( 42,  0,  0,  1032000000U),
PLLCPU( 86,  0,  1,  1044000000U),
PLLCPU( 43,  0,  0,  1056000000U),
PLLCPU( 88,  0,  1,  1068000000U),
PLLCPU( 44,  0,  0,  1080000000U),
PLLCPU( 90,  0,  1,  1092000000U),
PLLCPU( 45,  0,  0,  1104000000U),
PLLCPU( 92,  0,  1,  1116000000U),
PLLCPU( 46,  0,  0,  1128000000U),
PLLCPU( 94,  0,  1,  1140000000U),
PLLCPU( 47,  0,  0,  1152000000U),
PLLCPU( 96,  0,  1,  1164000000U),
PLLCPU( 48,  0,  0,  1176000000U),
PLLCPU( 98,  0,  1,  1188000000U),
PLLCPU( 49,  0,  0,  1200000000U),
PLLCPU(100,  0,  1,  1212000000U),
PLLCPU( 50,  0,  0,  1224000000U),
PLLCPU(102,  0,  1,  1236000000U),
PLLCPU( 51,  0,  0,  1248000000U),
PLLCPU(104,  0,  1,  1260000000U),
PLLCPU( 52,  0,  0,  1272000000U),
PLLCPU(106,  0,  1,  1284000000U),
PLLCPU( 53,  0,  0,  1296000000U),
PLLCPU(108,  0,  1,  1308000000U),
PLLCPU( 54,  0,  0,  1320000000U),
PLLCPU(110,  0,  1,  1332000000U),
PLLCPU( 55,  0,  0,  1344000000U),
PLLCPU(112,  0,  1,  1356000000U),
PLLCPU( 56,  0,  0,  1368000000U),
PLLCPU(114,  0,  1,  1380000000U),
PLLCPU( 57,  0,  0,  1392000000U),
PLLCPU(116,  0,  1,  1404000000U),
PLLCPU( 58,  0,  0,  1416000000U),
PLLCPU(118,  0,  1,  1428000000U),
PLLCPU( 59,  0,  0,  1440000000U),
PLLCPU(120,  0,  1,  1452000000U),
PLLCPU( 60,  0,  0,  1464000000U),
PLLCPU(122,  0,  1,  1476000000U),
PLLCPU( 61,  0,  0,  1488000000U),
PLLCPU(124,  0,  1,  1500000000U),
PLLCPU( 62,  0,  0,  1512000000U),
PLLCPU(126,  0,  1,  1524000000U),
PLLCPU( 63,  0,  0,  1536000000U),
PLLCPU( 64,  0,  0,  1560000000U),
PLLCPU( 65,  0,  0,  1584000000U),
PLLCPU( 66,  0,  0,  1608000000U),
PLLCPU( 67,  0,  0,  1632000000U),
PLLCPU( 68,  0,  0,  1656000000U),
PLLCPU( 69,  0,  0,  1680000000U),
PLLCPU( 70,  0,  0,  1704000000U),
PLLCPU( 71,  0,  0,  1728000000U),
PLLCPU( 72,  0,  0,  1752000000U),
PLLCPU( 73,  0,  0,  1776000000U),
PLLCPU( 74,  0,  0,  1800000000U),
PLLCPU( 75,  0,  0,  1824000000U),
PLLCPU( 76,  0,  0,  1848000000U),
PLLCPU( 77,  0,  0,  1872000000U),
PLLCPU( 78,  0,  0,  1896000000U),
};
//n,m,freq
struct sunxi_clk_factor_freq factor_pllvideo_tbl[] = {
PLLVIDEO(4 ,0, 120000000U),
PLLVIDEO(10 ,1, 132000000U),
PLLVIDEO(5 ,0, 144000000U),
PLLVIDEO(24 ,3, 150000000U),
PLLVIDEO(18 ,2, 152000000U),
PLLVIDEO(12 ,1, 156000000U),
PLLVIDEO(19 ,2, 160000000U),
PLLVIDEO(26 ,3, 162000000U),
PLLVIDEO(6 ,0, 168000000U),
PLLVIDEO(28 ,3, 174000000U),
PLLVIDEO(21 ,2, 176000000U),
PLLVIDEO(14 ,1, 180000000U),
PLLVIDEO(60 ,7, 183000000U),
PLLVIDEO(22 ,2, 184000000U),
PLLVIDEO(30 ,3, 186000000U),
PLLVIDEO(62 ,7, 189000000U),
PLLVIDEO(31 ,3, 192000000U),
PLLVIDEO(64 ,7, 195000000U),
PLLVIDEO(32 ,3, 198000000U),
PLLVIDEO(24 ,2, 200000000U),
PLLVIDEO(66 ,7, 201000000U),
PLLVIDEO(16 ,1, 204000000U),
PLLVIDEO(68 ,7, 207000000U),
PLLVIDEO(25 ,2, 208000000U),
PLLVIDEO(34 ,3, 210000000U),
PLLVIDEO(70 ,7, 213000000U),
PLLVIDEO(35 ,3, 216000000U),
PLLVIDEO(72 ,7, 219000000U),
PLLVIDEO(36 ,3, 222000000U),
PLLVIDEO(27 ,2, 224000000U),
PLLVIDEO(74 ,7, 225000000U),
PLLVIDEO(18 ,1, 228000000U),
PLLVIDEO(76 ,7, 231000000U),
PLLVIDEO(28 ,2, 232000000U),
PLLVIDEO(38 ,3, 234000000U),
PLLVIDEO(78 ,7, 237000000U),
PLLVIDEO(9 ,0, 240000000U),
PLLVIDEO(80 ,7, 243000000U),
PLLVIDEO(40 ,3, 246000000U),
PLLVIDEO(30 ,2, 248000000U),
PLLVIDEO(82 ,7, 249000000U),
PLLVIDEO(20 ,1, 252000000U),
PLLVIDEO(84 ,7, 255000000U),
PLLVIDEO(31 ,2, 256000000U),
PLLVIDEO(42 ,3, 258000000U),
PLLVIDEO(86 ,7, 261000000U),
PLLVIDEO(10 ,0, 264000000U),
PLLVIDEO(88 ,7, 267000000U),
PLLVIDEO(44 ,3, 270000000U),
PLLVIDEO(33 ,2, 272000000U),
PLLVIDEO(90 ,7, 273000000U),
PLLVIDEO(22 ,1, 276000000U),
PLLVIDEO(92 ,7, 279000000U),
PLLVIDEO(34 ,2, 280000000U),
PLLVIDEO(46 ,3, 282000000U),
PLLVIDEO(94 ,7, 285000000U),
PLLVIDEO(11 ,0, 288000000U),
PLLVIDEO(96 ,7, 291000000U),
PLLVIDEO(48 ,3, 294000000U),
PLLVIDEO(36 ,2, 296000000U),
PLLVIDEO(98 ,7, 297000000U),
PLLVIDEO(24 ,1, 300000000U),
PLLVIDEO(100 ,7, 303000000U),
PLLVIDEO(37 ,2, 304000000U),
PLLVIDEO(50 ,3, 306000000U),
PLLVIDEO(102 ,7, 309000000U),
PLLVIDEO(12 ,0, 312000000U),
PLLVIDEO(104 ,7, 315000000U),
PLLVIDEO(52 ,3, 318000000U),
PLLVIDEO(39 ,2, 320000000U),
PLLVIDEO(106 ,7, 321000000U),
PLLVIDEO(26 ,1, 324000000U),
PLLVIDEO(108 ,7, 327000000U),
PLLVIDEO(40 ,2, 328000000U),
PLLVIDEO(54 ,3, 330000000U),
PLLVIDEO(110 ,7, 333000000U),
PLLVIDEO(13 ,0, 336000000U),
PLLVIDEO(112 ,7, 339000000U),
PLLVIDEO(56 ,3, 342000000U),
PLLVIDEO(114 ,7, 345000000U),
PLLVIDEO(28 ,1, 348000000U),
PLLVIDEO(116 ,7, 351000000U),
PLLVIDEO(58 ,3, 354000000U),
PLLVIDEO(118 ,7, 357000000U),
PLLVIDEO(14 ,0, 360000000U),
PLLVIDEO(120 ,7, 363000000U),
PLLVIDEO(60 ,3, 366000000U),
PLLVIDEO(122 ,7, 369000000U),
PLLVIDEO(30 ,1, 372000000U),
PLLVIDEO(124 ,7, 375000000U),
PLLVIDEO(62 ,3, 378000000U),
PLLVIDEO(126 ,7, 381000000U),
PLLVIDEO(15 ,0, 384000000U),
PLLVIDEO(64 ,3, 390000000U),
PLLVIDEO(32 ,1, 396000000U),
PLLVIDEO(66 ,3, 402000000U),
PLLVIDEO(16 ,0, 408000000U),
PLLVIDEO(68 ,3, 414000000U),
PLLVIDEO(34 ,1, 420000000U),
PLLVIDEO(70 ,3, 426000000U),
PLLVIDEO(17 ,0, 432000000U),
PLLVIDEO(72 ,3, 438000000U),
PLLVIDEO(36 ,1, 444000000U),
PLLVIDEO(74 ,3, 450000000U),
PLLVIDEO(18 ,0, 456000000U),
PLLVIDEO(75 ,3, 456000000U),
PLLVIDEO(76 ,3, 462000000U),
PLLVIDEO(38 ,1, 468000000U),
PLLVIDEO(78 ,3, 474000000U),
PLLVIDEO(19 ,0, 480000000U),
PLLVIDEO(80 ,3, 486000000U),
PLLVIDEO(40 ,1, 492000000U),
PLLVIDEO(82 ,3, 498000000U),
PLLVIDEO(20 ,0, 504000000U),
PLLVIDEO(84 ,3, 510000000U),
PLLVIDEO(85 ,3, 516000000U),
PLLVIDEO(86 ,3, 522000000U),
PLLVIDEO(21 ,0, 528000000U),
PLLVIDEO(88 ,3, 534000000U),
PLLVIDEO(89 ,3, 540000000U),
PLLVIDEO(90 ,3, 546000000U),
PLLVIDEO(22 ,0, 552000000U),
PLLVIDEO(92 ,3, 558000000U),
PLLVIDEO(93 ,3, 564000000U),
PLLVIDEO(94 ,3, 570000000U),
PLLVIDEO(23 ,0, 576000000U),
PLLVIDEO(96 ,3, 582000000U),
PLLVIDEO(97 ,3, 588000000U),
PLLVIDEO(98 ,3, 594000000U),
PLLVIDEO(24 ,0, 600000000U),
PLLVIDEO(100 ,3, 606000000U),
PLLVIDEO(101 ,3, 612000000U),
PLLVIDEO(102 ,3, 618000000U),
PLLVIDEO(25 ,0, 624000000U),
PLLVIDEO(104 ,3, 630000000U),
PLLVIDEO(105 ,3, 636000000U),
PLLVIDEO(106 ,3, 642000000U),
PLLVIDEO(26 ,0, 648000000U),
PLLVIDEO(108 ,3, 654000000U),
PLLVIDEO(109 ,3, 660000000U),
PLLVIDEO(110 ,3, 666000000U),
PLLVIDEO(27 ,0, 672000000U),
PLLVIDEO(112 ,3, 678000000U),
PLLVIDEO(113 ,3, 684000000U),
PLLVIDEO(114 ,3, 690000000U),
PLLVIDEO(28 ,0, 696000000U),
PLLVIDEO(116 ,3, 702000000U),
PLLVIDEO(117 ,3, 708000000U),
PLLVIDEO(118 ,3, 714000000U),
PLLVIDEO(29 ,0, 720000000U),
PLLVIDEO(120 ,3, 726000000U),
PLLVIDEO(121 ,3, 732000000U),
PLLVIDEO(122 ,3, 738000000U),
PLLVIDEO(30 ,0, 744000000U),
PLLVIDEO(124 ,3, 750000000U),
PLLVIDEO(125 ,3, 756000000U),
PLLVIDEO(126 ,3, 762000000U),
PLLVIDEO(31 ,0, 768000000U),
PLLVIDEO(32 ,0, 792000000U),
PLLVIDEO(33 ,0, 816000000U),
PLLVIDEO(34 ,0, 840000000U),
PLLVIDEO(35 ,0, 864000000U),
PLLVIDEO(36 ,0, 888000000U),
};
//n,m,freq
struct sunxi_clk_factor_freq factor_pllve_tbl[] = {
PLLVE(4,0, 120000000U),
PLLVE(10,1, 132000000U),
PLLVE(22,3, 138000000U),
PLLVE(11,1, 144000000U),
PLLVE(24,3, 150000000U),
PLLVE(18,2, 152000000U),
PLLVE(12,1, 156000000U),
PLLVE(19,2, 160000000U),
PLLVE(26,3, 162000000U),
PLLVE(13,1, 168000000U),
PLLVE(56,7, 171000000U),
PLLVE(57,7, 174000000U),
PLLVE(21,2, 176000000U),
PLLVE(58,7, 177000000U),
PLLVE(14,1, 180000000U),
PLLVE(60,7, 183000000U),
PLLVE(22,2, 184000000U),
PLLVE(30,3, 186000000U),
PLLVE(62,7, 189000000U),
PLLVE(15,1, 192000000U),
PLLVE(64,7, 195000000U),
PLLVE(32,3, 198000000U),
PLLVE(24,2, 200000000U),
PLLVE(66,7, 201000000U),
PLLVE(16,1, 204000000U),
PLLVE(68,7, 207000000U),
PLLVE(25,2, 208000000U),
PLLVE(34,3, 210000000U),
PLLVE(70,7, 213000000U),
PLLVE(17,1, 216000000U),
PLLVE(72,7, 219000000U),
PLLVE(36,3, 222000000U),
PLLVE(27,2, 224000000U),
PLLVE(74,7, 225000000U),
PLLVE(37,3, 228000000U),
PLLVE(76,7, 231000000U),
PLLVE(28,2, 232000000U),
PLLVE(38,3, 234000000U),
PLLVE(78,7, 237000000U),
PLLVE(39,3, 240000000U),
PLLVE(80,7, 243000000U),
PLLVE(81,7, 246000000U),
PLLVE(30,2, 248000000U),
PLLVE(82,7, 249000000U),
PLLVE(20,1, 252000000U),
PLLVE(84,7, 255000000U),
PLLVE(31,2, 256000000U),
PLLVE(85,7, 258000000U),
PLLVE(86,7, 261000000U),
PLLVE(43,3, 264000000U),
PLLVE(88,7, 267000000U),
PLLVE(44,3, 270000000U),
PLLVE(33,2, 272000000U),
PLLVE(90,7, 273000000U),
PLLVE(45,3, 276000000U),
PLLVE(92,7, 279000000U),
PLLVE(34,2, 280000000U),
PLLVE(46,3, 282000000U),
PLLVE(94,7, 285000000U),
PLLVE(95,7, 288000000U),
PLLVE(96,7, 291000000U),
PLLVE(97,7, 294000000U),
PLLVE(36,2, 296000000U),
PLLVE(98,7, 297000000U),
PLLVE(99,7, 300000000U),
PLLVE(100,7, 303000000U),
PLLVE(37,2, 304000000U),
PLLVE(50,3, 306000000U),
PLLVE(102,7, 309000000U),
PLLVE(25,1, 312000000U),
PLLVE(104,7, 315000000U),
PLLVE(52,3, 318000000U),
PLLVE(39,2, 320000000U),
PLLVE(106,7, 321000000U),
PLLVE(26,1, 324000000U),
PLLVE(108,7, 327000000U),
PLLVE(40,2, 328000000U),
PLLVE(54,3, 330000000U),
PLLVE(110,7, 333000000U),
PLLVE(55,3, 336000000U),
PLLVE(112,7, 339000000U),
PLLVE(56,3, 342000000U),
PLLVE(114,7, 345000000U),
PLLVE(57,3, 348000000U),
PLLVE(116,7, 351000000U),
PLLVE(58,3, 354000000U),
PLLVE(118,7, 357000000U),
PLLVE(59,3, 360000000U),
PLLVE(120,7, 363000000U),
PLLVE(121,7, 366000000U),
PLLVE(122,7, 369000000U),
PLLVE(61,3, 372000000U),
PLLVE(124,7, 375000000U),
PLLVE(62,3, 378000000U),
PLLVE(126,7, 381000000U),
PLLVE(63,3, 384000000U),
PLLVE(64,3, 390000000U),
PLLVE(65,3, 396000000U),
PLLVE(66,3, 402000000U),
PLLVE(67,3, 408000000U),
PLLVE(68,3, 414000000U),
PLLVE(69,3, 420000000U),
PLLVE(70,3, 426000000U),
PLLVE(71,3, 432000000U),
PLLVE(72,3, 438000000U),
PLLVE(73,3, 444000000U),
PLLVE(74,3, 450000000U),
PLLVE(75,3, 456000000U),
PLLVE(76,3, 462000000U),
PLLVE(77,3, 468000000U),
PLLVE(78,3, 474000000U),
PLLVE(79,3, 480000000U),
PLLVE(80,3, 486000000U),
PLLVE(81,3, 492000000U),
PLLVE(82,3, 498000000U),
PLLVE(83,3, 504000000U),
PLLVE(84,3, 510000000U),
PLLVE(85,3, 516000000U),
PLLVE(86,3, 522000000U),
PLLVE(87,3, 528000000U),
PLLVE(88,3, 534000000U),
PLLVE(89,3, 540000000U),
PLLVE(90,3, 546000000U),
PLLVE(91,3, 552000000U),
PLLVE(92,3, 558000000U),
PLLVE(93,3, 564000000U),
PLLVE(94,3, 570000000U),
PLLVE(95,3, 576000000U),
PLLVE(96,3, 582000000U),
PLLVE(97,3, 588000000U),
PLLVE(98,3, 594000000U),
PLLVE(99,3, 600000000U),
PLLVE(100,3, 606000000U),
PLLVE(101,3, 612000000U),
PLLVE(102,3, 618000000U),
PLLVE(103,3, 624000000U),
PLLVE(104,3, 630000000U),
PLLVE(105,3, 636000000U),
PLLVE(106,3, 642000000U),
PLLVE(107,3, 648000000U),
PLLVE(108,3, 654000000U),
PLLVE(109,3, 660000000U),
PLLVE(110,3, 666000000U),
PLLVE(111,3, 672000000U),
PLLVE(112,3, 678000000U),
PLLVE(113,3, 684000000U),
PLLVE(114,3, 690000000U),
PLLVE(115,3, 696000000U),
PLLVE(116,3, 702000000U),
PLLVE(117,3, 708000000U),
PLLVE(118,3, 714000000U),
PLLVE(119,3, 720000000U),
PLLVE(120,3, 726000000U),
PLLVE(121,3, 732000000U),
PLLVE(122,3, 738000000U),
PLLVE(123,3, 744000000U),
PLLVE(124,3, 750000000U),
PLLVE(125,3, 756000000U),
PLLVE(126,3, 762000000U),
PLLVE(127,3, 768000000U),
PLLVE(32,0, 792000000U),
PLLVE(33,0, 816000000U),
PLLVE(34,0, 840000000U),
PLLVE(35,0, 864000000U),
PLLVE(36,0, 888000000U),
};
//#define PLLDDR0(n,k,m,freq)  {F_N8X5_K4X2_M0X2( n, k, m),  freq}
struct sunxi_clk_factor_freq factor_pllddr0_tbl[] = {
PLLDDR0( 24,  0,  2,   200000000U),
PLLDDR0( 16,  0,  1,   204000000U),
PLLDDR0( 12,  1,  2,   208000000U),
PLLDDR0(  2,  2,  0,   216000000U),
PLLDDR0(  6,  3,  2,   224000000U),
PLLDDR0( 18,  0,  1,   228000000U),
PLLDDR0( 28,  0,  2,   232000000U),
PLLDDR0( 12,  2,  3,   234000000U),
PLLDDR0(  4,  1,  0,   240000000U),
PLLDDR0( 30,  0,  2,   248000000U),
PLLDDR0(  6,  2,  1,   252000000U),
PLLDDR0(  7,  3,  2,   256000000U),
PLLDDR0( 10,  0,  0,   264000000U),
PLLDDR0( 14,  2,  3,   270000000U),
PLLDDR0( 16,  1,  2,   272000000U),
PLLDDR0( 22,  0,  1,   276000000U),
PLLDDR0(  2,  3,  0,   288000000U),
PLLDDR0( 24,  0,  1,   300000000U),
PLLDDR0( 18,  1,  2,   304000000U),
PLLDDR0( 16,  2,  3,   306000000U),
PLLDDR0( 12,  0,  0,   312000000U),
PLLDDR0(  9,  3,  2,   320000000U),
PLLDDR0(  8,  2,  1,   324000000U),
PLLDDR0(  6,  1,  0,   336000000U),
PLLDDR0( 18,  2,  3,   342000000U),
PLLDDR0( 28,  0,  1,   348000000U),
PLLDDR0( 10,  3,  2,   352000000U),
PLLDDR0(  4,  2,  0,   360000000U),
PLLDDR0( 22,  1,  2,   368000000U),
PLLDDR0( 30,  0,  1,   372000000U),
PLLDDR0( 20,  2,  3,   378000000U),
PLLDDR0(  3,  3,  0,   384000000U),
PLLDDR0( 10,  2,  1,   396000000U),
PLLDDR0( 24,  1,  2,   400000000U),
PLLDDR0( 16,  0,  0,   408000000U),
PLLDDR0( 22,  2,  3,   414000000U),
PLLDDR0( 12,  3,  2,   416000000U),
PLLDDR0(  5,  2,  0,   432000000U),
PLLDDR0( 13,  3,  2,   448000000U),
PLLDDR0( 24,  2,  3,   450000000U),
PLLDDR0( 18,  0,  0,   456000000U),
PLLDDR0( 28,  1,  2,   464000000U),
PLLDDR0( 12,  2,  1,   468000000U),
PLLDDR0(  4,  3,  0,   480000000U),
PLLDDR0( 26,  2,  3,   486000000U),
PLLDDR0( 30,  1,  2,   496000000U),
PLLDDR0(  6,  2,  0,   504000000U),
PLLDDR0( 15,  3,  2,   512000000U),
PLLDDR0( 28,  2,  3,   522000000U),
PLLDDR0( 10,  1,  0,   528000000U),
PLLDDR0( 14,  2,  1,   540000000U),
PLLDDR0( 16,  3,  2,   544000000U),
PLLDDR0( 22,  0,  0,   552000000U),
PLLDDR0( 30,  2,  3,   558000000U),
PLLDDR0(  5,  3,  0,   576000000U),
PLLDDR0( 24,  0,  0,   600000000U),
};
//#define PLLDDR1(n,m,freq) {F_N8X7_M0X2(n , m),  freq}
struct sunxi_clk_factor_freq factor_pllddr1_tbl[] = {
PLLDDR1( 24,  2,   200000000U),
PLLDDR1( 16,  1,   204000000U),
PLLDDR1( 25,  2,   208000000U),
PLLDDR1( 34,  3,   210000000U),
PLLDDR1(  8,  0,   216000000U),
PLLDDR1( 36,  3,   222000000U),
PLLDDR1( 27,  2,   224000000U),
PLLDDR1( 18,  1,   228000000U),
PLLDDR1( 28,  2,   232000000U),
PLLDDR1( 38,  3,   234000000U),
PLLDDR1(  9,  0,   240000000U),
PLLDDR1( 40,  3,   246000000U),
PLLDDR1( 30,  2,   248000000U),
PLLDDR1( 20,  1,   252000000U),
PLLDDR1( 31,  2,   256000000U),
PLLDDR1( 42,  3,   258000000U),
PLLDDR1( 10,  0,   264000000U),
PLLDDR1( 44,  3,   270000000U),
PLLDDR1( 33,  2,   272000000U),
PLLDDR1( 22,  1,   276000000U),
PLLDDR1( 34,  2,   280000000U),
PLLDDR1( 46,  3,   282000000U),
PLLDDR1( 11,  0,   288000000U),
PLLDDR1( 48,  3,   294000000U),
PLLDDR1( 36,  2,   296000000U),
PLLDDR1( 24,  1,   300000000U),
PLLDDR1( 37,  2,   304000000U),
PLLDDR1( 50,  3,   306000000U),
PLLDDR1( 12,  0,   312000000U),
PLLDDR1( 52,  3,   318000000U),
PLLDDR1( 39,  2,   320000000U),
PLLDDR1( 26,  1,   324000000U),
PLLDDR1( 40,  2,   328000000U),
PLLDDR1( 54,  3,   330000000U),
PLLDDR1( 13,  0,   336000000U),
PLLDDR1( 56,  3,   342000000U),
PLLDDR1( 42,  2,   344000000U),
PLLDDR1( 28,  1,   348000000U),
PLLDDR1( 43,  2,   352000000U),
PLLDDR1( 58,  3,   354000000U),
PLLDDR1( 14,  0,   360000000U),
PLLDDR1( 60,  3,   366000000U),
PLLDDR1( 45,  2,   368000000U),
PLLDDR1( 30,  1,   372000000U),
PLLDDR1( 46,  2,   376000000U),
PLLDDR1( 62,  3,   378000000U),
PLLDDR1( 15,  0,   384000000U),
PLLDDR1( 64,  3,   390000000U),
PLLDDR1( 48,  2,   392000000U),
PLLDDR1( 32,  1,   396000000U),
PLLDDR1( 49,  2,   400000000U),
PLLDDR1( 66,  3,   402000000U),
PLLDDR1( 16,  0,   408000000U),
PLLDDR1( 68,  3,   414000000U),
PLLDDR1( 51,  2,   416000000U),
PLLDDR1( 34,  1,   420000000U),
PLLDDR1( 52,  2,   424000000U),
PLLDDR1( 70,  3,   426000000U),
PLLDDR1( 17,  0,   432000000U),
PLLDDR1( 72,  3,   438000000U),
PLLDDR1( 54,  2,   440000000U),
PLLDDR1( 36,  1,   444000000U),
PLLDDR1( 55,  2,   448000000U),
PLLDDR1( 74,  3,   450000000U),
PLLDDR1( 18,  0,   456000000U),
PLLDDR1( 76,  3,   462000000U),
PLLDDR1( 57,  2,   464000000U),
PLLDDR1( 38,  1,   468000000U),
PLLDDR1( 58,  2,   472000000U),
PLLDDR1( 78,  3,   474000000U),
PLLDDR1( 19,  0,   480000000U),
PLLDDR1( 80,  3,   486000000U),
PLLDDR1( 60,  2,   488000000U),
PLLDDR1( 40,  1,   492000000U),
PLLDDR1( 61,  2,   496000000U),
PLLDDR1( 82,  3,   498000000U),
PLLDDR1( 20,  0,   504000000U),
PLLDDR1( 84,  3,   510000000U),
PLLDDR1( 63,  2,   512000000U),
PLLDDR1( 42,  1,   516000000U),
PLLDDR1( 64,  2,   520000000U),
PLLDDR1( 86,  3,   522000000U),
PLLDDR1( 21,  0,   528000000U),
PLLDDR1( 88,  3,   534000000U),
PLLDDR1( 66,  2,   536000000U),
PLLDDR1( 44,  1,   540000000U),
PLLDDR1( 67,  2,   544000000U),
PLLDDR1( 90,  3,   546000000U),
PLLDDR1( 22,  0,   552000000U),
PLLDDR1( 92,  3,   558000000U),
PLLDDR1( 69,  2,   560000000U),
PLLDDR1( 46,  1,   564000000U),
PLLDDR1( 70,  2,   568000000U),
PLLDDR1( 94,  3,   570000000U),
PLLDDR1( 23,  0,   576000000U),
PLLDDR1( 96,  3,   582000000U),
PLLDDR1( 72,  2,   584000000U),
PLLDDR1( 48,  1,   588000000U),
PLLDDR1( 73,  2,   592000000U),
PLLDDR1( 98,  3,   594000000U),
PLLDDR1( 24,  0,   600000000U),
};

//#define PLLPERIPH(n,k,freq)  {F_N8X5_K4X2( n, k),  freq}
struct sunxi_clk_factor_freq factor_pllperiph0_tbl[] = {
PLLPERIPH(  0,  1,    24000000U),
PLLPERIPH(  0,  2,    36000000U),
PLLPERIPH(  0,  3,    48000000U),
PLLPERIPH(  4,  0,    60000000U),
PLLPERIPH(  1,  2,    72000000U),
PLLPERIPH(  6,  0,    84000000U),
PLLPERIPH(  1,  3,    96000000U),
PLLPERIPH(  2,  2,   108000000U),
PLLPERIPH(  4,  1,   120000000U),
PLLPERIPH( 10,  0,   132000000U),
PLLPERIPH(  2,  3,   144000000U),
PLLPERIPH( 12,  0,   156000000U),
PLLPERIPH(  6,  1,   168000000U),
PLLPERIPH(  4,  2,   180000000U),
PLLPERIPH(  3,  3,   192000000U),
PLLPERIPH( 16,  0,   204000000U),
PLLPERIPH(  5,  2,   216000000U),
PLLPERIPH( 18,  0,   228000000U),
PLLPERIPH(  4,  3,   240000000U),
PLLPERIPH(  6,  2,   252000000U),
PLLPERIPH( 10,  1,   264000000U),
PLLPERIPH( 22,  0,   276000000U),
PLLPERIPH(  5,  3,   288000000U),
PLLPERIPH( 24,  0,   300000000U),
PLLPERIPH( 12,  1,   312000000U),
PLLPERIPH(  8,  2,   324000000U),
PLLPERIPH(  6,  3,   336000000U),
PLLPERIPH( 28,  0,   348000000U),
PLLPERIPH(  9,  2,   360000000U),
PLLPERIPH( 30,  0,   372000000U),
PLLPERIPH(  7,  3,   384000000U),
PLLPERIPH( 10,  2,   396000000U),
PLLPERIPH( 16,  1,   408000000U),
PLLPERIPH(  8,  3,   432000000U),
PLLPERIPH( 18,  1,   456000000U),
PLLPERIPH( 12,  2,   468000000U),
PLLPERIPH(  9,  3,   480000000U),
PLLPERIPH( 13,  2,   504000000U),
PLLPERIPH( 10,  3,   528000000U),
PLLPERIPH( 14,  2,   540000000U),
PLLPERIPH( 22,  1,   552000000U),
PLLPERIPH( 11,  3,   576000000U),
PLLPERIPH( 24,  1,   600000000U),
PLLPERIPH( 16,  2,   612000000U),
PLLPERIPH( 12,  3,   624000000U),
PLLPERIPH( 17,  2,   648000000U),
PLLPERIPH( 13,  3,   672000000U),
PLLPERIPH( 18,  2,   684000000U),
PLLPERIPH( 28,  1,   696000000U),
PLLPERIPH( 14,  3,   720000000U),
PLLPERIPH( 30,  1,   744000000U),
PLLPERIPH( 20,  2,   756000000U),
PLLPERIPH( 15,  3,   768000000U),
PLLPERIPH( 21,  2,   792000000U),
PLLPERIPH( 16,  3,   816000000U),
PLLPERIPH( 22,  2,   828000000U),
PLLPERIPH( 17,  3,   864000000U),
PLLPERIPH( 24,  2,   900000000U),
PLLPERIPH( 18,  3,   912000000U),
PLLPERIPH( 25,  2,   936000000U),
PLLPERIPH( 19,  3,   960000000U),
PLLPERIPH( 26,  2,   972000000U),
PLLPERIPH( 20,  3,  1008000000U),
PLLPERIPH( 28,  2,  1044000000U),
PLLPERIPH( 21,  3,  1056000000U),
PLLPERIPH( 29,  2,  1080000000U),
PLLPERIPH( 22,  3,  1104000000U),
PLLPERIPH( 30,  2,  1116000000U),
PLLPERIPH( 23,  3,  1152000000U),
PLLPERIPH( 24,  3,  1200000000U),
PLLPERIPH( 25,  3,  1248000000U),
PLLPERIPH( 26,  3,  1296000000U),
PLLPERIPH( 27,  3,  1344000000U),
PLLPERIPH( 28,  3,  1392000000U),
PLLPERIPH( 29,  3,  1440000000U),
PLLPERIPH( 30,  3,  1488000000U),
PLLPERIPH( 31,  3,  1536000000U),
};
//n,k,freq
//#define PLLPERIPH(n,k,freq)  {F_N8X5_K4X2( n, k),  freq}
struct sunxi_clk_factor_freq factor_pllperiph1_tbl[] = {
PLLPERIPH(  0,  0,    24000000U),
PLLPERIPH(  0,  1,    48000000U),
PLLPERIPH(  0,  2,    72000000U),
PLLPERIPH(  0,  3,    96000000U),
PLLPERIPH(  4,  0,   120000000U),
PLLPERIPH(  1,  2,   144000000U),
PLLPERIPH(  6,  0,   168000000U),
PLLPERIPH(  1,  3,   192000000U),
PLLPERIPH(  2,  2,   216000000U),
PLLPERIPH(  4,  1,   240000000U),
PLLPERIPH( 10,  0,   264000000U),
PLLPERIPH(  2,  3,   288000000U),
PLLPERIPH( 12,  0,   312000000U),
PLLPERIPH(  6,  1,   336000000U),
PLLPERIPH(  4,  2,   360000000U),
PLLPERIPH(  3,  3,   384000000U),
PLLPERIPH( 16,  0,   408000000U),
PLLPERIPH(  5,  2,   432000000U),
PLLPERIPH( 18,  0,   456000000U),
PLLPERIPH(  4,  3,   480000000U),
PLLPERIPH(  6,  2,   504000000U),
PLLPERIPH( 10,  1,   528000000U),
PLLPERIPH( 22,  0,   552000000U),
PLLPERIPH(  5,  3,   576000000U),
PLLPERIPH( 24,  0,   600000000U),
PLLPERIPH( 12,  1,   624000000U),
PLLPERIPH(  8,  2,   648000000U),
PLLPERIPH(  6,  3,   672000000U),
PLLPERIPH( 28,  0,   696000000U),
PLLPERIPH(  9,  2,   720000000U),
PLLPERIPH( 30,  0,   744000000U),
PLLPERIPH(  7,  3,   768000000U),
PLLPERIPH( 10,  2,   792000000U),
PLLPERIPH( 16,  1,   816000000U),
PLLPERIPH(  8,  3,   864000000U),
PLLPERIPH( 18,  1,   912000000U),
PLLPERIPH( 12,  2,   936000000U),
PLLPERIPH(  9,  3,   960000000U),
PLLPERIPH( 13,  2,  1008000000U),
PLLPERIPH( 10,  3,  1056000000U),
PLLPERIPH( 14,  2,  1080000000U),
PLLPERIPH( 22,  1,  1104000000U),
PLLPERIPH( 11,  3,  1152000000U),
PLLPERIPH( 24,  1,  1200000000U),
PLLPERIPH( 16,  2,  1224000000U),
PLLPERIPH( 12,  3,  1248000000U),
PLLPERIPH( 17,  2,  1296000000U),
PLLPERIPH( 13,  3,  1344000000U),
PLLPERIPH( 18,  2,  1368000000U),
PLLPERIPH( 28,  1,  1392000000U),
PLLPERIPH( 14,  3,  1440000000U),
PLLPERIPH( 30,  1,  1488000000U),
PLLPERIPH( 20,  2,  1512000000U),
PLLPERIPH( 15,  3,  1536000000U),
PLLPERIPH( 21,  2,  1584000000U),
PLLPERIPH( 16,  3,  1632000000U),
PLLPERIPH( 22,  2,  1656000000U),
PLLPERIPH( 17,  3,  1728000000U),
PLLPERIPH( 24,  2,  1800000000U),
};

//#define PLL24M(n,k,n1,m , freq)    {F_N8X5_K4X2_1N16X5_M0X2(n,k,n1,m) , freq}
struct sunxi_clk_factor_freq factor_pll24m_tbl[] = {
PLL24M(  2,  3, 12,  0,    24000000U),
PLL24M( 24,  0, 26,  0,    24074074),
PLL24M( 20,  2, 16,  3,    24088235),
PLL24M( 15,  3, 22,  2,    24115941),
PLL24M( 31,  1, 22,  2,    24115942),
PLL24M( 12,  0, 13,  0,    24142857),
PLL24M( 30,  2, 24,  3,    24180000),
PLL24M(  8,  2, 28,  0,    24206896),
PLL24M(  6,  1, 14,  0,    24266666),
PLL24M( 28,  0, 30,  0,    24322580),
PLL24M(  4,  2, 15,  0,    24375000),
PLL24M( 18,  3, 26,  2,    24395061),
PLL24M( 30,  0, 10,  2,    24424242),
PLL24M(  3,  3, 16,  0,    24470588),
PLL24M( 16,  0, 17,  0,    24555555),
PLL24M( 28,  2, 22,  3,    24586956),
PLL24M( 21,  3, 30,  2,    24602150),
PLL24M(  5,  2, 18,  0,    24631578),
PLL24M( 18,  2, 19,  2,    24699999),
PLL24M( 18,  0, 19,  0,    24700000),
PLL24M(  4,  3, 20,  0,    24761904),
PLL24M(  6,  2, 21,  0,    24818181),
PLL24M( 10,  1, 22,  0,    24869565),
PLL24M( 22,  0, 23,  0,    24916666),
PLL24M(  5,  3, 24,  0,    24960000),
PLL24M( 24,  2, 25,  2,    24999999),
PLL24M( 24,  0, 25,  0,    25000000U),
PLL24M( 12,  1,  8,  2,    25037036),
PLL24M( 12,  1, 26,  0,    25037037),
PLL24M(  8,  2, 27,  0,    25071428),
PLL24M(  6,  3, 28,  0,    25103448),
PLL24M( 28,  0, 29,  0,    25133333),
PLL24M(  9,  2, 30,  0,    25161290),
PLL24M( 30,  2, 31,  2,    25187499),
PLL24M( 30,  0, 31,  0,    25187500),
PLL24M(  7,  3, 10,  2,    25212121),
PLL24M( 10,  2, 16,  1,    25235294),
PLL24M( 18,  1, 12,  2,    25333333),
PLL24M( 12,  2, 19,  1,    25350000),
PLL24M( 10,  3, 14,  2,    25422222),
PLL24M( 14,  2, 22,  1,    25434782),
PLL24M( 24,  1, 16,  2,    25490196),
PLL24M( 16,  2, 25,  1,    25500000),
PLL24M( 13,  3, 18,  2,    25543859),
PLL24M( 18,  2, 28,  1,    25551724),
PLL24M( 30,  1, 20,  2,    25587301),
PLL24M( 20,  2, 31,  1,    25593750),
PLL24M( 16,  3, 22,  2,    25623188),
PLL24M( 24,  2, 18,  3,    25657894),
PLL24M( 19,  3, 26,  2,    25679012),
PLL24M( 28,  2, 21,  3,    25704545),
PLL24M( 22,  3, 30,  2,    25720430),
PLL24M(  0,  2,  0,  2,    25999998),
PLL24M(  1,  2,  1,  2,    25999999),
PLL24M(  0,  0,  0,  0,    26000000U),
PLL24M( 30,  2, 22,  3,    26282608),
PLL24M( 21,  3, 28,  2,    26298850),
PLL24M( 26,  2, 19,  3,    26325000),
PLL24M( 18,  3, 24,  2,    26346666),
PLL24M( 22,  2, 16,  3,    26382352),
PLL24M( 15,  3, 20,  2,    26412698),
PLL24M( 20,  2, 30,  1,    26419354),
PLL24M( 28,  1, 18,  2,    26456140),
PLL24M( 18,  2, 27,  1,    26464285),
PLL24M( 12,  3, 16,  2,    26509803),
PLL24M( 16,  2, 24,  1,    26520000),
PLL24M( 22,  1, 14,  2,    26577777),
PLL24M( 14,  2, 21,  1,    26590909),
PLL24M(  9,  3, 12,  2,    26666666),
PLL24M( 12,  2, 18,  1,    26684210),
PLL24M( 16,  1, 10,  2,    26787878),
PLL24M( 10,  2, 31,  0,    26812500),
PLL24M(  7,  3, 30,  0,    26838709),
PLL24M( 30,  0, 29,  0,    26866666),
PLL24M(  9,  2, 28,  0,    26896551),
PLL24M( 28,  0, 27,  0,    26928571),
PLL24M(  6,  3, 26,  0,    26962962),
PLL24M(  8,  2, 25,  0,    27000000U),
PLL24M( 25,  2, 24,  2,    27039999),
PLL24M( 12,  1, 24,  0,    27040000),
PLL24M( 24,  0, 23,  0,    27083333),
PLL24M(  5,  3, 22,  0,    27130434),
PLL24M( 22,  0, 21,  0,    27181818),
PLL24M( 10,  1, 20,  0,    27238095),
PLL24M(  6,  2, 19,  0,    27300000),
PLL24M(  4,  3, 18,  0,    27368421),
PLL24M( 18,  0, 17,  0,    27444444),
PLL24M( 30,  2, 21,  3,    27477272),
PLL24M( 22,  3, 28,  2,    27494252),
PLL24M(  5,  2, 16,  0,    27529411),
PLL24M( 16,  2, 15,  2,    27624999),
PLL24M( 16,  0, 15,  0,    27625000),
PLL24M( 10,  2, 30,  0,    27677419),
PLL24M( 26,  2, 18,  3,    27710526),
PLL24M(  3,  3,  4,  2,    27733332),
PLL24M(  3,  3, 14,  0,    27733333),
PLL24M( 30,  0, 28,  0,    27793103),
PLL24M(  4,  2, 13,  0,    27857142),
PLL24M( 28,  0, 26,  0,    27925925),
PLL24M( 24,  3, 30,  2,    27956989),
PLL24M( 13,  2, 12,  2,    27999999),
PLL24M(  6,  1, 12,  0,    28000000U),
PLL24M( 22,  2, 31,  1,    28031250),
PLL24M( 16,  3, 20,  2,    28063492),
PLL24M(  8,  2, 24,  0,    28080000),
PLL24M( 12,  0, 11,  0,    28166666),
PLL24M( 20,  2, 28,  1,    28241379),
PLL24M( 21,  3, 26,  2,    28246913),
PLL24M( 24,  0, 22,  0,    28260869),
PLL24M( 28,  2, 19,  3,    28275000),
PLL24M( 30,  1, 18,  2,    28280701),
PLL24M(  2,  3, 10,  0,    28363636),
PLL24M( 22,  0, 20,  0,    28476190),
PLL24M( 18,  2, 25,  1,    28500000),
PLL24M( 16,  1, 30,  0,    28516129),
PLL24M( 13,  3, 16,  2,    28549019),
PLL24M( 10,  2,  9,  2,    28599999),
PLL24M( 10,  0,  9,  0,    28600000),
PLL24M( 18,  3, 22,  2,    28637681),
PLL24M( 24,  2, 16,  3,    28676470),
PLL24M(  7,  3, 28,  0,    28689655),
PLL24M(  6,  2, 18,  0,    28736842),
PLL24M( 30,  0, 27,  0,    28785714),
PLL24M( 16,  2, 22,  1,    28826086),
PLL24M(  4,  1,  8,  0,    28888888),
PLL24M( 22,  2, 30,  1,    28935483),
PLL24M( 28,  2, 25,  2,    28999999),
PLL24M( 28,  0, 25,  0,    29000000U),
PLL24M( 18,  0, 16,  0,    29058823),
PLL24M( 25,  3, 30,  2,    29075268),
PLL24M( 27,  2, 24,  2,    29119999),
PLL24M(  6,  3, 24,  0,    29120000),
PLL24M( 15,  3, 18,  2,    29192982),
PLL24M(  2,  2,  7,  0,    29250000),
PLL24M( 10,  3, 12,  2,    29333333),
PLL24M( 12,  1, 22,  0,    29391304),
PLL24M( 16,  0, 14,  0,    29466666),
PLL24M( 22,  3, 26,  2,    29530864),
PLL24M( 24,  0, 21,  0,    29545454),
PLL24M( 28,  1, 16,  2,    29568627),
PLL24M( 10,  2, 28,  0,    29586206),
PLL24M( 18,  2, 24,  1,    29640000),
PLL24M(  1,  3,  6,  0,    29714285),
PLL24M( 28,  2, 18,  3,    29763157),
PLL24M( 12,  2, 16,  1,    29823529),
PLL24M( 30,  0, 26,  0,    29851851),
PLL24M( 24,  3, 28,  2,    29885057),
PLL24M( 22,  2, 19,  2,    29899999),
PLL24M( 22,  0, 19,  0,    29900000),
PLL24M( 18,  1, 10,  2,    29939393),
PLL24M(  4,  2, 12,  0,    30000000U),
PLL24M( 12,  3, 14,  2,    30044444),
PLL24M( 10,  1, 18,  0,    30105263),
PLL24M( 16,  2, 21,  1,    30136363),
PLL24M( 19,  3, 22,  2,    30144927),
PLL24M( 28,  2, 24,  2,    30159999),
PLL24M( 28,  0, 24,  0,    30160000),
PLL24M(  8,  3, 30,  0,    30193548),
PLL24M( 30,  2, 19,  3,    30225000),
PLL24M(  6,  0,  5,  0,    30333333),
PLL24M( 24,  2, 31,  1,    30468750),
PLL24M( 16,  1, 28,  0,    30482758),
PLL24M( 21,  3, 24,  2,    30506666),
PLL24M(  8,  2, 22,  0,    30521739),
PLL24M(  4,  3, 16,  0,    30588235),
PLL24M( 10,  2, 27,  0,    30642857),
PLL24M( 22,  1, 12,  2,    30666666),
PLL24M( 12,  0, 10,  0,    30727272),
PLL24M( 14,  2, 18,  1,    30789473),
PLL24M(  7,  3, 26,  0,    30814814),
PLL24M( 18,  2, 15,  2,    30874999),
PLL24M( 18,  0, 15,  0,    30875000),
PLL24M( 22,  2, 28,  1,    30931034),
PLL24M( 24,  0, 20,  0,    30952380),
PLL24M( 26,  2, 16,  3,    30970588),
PLL24M( 30,  2, 25,  2,    30999999),
PLL24M( 30,  0, 25,  0,    31000000U),
PLL24M( 16,  3, 18,  2,    31017543),
PLL24M( 25,  3, 28,  2,    31080459),
PLL24M(  1,  2,  4,  0,    31200000),
PLL24M( 27,  3, 30,  2,    31311827),
PLL24M( 18,  3, 20,  2,    31365079),
PLL24M( 28,  0, 23,  0,    31416666),
PLL24M( 24,  2, 30,  1,    31451612),
PLL24M( 22,  0, 18,  0,    31473684),
PLL24M( 20,  2, 25,  1,    31500000),
PLL24M(  9,  3, 10,  2,    31515151),
PLL24M( 16,  0, 13,  0,    31571428),
PLL24M( 30,  1, 16,  2,    31607843),
PLL24M(  6,  3, 22,  0,    31652173),
PLL24M( 12,  2, 31,  0,    31687500),
PLL24M( 10,  0,  8,  0,    31777777),
PLL24M( 30,  2, 18,  3,    31815789),
PLL24M( 18,  1, 30,  0,    31870967),
PLL24M( 22,  3, 24,  2,    31893333),
PLL24M(  8,  2, 21,  0,    31909090),
PLL24M( 15,  2, 12,  2,    31999999),
PLL24M(  3,  3, 12,  0,    32000000U),
PLL24M( 22,  2, 27,  1,    32035714),
PLL24M( 24,  3, 26,  2,    32098765),
PLL24M(  6,  2, 16,  0,    32117647),
PLL24M( 12,  1, 20,  0,    32190476),
PLL24M( 18,  2, 22,  1,    32217391),
PLL24M( 30,  2, 24,  2,    32239999),
PLL24M( 30,  0, 24,  0,    32240000),
PLL24M(  8,  3, 28,  0,    32275862),
PLL24M( 13,  3, 14,  2,    32355555),
PLL24M( 28,  3, 30,  2,    32430107),
PLL24M(  4,  2,  3,  2,    32499999),
PLL24M(  4,  0,  3,  0,    32500000),
PLL24M( 15,  3, 16,  2,    32627450),
PLL24M( 12,  2, 30,  0,    32709677),
PLL24M( 16,  1, 26,  0,    32740740),
PLL24M( 20,  2, 24,  1,    32760000),
PLL24M( 28,  0, 22,  0,    32782608),
PLL24M(  5,  3, 18,  0,    32842105),
PLL24M( 26,  2, 31,  1,    32906250),
PLL24M( 18,  0, 14,  0,    32933333),
PLL24M( 10,  2, 25,  0,    33000000U),
PLL24M( 19,  3, 20,  2,    33015872),
PLL24M(  6,  1, 10,  0,    33090909),
PLL24M( 16,  2, 19,  1,    33150000),
PLL24M( 21,  3, 22,  2,    33159420),
PLL24M( 22,  0, 17,  0,    33222222),
PLL24M( 28,  2, 16,  3,    33264705),
PLL24M( 31,  2, 24,  2,    33279999),
PLL24M(  7,  3, 24,  0,    33280000),
PLL24M( 24,  1, 12,  2,    33333333),
PLL24M( 25,  3, 26,  2,    33382716),
PLL24M(  2,  2,  6,  0,    33428571),
PLL24M( 27,  3, 28,  2,    33471264),
PLL24M( 28,  1, 14,  2,    33511111),
PLL24M(  9,  3, 30,  0,    33548387),
PLL24M( 30,  0, 23,  0,    33583333),
PLL24M( 24,  2, 28,  1,    33620689),
PLL24M( 10,  1, 16,  0,    33647058),
PLL24M( 18,  2, 21,  1,    33681818),
PLL24M( 12,  2,  9,  2,    33799999),
PLL24M( 12,  0,  9,  0,    33800000),
PLL24M(  9,  2, 22,  0,    33913043),
PLL24M( 26,  2, 30,  1,    33967741),
PLL24M( 16,  2, 12,  2,    33999999),
PLL24M( 16,  0, 12,  0,    34000000U),
PLL24M( 18,  1, 28,  0,    34068965),
PLL24M(  6,  2, 15,  0,    34125000),
PLL24M( 24,  0, 18,  0,    34210526),
PLL24M( 28,  0, 21,  0,    34272727),
PLL24M( 10,  2, 24,  0,    34320000),
PLL24M( 14,  2, 16,  1,    34411764),
PLL24M( 22,  2, 25,  1,    34500000),
PLL24M(  0,  3,  0,  2,    34666664),
PLL24M(  0,  3,  2,  0,    34666666),
PLL24M( 24,  2, 27,  1,    34821428),
PLL24M( 16,  2, 18,  1,    34894736),
PLL24M( 12,  2, 28,  0,    34965517),
PLL24M( 30,  0, 22,  0,    35043478),
PLL24M(  8,  2, 19,  0,    35100000),
PLL24M( 22,  0, 16,  0,    35176470),
PLL24M( 13,  2, 30,  0,    35225806),
PLL24M( 18,  0, 13,  0,    35285714),
PLL24M( 28,  2, 31,  1,    35343750),
PLL24M( 16,  1, 24,  0,    35360000),
PLL24M(  4,  2, 10,  0,    35454545),
PLL24M( 30,  2, 16,  3,    35558823),
PLL24M( 12,  1, 18,  0,    35578947),
PLL24M( 20,  2, 22,  1,    35608695),
PLL24M( 10,  2,  7,  2,    35749999),
PLL24M( 10,  0,  7,  0,    35750000),
PLL24M( 31,  3, 30,  2,    35784946),
PLL24M( 30,  1, 14,  2,    35822222),
PLL24M(  9,  3, 28,  0,    35862068),
PLL24M( 22,  2, 24,  1,    35880000),
PLL24M( 28,  0, 20,  0,    35904761),
PLL24M( 27,  3, 26,  2,    35950617),
PLL24M(  5,  2, 12,  0,    36000000U),
PLL24M( 25,  3, 24,  2,    36053333),
PLL24M( 24,  0, 17,  0,    36111111),
PLL24M(  7,  3, 22,  0,    36173913),
PLL24M( 12,  2, 27,  0,    36214285),
PLL24M( 22,  1, 10,  2,    36242424),
PLL24M( 26,  2, 28,  1,    36310344),
PLL24M( 21,  3, 20,  2,    36317460),
PLL24M(  6,  2,  4,  2,    36399999),
PLL24M(  6,  0,  4,  0,    36400000),
PLL24M( 28,  2, 30,  1,    36483870),
PLL24M( 19,  3, 18,  2,    36491228),
PLL24M( 14,  2, 31,  0,    36562500),
PLL24M( 18,  1, 26,  0,    36592592),
PLL24M( 30,  0, 21,  0,    36636363),
PLL24M(  5,  3, 16,  0,    36705882),
PLL24M( 16,  0, 11,  0,    36833333),
PLL24M( 10,  3, 30,  0,    36903225),
PLL24M(  8,  2, 18,  0,    36947368),
PLL24M( 15,  3, 14,  2,    36977777),
PLL24M( 18,  2, 19,  1,    37050000),
PLL24M( 30,  3, 28,  2,    37057471),
PLL24M(  9,  2,  6,  2,    37142856),
PLL24M(  4,  1,  6,  0,    37142857),
PLL24M( 20,  2, 21,  1,    37227272),
PLL24M( 28,  3, 26,  2,    37234567),
PLL24M( 10,  2, 22,  0,    37304347),
PLL24M( 13,  3, 12,  2,    37333333),
PLL24M( 22,  2, 15,  2,    37374999),
PLL24M( 22,  0, 15,  0,    37375000),
PLL24M(  8,  3, 24,  0,    37440000),
PLL24M( 24,  2, 25,  1,    37500000),
PLL24M( 12,  0,  8,  0,    37555555),
PLL24M( 26,  2, 27,  1,    37607142),
PLL24M( 13,  2, 28,  0,    37655172),
PLL24M( 24,  3, 22,  2,    37681159),
PLL24M( 28,  2, 19,  2,    37699999),
PLL24M( 28,  0, 19,  0,    37700000),
PLL24M( 14,  2, 30,  0,    37741935),
PLL24M( 30,  2, 31,  1,    37781250),
PLL24M(  3,  3, 10,  0,    37818181),
PLL24M( 22,  3, 20,  2,    37968253),
PLL24M( 18,  2, 12,  2,    37999999),
PLL24M( 18,  0, 12,  0,    38000000U),
PLL24M( 10,  1, 14,  0,    38133333),
PLL24M( 24,  0, 16,  0,    38235294),
PLL24M( 31,  3, 28,  2,    38252873),
PLL24M(  6,  3, 18,  0,    38315789),
PLL24M( 30,  0, 20,  0,    38380952),
PLL24M( 16,  1, 22,  0,    38434782),
PLL24M(  9,  3, 26,  0,    38518518),
PLL24M( 22,  1, 30,  0,    38580645),
PLL24M( 28,  1, 12,  2,    38666666),
PLL24M( 18,  3, 16,  2,    38745097),
PLL24M( 27,  3, 24,  2,    38826666),
PLL24M(  0,  2,  1,  0,    39000000U),
PLL24M( 25,  3, 22,  2,    39188405),
PLL24M( 16,  3, 14,  2,    39288888),
PLL24M( 24,  1, 10,  2,    39393939),
PLL24M( 10,  3, 28,  0,    39448275),
PLL24M( 18,  1, 24,  0,    39520000),
PLL24M(  7,  3, 20,  0,    39619047),
PLL24M( 28,  0, 18,  0,    39684210),
PLL24M( 12,  1, 16,  0,    39764705),
PLL24M( 30,  3, 26,  2,    39802469),
PLL24M( 22,  0, 14,  0,    39866666),
PLL24M( 19,  2, 12,  2,    39999999),
PLL24M(  4,  3, 12,  0,    40000000U),
PLL24M( 21,  3, 18,  2,    40140350),
PLL24M( 16,  0, 10,  0,    40181818),
PLL24M( 28,  3, 24,  2,    40213333),
PLL24M( 11,  3, 30,  0,    40258064),
PLL24M( 30,  2, 19,  2,    40299999),
PLL24M( 30,  0, 19,  0,    40300000),
PLL24M( 14,  2, 28,  0,    40344827),
PLL24M( 28,  2, 27,  1,    40392857),
PLL24M(  6,  1,  8,  0,    40444444),
PLL24M( 26,  2, 25,  1,    40500000),
PLL24M( 12,  2, 24,  0,    40560000),
PLL24M( 24,  2, 15,  2,    40624999),
PLL24M( 24,  0, 15,  0,    40625000),
PLL24M(  8,  3, 22,  0,    40695652),
PLL24M( 22,  2, 21,  1,    40772727),
PLL24M( 19,  3, 16,  2,    40784313),
PLL24M( 10,  0,  6,  0,    40857142),
PLL24M( 20,  2, 19,  1,    40950000),
PLL24M( 12,  3, 10,  2,    40969696),
PLL24M(  9,  2, 18,  0,    41052631),
PLL24M( 31,  3, 26,  2,    41086419),
PLL24M( 18,  0, 11,  0,    41166666),
PLL24M( 22,  1, 28,  0,    41241379),
PLL24M( 24,  3, 20,  2,    41269841),
PLL24M(  8,  2, 16,  0,    41294117),
PLL24M( 30,  1, 12,  2,    41333333),
PLL24M( 16,  2, 31,  0,    41437500),
PLL24M(  7,  2,  4,  2,    41599999),
PLL24M(  1,  3,  4,  0,    41600000),
PLL24M( 30,  2, 28,  1,    41689655),
PLL24M( 14,  2, 27,  0,    41785714),
PLL24M( 28,  0, 17,  0,    41888888),
PLL24M( 24,  1, 30,  0,    41935483),
PLL24M( 22,  3, 18,  2,    41964912),
PLL24M(  6,  2, 12,  0,    42000000U),
PLL24M( 16,  1, 20,  0,    42095238),
PLL24M( 26,  2, 24,  1,    42120000),
PLL24M( 27,  3, 22,  2,    42202898),
PLL24M( 12,  2,  7,  2,    42249999),
PLL24M( 12,  0,  7,  0,    42250000),
PLL24M( 10,  3, 26,  0,    42370370),
PLL24M( 24,  2, 22,  1,    42391304),
PLL24M( 30,  0, 18,  0,    42421052),
PLL24M(  5,  2, 10,  0,    42545454),
PLL24M( 15,  3, 12,  2,    42666666),
PLL24M( 22,  0, 13,  0,    42714285),
PLL24M( 16,  2, 30,  0,    42774193),
PLL24M(  6,  3, 16,  0,    42823529),
PLL24M( 10,  2, 19,  0,    42900000),
PLL24M( 25,  3, 20,  2,    42920634),
PLL24M( 18,  1, 22,  0,    42956521),
PLL24M( 30,  3, 24,  2,    42986666),
PLL24M( 11,  3, 28,  0,    43034482),
PLL24M( 20,  2, 18,  1,    43105263),
PLL24M( 30,  2, 27,  1,    43178571),
PLL24M(  4,  0,  2,  0,    43333333),
PLL24M( 28,  2, 25,  1,    43500000),
PLL24M( 18,  2, 16,  1,    43588235),
PLL24M( 12,  3, 30,  0,    43612903),
PLL24M( 13,  2, 24,  0,    43680000),
PLL24M( 28,  3, 22,  2,    43710144),
PLL24M(  7,  3, 18,  0,    43789473),
PLL24M(  8,  2, 15,  0,    43875000),
PLL24M( 18,  3, 14,  2,    43911110),
PLL24M( 21,  2, 12,  2,    43999999),
PLL24M( 10,  1, 12,  0,    44000000U),
PLL24M( 12,  2, 22,  0,    44086956),
PLL24M( 13,  3, 10,  2,    44121212),
PLL24M( 16,  2,  9,  2,    44199999),
PLL24M( 16,  0,  9,  0,    44200000),
PLL24M( 22,  1, 26,  0,    44296296),
PLL24M( 24,  2, 21,  1,    44318181),
PLL24M( 28,  0, 16,  0,    44352941),
PLL24M( 31,  3, 24,  2,    44373333),
PLL24M(  2,  3,  6,  0,    44571428),
PLL24M( 30,  0, 17,  0,    44777777),
PLL24M( 24,  1, 28,  0,    44827586),
PLL24M( 22,  2, 19,  1,    44850000),
PLL24M( 21,  3, 16,  2,    44862744),
PLL24M( 18,  0, 10,  0,    44909090),
PLL24M( 14,  2, 25,  0,    45000000U),
PLL24M( 12,  1, 14,  0,    45066666),
PLL24M( 10,  2, 18,  0,    45157894),
PLL24M(  9,  3, 22,  0,    45217391),
PLL24M( 28,  2, 24,  1,    45240000),
PLL24M( 17,  2, 30,  0,    45290322),
PLL24M( 16,  3, 12,  2,    45333333),
PLL24M(  6,  2,  3,  2,    45499999),
PLL24M(  6,  0,  3,  0,    45500000),
PLL24M( 24,  3, 18,  2,    45614034),
PLL24M( 28,  1, 10,  2,    45696969),
PLL24M( 16,  2, 28,  0,    45724137),
PLL24M( 10,  3, 24,  0,    45760000),
PLL24M( 26,  2, 22,  1,    45782608),
PLL24M(  9,  2, 16,  0,    45882352),
PLL24M( 22,  2, 12,  2,    45999999),
PLL24M( 22,  0, 12,  0,    46000000U),
PLL24M( 12,  2, 21,  0,    46090909),
PLL24M(  3,  3,  2,  2,    46222221),
PLL24M(  3,  3,  8,  0,    46222222),
PLL24M( 18,  2, 31,  0,    46312500),
PLL24M( 24,  0, 13,  0,    46428571),
PLL24M( 30,  2, 25,  1,    46500000),
PLL24M( 16,  1, 18,  0,    46526315),
PLL24M( 12,  3, 28,  0,    46620689),
PLL24M( 30,  3, 22,  2,    46724637),
PLL24M(  2,  2,  4,  0,    46800000),
PLL24M( 22,  3, 16,  2,    46901960),
PLL24M( 13,  3, 30,  0,    46967741),
PLL24M( 18,  1,  6,  2,    47047618),
PLL24M( 18,  1, 20,  0,    47047619),
PLL24M( 28,  2, 15,  2,    47124999),
PLL24M( 28,  0, 15,  0,    47125000),
PLL24M( 22,  2, 18,  1,    47210526),
PLL24M(  4,  3, 10,  0,    47272727),
PLL24M( 16,  2, 27,  0,    47357142),
PLL24M( 30,  0, 16,  0,    47411764),
PLL24M( 25,  3, 18,  2,    47438596),
PLL24M( 13,  2, 22,  0,    47478260),
PLL24M( 10,  0,  5,  0,    47666666),
PLL24M( 18,  2, 30,  0,    47806451),
PLL24M( 22,  1, 24,  0,    47840000),
PLL24M( 26,  2, 21,  1,    47863636),
PLL24M( 28,  3, 20,  2,    47873015),
PLL24M(  5,  3, 12,  0,    48000000U),
PLL24M( 24,  1, 26,  0,    48148148),
PLL24M( 20,  2, 16,  1,    48176470),
PLL24M( 31,  3, 22,  2,    48231884),
PLL24M( 12,  0,  6,  0,    48285714),
PLL24M( 30,  2, 24,  1,    48360000),
PLL24M( 17,  2, 28,  0,    48413793),
PLL24M(  6,  3,  4,  2,    48533332),
PLL24M(  6,  3, 14,  0,    48533333),
PLL24M( 28,  1, 30,  0,    48645161),
PLL24M(  4,  2,  7,  0,    48750000),
PLL24M( 30,  1, 10,  2,    48848484),
PLL24M(  7,  3, 16,  0,    48941176),
PLL24M( 16,  0,  8,  0,    49111111),
PLL24M( 28,  2, 22,  1,    49173913),
PLL24M(  8,  3, 18,  0,    49263157),
PLL24M( 18,  2,  9,  2,    49399999),
PLL24M( 18,  0,  9,  0,    49400000),
PLL24M(  9,  3, 20,  0,    49523809),
PLL24M(  6,  2, 10,  0,    49636363),
PLL24M( 10,  3, 22,  0,    49739130),
PLL24M( 22,  0, 11,  0,    49833333),
PLL24M( 11,  3, 24,  0,    49920000),
PLL24M( 24,  2, 12,  2,    49999999),
PLL24M( 24,  0, 12,  0,    50000000U),
PLL24M( 12,  3,  8,  2,    50074073),
PLL24M( 12,  3, 26,  0,    50074074),
PLL24M(  8,  2, 13,  0,    50142857),
PLL24M( 13,  3, 28,  0,    50206896),
PLL24M( 28,  0, 14,  0,    50266666),
PLL24M( 14,  3, 30,  0,    50322580),
PLL24M( 30,  2, 15,  2,    50374999),
PLL24M( 30,  0, 15,  0,    50375000),
PLL24M( 15,  3, 10,  2,    50424242),
PLL24M( 10,  2, 16,  0,    50470588),
PLL24M( 18,  3, 12,  2,    50666666),
PLL24M( 12,  2, 19,  0,    50700000),
PLL24M( 21,  3, 14,  2,    50844444),
PLL24M( 14,  2, 22,  0,    50869565),
PLL24M( 24,  3, 16,  2,    50980392),
PLL24M( 16,  2, 25,  0,    51000000U),
PLL24M( 27,  3, 18,  2,    51087719),
PLL24M( 18,  2, 28,  0,    51103448),
PLL24M( 30,  3, 20,  2,    51174603),
PLL24M( 20,  2, 31,  0,    51187500),
PLL24M( 24,  2, 18,  1,    51315789),
PLL24M( 28,  2, 21,  1,    51409090),
PLL24M(  1,  2,  0,  2,    51999999),
PLL24M(  0,  1,  0,  0,    52000000U),
PLL24M( 30,  2, 22,  1,    52565217),
PLL24M( 26,  2, 19,  1,    52650000),
PLL24M( 22,  2, 16,  1,    52764705),
PLL24M( 31,  3, 20,  2,    52825396),
PLL24M( 20,  2, 30,  0,    52838709),
PLL24M( 28,  3, 18,  2,    52912280),
PLL24M( 18,  2, 27,  0,    52928571),
PLL24M( 25,  3, 16,  2,    53019607),
PLL24M( 16,  2, 24,  0,    53040000),
PLL24M( 22,  3, 14,  2,    53155555),
PLL24M( 14,  2, 21,  0,    53181818),
PLL24M( 19,  3, 12,  2,    53333333),
PLL24M( 12,  2, 18,  0,    53368421),
PLL24M( 16,  3, 10,  2,    53575757),
PLL24M( 10,  2, 15,  0,    53625000),
PLL24M( 15,  3, 30,  0,    53677419),
PLL24M( 30,  0, 14,  0,    53733333),
PLL24M( 14,  3, 28,  0,    53793103),
PLL24M( 28,  0, 13,  0,    53857142),
PLL24M( 13,  3, 26,  0,    53925925),
PLL24M(  8,  2, 12,  0,    54000000U),
PLL24M( 12,  3, 24,  0,    54080000),
PLL24M( 24,  0, 11,  0,    54166666),
PLL24M( 11,  3, 22,  0,    54260869),
PLL24M( 22,  0, 10,  0,    54363636),
PLL24M( 10,  3, 20,  0,    54476190),
PLL24M(  6,  2,  9,  0,    54600000),
PLL24M(  9,  3, 18,  0,    54736842),
PLL24M( 18,  0,  8,  0,    54888888),
PLL24M( 30,  2, 21,  1,    54954545),
PLL24M(  8,  3, 16,  0,    55058823),
PLL24M( 16,  2,  7,  2,    55249999),
PLL24M( 16,  0,  7,  0,    55250000),
PLL24M( 21,  2, 30,  0,    55354838),
PLL24M( 26,  2, 18,  1,    55421052),
PLL24M(  7,  3, 14,  0,    55466666),
PLL24M( 30,  1, 28,  0,    55586206),
PLL24M(  4,  2,  6,  0,    55714285),
PLL24M( 28,  1, 26,  0,    55851851),
PLL24M( 27,  2, 12,  2,    55999999),
PLL24M(  6,  3, 12,  0,    56000000U),
PLL24M( 22,  2, 31,  0,    56062500),
PLL24M( 17,  2, 24,  0,    56160000),
PLL24M( 12,  0,  5,  0,    56333333),
PLL24M( 20,  2, 28,  0,    56482758),
PLL24M( 24,  1, 22,  0,    56521739),
PLL24M( 28,  2, 19,  1,    56550000),
PLL24M( 30,  3, 18,  2,    56561403),
PLL24M(  5,  3, 10,  0,    56727272),
PLL24M( 22,  1, 20,  0,    56952380),
PLL24M( 18,  2, 25,  0,    57000000U),
PLL24M( 16,  3, 30,  0,    57032258),
PLL24M( 27,  3, 16,  2,    57098039),
PLL24M( 10,  2,  4,  2,    57199999),
PLL24M( 10,  0,  4,  0,    57200000),
PLL24M( 24,  2, 16,  1,    57352941),
PLL24M( 15,  3, 28,  0,    57379310),
PLL24M( 13,  2, 18,  0,    57473684),
PLL24M( 30,  0, 13,  0,    57571428),
PLL24M( 16,  2, 22,  0,    57652173),
PLL24M(  4,  3,  8,  0,    57777777),
PLL24M( 22,  2, 30,  0,    57870967),
PLL24M( 28,  2, 12,  2,    57999999),
PLL24M( 28,  0, 12,  0,    58000000U),
PLL24M( 18,  1, 16,  0,    58117647),
PLL24M( 13,  3, 24,  0,    58240000),
PLL24M( 31,  3, 18,  2,    58385964),
PLL24M(  2,  2,  3,  0,    58500000),
PLL24M( 21,  3, 12,  2,    58666666),
PLL24M( 12,  3, 22,  0,    58782608),
PLL24M( 16,  1, 14,  0,    58933333),
PLL24M( 24,  2, 10,  2,    59090908),
PLL24M( 24,  0, 10,  0,    59090909),
PLL24M( 28,  3, 16,  2,    59137254),
PLL24M( 21,  2, 28,  0,    59172413),
PLL24M( 18,  2, 24,  0,    59280000),
PLL24M(  3,  3,  6,  0,    59428571),
PLL24M( 28,  2, 18,  1,    59526315),
PLL24M( 12,  2, 16,  0,    59647058),
PLL24M( 30,  1, 26,  0,    59703703),
PLL24M( 22,  2,  9,  2,    59799999),
PLL24M( 22,  0,  9,  0,    59800000),
PLL24M( 18,  3, 10,  2,    59878787),
PLL24M(  9,  2, 12,  0,    60000000U),
PLL24M( 25,  3, 14,  2,    60088888),
PLL24M( 10,  3, 18,  0,    60210526),
PLL24M( 16,  2, 21,  0,    60272727),
PLL24M( 28,  1, 24,  0,    60320000),
PLL24M( 17,  3, 30,  0,    60387096),
PLL24M( 30,  2, 19,  1,    60450000),
PLL24M(  6,  0,  2,  0,    60666666),
PLL24M( 24,  2, 31,  0,    60937500),
PLL24M( 16,  3, 28,  0,    60965517),
PLL24M( 17,  2, 22,  0,    61043478),
PLL24M(  9,  3, 16,  0,    61176470),
PLL24M( 10,  2, 13,  0,    61285714),
PLL24M( 22,  3, 12,  2,    61333333),
PLL24M( 12,  1, 10,  0,    61454545),
PLL24M( 14,  2, 18,  0,    61578947),
PLL24M( 15,  3, 26,  0,    61629629),
PLL24M( 18,  2,  7,  2,    61749999),
PLL24M( 18,  0,  7,  0,    61750000),
PLL24M( 22,  2, 28,  0,    61862068),
PLL24M( 24,  1, 20,  0,    61904761),
PLL24M( 26,  2, 16,  1,    61941176),
PLL24M( 30,  2, 12,  2,    61999999),
PLL24M( 30,  0, 12,  0,    62000000U),
PLL24M(  2,  3,  4,  0,    62400000),
PLL24M( 28,  0, 11,  0,    62833333),
PLL24M( 24,  2, 30,  0,    62903225),
PLL24M( 22,  1, 18,  0,    62947368),
PLL24M( 20,  2, 25,  0,    63000000U),
PLL24M( 19,  3, 10,  2,    63030302),
PLL24M( 16,  0,  6,  0,    63142857),
PLL24M( 30,  3, 16,  2,    63215686),
PLL24M( 13,  3, 22,  0,    63304347),
PLL24M( 12,  2, 15,  0,    63375000),
PLL24M( 10,  1,  8,  0,    63555555),
PLL24M( 30,  2, 18,  1,    63631578),
PLL24M( 18,  3, 30,  0,    63741935),
PLL24M(  8,  2, 10,  0,    63818181),
PLL24M( 31,  2, 12,  2,    63999999),
PLL24M(  7,  3, 12,  0,    64000000U),
PLL24M( 22,  2, 27,  0,    64071428),
PLL24M( 13,  2, 16,  0,    64235294),
PLL24M( 12,  3, 20,  0,    64380952),
PLL24M( 18,  2, 22,  0,    64434782),
PLL24M( 30,  1, 24,  0,    64480000),
PLL24M( 17,  3, 28,  0,    64551724),
PLL24M( 27,  3, 14,  2,    64711110),
PLL24M(  4,  2,  1,  2,    64999999),
PLL24M(  4,  0,  1,  0,    65000000U),
PLL24M( 31,  3, 16,  2,    65254901),
PLL24M( 25,  2, 30,  0,    65419354),
PLL24M( 16,  3, 26,  0,    65481481),
PLL24M( 20,  2, 24,  0,    65520000),
PLL24M( 28,  1, 22,  0,    65565217),
PLL24M( 11,  3, 18,  0,    65684210),
PLL24M( 26,  2, 31,  0,    65812500),
PLL24M( 18,  1, 14,  0,    65866666),
PLL24M( 10,  2, 12,  0,    66000000U),
PLL24M(  6,  3, 10,  0,    66181818),
PLL24M( 16,  2, 19,  0,    66300000),
PLL24M( 22,  0,  8,  0,    66444444),
PLL24M( 28,  2, 16,  1,    66529411),
PLL24M( 15,  3, 24,  0,    66560000),
PLL24M( 24,  3, 12,  2,    66666666),
PLL24M(  5,  2,  6,  0,    66857142),
PLL24M( 28,  3, 14,  2,    67022222),
PLL24M( 19,  3, 30,  0,    67096774),
PLL24M( 30,  0, 11,  0,    67166666),
PLL24M( 24,  2, 28,  0,    67241379),
PLL24M( 10,  3, 16,  0,    67294117),
PLL24M( 18,  2, 21,  0,    67363636),
PLL24M( 12,  2,  4,  2,    67599999),
PLL24M( 12,  0,  4,  0,    67600000),
PLL24M( 14,  3, 22,  0,    67826086),
PLL24M( 26,  2, 30,  0,    67935483),
PLL24M( 16,  1, 12,  0,    68000000U),
PLL24M( 18,  3, 28,  0,    68137931),
PLL24M(  6,  2,  7,  0,    68250000),
PLL24M( 24,  1, 18,  0,    68421052),
PLL24M( 28,  0, 10,  0,    68545454),
PLL24M( 21,  2, 24,  0,    68640000),
PLL24M( 14,  2, 16,  0,    68823529),
PLL24M( 22,  2, 25,  0,    69000000U),
PLL24M(  1,  3,  0,  2,    69333332),
PLL24M(  1,  3,  2,  0,    69333333),
PLL24M( 24,  2, 27,  0,    69642857),
PLL24M( 16,  2, 18,  0,    69789473),
PLL24M( 25,  2, 28,  0,    69931034),
PLL24M( 30,  1, 22,  0,    70086956),
PLL24M(  8,  2,  9,  0,    70200000),
PLL24M( 22,  1, 16,  0,    70352941),
PLL24M( 20,  3, 30,  0,    70451612),
PLL24M( 18,  0,  6,  0,    70571428),
PLL24M( 28,  2, 31,  0,    70687500),
PLL24M( 16,  3, 24,  0,    70720000),
PLL24M(  9,  2, 10,  0,    70909090),
PLL24M( 30,  2, 16,  1,    71117647),
PLL24M( 12,  3, 18,  0,    71157894),
PLL24M( 20,  2, 22,  0,    71217391),
PLL24M( 10,  2,  3,  2,    71499999),
PLL24M( 10,  0,  3,  0,    71500000),
PLL24M( 30,  3, 14,  2,    71644444),
PLL24M( 19,  3, 28,  0,    71724137),
PLL24M( 22,  2, 24,  0,    71760000),
PLL24M( 28,  1, 20,  0,    71809523),
PLL24M(  8,  3, 12,  0,    72000000U),
PLL24M( 24,  0,  8,  0,    72222222),
PLL24M( 15,  3, 22,  0,    72347826),
PLL24M( 12,  2, 13,  0,    72428571),
PLL24M( 22,  3, 10,  2,    72484848),
PLL24M( 26,  2, 28,  0,    72620689),
PLL24M( 13,  2,  4,  2,    72799999),
PLL24M(  6,  1,  4,  0,    72800000),
PLL24M( 28,  2, 30,  0,    72967741),
PLL24M( 14,  2, 15,  0,    73125000),
PLL24M( 18,  3,  8,  2,    73185184),
PLL24M( 18,  3, 26,  0,    73185185),
PLL24M( 30,  0, 10,  0,    73272727),
PLL24M( 11,  3, 16,  0,    73411764),
PLL24M( 16,  0,  5,  0,    73666666),
PLL24M( 21,  3, 30,  0,    73806451),
PLL24M( 17,  2, 18,  0,    73894736),
PLL24M( 31,  3, 14,  2,    73955555),
PLL24M( 18,  2, 19,  0,    74100000),
PLL24M(  4,  3,  6,  0,    74285714),
PLL24M( 20,  2, 21,  0,    74454545),
PLL24M( 21,  2, 22,  0,    74608695),
PLL24M( 27,  3, 12,  2,    74666666),
PLL24M( 22,  2,  7,  2,    74749999),
PLL24M( 22,  0,  7,  0,    74750000),
PLL24M( 17,  3, 24,  0,    74880000),
PLL24M( 24,  2, 25,  0,    75000000U),
PLL24M( 12,  1,  2,  2,    75111110),
PLL24M( 12,  1,  8,  0,    75111111),
PLL24M( 26,  2, 27,  0,    75214285),
PLL24M( 20,  3, 28,  0,    75310344),
PLL24M( 28,  2,  9,  2,    75399999),
PLL24M( 28,  0,  9,  0,    75400000),
PLL24M( 29,  2, 30,  0,    75483870),
PLL24M( 30,  2, 31,  0,    75562500),
PLL24M(  7,  3, 10,  0,    75636363),
PLL24M( 18,  1, 12,  0,    76000000U),
PLL24M( 10,  3, 14,  0,    76266666),
PLL24M( 24,  1, 16,  0,    76470588),
PLL24M( 13,  3, 18,  0,    76631578),
PLL24M( 30,  1, 20,  0,    76761904),
PLL24M( 16,  3, 22,  0,    76869565),
PLL24M( 19,  3,  8,  2,    77037036),
PLL24M( 19,  3, 26,  0,    77037037),
PLL24M( 22,  3, 30,  0,    77161290),
PLL24M( 28,  3, 12,  2,    77333333),
PLL24M(  0,  2,  0,  0,    78000000U),
PLL24M( 24,  3, 10,  2,    78787878),
PLL24M( 21,  3, 28,  0,    78896551),
PLL24M( 18,  3, 24,  0,    79040000),
PLL24M( 15,  3,  6,  2,    79238094),
PLL24M( 15,  3, 20,  0,    79238095),
PLL24M( 28,  1, 18,  0,    79368421),
PLL24M( 12,  3, 16,  0,    79529411),
PLL24M( 22,  1, 14,  0,    79733333),
PLL24M(  9,  3, 12,  0,    80000000U),
PLL24M( 16,  1, 10,  0,    80363636),
PLL24M( 23,  3, 30,  0,    80516129),
PLL24M( 30,  2,  9,  2,    80599999),
PLL24M( 30,  0,  9,  0,    80600000),
PLL24M( 29,  2, 28,  0,    80689655),
PLL24M( 28,  2, 27,  0,    80785714),
PLL24M(  6,  3,  8,  0,    80888888),
PLL24M( 26,  2, 25,  0,    81000000U),
PLL24M( 25,  2, 24,  0,    81120000),
PLL24M( 24,  2,  7,  2,    81249999),
PLL24M( 24,  0,  7,  0,    81250000),
PLL24M( 17,  3, 22,  0,    81391304),
PLL24M( 22,  2, 21,  0,    81545454),
PLL24M( 10,  1,  6,  0,    81714285),
PLL24M( 20,  2, 19,  0,    81900000),
PLL24M( 25,  3, 10,  2,    81939393),
PLL24M( 14,  3, 18,  0,    82105263),
PLL24M( 18,  0,  5,  0,    82333333),
PLL24M( 22,  3, 28,  0,    82482758),
PLL24M( 17,  2, 16,  0,    82588235),
PLL24M( 30,  3, 12,  2,    82666666),
PLL24M( 16,  2, 15,  0,    82875000),
PLL24M( 15,  2,  4,  2,    83199999),
PLL24M(  3,  3,  4,  0,    83200000),
PLL24M( 30,  2, 28,  0,    83379310),
PLL24M( 14,  2, 13,  0,    83571428),
PLL24M( 28,  0,  8,  0,    83777777),
PLL24M( 24,  3, 30,  0,    83870967),
PLL24M( 13,  2, 12,  0,    84000000U),
PLL24M( 16,  3, 20,  0,    84190476),
PLL24M( 26,  2, 24,  0,    84240000),
PLL24M( 12,  2,  3,  2,    84499999),
PLL24M( 12,  0,  3,  0,    84500000),
PLL24M( 21,  3, 26,  0,    84740740),
PLL24M( 24,  2, 22,  0,    84782608),
PLL24M( 30,  1, 18,  0,    84842105),
PLL24M(  8,  3, 10,  0,    85090909),
PLL24M( 31,  3, 12,  2,    85333333),
PLL24M( 22,  0,  6,  0,    85428571),
PLL24M( 13,  3, 16,  0,    85647058),
PLL24M( 10,  2,  9,  0,    85800000),
PLL24M( 18,  3, 22,  0,    85913043),
PLL24M( 23,  3, 28,  0,    86068965),
PLL24M( 20,  2, 18,  0,    86210526),
PLL24M( 30,  2, 27,  0,    86357142),
PLL24M(  4,  1,  2,  0,    86666666),
PLL24M( 28,  2, 25,  0,    87000000U),
PLL24M( 18,  2, 16,  0,    87176470),
PLL24M( 25,  3, 30,  0,    87225806),
PLL24M( 20,  3, 24,  0,    87360000),
PLL24M( 15,  3, 18,  0,    87578947),
PLL24M(  8,  2,  7,  0,    87750000),
PLL24M( 10,  3, 12,  0,    88000000U),
PLL24M( 25,  2, 22,  0,    88173913),
PLL24M( 27,  3, 10,  2,    88242424),
PLL24M( 16,  2,  4,  2,    88399999),
PLL24M( 16,  0,  4,  0,    88400000),
PLL24M( 22,  3, 26,  0,    88592592),
PLL24M( 24,  2, 21,  0,    88636363),
PLL24M( 28,  1, 16,  0,    88705882),
PLL24M(  5,  3,  6,  0,    89142857),
PLL24M( 30,  0,  8,  0,    89555555),
PLL24M( 24,  3, 28,  0,    89655172),
PLL24M( 22,  2, 19,  0,    89700000),
PLL24M( 18,  1, 10,  0,    89818181),
PLL24M( 14,  2, 12,  0,    90000000U),
PLL24M( 12,  3,  4,  2,    90133332),
PLL24M( 12,  3, 14,  0,    90133333),
PLL24M( 21,  2, 18,  0,    90315789),
PLL24M( 19,  3, 22,  0,    90434782),
PLL24M( 28,  2, 24,  0,    90480000),
PLL24M( 26,  3, 30,  0,    90580645),
PLL24M(  6,  2,  1,  2,    90999999),
PLL24M(  6,  0,  1,  0,    91000000U),
PLL24M( 28,  3, 10,  2,    91393939),
PLL24M( 21,  3, 24,  0,    91520000),
PLL24M( 26,  2, 22,  0,    91565217),
PLL24M( 14,  3, 16,  0,    91764705),
PLL24M( 22,  1, 12,  0,    92000000U),
PLL24M( 12,  2, 10,  0,    92181818),
PLL24M(  7,  3,  8,  0,    92444444),
PLL24M( 18,  2, 15,  0,    92625000),
PLL24M( 24,  0,  6,  0,    92857142),
PLL24M( 30,  2, 25,  0,    93000000U),
PLL24M( 16,  3, 18,  0,    93052631),
PLL24M( 25,  3, 28,  0,    93241379),
PLL24M(  5,  2,  4,  0,    93600000),
PLL24M( 27,  3, 30,  0,    93935483),
PLL24M( 18,  3,  6,  2,    94095237),
PLL24M( 18,  3, 20,  0,    94095238),
PLL24M( 28,  2,  7,  2,    94249999),
PLL24M( 28,  0,  7,  0,    94250000),
PLL24M( 22,  2, 18,  0,    94421052),
PLL24M(  9,  3, 10,  0,    94545454),
PLL24M( 16,  2, 13,  0,    94714285),
PLL24M( 30,  1, 16,  0,    94823529),
PLL24M( 20,  3, 22,  0,    94956521),
PLL24M( 10,  0,  2,  0,    95333333),
PLL24M( 22,  3, 24,  0,    95680000),
PLL24M( 26,  2, 21,  0,    95727272),
PLL24M( 11,  3, 12,  0,    96000000U),
PLL24M( 24,  3, 26,  0,    96296296),
PLL24M( 20,  2, 16,  0,    96352941),
PLL24M( 12,  1,  6,  0,    96571428),
PLL24M( 30,  2, 24,  0,    96720000),
PLL24M( 26,  3, 28,  0,    96827586),
PLL24M( 13,  3, 14,  0,    97066666),
PLL24M( 28,  3, 30,  0,    97290322),
PLL24M(  4,  2,  3,  0,    97500000),
PLL24M( 30,  3, 10,  2,    97696969),
PLL24M( 15,  3, 16,  0,    97882352),
PLL24M( 16,  1,  8,  0,    98222222),
PLL24M( 28,  2, 22,  0,    98347826),
PLL24M( 17,  3, 18,  0,    98526315),
PLL24M( 18,  2,  4,  2,    98799999),
PLL24M( 18,  0,  4,  0,    98800000),
PLL24M( 19,  3,  6,  2,    99047618),
PLL24M( 19,  3, 20,  0,    99047619),
PLL24M( 13,  2, 10,  0,    99272727),
PLL24M( 21,  3, 22,  0,    99478260),
PLL24M( 22,  0,  5,  0,    99666666),
PLL24M( 23,  3, 24,  0,    99840000),
PLL24M( 24,  1, 12,  0,   100000000U),
PLL24M( 25,  3, 26,  0,   100148148),
PLL24M(  8,  2,  6,  0,   100285714),
PLL24M( 27,  3, 28,  0,   100413793),
PLL24M( 28,  1, 14,  0,   100533333),
PLL24M( 29,  3, 30,  0,   100645161),
PLL24M( 30,  2,  7,  2,   100749999),
PLL24M( 30,  0,  7,  0,   100750000),
PLL24M( 31,  3, 10,  2,   100848484),
PLL24M( 21,  2, 16,  0,   100941176),
PLL24M( 12,  2,  9,  0,   101400000),
PLL24M( 29,  2, 22,  0,   101739130),
PLL24M( 16,  2, 12,  0,   102000000U),
PLL24M( 20,  2, 15,  0,   102375000),
PLL24M( 24,  2, 18,  0,   102631578),
PLL24M( 28,  2, 21,  0,   102818181),
PLL24M(  3,  2,  0,  2,   103999998),
PLL24M(  7,  2,  1,  2,   103999999),
PLL24M(  0,  3,  0,  0,   104000000U),
PLL24M( 30,  2, 22,  0,   105130434),
PLL24M( 26,  2, 19,  0,   105300000),
PLL24M( 22,  2, 16,  0,   105529411),
PLL24M( 18,  2, 13,  0,   105857142),
PLL24M( 14,  2, 10,  0,   106363636),
PLL24M( 25,  2, 18,  0,   106736842),
PLL24M( 10,  2,  7,  0,   107250000),
PLL24M( 31,  3, 30,  0,   107354838),
PLL24M( 30,  1, 14,  0,   107466666),
PLL24M( 29,  3, 28,  0,   107586206),
PLL24M( 28,  0,  6,  0,   107714285),
PLL24M( 27,  3, 26,  0,   107851851),
PLL24M( 17,  2, 12,  0,   108000000U),
PLL24M( 25,  3, 24,  0,   108160000),
PLL24M( 24,  0,  5,  0,   108333333),
PLL24M( 23,  3, 22,  0,   108521739),
PLL24M( 22,  1, 10,  0,   108727272),
PLL24M( 21,  3, 20,  0,   108952380),
PLL24M(  6,  2,  4,  0,   109200000),
PLL24M( 19,  3, 18,  0,   109473684),
PLL24M( 18,  1,  8,  0,   109777777),
PLL24M( 30,  2, 21,  0,   109909090),
PLL24M( 17,  3, 16,  0,   110117647),
PLL24M( 16,  2,  3,  2,   110499999),
PLL24M( 16,  0,  3,  0,   110500000),
PLL24M( 26,  2, 18,  0,   110842105),
PLL24M( 15,  3,  4,  2,   110933332),
PLL24M( 15,  3, 14,  0,   110933333),
PLL24M( 30,  3, 28,  0,   111172413),
PLL24M(  9,  2,  6,  0,   111428571),
PLL24M( 28,  3, 26,  0,   111703703),
PLL24M( 13,  3, 12,  0,   112000000U),
PLL24M( 22,  2, 15,  0,   112125000),
PLL24M( 26,  3, 24,  0,   112320000),
PLL24M( 12,  0,  2,  0,   112666666),
PLL24M( 24,  3, 22,  0,   113043478),
PLL24M( 28,  2, 19,  0,   113100000),
PLL24M( 11,  3, 10,  0,   113454545),
PLL24M( 22,  3, 20,  0,   113904761),
PLL24M( 18,  2, 12,  0,   114000000U),
PLL24M( 21,  2,  4,  2,   114399999),
PLL24M( 10,  1,  4,  0,   114400000),
PLL24M( 24,  2, 16,  0,   114705882),
PLL24M( 31,  3, 28,  0,   114758620),
PLL24M( 20,  3, 18,  0,   114947368),
PLL24M( 30,  2,  6,  2,   115142856),
PLL24M( 30,  0,  6,  0,   115142857),
PLL24M(  9,  3,  2,  2,   115555554),
PLL24M(  9,  3,  8,  0,   115555555),
PLL24M( 28,  1, 12,  0,   116000000U),
PLL24M( 18,  3, 16,  0,   116235294),
PLL24M( 27,  3, 24,  0,   116480000),
PLL24M(  2,  2,  1,  0,   117000000U),
PLL24M( 25,  3, 22,  0,   117565217),
PLL24M( 16,  3, 14,  0,   117866666),
PLL24M( 24,  1, 10,  0,   118181818),
PLL24M(  7,  3,  6,  0,   118857142),
PLL24M( 28,  2, 18,  0,   119052631),
PLL24M( 25,  2, 16,  0,   119294117),
PLL24M( 30,  3, 26,  0,   119407407),
PLL24M( 22,  2,  4,  2,   119599999),
PLL24M( 22,  0,  4,  0,   119600000),
PLL24M( 14,  3, 12,  0,   120000000U),
PLL24M( 21,  3, 18,  0,   120421052),
PLL24M( 16,  2, 10,  0,   120545454),
PLL24M( 28,  3, 24,  0,   120640000),
PLL24M( 30,  2, 19,  0,   120900000),
PLL24M(  6,  1,  0,  2,   121333332),
PLL24M(  6,  1,  2,  0,   121333333),
PLL24M( 24,  2, 15,  0,   121875000),
PLL24M( 26,  3, 22,  0,   122086956),
PLL24M( 19,  3, 16,  0,   122352941),
PLL24M( 10,  2,  6,  0,   122571428),
PLL24M( 12,  3, 10,  0,   122909090),
PLL24M( 29,  2, 18,  0,   123157894),
PLL24M( 31,  3, 26,  0,   123259259),
PLL24M( 18,  2,  3,  2,   123499999),
PLL24M( 18,  0,  3,  0,   123500000),
PLL24M( 24,  3, 20,  0,   123809523),
PLL24M( 26,  2, 16,  0,   123882352),
PLL24M( 30,  1, 12,  0,   124000000U),
PLL24M(  5,  3,  4,  0,   124800000),
PLL24M( 28,  0,  5,  0,   125666666),
PLL24M( 22,  3, 18,  0,   125894736),
PLL24M( 20,  2, 12,  0,   126000000U),
PLL24M( 16,  1,  6,  0,   126285714),
PLL24M( 27,  3, 22,  0,   126608695),
PLL24M( 12,  2,  7,  0,   126750000),
PLL24M( 10,  3,  2,  2,   127111110),
PLL24M( 10,  3,  8,  0,   127111111),
PLL24M( 30,  2, 18,  0,   127263157),
PLL24M( 17,  2, 10,  0,   127636363),
PLL24M( 15,  3, 12,  0,   128000000U),
PLL24M( 22,  2, 13,  0,   128142857),
PLL24M( 20,  3, 16,  0,   128470588),
PLL24M( 25,  3, 20,  0,   128761904),
PLL24M( 30,  3, 24,  0,   128960000),
PLL24M(  4,  2,  0,  2,   129999999),
PLL24M(  4,  0,  0,  0,   130000000U),
PLL24M( 28,  3, 22,  0,   131130434),
PLL24M( 23,  3, 18,  0,   131368421),
PLL24M( 26,  2, 15,  0,   131625000),
PLL24M( 18,  3,  4,  2,   131733332),
PLL24M( 18,  3, 14,  0,   131733333),
PLL24M( 21,  2, 12,  0,   132000000U),
PLL24M( 13,  3, 10,  0,   132363636),
PLL24M( 16,  2,  9,  0,   132600000),
PLL24M( 22,  1,  8,  0,   132888888),
PLL24M( 28,  2, 16,  0,   133058823),
PLL24M( 31,  3, 24,  0,   133120000),
PLL24M(  8,  3,  6,  0,   133714285),
PLL24M( 30,  0,  5,  0,   134333333),
PLL24M( 21,  3, 16,  0,   134588235),
PLL24M( 18,  2, 10,  0,   134727272),
PLL24M( 25,  2,  4,  2,   135199999),
PLL24M( 12,  1,  4,  0,   135200000),
PLL24M( 29,  3, 22,  0,   135652173),
PLL24M( 16,  3, 12,  0,   136000000U),
PLL24M(  6,  2,  3,  0,   136500000),
PLL24M( 24,  3, 18,  0,   136842105),
PLL24M( 28,  1, 10,  0,   137090909),
PLL24M( 29,  2, 16,  0,   137647058),
PLL24M( 22,  2, 12,  0,   138000000U),
PLL24M(  3,  3,  0,  2,   138666664),
PLL24M(  3,  3,  2,  0,   138666666),
PLL24M( 24,  2, 13,  0,   139285714),
PLL24M( 30,  3, 22,  0,   140173913),
PLL24M(  8,  2,  4,  0,   140400000),
PLL24M( 22,  3, 16,  0,   140705882),
PLL24M( 18,  1,  6,  0,   141142857),
PLL24M( 28,  2, 15,  0,   141375000),
PLL24M( 14,  3, 10,  0,   141818181),
PLL24M( 30,  2, 16,  0,   142235294),
PLL24M( 25,  3, 18,  0,   142315789),
PLL24M( 10,  2,  1,  2,   142999999),
PLL24M( 10,  0,  1,  0,   143000000U),
PLL24M( 28,  3, 20,  0,   143619047),
PLL24M( 17,  3, 12,  0,   144000000U),
PLL24M( 24,  1,  8,  0,   144444444),
PLL24M( 31,  3, 22,  0,   144695652),
PLL24M( 12,  2,  6,  0,   144857142),
PLL24M( 27,  2,  4,  2,   145599999),
PLL24M(  6,  3,  4,  0,   145600000),
PLL24M( 14,  2,  7,  0,   146250000),
PLL24M( 30,  1, 10,  0,   146545454),
PLL24M( 23,  3, 16,  0,   146823529),
PLL24M( 16,  0,  2,  0,   147333333),
PLL24M( 26,  3, 18,  0,   147789473),
PLL24M( 18,  2,  9,  0,   148200000),
PLL24M(  9,  3,  6,  0,   148571428),
PLL24M( 20,  2, 10,  0,   148909090),
PLL24M( 22,  2,  3,  2,   149499999),
PLL24M( 22,  0,  3,  0,   149500000),
PLL24M( 24,  2, 12,  0,   150000000U),
PLL24M( 12,  3,  2,  2,   150222221),
PLL24M( 12,  3,  8,  0,   150222222),
PLL24M( 26,  2, 13,  0,   150428571),
PLL24M( 28,  2,  4,  2,   150799999),
PLL24M( 28,  0,  4,  0,   150800000),
PLL24M( 30,  2, 15,  0,   151125000),
PLL24M( 15,  3, 10,  0,   151272727),
PLL24M( 18,  3, 12,  0,   152000000U),
PLL24M( 21,  3,  4,  2,   152533332),
PLL24M( 21,  3, 14,  0,   152533333),
PLL24M( 24,  3, 16,  0,   152941176),
PLL24M( 27,  3, 18,  0,   153263157),
PLL24M( 30,  3, 20,  0,   153523809),
PLL24M(  1,  2,  0,  0,   156000000U),
PLL24M( 31,  3, 20,  0,   158476190),
PLL24M( 28,  3, 18,  0,   158736842),
PLL24M( 25,  3, 16,  0,   159058823),
PLL24M( 22,  3, 14,  0,   159466666),
PLL24M( 19,  3, 12,  0,   160000000U),
PLL24M( 16,  3, 10,  0,   160727272),
PLL24M( 30,  2,  4,  2,   161199999),
PLL24M( 30,  0,  4,  0,   161200000),
PLL24M( 28,  2, 13,  0,   161571428),
PLL24M( 13,  3,  8,  0,   161777777),
PLL24M( 26,  2, 12,  0,   162000000U),
PLL24M( 24,  2,  3,  2,   162499999),
PLL24M( 24,  0,  3,  0,   162500000),
PLL24M( 22,  2, 10,  0,   163090909),
PLL24M( 10,  3,  6,  0,   163428571),
PLL24M( 20,  2,  9,  0,   163800000),
PLL24M( 29,  3, 18,  0,   164210526),
PLL24M( 18,  0,  2,  0,   164666666),
PLL24M( 26,  3, 16,  0,   165176470),
PLL24M( 16,  2,  7,  0,   165750000),
PLL24M( 31,  2,  4,  2,   166399999),
PLL24M(  7,  3,  4,  0,   166400000),
PLL24M( 14,  2,  6,  0,   167142857),
PLL24M( 28,  1,  8,  0,   167555555),
PLL24M( 20,  3, 12,  0,   168000000U),
PLL24M( 12,  2,  1,  2,   168999999),
PLL24M( 12,  0,  1,  0,   169000000U),
PLL24M( 30,  3, 18,  0,   169684210),
PLL24M( 17,  3, 10,  0,   170181818),
PLL24M( 22,  1,  6,  0,   170857142),
PLL24M( 27,  3, 16,  0,   171294117),
PLL24M( 10,  2,  4,  0,   171600000),
PLL24M( 30,  2, 13,  0,   172714285),
PLL24M(  4,  3,  0,  2,   173333332),
PLL24M(  4,  3,  2,  0,   173333333),
PLL24M( 28,  2, 12,  0,   174000000U),
PLL24M( 31,  3, 18,  0,   175157894),
PLL24M(  8,  2,  3,  0,   175500000),
PLL24M( 21,  3, 12,  0,   176000000U),
PLL24M( 16,  1,  4,  0,   176800000),
PLL24M( 24,  2, 10,  0,   177272727),
PLL24M( 28,  3, 16,  0,   177411764),
PLL24M( 11,  3,  6,  0,   178285714),
PLL24M( 30,  1,  2,  2,   179111110),
PLL24M( 30,  1,  8,  0,   179111111),
PLL24M( 22,  2,  9,  0,   179400000),
PLL24M( 18,  3, 10,  0,   179636363),
PLL24M( 29,  2, 12,  0,   180000000U),
PLL24M( 25,  3, 14,  0,   180266666),
PLL24M(  6,  2,  0,  2,   181999998),
PLL24M( 13,  2,  1,  2,   181999999),
PLL24M(  6,  0,  0,  0,   182000000U),
PLL24M( 29,  3, 16,  0,   183529411),
PLL24M( 22,  3, 12,  0,   184000000U),
PLL24M( 25,  2, 10,  0,   184363636),
PLL24M( 15,  3,  8,  0,   184888888),
PLL24M( 18,  2,  7,  0,   185250000),
PLL24M( 24,  1,  6,  0,   185714285),
PLL24M( 30,  2, 12,  0,   186000000U),
PLL24M(  8,  3,  4,  0,   187200000),
PLL24M( 28,  2,  3,  2,   188499999),
PLL24M( 28,  0,  3,  0,   188500000),
PLL24M( 19,  3, 10,  0,   189090909),
PLL24M( 16,  2,  6,  0,   189428571),
PLL24M( 30,  3, 16,  0,   189647058),
PLL24M( 10,  1,  2,  0,   190666666),
PLL24M( 26,  2, 10,  0,   191454545),
PLL24M( 23,  3, 12,  0,   192000000U),
PLL24M( 12,  3,  6,  0,   193142857),
PLL24M( 27,  3,  4,  2,   194133332),
PLL24M( 27,  3, 14,  0,   194133333),
PLL24M(  4,  2,  1,  0,   195000000U),
PLL24M( 31,  3, 16,  0,   195764705),
PLL24M( 16,  3,  8,  0,   196444444),
PLL24M( 18,  1,  4,  0,   197600000),
PLL24M( 20,  3, 10,  0,   198545454),
PLL24M( 22,  0,  2,  0,   199333333),
PLL24M( 24,  3, 12,  0,   200000000U),
PLL24M( 17,  2,  6,  0,   200571428),
PLL24M( 28,  3, 14,  0,   201066666),
PLL24M( 30,  2,  3,  2,   201499999),
PLL24M( 30,  0,  3,  0,   201500000),
PLL24M( 12,  2,  4,  0,   202800000),
PLL24M( 20,  2,  7,  0,   204750000),
PLL24M( 28,  2, 10,  0,   205636363),
PLL24M(  7,  2,  0,  2,   207999999),
PLL24M(  1,  3,  0,  0,   208000000U),
PLL24M( 26,  2,  9,  0,   210600000),
PLL24M( 18,  2,  6,  0,   211714285),
PLL24M( 29,  2, 10,  0,   212727272),
PLL24M( 10,  2,  3,  0,   214500000),
PLL24M( 30,  3,  4,  2,   214933332),
PLL24M( 30,  3, 14,  0,   214933333),
PLL24M( 28,  1,  6,  0,   215428571),
PLL24M( 26,  3, 12,  0,   216000000U),
PLL24M( 24,  0,  2,  0,   216666666),
PLL24M( 22,  3, 10,  0,   217454545),
PLL24M( 13,  2,  4,  0,   218400000),
PLL24M( 18,  3,  2,  2,   219555554),
PLL24M( 18,  3,  8,  0,   219555555),
PLL24M( 30,  2, 10,  0,   219818181),
PLL24M( 16,  2,  1,  2,   220999999),
PLL24M( 16,  0,  1,  0,   221000000U),
PLL24M( 31,  3, 14,  0,   221866666),
PLL24M( 14,  3,  6,  0,   222857142),
PLL24M( 27,  3, 12,  0,   224000000U),
PLL24M( 22,  2,  7,  0,   224250000),
PLL24M( 12,  1,  0,  2,   225333332),
PLL24M( 12,  1,  2,  0,   225333333),
PLL24M( 28,  2,  9,  0,   226200000),
PLL24M( 23,  3, 10,  0,   226909090),
PLL24M( 10,  3,  4,  0,   228800000),
PLL24M( 30,  1,  6,  0,   230285714),
PLL24M( 19,  3,  2,  2,   231111110),
PLL24M( 19,  3,  8,  0,   231111111),
PLL24M( 28,  3, 12,  0,   232000000U),
PLL24M(  2,  2,  0,  0,   234000000U),
PLL24M( 24,  3, 10,  0,   236363636),
PLL24M( 15,  3,  6,  0,   237714285),
PLL24M( 22,  1,  4,  0,   239200000),
PLL24M( 29,  3, 12,  0,   240000000U),
PLL24M( 30,  2,  9,  0,   241800000),
PLL24M(  6,  3,  0,  2,   242666664),
PLL24M(  6,  3,  2,  0,   242666666),
PLL24M( 24,  2,  7,  0,   243750000),
PLL24M( 21,  2,  6,  0,   245142857),
PLL24M( 25,  3, 10,  0,   245818181),
PLL24M( 18,  2,  1,  2,   246999999),
PLL24M( 18,  0,  1,  0,   247000000U),
PLL24M( 30,  3, 12,  0,   248000000U),
PLL24M( 11,  3,  4,  0,   249600000),
PLL24M( 28,  0,  2,  0,   251333333),
PLL24M( 16,  3,  6,  0,   252571428),
PLL24M( 12,  2,  3,  0,   253500000),
PLL24M( 21,  3,  2,  2,   254222221),
PLL24M( 21,  3,  8,  0,   254222222),
PLL24M( 26,  3, 10,  0,   255272727),
PLL24M( 31,  3, 12,  0,   256000000U),
PLL24M( 22,  2,  6,  0,   256285714),
PLL24M(  9,  2,  0,  2,   259999998),
PLL24M( 19,  2,  1,  2,   259999999),
PLL24M(  4,  1,  0,  0,   260000000U),
PLL24M( 26,  2,  7,  0,   263250000),
PLL24M( 27,  3, 10,  0,   264727272),
PLL24M( 16,  2,  4,  0,   265200000),
PLL24M( 22,  3,  8,  0,   265777777),
PLL24M( 17,  3,  6,  0,   267428571),
PLL24M( 30,  0,  2,  0,   268666666),
PLL24M( 12,  3,  4,  0,   270400000),
PLL24M(  6,  2,  1,  0,   273000000U),
PLL24M( 28,  3, 10,  0,   274181818),
PLL24M(  7,  3,  0,  2,   277333332),
PLL24M(  7,  3,  2,  0,   277333333),
PLL24M( 24,  2,  6,  0,   278571428),
PLL24M( 17,  2,  4,  0,   280800000),
PLL24M( 18,  3,  6,  0,   282285714),
PLL24M( 28,  2,  7,  0,   282750000),
PLL24M( 29,  3, 10,  0,   283636363),
PLL24M( 10,  2,  0,  2,   285999999),
PLL24M( 10,  0,  0,  0,   286000000U),
PLL24M( 24,  3,  8,  0,   288888888),
PLL24M( 25,  2,  6,  0,   289714285),
PLL24M( 13,  3,  4,  0,   291200000),
PLL24M( 14,  2,  3,  0,   292500000),
PLL24M( 30,  3, 10,  0,   293090909),
PLL24M( 16,  1,  2,  0,   294666666),
PLL24M( 18,  2,  4,  0,   296400000),
PLL24M( 19,  3,  6,  0,   297142857),
PLL24M( 22,  2,  1,  2,   298999999),
PLL24M( 22,  0,  1,  0,   299000000U),
PLL24M( 25,  3,  8,  0,   300444444),
PLL24M( 26,  2,  6,  0,   300857142),
PLL24M( 28,  1,  4,  0,   301600000),
PLL24M( 30,  2,  7,  0,   302250000),
PLL24M( 31,  3, 10,  0,   302545454),
PLL24M(  2,  3,  0,  0,   312000000U),
PLL24M( 30,  1,  4,  0,   322400000),
PLL24M( 28,  2,  6,  0,   323142857),
PLL24M( 27,  3,  2,  2,   323555554),
PLL24M( 27,  3,  8,  0,   323555555),
PLL24M( 24,  2,  1,  2,   324999999),
PLL24M( 24,  0,  1,  0,   325000000U),
PLL24M( 21,  3,  6,  0,   326857142),
PLL24M( 20,  2,  4,  0,   327600000),
PLL24M( 18,  1,  0,  2,   329333332),
PLL24M( 18,  1,  2,  0,   329333333),
PLL24M( 16,  2,  3,  0,   331500000),
PLL24M( 15,  3,  4,  0,   332800000),
PLL24M( 29,  2,  6,  0,   334285714),
PLL24M( 28,  3,  2,  2,   335111110),
PLL24M( 28,  3,  8,  0,   335111111),
PLL24M( 12,  2,  0,  2,   337999998),
PLL24M( 25,  2,  1,  2,   337999999),
PLL24M( 12,  0,  0,  0,   338000000U),
PLL24M( 22,  3,  6,  0,   341714285),
PLL24M( 21,  2,  4,  0,   343200000),
PLL24M( 30,  2,  6,  0,   345428571),
PLL24M(  9,  3,  0,  2,   346666664),
PLL24M(  9,  3,  2,  0,   346666666),
PLL24M(  8,  2,  1,  0,   351000000U),
PLL24M( 16,  3,  4,  0,   353600000),
PLL24M( 23,  3,  6,  0,   356571428),
PLL24M( 30,  3,  2,  2,   358222221),
PLL24M( 30,  3,  8,  0,   358222222),
PLL24M( 22,  2,  4,  0,   358800000),
PLL24M( 13,  2,  0,  2,   363999999),
PLL24M(  6,  1,  0,  0,   364000000U),
PLL24M( 31,  3,  8,  0,   369777777),
PLL24M( 18,  2,  3,  0,   370500000),
PLL24M( 24,  3,  6,  0,   371428571),
PLL24M( 17,  3,  4,  0,   374400000),
PLL24M( 28,  2,  1,  2,   376999999),
PLL24M( 28,  0,  1,  0,   377000000U),
PLL24M( 10,  3,  0,  2,   381333332),
PLL24M( 10,  3,  2,  0,   381333333),
PLL24M( 25,  3,  6,  0,   386285714),
PLL24M(  4,  2,  0,  0,   390000000U),
PLL24M( 18,  3,  4,  0,   395200000),
PLL24M( 22,  1,  2,  0,   398666666),
PLL24M( 26,  3,  6,  0,   401142857),
PLL24M( 30,  2,  1,  2,   402999999),
PLL24M( 30,  0,  1,  0,   403000000U),
PLL24M( 25,  2,  4,  0,   405600000),
PLL24M( 20,  2,  3,  0,   409500000),
PLL24M( 15,  2,  0,  2,   415999998),
PLL24M( 31,  2,  1,  2,   415999999),
PLL24M(  3,  3,  0,  0,   416000000U),
PLL24M( 26,  2,  4,  0,   421200000),
PLL24M( 10,  2,  1,  0,   429000000U),
PLL24M( 28,  3,  6,  0,   430857142),
PLL24M( 24,  1,  0,  2,   433333332),
PLL24M( 24,  1,  2,  0,   433333333),
PLL24M( 20,  3,  4,  0,   436800000),
PLL24M( 16,  2,  0,  2,   441999999),
PLL24M( 16,  0,  0,  0,   442000000U),
PLL24M( 29,  3,  6,  0,   445714285),
PLL24M( 22,  2,  3,  0,   448500000),
PLL24M( 12,  3,  0,  2,   450666664),
PLL24M( 12,  3,  2,  0,   450666666),
PLL24M( 28,  2,  4,  0,   452400000),
PLL24M( 21,  3,  4,  0,   457600000),
PLL24M( 30,  3,  6,  0,   460571428),
PLL24M(  5,  2,  0,  0,   468000000U),
PLL24M( 31,  3,  6,  0,   475428571),
PLL24M( 22,  3,  4,  0,   478400000),
PLL24M( 30,  2,  4,  0,   483600000),
PLL24M( 13,  3,  0,  2,   485333332),
PLL24M( 13,  3,  2,  0,   485333333),
PLL24M( 24,  2,  3,  0,   487500000),
PLL24M( 18,  2,  0,  2,   493999998),
PLL24M( 18,  0,  0,  0,   494000000U),
PLL24M( 23,  3,  4,  0,   499200000),
PLL24M( 28,  1,  2,  0,   502666666),
PLL24M( 12,  2,  1,  0,   507000000U),
PLL24M( 19,  2,  0,  2,   519999999),
PLL24M(  4,  3,  0,  0,   520000000U),
PLL24M( 26,  2,  3,  0,   526500000),
PLL24M( 30,  1,  0,  2,   537333332),
PLL24M( 30,  1,  2,  0,   537333333),
PLL24M( 25,  3,  4,  0,   540800000),
PLL24M(  6,  2,  0,  0,   546000000U),
PLL24M( 15,  3,  0,  2,   554666664),
PLL24M( 15,  3,  2,  0,   554666666),
PLL24M( 26,  3,  4,  0,   561600000),
PLL24M( 28,  2,  3,  0,   565500000),
PLL24M( 21,  2,  0,  2,   571999998),
PLL24M( 10,  1,  0,  0,   572000000U),
PLL24M( 27,  3,  4,  0,   582400000),
PLL24M( 14,  2,  1,  0,   585000000U),
PLL24M( 16,  3,  0,  2,   589333332),
PLL24M( 16,  3,  2,  0,   589333333),
PLL24M( 22,  2,  0,  2,   597999999),
PLL24M( 22,  0,  0,  0,   598000000U),
PLL24M( 28,  3,  4,  0,   603200000),
PLL24M( 30,  2,  3,  0,   604500000),
PLL24M(  5,  3,  0,  0,   624000000U),
PLL24M( 30,  3,  4,  0,   644800000),
PLL24M( 24,  2,  0,  2,   649999998),
PLL24M( 24,  0,  0,  0,   650000000U),
PLL24M( 18,  3,  0,  2,   658666664),
PLL24M( 18,  3,  2,  0,   658666666),
PLL24M( 16,  2,  1,  0,   663000000U),
PLL24M( 31,  3,  4,  0,   665600000),
PLL24M( 25,  2,  0,  2,   675999999),
PLL24M( 12,  1,  0,  0,   676000000U),
PLL24M( 19,  3,  0,  2,   693333332),
PLL24M( 19,  3,  2,  0,   693333333),
PLL24M(  8,  2,  0,  0,   702000000U),
PLL24M( 27,  2,  0,  2,   727999998),
PLL24M(  6,  3,  0,  0,   728000000U),
PLL24M( 18,  2,  1,  0,   741000000U),
PLL24M( 28,  2,  0,  2,   753999999),
PLL24M( 28,  0,  0,  0,   754000000U),
PLL24M( 21,  3,  0,  2,   762666664),
PLL24M( 21,  3,  2,  0,   762666666),
PLL24M(  9,  2,  0,  0,   780000000U),
PLL24M( 22,  3,  0,  2,   797333332),
PLL24M( 22,  3,  2,  0,   797333333),
PLL24M( 30,  2,  0,  2,   805999998),
PLL24M( 30,  0,  0,  0,   806000000U),
PLL24M( 20,  2,  1,  0,   819000000U),
PLL24M( 31,  2,  0,  2,   831999999),
PLL24M(  7,  3,  0,  0,   832000000U),
PLL24M( 10,  2,  0,  0,   858000000U),
PLL24M( 24,  3,  0,  2,   866666664),
PLL24M( 24,  3,  2,  0,   866666666),
PLL24M( 16,  1,  0,  0,   884000000U),
PLL24M( 22,  2,  1,  0,   897000000U),
PLL24M( 25,  3,  0,  2,   901333332),
PLL24M( 25,  3,  2,  0,   901333333),
PLL24M(  8,  3,  0,  0,   936000000U),
PLL24M( 27,  3,  0,  2,   970666664),
PLL24M( 27,  3,  2,  0,   970666666),
PLL24M( 24,  2,  1,  0,   975000000U),
PLL24M( 18,  1,  0,  0,   988000000U),
PLL24M( 28,  3,  0,  2,  1005333332),
PLL24M( 28,  3,  2,  0,  1005333333),
PLL24M( 12,  2,  0,  0,  1014000000U),
PLL24M(  9,  3,  0,  0,  1040000000U),
PLL24M( 26,  2,  1,  0,  1053000000U),
PLL24M( 30,  3,  0,  2,  1074666664),
PLL24M( 30,  3,  2,  0,  1074666666),
PLL24M( 13,  2,  0,  0,  1092000000U),
PLL24M( 31,  3,  0,  2,  1109333332),
PLL24M( 31,  3,  2,  0,  1109333333),
PLL24M( 28,  2,  1,  0,  1131000000U),
PLL24M( 10,  3,  0,  0,  1144000000U),
PLL24M( 14,  2,  0,  0,  1170000000U),
PLL24M( 22,  1,  0,  0,  1196000000U),
PLL24M( 30,  2,  1,  0,  1209000000U),
PLL24M( 11,  3,  0,  0,  1248000000U),
PLL24M( 24,  1,  0,  0,  1300000000U),
PLL24M( 16,  2,  0,  0,  1326000000U),
PLL24M( 12,  3,  0,  0,  1352000000U),
PLL24M( 17,  2,  0,  0,  1404000000U),
PLL24M( 13,  3,  0,  0,  1456000000U),
PLL24M( 18,  2,  0,  0,  1482000000U),
PLL24M( 28,  1,  0,  0,  1508000000U),
PLL24M( 14,  3,  0,  0,  1560000000U),
PLL24M( 30,  1,  0,  0,  1612000000U),
PLL24M( 20,  2,  0,  0,  1638000000U),
PLL24M( 15,  3,  0,  0,  1664000000U),
PLL24M( 21,  2,  0,  0,  1716000000U),
PLL24M( 16,  3,  0,  0,  1768000000U),
PLL24M( 22,  2,  0,  0,  1794000000U),
};

//n,m,freq
struct sunxi_clk_factor_freq factor_pllgpu_tbl[] = {
PLLGPU(4 ,0,	120000000U),
PLLGPU(15 ,2,	128000000U),
PLLGPU(10 ,1,	132000000U),
PLLGPU(16 ,2,	136000000U),
PLLGPU(11 ,1,	144000000U),
PLLGPU(18 ,2,	152000000U),
PLLGPU(12 ,1,	156000000U),
PLLGPU(19 ,2,	160000000U),
PLLGPU(26 ,3,	162000000U),
PLLGPU(54 ,7,	165000000U),
PLLGPU(6 ,0,	168000000U),
PLLGPU(56 ,7,	171000000U),
PLLGPU(28 ,3,	174000000U),
PLLGPU(21 ,2,	176000000U),
PLLGPU(58 ,7,	177000000U),
PLLGPU(29 ,3,	180000000U),
PLLGPU(60 ,7,	183000000U),
PLLGPU(22 ,2,	184000000U),
PLLGPU(30 ,3,	186000000U),
PLLGPU(62 ,7,	189000000U),
PLLGPU(31 ,3,	192000000U),
PLLGPU(64 ,7,	195000000U),
PLLGPU(32 ,3,	198000000U),
PLLGPU(24 ,2,	200000000U),
PLLGPU(66 ,7,	201000000U),
PLLGPU(33 ,3,	204000000U),
PLLGPU(68 ,7,	207000000U),
PLLGPU(25 ,2,	208000000U),
PLLGPU(34 ,3,	210000000U),
PLLGPU(70 ,7,	213000000U),
PLLGPU(35 ,3,	216000000U),
PLLGPU(72 ,7,	219000000U),
PLLGPU(36 ,3,	222000000U),
PLLGPU(27 ,2,	224000000U),
PLLGPU(74 ,7,	225000000U),
PLLGPU(37 ,3,	228000000U),
PLLGPU(76 ,7,	231000000U),
PLLGPU(28 ,2,	232000000U),
PLLGPU(38 ,3,	234000000U),
PLLGPU(78 ,7,	237000000U),
PLLGPU(39 ,3,	240000000U),
PLLGPU(80 ,7,	243000000U),
PLLGPU(40 ,3,	246000000U),
PLLGPU(30 ,2,	248000000U),
PLLGPU(82 ,7,	249000000U),
PLLGPU(20 ,1,	252000000U),
PLLGPU(84 ,7,	255000000U),
PLLGPU(31 ,2,	256000000U),
PLLGPU(42 ,3,	258000000U),
PLLGPU(86 ,7,	261000000U),
PLLGPU(43 ,3,	264000000U),
PLLGPU(88 ,7,	267000000U),
PLLGPU(44 ,3,	270000000U),
PLLGPU(33 ,2,	272000000U),
PLLGPU(90 ,7,	273000000U),
PLLGPU(45 ,3,	276000000U),
PLLGPU(92 ,7,	279000000U),
PLLGPU(34 ,2,	280000000U),
PLLGPU(46 ,3,	282000000U),
PLLGPU(94 ,7,	285000000U),
PLLGPU(47 ,3,	288000000U),
PLLGPU(96 ,7,	291000000U),
PLLGPU(48 ,3,	294000000U),
PLLGPU(36 ,2,	296000000U),
PLLGPU(98 ,7,	297000000U),
PLLGPU(49 ,3,	300000000U),
PLLGPU(100 ,7,	303000000U),
PLLGPU(37 ,2,	304000000U),
PLLGPU(50 ,3,	306000000U),
PLLGPU(102 ,7,	309000000U),
PLLGPU(51 ,3,	312000000U),
PLLGPU(104 ,7,	315000000U),
PLLGPU(52 ,3,	318000000U),
PLLGPU(39 ,2,	320000000U),
PLLGPU(106 ,7,	321000000U),
PLLGPU(53 ,3,	324000000U),
PLLGPU(108 ,7,	327000000U),
PLLGPU(40 ,2,	328000000U),
PLLGPU(54 ,3,	330000000U),
PLLGPU(110 ,7,	333000000U),
PLLGPU(55 ,3,	336000000U),
PLLGPU(112 ,7,	339000000U),
PLLGPU(56 ,3,	342000000U),
PLLGPU(114 ,7,	345000000U),
PLLGPU(57 ,3,	348000000U),
PLLGPU(116 ,7,	351000000U),
PLLGPU(58 ,3,	354000000U),
PLLGPU(118 ,7,	357000000U),
PLLGPU(59 ,3,	360000000U),
PLLGPU(120 ,7,	363000000U),
PLLGPU(60 ,3,	366000000U),
PLLGPU(122 ,7,	369000000U),
PLLGPU(61 ,3,	372000000U),
PLLGPU(124 ,7,	375000000U),
PLLGPU(62 ,3,	378000000U),
PLLGPU(126 ,7,	381000000U),
PLLGPU(63 ,3,	384000000U),
PLLGPU(64 ,3,	390000000U),
PLLGPU(65 ,3,	396000000U),
PLLGPU(66 ,3,	402000000U),
PLLGPU(33 ,1,	408000000U),
PLLGPU(68 ,3,	414000000U),
PLLGPU(69 ,3,	420000000U),
PLLGPU(70 ,3,	426000000U),
PLLGPU(71 ,3,	432000000U),
PLLGPU(72 ,3,	438000000U),
PLLGPU(73 ,3,	444000000U),
PLLGPU(74 ,3,	450000000U),
PLLGPU(75 ,3,	456000000U),
PLLGPU(76 ,3,	462000000U),
PLLGPU(77 ,3,	468000000U),
PLLGPU(78 ,3,	474000000U),
PLLGPU(79 ,3,	480000000U),
PLLGPU(80 ,3,	486000000U),
PLLGPU(81 ,3,	492000000U),
PLLGPU(82 ,3,	498000000U),
PLLGPU(83 ,3,	504000000U),
PLLGPU(84 ,3,	510000000U),
PLLGPU(85 ,3,	516000000U),
PLLGPU(86 ,3,	522000000U),
PLLGPU(87 ,3,	528000000U),
PLLGPU(88 ,3,	534000000U),
PLLGPU(89 ,3,	540000000U),
PLLGPU(90 ,3,	546000000U),
PLLGPU(91 ,3,	552000000U),
PLLGPU(92 ,3,	558000000U),
PLLGPU(93 ,3,	564000000U),
PLLGPU(94 ,3,	570000000U),
PLLGPU(95 ,3,	576000000U),
PLLGPU(96 ,3,	582000000U),
PLLGPU(97 ,3,	588000000U),
PLLGPU(98 ,3,	594000000U),
PLLGPU(99 ,3,	600000000U),
PLLGPU(100 ,3,	606000000U),
PLLGPU(101 ,3,	612000000U),
PLLGPU(102 ,3,	618000000U),
PLLGPU(103 ,3,	624000000U),
PLLGPU(104 ,3,	630000000U),
PLLGPU(105 ,3,	636000000U),
PLLGPU(106 ,3,	642000000U),
PLLGPU(107 ,3,	648000000U),
PLLGPU(108 ,3,	654000000U),
PLLGPU(109 ,3,	660000000U),
PLLGPU(110 ,3,	666000000U),
PLLGPU(111 ,3,	672000000U),
PLLGPU(112 ,3,	678000000U),
PLLGPU(113 ,3,	684000000U),
PLLGPU(114 ,3,	690000000U),
PLLGPU(115 ,3,	696000000U),
PLLGPU(116 ,3,	702000000U),
PLLGPU(117 ,3,	708000000U),
PLLGPU(118 ,3,	714000000U),
PLLGPU(119 ,3,	720000000U),
PLLGPU(120 ,3,	726000000U),
PLLGPU(121 ,3,	732000000U),
PLLGPU(122 ,3,	738000000U),
PLLGPU(123 ,3,	744000000U),
PLLGPU(124 ,3,	750000000U),
PLLGPU(125 ,3,	756000000U),
PLLGPU(126 ,3,	762000000U),
PLLGPU(127 ,3,	768000000U),
PLLGPU(32 ,0,	792000000U),
PLLGPU(33 ,0,	816000000U),
PLLGPU(34 ,0,	840000000U),
PLLGPU(35 ,0,	864000000U),
PLLGPU(36 ,0,	888000000U),
};
//n,m,freq
struct sunxi_clk_factor_freq factor_pllhsic_tbl[] = {
PLLHSIC(19	,3,	120000000U),
PLLHSIC(20	,3,	126000000U),
PLLHSIC(15	,2,	128000000U),
PLLHSIC(10	,1,	132000000U),
PLLHSIC(16	,2,	136000000U),
PLLHSIC(22	,3,	138000000U),
PLLHSIC(11	,1,	144000000U),
PLLHSIC(24	,3,	150000000U),
PLLHSIC(18	,2,	152000000U),
PLLHSIC(12	,1,	156000000U),
PLLHSIC(52	,7,	159000000U),
PLLHSIC(19	,2,	160000000U),
PLLHSIC(26	,3,	162000000U),
PLLHSIC(54	,7,	165000000U),
PLLHSIC(13	,1,	168000000U),
PLLHSIC(56	,7,	171000000U),
PLLHSIC(28	,3,	174000000U),
PLLHSIC(21	,2,	176000000U),
PLLHSIC(58	,7,	177000000U),
PLLHSIC(29	,3,	180000000U),
PLLHSIC(60	,7,	183000000U),
PLLHSIC(22	,2,	184000000U),
PLLHSIC(30	,3,	186000000U),
PLLHSIC(62	,7,	189000000U),
PLLHSIC(31	,3,	192000000U),
PLLHSIC(64	,7,	195000000U),
PLLHSIC(32	,3,	198000000U),
PLLHSIC(24	,2,	200000000U),
PLLHSIC(66	,7,	201000000U),
PLLHSIC(33	,3,	204000000U),
PLLHSIC(68	,7,	207000000U),
PLLHSIC(25	,2,	208000000U),
PLLHSIC(34	,3,	210000000U),
PLLHSIC(70	,7,	213000000U),
PLLHSIC(35	,3,	216000000U),
PLLHSIC(72	,7,	219000000U),
PLLHSIC(36	,3,	222000000U),
PLLHSIC(27	,2,	224000000U),
PLLHSIC(74	,7,	225000000U),
PLLHSIC(37	,3,	228000000U),
PLLHSIC(76	,7,	231000000U),
PLLHSIC(28	,2,	232000000U),
PLLHSIC(38	,3,	234000000U),
PLLHSIC(78	,7,	237000000U),
PLLHSIC(39	,3,	240000000U),
PLLHSIC(80	,7,	243000000U),
PLLHSIC(40	,3,	246000000U),
PLLHSIC(30	,2,	248000000U),
PLLHSIC(82	,7,	249000000U),
PLLHSIC(41	,3,	252000000U),
PLLHSIC(84	,7,	255000000U),
PLLHSIC(31	,2,	256000000U),
PLLHSIC(42	,3,	258000000U),
PLLHSIC(86	,7,	261000000U),
PLLHSIC(43	,3,	264000000U),
PLLHSIC(88	,7,	267000000U),
PLLHSIC(44	,3,	270000000U),
PLLHSIC(33	,2,	272000000U),
PLLHSIC(90	,7,	273000000U),
PLLHSIC(45	,3,	276000000U),
PLLHSIC(92	,7,	279000000U),
PLLHSIC(34	,2,	280000000U),
PLLHSIC(46	,3,	282000000U),
PLLHSIC(94	,7,	285000000U),
PLLHSIC(47	,3,	288000000U),
PLLHSIC(96	,7,	291000000U),
PLLHSIC(48	,3,	294000000U),
PLLHSIC(36	,2,	296000000U),
PLLHSIC(98	,7,	297000000U),
PLLHSIC(49	,3,	300000000U),
PLLHSIC(100	,7,	303000000U),
PLLHSIC(37	,2,	304000000U),
PLLHSIC(50	,3,	306000000U),
PLLHSIC(102	,7,	309000000U),
PLLHSIC(51	,3,	312000000U),
PLLHSIC(104	,7,	315000000U),
PLLHSIC(52	,3,	318000000U),
PLLHSIC(39	,2,	320000000U),
PLLHSIC(106	,7,	321000000U),
PLLHSIC(53	,3,	324000000U),
PLLHSIC(108	,7,	327000000U),
PLLHSIC(40	,2,	328000000U),
PLLHSIC(54	,3,	330000000U),
PLLHSIC(110	,7,	333000000U),
PLLHSIC(55	,3,	336000000U),
PLLHSIC(112	,7,	339000000U),
PLLHSIC(56	,3,	342000000U),
PLLHSIC(114	,7,	345000000U),
PLLHSIC(57	,3,	348000000U),
PLLHSIC(116	,7,	351000000U),
PLLHSIC(58	,3,	354000000U),
PLLHSIC(118	,7,	357000000U),
PLLHSIC(59	,3,	360000000U),
PLLHSIC(120	,7,	363000000U),
PLLHSIC(60	,3,	366000000U),
PLLHSIC(122	,7,	369000000U),
PLLHSIC(61	,3,	372000000U),
PLLHSIC(124	,7,	375000000U),
PLLHSIC(62	,3,	378000000U),
PLLHSIC(126	,7,	381000000U),
PLLHSIC(63	,3,	384000000U),
PLLHSIC(64	,3,	390000000U),
PLLHSIC(65	,3,	396000000U),
PLLHSIC(66	,3,	402000000U),
PLLHSIC(67	,3,	408000000U),
PLLHSIC(68	,3,	414000000U),
PLLHSIC(69	,3,	420000000U),
PLLHSIC(70	,3,	426000000U),
PLLHSIC(71	,3,	432000000U),
PLLHSIC(72	,3,	438000000U),
PLLHSIC(73	,3,	444000000U),
PLLHSIC(74	,3,	450000000U),
PLLHSIC(75	,3,	456000000U),
PLLHSIC(76	,3,	462000000U),
PLLHSIC(77	,3,	468000000U),
PLLHSIC(78	,3,	474000000U),
PLLHSIC(79	,3,	480000000U),
PLLHSIC(80	,3,	486000000U),
PLLHSIC(81	,3,	492000000U),
PLLHSIC(82	,3,	498000000U),
PLLHSIC(83	,3,	504000000U),
PLLHSIC(84	,3,	510000000U),
PLLHSIC(85	,3,	516000000U),
PLLHSIC(86	,3,	522000000U),
PLLHSIC(87	,3,	528000000U),
PLLHSIC(88	,3,	534000000U),
PLLHSIC(89	,3,	540000000U),
PLLHSIC(90	,3,	546000000U),
PLLHSIC(91	,3,	552000000U),
PLLHSIC(92	,3,	558000000U),
PLLHSIC(93	,3,	564000000U),
PLLHSIC(94	,3,	570000000U),
PLLHSIC(95	,3,	576000000U),
PLLHSIC(96	,3,	582000000U),
PLLHSIC(97	,3,	588000000U),
PLLHSIC(98	,3,	594000000U),
PLLHSIC(99	,3,	600000000U),
PLLHSIC(100	,3,	606000000U),
PLLHSIC(101	,3,	612000000U),
PLLHSIC(102	,3,	618000000U),
PLLHSIC(103	,3,	624000000U),
PLLHSIC(104	,3,	630000000U),
PLLHSIC(105	,3,	636000000U),
PLLHSIC(106	,3,	642000000U),
PLLHSIC(107	,3,	648000000U),
PLLHSIC(108	,3,	654000000U),
PLLHSIC(109	,3,	660000000U),
PLLHSIC(110	,3,	666000000U),
PLLHSIC(111	,3,	672000000U),
PLLHSIC(112	,3,	678000000U),
PLLHSIC(113	,3,	684000000U),
PLLHSIC(114	,3,	690000000U),
PLLHSIC(115	,3,	696000000U),
PLLHSIC(116	,3,	702000000U),
PLLHSIC(117	,3,	708000000U),
PLLHSIC(118	,3,	714000000U),
PLLHSIC(119	,3,	720000000U),
PLLHSIC(120	,3,	726000000U),
PLLHSIC(121	,3,	732000000U),
PLLHSIC(122	,3,	738000000U),
PLLHSIC(123	,3,	744000000U),
PLLHSIC(124	,3,	750000000U),
PLLHSIC(125	,3,	756000000U),
PLLHSIC(126	,3,	762000000U),
PLLHSIC(127	,3,	768000000U),
PLLHSIC(32	,0,	792000000U),
PLLHSIC(33	,0,	816000000U),
PLLHSIC(34	,0,	840000000U),
PLLHSIC(35	,0,	864000000U),
PLLHSIC(36	,0,	888000000U),
};
//n,m,freq
struct sunxi_clk_factor_freq factor_pllde_tbl[] = {
PLLDE(4 ,0, 120000000U),
PLLDE(15 ,2, 128000000U),
PLLDE(10 ,1, 132000000U),
PLLDE(16 ,2, 136000000U),
PLLDE(11 ,1, 144000000U),
PLLDE(24 ,3, 150000000U),
PLLDE(18 ,2, 152000000U),
PLLDE(12 ,1, 156000000U),
PLLDE(19 ,2, 160000000U),
PLLDE(26 ,3, 162000000U),
PLLDE(13 ,1, 168000000U),
PLLDE(28 ,3, 174000000U),
PLLDE(21 ,2, 176000000U),
PLLDE(14 ,1, 180000000U),
PLLDE(22 ,2, 184000000U),
PLLDE(30 ,3, 186000000U),
PLLDE(15 ,1, 192000000U),
PLLDE(64 ,7, 195000000U),
PLLDE(32 ,3, 198000000U),
PLLDE(24 ,2, 200000000U),
PLLDE(66 ,7, 201000000U),
PLLDE(16 ,1, 204000000U),
PLLDE(68 ,7, 207000000U),
PLLDE(25 ,2, 208000000U),
PLLDE(34 ,3, 210000000U),
PLLDE(70 ,7, 213000000U),
PLLDE(17 ,1, 216000000U),
PLLDE(72 ,7, 219000000U),
PLLDE(36 ,3, 222000000U),
PLLDE(27 ,2, 224000000U),
PLLDE(74 ,7, 225000000U),
PLLDE(18 ,1, 228000000U),
PLLDE(76 ,7, 231000000U),
PLLDE(28 ,2, 232000000U),
PLLDE(38 ,3, 234000000U),
PLLDE(78 ,7, 237000000U),
PLLDE(19 ,1, 240000000U),
PLLDE(80 ,7, 243000000U),
PLLDE(40 ,3, 246000000U),
PLLDE(30 ,2, 248000000U),
PLLDE(82 ,7, 249000000U),
PLLDE(20 ,1, 252000000U),
PLLDE(84 ,7, 255000000U),
PLLDE(31 ,2, 256000000U),
PLLDE(42 ,3, 258000000U),
PLLDE(86 ,7, 261000000U),
PLLDE(21 ,1, 264000000U),
PLLDE(88 ,7, 267000000U),
PLLDE(44 ,3, 270000000U),
PLLDE(33 ,2, 272000000U),
PLLDE(90 ,7, 273000000U),
PLLDE(22 ,1, 276000000U),
PLLDE(92 ,7, 279000000U),
PLLDE(34 ,2, 280000000U),
PLLDE(46 ,3, 282000000U),
PLLDE(94 ,7, 285000000U),
PLLDE(23 ,1, 288000000U),
PLLDE(96 ,7, 291000000U),
PLLDE(48 ,3, 294000000U),
PLLDE(36 ,2, 296000000U),
PLLDE(98 ,7, 297000000U),
PLLDE(24 ,1, 300000000U),
PLLDE(100 ,7, 303000000U),
PLLDE(37 ,2, 304000000U),
PLLDE(50 ,3, 306000000U),
PLLDE(102 ,7, 309000000U),
PLLDE(25 ,1, 312000000U),
PLLDE(104 ,7, 315000000U),
PLLDE(52 ,3, 318000000U),
PLLDE(39 ,2, 320000000U),
PLLDE(106 ,7, 321000000U),
PLLDE(26 ,1, 324000000U),
PLLDE(108 ,7, 327000000U),
PLLDE(40 ,2, 328000000U),
PLLDE(54 ,3, 330000000U),
PLLDE(110 ,7, 333000000U),
PLLDE(27 ,1, 336000000U),
PLLDE(112 ,7, 339000000U),
PLLDE(56 ,3, 342000000U),
PLLDE(114 ,7, 345000000U),
PLLDE(28 ,1, 348000000U),
PLLDE(116 ,7, 351000000U),
PLLDE(58 ,3, 354000000U),
PLLDE(118 ,7, 357000000U),
PLLDE(29 ,1, 360000000U),
PLLDE(120 ,7, 363000000U),
PLLDE(60 ,3, 366000000U),
PLLDE(122 ,7, 369000000U),
PLLDE(30 ,1, 372000000U),
PLLDE(124 ,7, 375000000U),
PLLDE(62 ,3, 378000000U),
PLLDE(125 ,7, 378000000U),
PLLDE(126 ,7, 381000000U),
PLLDE(31 ,1, 384000000U),
PLLDE(64 ,3, 390000000U),
PLLDE(32 ,1, 396000000U),
PLLDE(66 ,3, 402000000U),
PLLDE(33 ,1, 408000000U),
PLLDE(68 ,3, 414000000U),
PLLDE(34 ,1, 420000000U),
PLLDE(70 ,3, 426000000U),
PLLDE(35 ,1, 432000000U),
PLLDE(72 ,3, 438000000U),
PLLDE(36 ,1, 444000000U),
PLLDE(74 ,3, 450000000U),
PLLDE(37 ,1, 456000000U),
PLLDE(76 ,3, 462000000U),
PLLDE(77 ,3, 468000000U),
PLLDE(78 ,3, 474000000U),
PLLDE(39 ,1, 480000000U),
PLLDE(80 ,3, 486000000U),
PLLDE(40 ,1, 492000000U),
PLLDE(82 ,3, 498000000U),
PLLDE(41 ,1, 504000000U),
PLLDE(84 ,3, 510000000U),
PLLDE(85 ,3, 516000000U),
PLLDE(86 ,3, 522000000U),
PLLDE(87 ,3, 528000000U),
PLLDE(88 ,3, 534000000U),
PLLDE(89 ,3, 540000000U),
PLLDE(90 ,3, 546000000U),
PLLDE(91 ,3, 552000000U),
PLLDE(92 ,3, 558000000U),
PLLDE(93 ,3, 564000000U),
PLLDE(94 ,3, 570000000U),
PLLDE(23 ,0, 576000000U),
PLLDE(96 ,3, 582000000U),
PLLDE(97 ,3, 588000000U),
PLLDE(98 ,3, 594000000U),
PLLDE(24 ,0, 600000000U),
PLLDE(100 ,3, 606000000U),
PLLDE(101 ,3, 612000000U),
PLLDE(102 ,3, 618000000U),
PLLDE(25 ,0, 624000000U),
PLLDE(104 ,3, 630000000U),
PLLDE(105 ,3, 636000000U),
PLLDE(106 ,3, 642000000U),
PLLDE(26 ,0, 648000000U),
PLLDE(108 ,3, 654000000U),
PLLDE(109 ,3, 660000000U),
PLLDE(110 ,3, 666000000U),
PLLDE(27 ,0, 672000000U),
PLLDE(112 ,3, 678000000U),
PLLDE(113 ,3, 684000000U),
PLLDE(114 ,3, 690000000U),
PLLDE(28 ,0, 696000000U),
PLLDE(116 ,3, 702000000U),
PLLDE(117 ,3, 708000000U),
PLLDE(118 ,3, 714000000U),
PLLDE(29 ,0, 720000000U),
PLLDE(120 ,3, 726000000U),
PLLDE(121 ,3, 732000000U),
PLLDE(122 ,3, 738000000U),
PLLDE(30 ,0, 744000000U),
PLLDE(124 ,3, 750000000U),
PLLDE(125 ,3, 756000000U),
PLLDE(126 ,3, 762000000U),
PLLDE(31 ,0, 768000000U),
PLLDE(32 ,0, 792000000U),
PLLDE(33 ,0, 816000000U),
PLLDE(34 ,0, 840000000U),
PLLDE(35 ,0, 864000000U),
PLLDE(36 ,0, 888000000U),
};


static unsigned int pllcpu0_max , pllcpu1_max ,pllvideo_max;
static unsigned int pllve_max,pllddr0_max;
static unsigned int pllperiph0_max, pllperiph1_max , pllgpu_max;
static unsigned int pllhsic_max,pllde_max,pllddr1_max;
static unsigned int pll24m_max;

#define tbl_max_freq(tbl)   tbl[ARRAY_SIZE(tbl)-1].freq
#define set_max_freq_tbl(pllname)  pllname##_max= tbl_max_freq(factor_##pllname##_tbl)

void sunxi_clk_factor_initlimits(void)
{
    pllcpu0_max= tbl_max_freq(factor_pllcpu0_tbl);
    pllcpu1_max= tbl_max_freq(factor_pllcpu1_tbl);
    pllvideo_max= tbl_max_freq(factor_pllvideo_tbl);
    pllve_max= tbl_max_freq(factor_pllve_tbl);
    pllddr0_max= tbl_max_freq(factor_pllddr0_tbl);
    pllperiph0_max= tbl_max_freq(factor_pllperiph0_tbl);
    pllperiph1_max= tbl_max_freq(factor_pllperiph1_tbl);
    pllgpu_max= tbl_max_freq(factor_pllgpu_tbl);
    pllhsic_max= tbl_max_freq(factor_pllhsic_tbl);
    pllde_max= tbl_max_freq(factor_pllde_tbl);
    pllddr1_max= tbl_max_freq(factor_pllddr1_tbl);
    pll24m_max = tbl_max_freq(factor_pll24m_tbl);
}