/*
************************************************************************************************************************
*                                                      eNand
*                                     Nand flash driver logic control module define
*
*                             Copyright(C), 2008-2009, SoftWinners Microelectronic Co., Ltd.
*											       All Rights Reserved
*
* File Name : bsp_nand.h
*
* Author : Kevin.z
*
* Version : v0.1
*
* Date : 2008.03.25
*
* Description : This file define the function interface and some data structure export
*               for the nand bsp.
*
* Others : None at present.
*
*
* History :
*
*  <Author>        <time>       <version>      <description>
*
* Kevin.z         2008.03.25      0.1          build the file
*
************************************************************************************************************************
*/
#ifndef __BSP_NAND_H__
#define __BSP_NAND_H__

#include "nand_type.h"

/*for partition*/
#define MAX_PART_COUNT_PER_FTL 24
#define MAX_PARTITION          4
#define ND_MAX_PARTITION_COUNT      (MAX_PART_COUNT_PER_FTL*MAX_PARTITION)

typedef struct boot_flash_info {
	__u32 chip_cnt;
	__u32 blk_cnt_per_chip;
	__u32 blocksize;
	__u32 pagesize;
	__u32 pagewithbadflag;	/*the 1st byte of spare area of this page */
} boot_flash_info_t;

struct boot_physical_param {
	__u32 chip;		/*chip no*/
	__u32 block;		/* block no within chip*/
	__u32 page;		/* apge no within block*/
	__u32 sectorbitmap;	/*done't care*/
	void *mainbuf;		/*data buf*/
	void *oobbuf;		/*oob buf*/
};

#define PARTITION_NAME_SIZE  16

struct _nand_disk {
	unsigned int size;
	unsigned int type;
	unsigned char name[PARTITION_NAME_SIZE];
};

struct _nand_phy_partition {
	void *dat;
};

struct _nftl_blk {
	unsigned int nftl_logic_size;
	struct _nand_partition *nand;
	struct _nftl_blk *nftl_blk_next;
	void *nftl_zone;
	void *cfg;
	unsigned int time;
	unsigned int ops_time;	/* add ecape time for ops nftl */
	unsigned int time_flush;
	void *nftl_thread;
	void *blk_lock;
	int (*read_data) (struct _nftl_blk *nftl_blk, unsigned int sector,
			  unsigned int len, unsigned char *buf);
	int (*write_data) (struct _nftl_blk *nftl_blk, unsigned int sector,
			   unsigned int len, unsigned char *buf);
	int (*flush_write_cache) (struct _nftl_blk *nftl_blk,
				  unsigned int num);
	int (*discard) (struct _nftl_blk *nftl_blk, unsigned int sector,
			unsigned int len);
	int (*shutdown_op) (struct _nftl_blk *nftl_blk);
	int (*read_sector_data) (struct _nftl_blk *nftl_blk,
				 unsigned int sector, unsigned int len,
				 unsigned char *buf);
	int (*write_sector_data) (struct _nftl_blk *nftl_blk,
				  unsigned int sector, unsigned int len,
				  unsigned char *buf);
	int (*flush_sector_write_cache) (struct _nftl_blk *nftl_blk,
					 unsigned int num);
};

extern __s32 PHY_SimpleErase(struct boot_physical_param *eraseop);
extern __s32 PHY_SimpleErase_2CH(struct boot_physical_param *eraseop);
extern __s32 PHY_SimpleErase_CurCH(struct boot_physical_param *eraseop);
extern __s32 PHY_SimpleRead(struct boot_physical_param *readop);
extern __s32 PHY_SimpleRead_CurCH(struct boot_physical_param *readop);
extern __s32 PHY_SimpleRead_2CH(struct boot_physical_param *readop);
extern __s32 PHY_SimpleWrite(struct boot_physical_param *writeop);
extern __s32 PHY_SimpleWrite_CurCH(struct boot_physical_param *writeop);
extern __s32 PHY_SimpleWrite_1K(struct boot_physical_param *writeop);
extern __s32 PHY_SimpleWrite_1KCurCH(struct boot_physical_param *writeop);
extern __s32 PHY_SimpleWrite_Seq(struct boot_physical_param *writeop);
extern __s32 PHY_SimpleRead_Seq(struct boot_physical_param *readop);
extern __s32 PHY_SimpleRead_1K(struct boot_physical_param *readop);
extern __s32 PHY_SimpleRead_1KCurCH(struct boot_physical_param *readop);
extern __s32 PHY_WaitAllRbReady(void);
extern int nand_uboot_erase_all_chip(void);

extern __s32 NFC_LSBEnable(__u32 chip, __u32 read_retry_type);
extern __s32 NFC_LSBDisable(__u32 chip, __u32 read_retry_type);
extern __s32 NFC_LSBInit(__u32 read_retry_type);
extern __s32 NFC_LSBExit(__u32 read_retry_type);
extern __u32 NAND_GetChannelCnt(void);

extern void ClearNandStruct(void);

/*for param get&set*/
extern __u32 NAND_GetFrequencePar(void);
extern __s32 NAND_SetFrequencePar(__u32 FrequencePar);
extern __u32 NAND_GetNandVersion(void);
extern __s32 NAND_GetFlashInfo(boot_flash_info_t *info);

extern __s32 NAND_DragonboardTest(void);

struct _nand_info *NandHwInit(void);
__s32 NandHwExit(void);
__s32 NandHwSuperStandby(void);
__s32 NandHwSuperResume(void);
__s32 NandHwNormalStandby(void);
__s32 NandHwNormalResume(void);
__s32 NandHwShutDown(void);

/*for NFTL*/
int nftl_initialize(struct _nftl_blk *nftl_blk, int no);
extern int nand_info_init(struct _nand_info *nand_info, unsigned char chip,
			  uint16 start_block, unsigned char *mbr_data);

#endif
