#ifndef UBOOT_HEAD
#define UBOOT_HEAD

#define MAGIC_NORMAL_UBOOT		"uboot"
#define MAGIC_SECURE_UBOOT		0x89119800
#define PHY_INFO_SIZE			0x8000
#define PHY_INFO_MAGIC			0xaa55a5a5
#define UBOOT_STAMP_VALUE		0xAE15BC34


#define UBOOT_START_BLOCK		    4
#define UBOOT_MAX_BLOCK_NUM			40
//#define UBOOT_BLOCK_NUM			30
/*
struct _boot_info{
	unsigned int magic;
	unsigned int len;
	unsigned int sum;

    unsigned int  data[8192-12];

};
*/
/******************************************************************************/
/*               the control information stored in file head                  */
/******************************************************************************/
struct normal_uboot_head_info
{
	unsigned int  jump_instruction;   // one intruction jumping to real code
	unsigned char magic[8];  		  // ="u-boot"
	unsigned int  check_sum;          // generated by PC
	unsigned int  align_size;		  // align size in byte
	unsigned int  length;             // the size of all file
	unsigned int  uboot_length;       // the size of uboot
	unsigned char version[8];         // uboot version
	unsigned char platform[8];        // platform information
	int           reserved[1];        //stamp space, 16bytes align
};

struct secure_uboot_head_info
{
	char name[16]	;	//user can modify
	unsigned int  magic	;	//must equal TOC_U32_MAGIC
	unsigned int  add_sum	;

	unsigned int  serial_num	;	//user can modify
	unsigned int  status		;	//user can modify,such as TOC_MAIN_INFO_STATUS_ENCRYP_NOT_USED

	unsigned int  items_nr;	//total entry number
	unsigned int  valid_len;
	unsigned int  reserved[5];	//reserved for future
	unsigned int  end;
};


struct _uboot_info
{
	unsigned int  sys_mode;
	unsigned int  use_lsb_page;
	unsigned int  copys;

	unsigned int  uboot_len;
	unsigned int  total_len;
	unsigned int  uboot_pages;
	unsigned int  total_pages;

	unsigned int  blocks_per_total;
	unsigned int  page_offset_for_nand_info;
	unsigned int  byte_offset_for_nand_info;
	unsigned int  uboot_block[30];

	unsigned int  nboot_copys;
	unsigned int  nboot_len;
	unsigned int  nboot_data_per_page;
	
};

#endif

