/*
************************************************************************************************************************
*                                                         eGON
*                                         the Embedded GO-ON Bootloader System
*
*                             Copyright(C), 2006-2008, SoftWinners Microelectronic Co., Ltd.
*											       All Rights Reserved
*
* File Name   : boo1.h
*
* Author      : Gary.Wang
*
* Version     : 1.1.0
*
* Date        : 2009.05.21
*
* Description :
*
* Others      : None at present.
*
*
* History     :
*
*  <Author>        <time>       <version>      <description>
*
* Gary.Wang      2009.05.21       1.1.0        build the file
*
************************************************************************************************************************
*/
#ifndef  __boo1_h
#define  __boo1_h


#include "boot0_v2.h"

typedef struct _boot_core_para_t
{
    unsigned int  user_set_clock;                 // Ƶ Mλ
    unsigned int  user_set_core_vol;              // ĵѹ mVλ
    unsigned int  vol_threshold;                  // ޵ѹ
}
boot_core_para_t;
/******************************************************************************/
/*                              file head of Boot1                            */
/******************************************************************************/
typedef struct _boot1_private_head_t
{
	unsigned int                dram_para[32];
	int							run_clock;				// Mhz
	int							run_core_vol;			// mV
	int							uart_port;              // UART
	normal_gpio_cfg             uart_gpio[2];           // UART(Դӡ)GPIOϢ
	int							twi_port;               // TWI
	normal_gpio_cfg             twi_gpio[2];            // TWIGPIOϢڿTWI
	int		                    work_mode;              // ģʽ
    int                         storage_type;           // 洢  0nand   1sdcard    2: spinor
    normal_gpio_cfg             nand_gpio[32];          // nand GPIOϢ
    char						nand_spare_data[256];	// nand Ϣ
    normal_gpio_cfg             sdcard_gpio[32];		// sdcard GPIOϢ
    char             			sdcard_spare_data[256];	// sdcard Ϣ
    int							reserved[6];			// λ, 256bytes align
}boot1_private_head_t;

typedef struct _Boot_file_head
{
	unsigned int  jump_instruction;   // one intruction jumping to real code
	unsigned char magic[8];  // ="u-boot"
	unsigned int  check_sum;          // generated by PC
	unsigned int  align_size;		  // align size in byte
	unsigned int  length;             // the size of all file
	unsigned int  uboot_length;       // the size of uboot
	unsigned char version[8];         // uboot version
	unsigned char platform[8];        // platform information
	int           reserved[1];        //stamp space, 16bytes align
}boot_file_head_t;


typedef struct _boot1_file_head_t
{
	boot_file_head_t      boot_head;
	boot1_private_head_t  prvt_head;
}boot1_file_head_t;


#endif     //  ifndef __boo1_h

/* end of boo1.h */
