/*
*************************************************************************************
*                         			eBsp
*					   Operation System Adapter Layer
*
*				(c) Copyright 2006-2010, All winners Co,Ld.
*							All	Rights Reserved
*
* File Name 	: OSAL_Dma.h
*
* Author 		: javen
*
* Description 	: Dma
*
* History 		:
*      <author>    		<time>       	<version >    		<desc>
*       javen     	   	2010-09-07          1.0         create this word
*		holi			2010-12-04			1.1			Ĳ֣ȫCSP_para·
*************************************************************************************
*/
#ifndef  __OSAL_DMA_H__
#define  __OSAL_DMA_H__



//---------------------------------------------------------------
//   
//---------------------------------------------------------------

typedef __s32 (*DmaCallback)( void *pArg);

/*
*******************************************************************************
*                     OSAL_DmaRequest
*
* Description:
*    DMAͨ
*
* Parameters:
*	 user_name 	:	ģͳ
*    DmaType  	:  	input. DMA͡Normal or Dedicated
* 
* Return value:
*    ɹDMAʧܷNULL
*
* note:
*    void
*
*******************************************************************************
*/
__hdle OSAL_DmaRequest(u8 * user_name ,__u32 DmaType);

/*
*******************************************************************************
*                     OSAL_DmaRelease
*
* Description:
*    DMAͨ
*
* Parameters:
*    hDMA  input. cspRequestDmaľ
* 
* Return value:
*    ɹEBSP_OKʧܷEBSP_FAIL
*
* note:
*    void
*
*******************************************************************************
*/
__s32 OSAL_DmaRelease(__hdle hDMA);


/*
*******************************************************************************
*                     OSAL_DmaEnableINT
*
* Description:
*    ʹDMAж
*
* Parameters:
*    hDMA 	    :  input. cspRequestDmaľ
*    IrqType    :  input. ͡end_irq or half_irq
* 
* Return value:
*    void
*
* note:
*    void
*
*******************************************************************************
*/
__s32 OSAL_DmaEnableINT(__hdle hDMA, __s32 IrqType);

/*
*******************************************************************************
*                     OSAL_DmaDisableINT
*
* Description:
*    ֹDMAж
*
* Parameters:
*    hDMA 	    :  input. cspRequestDmaľ
*    IrqType    :  input. ͡end_irq or half_irq
* 
* Return value:
*    void
*
* note:
*    void
*
*******************************************************************************
*/
__s32 OSAL_DmaDisableINT(__hdle hDMA, __s32 IrqType);

/*
*******************************************************************************
*                     eBsp_DmaRegIrq
*
* Description:
*    עжϴ
*
* Parameters:
*    hDMA 	    :  input. cspRequestDmaľ
*    IrqType    :  input. ж͡end_irq or half_irq
*    pCallBack  :  input. жϻص
*    pArg		:  input. жϻصĲ
* 
* Return value:
*    ɹDMAʧܷNULL
*
* note:
*    صԭͣtypedef void (*DmaCallback)(void *pArg);
*
*******************************************************************************
*/
__s32 OSAL_DmaRegIrq(__hdle hDMA, __u32 IrqType, DmaCallback pCallBack, void *pArg); 

/*
*******************************************************************************
*                     FunctionName
*
* Description:
*    עжϴ
*
* Parameters:
*    hDMA 	    :  input. cspRequestDmaľ
*    IrqType    :  input. ͡end_irq or half_irq
*    pCallBack  :  input. жϻص
* 
* Return value:
*    ɹDMAʧܷNULL
*
* note:
*    void
*
*******************************************************************************
*/
__s32 OSAL_DmaUnRegIrq(__hdle hDMA, __u32 IrqType, DmaCallback pCallBack);

/*
*******************************************************************************
*                     OSAL_DmaConfig
*
* Description:
*    DMA ͨá
*
* Parameters:
*    hDMA 	     :  input. cspRequestDmaľ
*    p_cfg       :  input.  DMAá,ʵݽṹstruct CSP_dma_config{}
* 
* Return value:
*    ɹEBSP_OKʧܷEBSP_FAIL
*
* note:
*    void
*
*******************************************************************************
*/
__s32 OSAL_DmaConfig(__hdle hDMA, void * p_cfg);

/*
*******************************************************************************
*                     OSAL_DmaStart
*
* Description:
*    ʼ DMA 䡣
*
* Parameters:
*    hDMA 	 		 :  input. cspRequestDmaľ
*    SrcAddr		 :  input. Դַ
*    DestAddr		 :  input. Ŀַ
*    TransferLength  :  input. 䳤
* 
* Return value:
*    ɹEBSP_OKʧܷEBSP_FAIL
*
* note:
*    void
*
*******************************************************************************
*/
__s32 OSAL_DmaStart(__hdle hDMA, __u32 SrcAddr, __u32 DestAddr, __u32 TransferLength);

/*
*******************************************************************************
*                     OSAL_DmaStop
*
* Description:
*    ֹͣDMA 䡣
*
* Parameters:
*    hDMA  input. cspRequestDmaľ
* 
* Return value:
*    ɹEBSP_OKʧܷEBSP_FAIL
*
* note:
*    void
*
*******************************************************************************
*/
__s32 OSAL_DmaStop(__hdle hDMA);

/*
*******************************************************************************
*                     OSAL_DmaRestart
*
* Description:
*    һDMA䡣
*
* Parameters:
*    hDMA 	 input. cspRequestDmaľ
* 
* Return value:
*    ɹEBSP_OKʧܷEBSP_FAIL
*
* note:
*    void
*
*******************************************************************************
*/
__s32 OSAL_DmaRestart(__hdle hDMA);

/*
*******************************************************************************
*                     OSAL_DmaQueryChannelNo
*
* Description:
*    ѯDMAͨš
*
* Parameters:
*    hDMA   input. cspRequestDmaľ
* 
* Return value:
*    DMAͨš
*
* note:
*    void
*
*******************************************************************************
*/
__u32 OSAL_DmaQueryChannelNo(__hdle hDMA);

/*
*******************************************************************************
*                     OSAL_DmaQueryStatus
*
* Description:
*    ѯDMAͨ״̬Busy or Idle
*
* Parameters:
*    hDMA  input. cspRequestDmaľ
* 
* Return value:
*    صǰDMAͨ״̬1busy0idle
*
* note:
*    void
*
*******************************************************************************
*/
__u32 OSAL_DmaQueryStatus(__hdle hDMA);

/*
*******************************************************************************
*                     OSAL_DmaQueryLeftCount
*
* Description:
*    ѯDMAʣֽ
*
* Parameters:
*    hDMA  :  input. cspRequestDmaľ
* 
* Return value:
*    صǰDMAʣֽ
*
* note:
*    void
*
*******************************************************************************
*/
__u32 OSAL_DmaQueryLeftCount(__hdle hDMA);

/*
*******************************************************************************
*                     OSAL_DmaQueryConfig
*
* Description:
*    ѯDMAͨá
*
* Parameters:
*    hDMA 	   :  input. cspRequestDmaľ
*    RegAddr   :  input. Ĵַ
*    RegWidth  :  input. Ĵ
*    RegValue  :  output. Ĵֵ
* 
* Return value:
*    ɹEBSP_OKʧܷEBSP_FAIL
*
* note:
*    void
*
*******************************************************************************
*/
__s32 OSAL_DmaQueryConfig(__hdle hDMA, __u32 RegAddr, __u32 RegWidth, __u32 *RegValue);

/*
*******************************************************************************
*                     eBsp_DmaPause
*
* Description:
*    ͣDMA䡣
*
* Parameters:
*    hDMA   input. cspRequestDmaľ
* 
* Return value:
*    ɹEBSP_OKʧܷEBSP_FAIL
*
* note:
*    void
*
*******************************************************************************
*/
__s32 OSAL_DmaPause(__hdle hDMA);

/*
*******************************************************************************
*                     eBsp_DmaProceed
*
* Description:
*    csp_DmaPause ͣDMA䡣
*
* Parameters:
*    hDMA   input. cspRequestDmaľ
* 
* Return value:
*    ɹEBSP_OKʧܷEBSP_FAIL
*
* note:
*    void
*
*******************************************************************************
*/
__s32 OSAL_DmaProceed(__hdle hDMA);

/*
*******************************************************************************
*                     OSAL_DmaChangeMode
*
* Description:
*    л DMA Ĵģʽ
*
* Parameters:
*    hDMA   input. cspRequestDmaľ
*    mode  :  input. ģʽ
* 
* Return value:
*    void
*
* note:
*    void
*
*******************************************************************************
*/
__s32 OSAL_DmaChangeMode(__hdle hDMA, __s32 mode);

#endif   //__OSAL_DMA_H__

