/*
 * Allwinner A1X SoCs pinctrl driver.
 *
 * Copyright (C) 2012 Maxime Ripard
 *
 * Maxime Ripard <maxime.ripard@free-electrons.com>
 *
 * This file is licensed under the terms of the GNU General Public
 * License version 2.  This program is licensed "as is" without any
 * warranty of any kind, whether express or implied.
 */

#ifndef __PINCTRL_SUNXI_H
#define __PINCTRL_SUNXI_H

#include <linux/kernel.h>
#include <linux/irq.h>
#include <linux/irqdesc.h>
#include <linux/irqdomain.h>
#include <mach/gpio.h>

#define SUNXI_PINCTRL_PIN_PA0	PINCTRL_PIN(SUNXI_PA_BASE + 0,  "PA0")
#define SUNXI_PINCTRL_PIN_PA1	PINCTRL_PIN(SUNXI_PA_BASE + 1,  "PA1")
#define SUNXI_PINCTRL_PIN_PA2	PINCTRL_PIN(SUNXI_PA_BASE + 2,  "PA2")
#define SUNXI_PINCTRL_PIN_PA3	PINCTRL_PIN(SUNXI_PA_BASE + 3,  "PA3")
#define SUNXI_PINCTRL_PIN_PA4	PINCTRL_PIN(SUNXI_PA_BASE + 4,  "PA4")
#define SUNXI_PINCTRL_PIN_PA5	PINCTRL_PIN(SUNXI_PA_BASE + 5,  "PA5")
#define SUNXI_PINCTRL_PIN_PA6	PINCTRL_PIN(SUNXI_PA_BASE + 6,  "PA6")
#define SUNXI_PINCTRL_PIN_PA7	PINCTRL_PIN(SUNXI_PA_BASE + 7,  "PA7")
#define SUNXI_PINCTRL_PIN_PA8	PINCTRL_PIN(SUNXI_PA_BASE + 8,  "PA8")
#define SUNXI_PINCTRL_PIN_PA9	PINCTRL_PIN(SUNXI_PA_BASE + 9,  "PA9")
#define SUNXI_PINCTRL_PIN_PA10	PINCTRL_PIN(SUNXI_PA_BASE + 10, "PA10")
#define SUNXI_PINCTRL_PIN_PA11	PINCTRL_PIN(SUNXI_PA_BASE + 11, "PA11")
#define SUNXI_PINCTRL_PIN_PA12	PINCTRL_PIN(SUNXI_PA_BASE + 12, "PA12")
#define SUNXI_PINCTRL_PIN_PA13	PINCTRL_PIN(SUNXI_PA_BASE + 13, "PA13")
#define SUNXI_PINCTRL_PIN_PA14	PINCTRL_PIN(SUNXI_PA_BASE + 14, "PA14")
#define SUNXI_PINCTRL_PIN_PA15	PINCTRL_PIN(SUNXI_PA_BASE + 15, "PA15")
#define SUNXI_PINCTRL_PIN_PA16	PINCTRL_PIN(SUNXI_PA_BASE + 16, "PA16")
#define SUNXI_PINCTRL_PIN_PA17	PINCTRL_PIN(SUNXI_PA_BASE + 17, "PA17")
#define SUNXI_PINCTRL_PIN_PA18	PINCTRL_PIN(SUNXI_PA_BASE + 18, "PA18")
#define SUNXI_PINCTRL_PIN_PA19	PINCTRL_PIN(SUNXI_PA_BASE + 19, "PA19")
#define SUNXI_PINCTRL_PIN_PA20	PINCTRL_PIN(SUNXI_PA_BASE + 20, "PA20")
#define SUNXI_PINCTRL_PIN_PA21	PINCTRL_PIN(SUNXI_PA_BASE + 21, "PA21")
#define SUNXI_PINCTRL_PIN_PA22	PINCTRL_PIN(SUNXI_PA_BASE + 22, "PA22")
#define SUNXI_PINCTRL_PIN_PA23	PINCTRL_PIN(SUNXI_PA_BASE + 23, "PA23")
#define SUNXI_PINCTRL_PIN_PA24	PINCTRL_PIN(SUNXI_PA_BASE + 24, "PA24")
#define SUNXI_PINCTRL_PIN_PA25	PINCTRL_PIN(SUNXI_PA_BASE + 25, "PA25")
#define SUNXI_PINCTRL_PIN_PA26	PINCTRL_PIN(SUNXI_PA_BASE + 26, "PA26")
#define SUNXI_PINCTRL_PIN_PA27	PINCTRL_PIN(SUNXI_PA_BASE + 27, "PA27")
#define SUNXI_PINCTRL_PIN_PA28	PINCTRL_PIN(SUNXI_PA_BASE + 28, "PA28")
#define SUNXI_PINCTRL_PIN_PA29	PINCTRL_PIN(SUNXI_PA_BASE + 29, "PA29")
#define SUNXI_PINCTRL_PIN_PA30	PINCTRL_PIN(SUNXI_PA_BASE + 30, "PA30")
#define SUNXI_PINCTRL_PIN_PA31	PINCTRL_PIN(SUNXI_PA_BASE + 31, "PA31")

#define SUNXI_PINCTRL_PIN_PB0	PINCTRL_PIN(SUNXI_PB_BASE + 0,  "PB0")
#define SUNXI_PINCTRL_PIN_PB1	PINCTRL_PIN(SUNXI_PB_BASE + 1,  "PB1")
#define SUNXI_PINCTRL_PIN_PB2	PINCTRL_PIN(SUNXI_PB_BASE + 2,  "PB2")
#define SUNXI_PINCTRL_PIN_PB3	PINCTRL_PIN(SUNXI_PB_BASE + 3,  "PB3")
#define SUNXI_PINCTRL_PIN_PB4	PINCTRL_PIN(SUNXI_PB_BASE + 4,  "PB4")
#define SUNXI_PINCTRL_PIN_PB5	PINCTRL_PIN(SUNXI_PB_BASE + 5,  "PB5")
#define SUNXI_PINCTRL_PIN_PB6	PINCTRL_PIN(SUNXI_PB_BASE + 6,  "PB6")
#define SUNXI_PINCTRL_PIN_PB7	PINCTRL_PIN(SUNXI_PB_BASE + 7,  "PB7")
#define SUNXI_PINCTRL_PIN_PB8	PINCTRL_PIN(SUNXI_PB_BASE + 8,  "PB8")
#define SUNXI_PINCTRL_PIN_PB9	PINCTRL_PIN(SUNXI_PB_BASE + 9,  "PB9")
#define SUNXI_PINCTRL_PIN_PB10	PINCTRL_PIN(SUNXI_PB_BASE + 10, "PB10")
#define SUNXI_PINCTRL_PIN_PB11	PINCTRL_PIN(SUNXI_PB_BASE + 11, "PB11")
#define SUNXI_PINCTRL_PIN_PB12	PINCTRL_PIN(SUNXI_PB_BASE + 12, "PB12")
#define SUNXI_PINCTRL_PIN_PB13	PINCTRL_PIN(SUNXI_PB_BASE + 13, "PB13")
#define SUNXI_PINCTRL_PIN_PB14	PINCTRL_PIN(SUNXI_PB_BASE + 14, "PB14")
#define SUNXI_PINCTRL_PIN_PB15	PINCTRL_PIN(SUNXI_PB_BASE + 15, "PB15")
#define SUNXI_PINCTRL_PIN_PB16	PINCTRL_PIN(SUNXI_PB_BASE + 16, "PB16")
#define SUNXI_PINCTRL_PIN_PB17	PINCTRL_PIN(SUNXI_PB_BASE + 17, "PB17")
#define SUNXI_PINCTRL_PIN_PB18	PINCTRL_PIN(SUNXI_PB_BASE + 18, "PB18")
#define SUNXI_PINCTRL_PIN_PB19	PINCTRL_PIN(SUNXI_PB_BASE + 19, "PB19")
#define SUNXI_PINCTRL_PIN_PB20	PINCTRL_PIN(SUNXI_PB_BASE + 20, "PB20")
#define SUNXI_PINCTRL_PIN_PB21	PINCTRL_PIN(SUNXI_PB_BASE + 21, "PB21")
#define SUNXI_PINCTRL_PIN_PB22	PINCTRL_PIN(SUNXI_PB_BASE + 22, "PB22")
#define SUNXI_PINCTRL_PIN_PB23	PINCTRL_PIN(SUNXI_PB_BASE + 23, "PB23")
#define SUNXI_PINCTRL_PIN_PB24	PINCTRL_PIN(SUNXI_PB_BASE + 24, "PB24")
#define SUNXI_PINCTRL_PIN_PB25	PINCTRL_PIN(SUNXI_PB_BASE + 25, "PB25")
#define SUNXI_PINCTRL_PIN_PB26	PINCTRL_PIN(SUNXI_PB_BASE + 26, "PB26")
#define SUNXI_PINCTRL_PIN_PB27	PINCTRL_PIN(SUNXI_PB_BASE + 27, "PB27")
#define SUNXI_PINCTRL_PIN_PB28	PINCTRL_PIN(SUNXI_PB_BASE + 28, "PB28")
#define SUNXI_PINCTRL_PIN_PB29	PINCTRL_PIN(SUNXI_PB_BASE + 29, "PB29")
#define SUNXI_PINCTRL_PIN_PB30	PINCTRL_PIN(SUNXI_PB_BASE + 30, "PB30")
#define SUNXI_PINCTRL_PIN_PB31	PINCTRL_PIN(SUNXI_PB_BASE + 31, "PB31")

#define SUNXI_PINCTRL_PIN_PC0	PINCTRL_PIN(SUNXI_PC_BASE + 0,  "PC0")
#define SUNXI_PINCTRL_PIN_PC1	PINCTRL_PIN(SUNXI_PC_BASE + 1,  "PC1")
#define SUNXI_PINCTRL_PIN_PC2	PINCTRL_PIN(SUNXI_PC_BASE + 2,  "PC2")
#define SUNXI_PINCTRL_PIN_PC3	PINCTRL_PIN(SUNXI_PC_BASE + 3,  "PC3")
#define SUNXI_PINCTRL_PIN_PC4	PINCTRL_PIN(SUNXI_PC_BASE + 4,  "PC4")
#define SUNXI_PINCTRL_PIN_PC5	PINCTRL_PIN(SUNXI_PC_BASE + 5,  "PC5")
#define SUNXI_PINCTRL_PIN_PC6	PINCTRL_PIN(SUNXI_PC_BASE + 6,  "PC6")
#define SUNXI_PINCTRL_PIN_PC7	PINCTRL_PIN(SUNXI_PC_BASE + 7,  "PC7")
#define SUNXI_PINCTRL_PIN_PC8	PINCTRL_PIN(SUNXI_PC_BASE + 8,  "PC8")
#define SUNXI_PINCTRL_PIN_PC9	PINCTRL_PIN(SUNXI_PC_BASE + 9,  "PC9")
#define SUNXI_PINCTRL_PIN_PC10	PINCTRL_PIN(SUNXI_PC_BASE + 10, "PC10")
#define SUNXI_PINCTRL_PIN_PC11	PINCTRL_PIN(SUNXI_PC_BASE + 11, "PC11")
#define SUNXI_PINCTRL_PIN_PC12	PINCTRL_PIN(SUNXI_PC_BASE + 12, "PC12")
#define SUNXI_PINCTRL_PIN_PC13	PINCTRL_PIN(SUNXI_PC_BASE + 13, "PC13")
#define SUNXI_PINCTRL_PIN_PC14	PINCTRL_PIN(SUNXI_PC_BASE + 14, "PC14")
#define SUNXI_PINCTRL_PIN_PC15	PINCTRL_PIN(SUNXI_PC_BASE + 15, "PC15")
#define SUNXI_PINCTRL_PIN_PC16	PINCTRL_PIN(SUNXI_PC_BASE + 16, "PC16")
#define SUNXI_PINCTRL_PIN_PC17	PINCTRL_PIN(SUNXI_PC_BASE + 17, "PC17")
#define SUNXI_PINCTRL_PIN_PC18	PINCTRL_PIN(SUNXI_PC_BASE + 18, "PC18")
#define SUNXI_PINCTRL_PIN_PC19	PINCTRL_PIN(SUNXI_PC_BASE + 19, "PC19")
#define SUNXI_PINCTRL_PIN_PC20	PINCTRL_PIN(SUNXI_PC_BASE + 20, "PC20")
#define SUNXI_PINCTRL_PIN_PC21	PINCTRL_PIN(SUNXI_PC_BASE + 21, "PC21")
#define SUNXI_PINCTRL_PIN_PC22	PINCTRL_PIN(SUNXI_PC_BASE + 22, "PC22")
#define SUNXI_PINCTRL_PIN_PC23	PINCTRL_PIN(SUNXI_PC_BASE + 23, "PC23")
#define SUNXI_PINCTRL_PIN_PC24	PINCTRL_PIN(SUNXI_PC_BASE + 24, "PC24")
#define SUNXI_PINCTRL_PIN_PC25	PINCTRL_PIN(SUNXI_PC_BASE + 25, "PC25")
#define SUNXI_PINCTRL_PIN_PC26	PINCTRL_PIN(SUNXI_PC_BASE + 26, "PC26")
#define SUNXI_PINCTRL_PIN_PC27	PINCTRL_PIN(SUNXI_PC_BASE + 27, "PC27")
#define SUNXI_PINCTRL_PIN_PC28	PINCTRL_PIN(SUNXI_PC_BASE + 28, "PC28")
#define SUNXI_PINCTRL_PIN_PC29	PINCTRL_PIN(SUNXI_PC_BASE + 29, "PC29")
#define SUNXI_PINCTRL_PIN_PC30	PINCTRL_PIN(SUNXI_PC_BASE + 30, "PC30")
#define SUNXI_PINCTRL_PIN_PC31	PINCTRL_PIN(SUNXI_PC_BASE + 31, "PC31")

#define SUNXI_PINCTRL_PIN_PD0	PINCTRL_PIN(SUNXI_PD_BASE + 0,  "PD0")
#define SUNXI_PINCTRL_PIN_PD1	PINCTRL_PIN(SUNXI_PD_BASE + 1,  "PD1")
#define SUNXI_PINCTRL_PIN_PD2	PINCTRL_PIN(SUNXI_PD_BASE + 2,  "PD2")
#define SUNXI_PINCTRL_PIN_PD3	PINCTRL_PIN(SUNXI_PD_BASE + 3,  "PD3")
#define SUNXI_PINCTRL_PIN_PD4	PINCTRL_PIN(SUNXI_PD_BASE + 4,  "PD4")
#define SUNXI_PINCTRL_PIN_PD5	PINCTRL_PIN(SUNXI_PD_BASE + 5,  "PD5")
#define SUNXI_PINCTRL_PIN_PD6	PINCTRL_PIN(SUNXI_PD_BASE + 6,  "PD6")
#define SUNXI_PINCTRL_PIN_PD7	PINCTRL_PIN(SUNXI_PD_BASE + 7,  "PD7")
#define SUNXI_PINCTRL_PIN_PD8	PINCTRL_PIN(SUNXI_PD_BASE + 8,  "PD8")
#define SUNXI_PINCTRL_PIN_PD9	PINCTRL_PIN(SUNXI_PD_BASE + 9,  "PD9")
#define SUNXI_PINCTRL_PIN_PD10	PINCTRL_PIN(SUNXI_PD_BASE + 10, "PD10")
#define SUNXI_PINCTRL_PIN_PD11	PINCTRL_PIN(SUNXI_PD_BASE + 11, "PD11")
#define SUNXI_PINCTRL_PIN_PD12	PINCTRL_PIN(SUNXI_PD_BASE + 12, "PD12")
#define SUNXI_PINCTRL_PIN_PD13	PINCTRL_PIN(SUNXI_PD_BASE + 13, "PD13")
#define SUNXI_PINCTRL_PIN_PD14	PINCTRL_PIN(SUNXI_PD_BASE + 14, "PD14")
#define SUNXI_PINCTRL_PIN_PD15	PINCTRL_PIN(SUNXI_PD_BASE + 15, "PD15")
#define SUNXI_PINCTRL_PIN_PD16	PINCTRL_PIN(SUNXI_PD_BASE + 16, "PD16")
#define SUNXI_PINCTRL_PIN_PD17	PINCTRL_PIN(SUNXI_PD_BASE + 17, "PD17")
#define SUNXI_PINCTRL_PIN_PD18	PINCTRL_PIN(SUNXI_PD_BASE + 18, "PD18")
#define SUNXI_PINCTRL_PIN_PD19	PINCTRL_PIN(SUNXI_PD_BASE + 19, "PD19")
#define SUNXI_PINCTRL_PIN_PD20	PINCTRL_PIN(SUNXI_PD_BASE + 20, "PD20")
#define SUNXI_PINCTRL_PIN_PD21	PINCTRL_PIN(SUNXI_PD_BASE + 21, "PD21")
#define SUNXI_PINCTRL_PIN_PD22	PINCTRL_PIN(SUNXI_PD_BASE + 22, "PD22")
#define SUNXI_PINCTRL_PIN_PD23	PINCTRL_PIN(SUNXI_PD_BASE + 23, "PD23")
#define SUNXI_PINCTRL_PIN_PD24	PINCTRL_PIN(SUNXI_PD_BASE + 24, "PD24")
#define SUNXI_PINCTRL_PIN_PD25	PINCTRL_PIN(SUNXI_PD_BASE + 25, "PD25")
#define SUNXI_PINCTRL_PIN_PD26	PINCTRL_PIN(SUNXI_PD_BASE + 26, "PD26")
#define SUNXI_PINCTRL_PIN_PD27	PINCTRL_PIN(SUNXI_PD_BASE + 27, "PD27")
#define SUNXI_PINCTRL_PIN_PD28	PINCTRL_PIN(SUNXI_PD_BASE + 28, "PD28")
#define SUNXI_PINCTRL_PIN_PD29	PINCTRL_PIN(SUNXI_PD_BASE + 29, "PD29")
#define SUNXI_PINCTRL_PIN_PD30	PINCTRL_PIN(SUNXI_PD_BASE + 30, "PD30")
#define SUNXI_PINCTRL_PIN_PD31	PINCTRL_PIN(SUNXI_PD_BASE + 31, "PD31")

#define SUNXI_PINCTRL_PIN_PE0	PINCTRL_PIN(SUNXI_PE_BASE + 0,  "PE0")
#define SUNXI_PINCTRL_PIN_PE1	PINCTRL_PIN(SUNXI_PE_BASE + 1,  "PE1")
#define SUNXI_PINCTRL_PIN_PE2	PINCTRL_PIN(SUNXI_PE_BASE + 2,  "PE2")
#define SUNXI_PINCTRL_PIN_PE3	PINCTRL_PIN(SUNXI_PE_BASE + 3,  "PE3")
#define SUNXI_PINCTRL_PIN_PE4	PINCTRL_PIN(SUNXI_PE_BASE + 4,  "PE4")
#define SUNXI_PINCTRL_PIN_PE5	PINCTRL_PIN(SUNXI_PE_BASE + 5,  "PE5")
#define SUNXI_PINCTRL_PIN_PE6	PINCTRL_PIN(SUNXI_PE_BASE + 6,  "PE6")
#define SUNXI_PINCTRL_PIN_PE7	PINCTRL_PIN(SUNXI_PE_BASE + 7,  "PE7")
#define SUNXI_PINCTRL_PIN_PE8	PINCTRL_PIN(SUNXI_PE_BASE + 8,  "PE8")
#define SUNXI_PINCTRL_PIN_PE9	PINCTRL_PIN(SUNXI_PE_BASE + 9,  "PE9")
#define SUNXI_PINCTRL_PIN_PE10	PINCTRL_PIN(SUNXI_PE_BASE + 10, "PE10")
#define SUNXI_PINCTRL_PIN_PE11	PINCTRL_PIN(SUNXI_PE_BASE + 11, "PE11")
#define SUNXI_PINCTRL_PIN_PE12	PINCTRL_PIN(SUNXI_PE_BASE + 12, "PE12")
#define SUNXI_PINCTRL_PIN_PE13	PINCTRL_PIN(SUNXI_PE_BASE + 13, "PE13")
#define SUNXI_PINCTRL_PIN_PE14	PINCTRL_PIN(SUNXI_PE_BASE + 14, "PE14")
#define SUNXI_PINCTRL_PIN_PE15	PINCTRL_PIN(SUNXI_PE_BASE + 15, "PE15")
#define SUNXI_PINCTRL_PIN_PE16	PINCTRL_PIN(SUNXI_PE_BASE + 16, "PE16")
#define SUNXI_PINCTRL_PIN_PE17	PINCTRL_PIN(SUNXI_PE_BASE + 17, "PE17")
#define SUNXI_PINCTRL_PIN_PE18	PINCTRL_PIN(SUNXI_PE_BASE + 18, "PE18")
#define SUNXI_PINCTRL_PIN_PE19	PINCTRL_PIN(SUNXI_PE_BASE + 19, "PE19")
#define SUNXI_PINCTRL_PIN_PE20	PINCTRL_PIN(SUNXI_PE_BASE + 20, "PE20")
#define SUNXI_PINCTRL_PIN_PE21	PINCTRL_PIN(SUNXI_PE_BASE + 21, "PE21")
#define SUNXI_PINCTRL_PIN_PE22	PINCTRL_PIN(SUNXI_PE_BASE + 22, "PE22")
#define SUNXI_PINCTRL_PIN_PE23	PINCTRL_PIN(SUNXI_PE_BASE + 23, "PE23")
#define SUNXI_PINCTRL_PIN_PE24	PINCTRL_PIN(SUNXI_PE_BASE + 24, "PE24")
#define SUNXI_PINCTRL_PIN_PE25	PINCTRL_PIN(SUNXI_PE_BASE + 25, "PE25")
#define SUNXI_PINCTRL_PIN_PE26	PINCTRL_PIN(SUNXI_PE_BASE + 26, "PE26")
#define SUNXI_PINCTRL_PIN_PE27	PINCTRL_PIN(SUNXI_PE_BASE + 27, "PE27")
#define SUNXI_PINCTRL_PIN_PE28	PINCTRL_PIN(SUNXI_PE_BASE + 28, "PE28")
#define SUNXI_PINCTRL_PIN_PE29	PINCTRL_PIN(SUNXI_PE_BASE + 29, "PE29")
#define SUNXI_PINCTRL_PIN_PE30	PINCTRL_PIN(SUNXI_PE_BASE + 30, "PE30")
#define SUNXI_PINCTRL_PIN_PE31	PINCTRL_PIN(SUNXI_PE_BASE + 31, "PE31")

#define SUNXI_PINCTRL_PIN_PF0	PINCTRL_PIN(SUNXI_PF_BASE + 0,  "PF0")
#define SUNXI_PINCTRL_PIN_PF1	PINCTRL_PIN(SUNXI_PF_BASE + 1,  "PF1")
#define SUNXI_PINCTRL_PIN_PF2	PINCTRL_PIN(SUNXI_PF_BASE + 2,  "PF2")
#define SUNXI_PINCTRL_PIN_PF3	PINCTRL_PIN(SUNXI_PF_BASE + 3,  "PF3")
#define SUNXI_PINCTRL_PIN_PF4	PINCTRL_PIN(SUNXI_PF_BASE + 4,  "PF4")
#define SUNXI_PINCTRL_PIN_PF5	PINCTRL_PIN(SUNXI_PF_BASE + 5,  "PF5")
#define SUNXI_PINCTRL_PIN_PF6	PINCTRL_PIN(SUNXI_PF_BASE + 6,  "PF6")
#define SUNXI_PINCTRL_PIN_PF7	PINCTRL_PIN(SUNXI_PF_BASE + 7,  "PF7")
#define SUNXI_PINCTRL_PIN_PF8	PINCTRL_PIN(SUNXI_PF_BASE + 8,  "PF8")
#define SUNXI_PINCTRL_PIN_PF9	PINCTRL_PIN(SUNXI_PF_BASE + 9,  "PF9")
#define SUNXI_PINCTRL_PIN_PF10	PINCTRL_PIN(SUNXI_PF_BASE + 10, "PF10")
#define SUNXI_PINCTRL_PIN_PF11	PINCTRL_PIN(SUNXI_PF_BASE + 11, "PF11")
#define SUNXI_PINCTRL_PIN_PF12	PINCTRL_PIN(SUNXI_PF_BASE + 12, "PF12")
#define SUNXI_PINCTRL_PIN_PF13	PINCTRL_PIN(SUNXI_PF_BASE + 13, "PF13")
#define SUNXI_PINCTRL_PIN_PF14	PINCTRL_PIN(SUNXI_PF_BASE + 14, "PF14")
#define SUNXI_PINCTRL_PIN_PF15	PINCTRL_PIN(SUNXI_PF_BASE + 15, "PF15")
#define SUNXI_PINCTRL_PIN_PF16	PINCTRL_PIN(SUNXI_PF_BASE + 16, "PF16")
#define SUNXI_PINCTRL_PIN_PF17	PINCTRL_PIN(SUNXI_PF_BASE + 17, "PF17")
#define SUNXI_PINCTRL_PIN_PF18	PINCTRL_PIN(SUNXI_PF_BASE + 18, "PF18")
#define SUNXI_PINCTRL_PIN_PF19	PINCTRL_PIN(SUNXI_PF_BASE + 19, "PF19")
#define SUNXI_PINCTRL_PIN_PF20	PINCTRL_PIN(SUNXI_PF_BASE + 20, "PF20")
#define SUNXI_PINCTRL_PIN_PF21	PINCTRL_PIN(SUNXI_PF_BASE + 21, "PF21")
#define SUNXI_PINCTRL_PIN_PF22	PINCTRL_PIN(SUNXI_PF_BASE + 22, "PF22")
#define SUNXI_PINCTRL_PIN_PF23	PINCTRL_PIN(SUNXI_PF_BASE + 23, "PF23")
#define SUNXI_PINCTRL_PIN_PF24	PINCTRL_PIN(SUNXI_PF_BASE + 24, "PF24")
#define SUNXI_PINCTRL_PIN_PF25	PINCTRL_PIN(SUNXI_PF_BASE + 25, "PF25")
#define SUNXI_PINCTRL_PIN_PF26	PINCTRL_PIN(SUNXI_PF_BASE + 26, "PF26")
#define SUNXI_PINCTRL_PIN_PF27	PINCTRL_PIN(SUNXI_PF_BASE + 27, "PF27")
#define SUNXI_PINCTRL_PIN_PF28	PINCTRL_PIN(SUNXI_PF_BASE + 28, "PF28")
#define SUNXI_PINCTRL_PIN_PF29	PINCTRL_PIN(SUNXI_PF_BASE + 29, "PF29")
#define SUNXI_PINCTRL_PIN_PF30	PINCTRL_PIN(SUNXI_PF_BASE + 30, "PF30")
#define SUNXI_PINCTRL_PIN_PF31	PINCTRL_PIN(SUNXI_PF_BASE + 31, "PF31")

#define SUNXI_PINCTRL_PIN_PG0	PINCTRL_PIN(SUNXI_PG_BASE + 0,  "PG0")
#define SUNXI_PINCTRL_PIN_PG1	PINCTRL_PIN(SUNXI_PG_BASE + 1,  "PG1")
#define SUNXI_PINCTRL_PIN_PG2	PINCTRL_PIN(SUNXI_PG_BASE + 2,  "PG2")
#define SUNXI_PINCTRL_PIN_PG3	PINCTRL_PIN(SUNXI_PG_BASE + 3,  "PG3")
#define SUNXI_PINCTRL_PIN_PG4	PINCTRL_PIN(SUNXI_PG_BASE + 4,  "PG4")
#define SUNXI_PINCTRL_PIN_PG5	PINCTRL_PIN(SUNXI_PG_BASE + 5,  "PG5")
#define SUNXI_PINCTRL_PIN_PG6	PINCTRL_PIN(SUNXI_PG_BASE + 6,  "PG6")
#define SUNXI_PINCTRL_PIN_PG7	PINCTRL_PIN(SUNXI_PG_BASE + 7,  "PG7")
#define SUNXI_PINCTRL_PIN_PG8	PINCTRL_PIN(SUNXI_PG_BASE + 8,  "PG8")
#define SUNXI_PINCTRL_PIN_PG9	PINCTRL_PIN(SUNXI_PG_BASE + 9,  "PG9")
#define SUNXI_PINCTRL_PIN_PG10	PINCTRL_PIN(SUNXI_PG_BASE + 10, "PG10")
#define SUNXI_PINCTRL_PIN_PG11	PINCTRL_PIN(SUNXI_PG_BASE + 11, "PG11")
#define SUNXI_PINCTRL_PIN_PG12	PINCTRL_PIN(SUNXI_PG_BASE + 12, "PG12")
#define SUNXI_PINCTRL_PIN_PG13	PINCTRL_PIN(SUNXI_PG_BASE + 13, "PG13")
#define SUNXI_PINCTRL_PIN_PG14	PINCTRL_PIN(SUNXI_PG_BASE + 14, "PG14")
#define SUNXI_PINCTRL_PIN_PG15	PINCTRL_PIN(SUNXI_PG_BASE + 15, "PG15")
#define SUNXI_PINCTRL_PIN_PG16	PINCTRL_PIN(SUNXI_PG_BASE + 16, "PG16")
#define SUNXI_PINCTRL_PIN_PG17	PINCTRL_PIN(SUNXI_PG_BASE + 17, "PG17")
#define SUNXI_PINCTRL_PIN_PG18	PINCTRL_PIN(SUNXI_PG_BASE + 18, "PG18")
#define SUNXI_PINCTRL_PIN_PG19	PINCTRL_PIN(SUNXI_PG_BASE + 19, "PG19")
#define SUNXI_PINCTRL_PIN_PG20	PINCTRL_PIN(SUNXI_PG_BASE + 20, "PG20")
#define SUNXI_PINCTRL_PIN_PG21	PINCTRL_PIN(SUNXI_PG_BASE + 21, "PG21")
#define SUNXI_PINCTRL_PIN_PG22	PINCTRL_PIN(SUNXI_PG_BASE + 22, "PG22")
#define SUNXI_PINCTRL_PIN_PG23	PINCTRL_PIN(SUNXI_PG_BASE + 23, "PG23")
#define SUNXI_PINCTRL_PIN_PG24	PINCTRL_PIN(SUNXI_PG_BASE + 24, "PG24")
#define SUNXI_PINCTRL_PIN_PG25	PINCTRL_PIN(SUNXI_PG_BASE + 25, "PG25")
#define SUNXI_PINCTRL_PIN_PG26	PINCTRL_PIN(SUNXI_PG_BASE + 26, "PG26")
#define SUNXI_PINCTRL_PIN_PG27	PINCTRL_PIN(SUNXI_PG_BASE + 27, "PG27")
#define SUNXI_PINCTRL_PIN_PG28	PINCTRL_PIN(SUNXI_PG_BASE + 28, "PG28")
#define SUNXI_PINCTRL_PIN_PG29	PINCTRL_PIN(SUNXI_PG_BASE + 29, "PG29")
#define SUNXI_PINCTRL_PIN_PG30	PINCTRL_PIN(SUNXI_PG_BASE + 30, "PG30")
#define SUNXI_PINCTRL_PIN_PG31	PINCTRL_PIN(SUNXI_PG_BASE + 31, "PG31")

#define SUNXI_PINCTRL_PIN_PH0	PINCTRL_PIN(SUNXI_PH_BASE + 0,  "PH0")
#define SUNXI_PINCTRL_PIN_PH1	PINCTRL_PIN(SUNXI_PH_BASE + 1,  "PH1")
#define SUNXI_PINCTRL_PIN_PH2	PINCTRL_PIN(SUNXI_PH_BASE + 2,  "PH2")
#define SUNXI_PINCTRL_PIN_PH3	PINCTRL_PIN(SUNXI_PH_BASE + 3,  "PH3")
#define SUNXI_PINCTRL_PIN_PH4	PINCTRL_PIN(SUNXI_PH_BASE + 4,  "PH4")
#define SUNXI_PINCTRL_PIN_PH5	PINCTRL_PIN(SUNXI_PH_BASE + 5,  "PH5")
#define SUNXI_PINCTRL_PIN_PH6	PINCTRL_PIN(SUNXI_PH_BASE + 6,  "PH6")
#define SUNXI_PINCTRL_PIN_PH7	PINCTRL_PIN(SUNXI_PH_BASE + 7,  "PH7")
#define SUNXI_PINCTRL_PIN_PH8	PINCTRL_PIN(SUNXI_PH_BASE + 8,  "PH8")
#define SUNXI_PINCTRL_PIN_PH9	PINCTRL_PIN(SUNXI_PH_BASE + 9,  "PH9")
#define SUNXI_PINCTRL_PIN_PH10	PINCTRL_PIN(SUNXI_PH_BASE + 10, "PH10")
#define SUNXI_PINCTRL_PIN_PH11	PINCTRL_PIN(SUNXI_PH_BASE + 11, "PH11")
#define SUNXI_PINCTRL_PIN_PH12	PINCTRL_PIN(SUNXI_PH_BASE + 12, "PH12")
#define SUNXI_PINCTRL_PIN_PH13	PINCTRL_PIN(SUNXI_PH_BASE + 13, "PH13")
#define SUNXI_PINCTRL_PIN_PH14	PINCTRL_PIN(SUNXI_PH_BASE + 14, "PH14")
#define SUNXI_PINCTRL_PIN_PH15	PINCTRL_PIN(SUNXI_PH_BASE + 15, "PH15")
#define SUNXI_PINCTRL_PIN_PH16	PINCTRL_PIN(SUNXI_PH_BASE + 16, "PH16")
#define SUNXI_PINCTRL_PIN_PH17	PINCTRL_PIN(SUNXI_PH_BASE + 17, "PH17")
#define SUNXI_PINCTRL_PIN_PH18	PINCTRL_PIN(SUNXI_PH_BASE + 18, "PH18")
#define SUNXI_PINCTRL_PIN_PH19	PINCTRL_PIN(SUNXI_PH_BASE + 19, "PH19")
#define SUNXI_PINCTRL_PIN_PH20	PINCTRL_PIN(SUNXI_PH_BASE + 20, "PH20")
#define SUNXI_PINCTRL_PIN_PH21	PINCTRL_PIN(SUNXI_PH_BASE + 21, "PH21")
#define SUNXI_PINCTRL_PIN_PH22	PINCTRL_PIN(SUNXI_PH_BASE + 22, "PH22")
#define SUNXI_PINCTRL_PIN_PH23	PINCTRL_PIN(SUNXI_PH_BASE + 23, "PH23")
#define SUNXI_PINCTRL_PIN_PH24	PINCTRL_PIN(SUNXI_PH_BASE + 24, "PH24")
#define SUNXI_PINCTRL_PIN_PH25	PINCTRL_PIN(SUNXI_PH_BASE + 25, "PH25")
#define SUNXI_PINCTRL_PIN_PH26	PINCTRL_PIN(SUNXI_PH_BASE + 26, "PH26")
#define SUNXI_PINCTRL_PIN_PH27	PINCTRL_PIN(SUNXI_PH_BASE + 27, "PH27")
#define SUNXI_PINCTRL_PIN_PH28	PINCTRL_PIN(SUNXI_PH_BASE + 28, "PH28")
#define SUNXI_PINCTRL_PIN_PH29	PINCTRL_PIN(SUNXI_PH_BASE + 29, "PH29")
#define SUNXI_PINCTRL_PIN_PH30	PINCTRL_PIN(SUNXI_PH_BASE + 30, "PH30")
#define SUNXI_PINCTRL_PIN_PH31	PINCTRL_PIN(SUNXI_PH_BASE + 31, "PH31")

#define SUNXI_PINCTRL_PIN_PI0	PINCTRL_PIN(SUNXI_PI_BASE + 0,  "PI0")
#define SUNXI_PINCTRL_PIN_PI1	PINCTRL_PIN(SUNXI_PI_BASE + 1,  "PI1")
#define SUNXI_PINCTRL_PIN_PI2	PINCTRL_PIN(SUNXI_PI_BASE + 2,  "PI2")
#define SUNXI_PINCTRL_PIN_PI3	PINCTRL_PIN(SUNXI_PI_BASE + 3,  "PI3")
#define SUNXI_PINCTRL_PIN_PI4	PINCTRL_PIN(SUNXI_PI_BASE + 4,  "PI4")
#define SUNXI_PINCTRL_PIN_PI5	PINCTRL_PIN(SUNXI_PI_BASE + 5,  "PI5")
#define SUNXI_PINCTRL_PIN_PI6	PINCTRL_PIN(SUNXI_PI_BASE + 6,  "PI6")
#define SUNXI_PINCTRL_PIN_PI7	PINCTRL_PIN(SUNXI_PI_BASE + 7,  "PI7")
#define SUNXI_PINCTRL_PIN_PI8	PINCTRL_PIN(SUNXI_PI_BASE + 8,  "PI8")
#define SUNXI_PINCTRL_PIN_PI9	PINCTRL_PIN(SUNXI_PI_BASE + 9,  "PI9")
#define SUNXI_PINCTRL_PIN_PI10	PINCTRL_PIN(SUNXI_PI_BASE + 10, "PI10")
#define SUNXI_PINCTRL_PIN_PI11	PINCTRL_PIN(SUNXI_PI_BASE + 11, "PI11")
#define SUNXI_PINCTRL_PIN_PI12	PINCTRL_PIN(SUNXI_PI_BASE + 12, "PI12")
#define SUNXI_PINCTRL_PIN_PI13	PINCTRL_PIN(SUNXI_PI_BASE + 13, "PI13")
#define SUNXI_PINCTRL_PIN_PI14	PINCTRL_PIN(SUNXI_PI_BASE + 14, "PI14")
#define SUNXI_PINCTRL_PIN_PI15	PINCTRL_PIN(SUNXI_PI_BASE + 15, "PI15")
#define SUNXI_PINCTRL_PIN_PI16	PINCTRL_PIN(SUNXI_PI_BASE + 16, "PI16")
#define SUNXI_PINCTRL_PIN_PI17	PINCTRL_PIN(SUNXI_PI_BASE + 17, "PI17")
#define SUNXI_PINCTRL_PIN_PI18	PINCTRL_PIN(SUNXI_PI_BASE + 18, "PI18")
#define SUNXI_PINCTRL_PIN_PI19	PINCTRL_PIN(SUNXI_PI_BASE + 19, "PI19")
#define SUNXI_PINCTRL_PIN_PI20	PINCTRL_PIN(SUNXI_PI_BASE + 20, "PI20")
#define SUNXI_PINCTRL_PIN_PI21	PINCTRL_PIN(SUNXI_PI_BASE + 21, "PI21")
#define SUNXI_PINCTRL_PIN_PI22	PINCTRL_PIN(SUNXI_PI_BASE + 22, "PI22")
#define SUNXI_PINCTRL_PIN_PI23	PINCTRL_PIN(SUNXI_PI_BASE + 23, "PI23")
#define SUNXI_PINCTRL_PIN_PI24	PINCTRL_PIN(SUNXI_PI_BASE + 24, "PI24")
#define SUNXI_PINCTRL_PIN_PI25	PINCTRL_PIN(SUNXI_PI_BASE + 25, "PI25")
#define SUNXI_PINCTRL_PIN_PI26	PINCTRL_PIN(SUNXI_PI_BASE + 26, "PI26")
#define SUNXI_PINCTRL_PIN_PI27	PINCTRL_PIN(SUNXI_PI_BASE + 27, "PI27")
#define SUNXI_PINCTRL_PIN_PI28	PINCTRL_PIN(SUNXI_PI_BASE + 28, "PI28")
#define SUNXI_PINCTRL_PIN_PI29	PINCTRL_PIN(SUNXI_PI_BASE + 29, "PI29")
#define SUNXI_PINCTRL_PIN_PI30	PINCTRL_PIN(SUNXI_PI_BASE + 30, "PI30")
#define SUNXI_PINCTRL_PIN_PI31	PINCTRL_PIN(SUNXI_PI_BASE + 31, "PI31")

#define SUNXI_PINCTRL_PIN_PJ0	PINCTRL_PIN(SUNXI_PJ_BASE + 0,  "PJ0")
#define SUNXI_PINCTRL_PIN_PJ1	PINCTRL_PIN(SUNXI_PJ_BASE + 1,  "PJ1")
#define SUNXI_PINCTRL_PIN_PJ2	PINCTRL_PIN(SUNXI_PJ_BASE + 2,  "PJ2")
#define SUNXI_PINCTRL_PIN_PJ3	PINCTRL_PIN(SUNXI_PJ_BASE + 3,  "PJ3")
#define SUNXI_PINCTRL_PIN_PJ4	PINCTRL_PIN(SUNXI_PJ_BASE + 4,  "PJ4")
#define SUNXI_PINCTRL_PIN_PJ5	PINCTRL_PIN(SUNXI_PJ_BASE + 5,  "PJ5")
#define SUNXI_PINCTRL_PIN_PJ6	PINCTRL_PIN(SUNXI_PJ_BASE + 6,  "PJ6")
#define SUNXI_PINCTRL_PIN_PJ7	PINCTRL_PIN(SUNXI_PJ_BASE + 7,  "PJ7")
#define SUNXI_PINCTRL_PIN_PJ8	PINCTRL_PIN(SUNXI_PJ_BASE + 8,  "PJ8")
#define SUNXI_PINCTRL_PIN_PJ9	PINCTRL_PIN(SUNXI_PJ_BASE + 9,  "PJ9")
#define SUNXI_PINCTRL_PIN_PJ10	PINCTRL_PIN(SUNXI_PJ_BASE + 10, "PJ10")
#define SUNXI_PINCTRL_PIN_PJ11	PINCTRL_PIN(SUNXI_PJ_BASE + 11, "PJ11")
#define SUNXI_PINCTRL_PIN_PJ12	PINCTRL_PIN(SUNXI_PJ_BASE + 12, "PJ12")
#define SUNXI_PINCTRL_PIN_PJ13	PINCTRL_PIN(SUNXI_PJ_BASE + 13, "PJ13")
#define SUNXI_PINCTRL_PIN_PJ14	PINCTRL_PIN(SUNXI_PJ_BASE + 14, "PJ14")
#define SUNXI_PINCTRL_PIN_PJ15	PINCTRL_PIN(SUNXI_PJ_BASE + 15, "PJ15")
#define SUNXI_PINCTRL_PIN_PJ16	PINCTRL_PIN(SUNXI_PJ_BASE + 16, "PJ16")
#define SUNXI_PINCTRL_PIN_PJ17	PINCTRL_PIN(SUNXI_PJ_BASE + 17, "PJ17")
#define SUNXI_PINCTRL_PIN_PJ18	PINCTRL_PIN(SUNXI_PJ_BASE + 18, "PJ18")
#define SUNXI_PINCTRL_PIN_PJ19	PINCTRL_PIN(SUNXI_PJ_BASE + 19, "PJ19")
#define SUNXI_PINCTRL_PIN_PJ20	PINCTRL_PIN(SUNXI_PJ_BASE + 20, "PJ20")
#define SUNXI_PINCTRL_PIN_PJ21	PINCTRL_PIN(SUNXI_PJ_BASE + 21, "PJ21")
#define SUNXI_PINCTRL_PIN_PJ22	PINCTRL_PIN(SUNXI_PJ_BASE + 22, "PJ22")
#define SUNXI_PINCTRL_PIN_PJ23	PINCTRL_PIN(SUNXI_PJ_BASE + 23, "PJ23")
#define SUNXI_PINCTRL_PIN_PJ24	PINCTRL_PIN(SUNXI_PJ_BASE + 24, "PJ24")
#define SUNXI_PINCTRL_PIN_PJ25	PINCTRL_PIN(SUNXI_PJ_BASE + 25, "PJ25")
#define SUNXI_PINCTRL_PIN_PJ26	PINCTRL_PIN(SUNXI_PJ_BASE + 26, "PJ26")
#define SUNXI_PINCTRL_PIN_PJ27	PINCTRL_PIN(SUNXI_PJ_BASE + 27, "PJ27")
#define SUNXI_PINCTRL_PIN_PJ28	PINCTRL_PIN(SUNXI_PJ_BASE + 28, "PJ28")
#define SUNXI_PINCTRL_PIN_PJ29	PINCTRL_PIN(SUNXI_PJ_BASE + 29, "PJ29")
#define SUNXI_PINCTRL_PIN_PJ30	PINCTRL_PIN(SUNXI_PJ_BASE + 30, "PJ30")
#define SUNXI_PINCTRL_PIN_PJ31	PINCTRL_PIN(SUNXI_PJ_BASE + 31, "PJ31")

#define SUNXI_PINCTRL_PIN_PK0	PINCTRL_PIN(SUNXI_PK_BASE + 0,  "PK0")
#define SUNXI_PINCTRL_PIN_PK1	PINCTRL_PIN(SUNXI_PK_BASE + 1,  "PK1")
#define SUNXI_PINCTRL_PIN_PK2	PINCTRL_PIN(SUNXI_PK_BASE + 2,  "PK2")
#define SUNXI_PINCTRL_PIN_PK3	PINCTRL_PIN(SUNXI_PK_BASE + 3,  "PK3")
#define SUNXI_PINCTRL_PIN_PK4	PINCTRL_PIN(SUNXI_PK_BASE + 4,  "PK4")
#define SUNXI_PINCTRL_PIN_PK5	PINCTRL_PIN(SUNXI_PK_BASE + 5,  "PK5")
#define SUNXI_PINCTRL_PIN_PK6	PINCTRL_PIN(SUNXI_PK_BASE + 6,  "PK6")
#define SUNXI_PINCTRL_PIN_PK7	PINCTRL_PIN(SUNXI_PK_BASE + 7,  "PK7")
#define SUNXI_PINCTRL_PIN_PK8	PINCTRL_PIN(SUNXI_PK_BASE + 8,  "PK8")
#define SUNXI_PINCTRL_PIN_PK9	PINCTRL_PIN(SUNXI_PK_BASE + 9,  "PK9")
#define SUNXI_PINCTRL_PIN_PK10	PINCTRL_PIN(SUNXI_PK_BASE + 10, "PK10")
#define SUNXI_PINCTRL_PIN_PK11	PINCTRL_PIN(SUNXI_PK_BASE + 11, "PK11")
#define SUNXI_PINCTRL_PIN_PK12	PINCTRL_PIN(SUNXI_PK_BASE + 12, "PK12")
#define SUNXI_PINCTRL_PIN_PK13	PINCTRL_PIN(SUNXI_PK_BASE + 13, "PK13")
#define SUNXI_PINCTRL_PIN_PK14	PINCTRL_PIN(SUNXI_PK_BASE + 14, "PK14")
#define SUNXI_PINCTRL_PIN_PK15	PINCTRL_PIN(SUNXI_PK_BASE + 15, "PK15")
#define SUNXI_PINCTRL_PIN_PK16	PINCTRL_PIN(SUNXI_PK_BASE + 16, "PK16")
#define SUNXI_PINCTRL_PIN_PK17	PINCTRL_PIN(SUNXI_PK_BASE + 17, "PK17")
#define SUNXI_PINCTRL_PIN_PK18	PINCTRL_PIN(SUNXI_PK_BASE + 18, "PK18")
#define SUNXI_PINCTRL_PIN_PK19	PINCTRL_PIN(SUNXI_PK_BASE + 19, "PK19")
#define SUNXI_PINCTRL_PIN_PK20	PINCTRL_PIN(SUNXI_PK_BASE + 20, "PK20")
#define SUNXI_PINCTRL_PIN_PK21	PINCTRL_PIN(SUNXI_PK_BASE + 21, "PK21")
#define SUNXI_PINCTRL_PIN_PK22	PINCTRL_PIN(SUNXI_PK_BASE + 22, "PK22")
#define SUNXI_PINCTRL_PIN_PK23	PINCTRL_PIN(SUNXI_PK_BASE + 23, "PK23")
#define SUNXI_PINCTRL_PIN_PK24	PINCTRL_PIN(SUNXI_PK_BASE + 24, "PK24")
#define SUNXI_PINCTRL_PIN_PK25	PINCTRL_PIN(SUNXI_PK_BASE + 25, "PK25")
#define SUNXI_PINCTRL_PIN_PK26	PINCTRL_PIN(SUNXI_PK_BASE + 26, "PK26")
#define SUNXI_PINCTRL_PIN_PK27	PINCTRL_PIN(SUNXI_PK_BASE + 27, "PK27")
#define SUNXI_PINCTRL_PIN_PK28	PINCTRL_PIN(SUNXI_PK_BASE + 28, "PK28")
#define SUNXI_PINCTRL_PIN_PK29	PINCTRL_PIN(SUNXI_PK_BASE + 29, "PK29")
#define SUNXI_PINCTRL_PIN_PK30	PINCTRL_PIN(SUNXI_PK_BASE + 30, "PK30")
#define SUNXI_PINCTRL_PIN_PK31	PINCTRL_PIN(SUNXI_PK_BASE + 31, "PK31")

#define SUNXI_PINCTRL_PIN_PL0	PINCTRL_PIN(SUNXI_PL_BASE + 0,  "PL0")
#define SUNXI_PINCTRL_PIN_PL1	PINCTRL_PIN(SUNXI_PL_BASE + 1,  "PL1")
#define SUNXI_PINCTRL_PIN_PL2	PINCTRL_PIN(SUNXI_PL_BASE + 2,  "PL2")
#define SUNXI_PINCTRL_PIN_PL3	PINCTRL_PIN(SUNXI_PL_BASE + 3,  "PL3")
#define SUNXI_PINCTRL_PIN_PL4	PINCTRL_PIN(SUNXI_PL_BASE + 4,  "PL4")
#define SUNXI_PINCTRL_PIN_PL5	PINCTRL_PIN(SUNXI_PL_BASE + 5,  "PL5")
#define SUNXI_PINCTRL_PIN_PL6	PINCTRL_PIN(SUNXI_PL_BASE + 6,  "PL6")
#define SUNXI_PINCTRL_PIN_PL7	PINCTRL_PIN(SUNXI_PL_BASE + 7,  "PL7")
#define SUNXI_PINCTRL_PIN_PL8	PINCTRL_PIN(SUNXI_PL_BASE + 8,  "PL8")
#define SUNXI_PINCTRL_PIN_PL9	PINCTRL_PIN(SUNXI_PL_BASE + 9,  "PL9")
#define SUNXI_PINCTRL_PIN_PL10	PINCTRL_PIN(SUNXI_PL_BASE + 10, "PL10")
#define SUNXI_PINCTRL_PIN_PL11	PINCTRL_PIN(SUNXI_PL_BASE + 11, "PL11")
#define SUNXI_PINCTRL_PIN_PL12	PINCTRL_PIN(SUNXI_PL_BASE + 12, "PL12")
#define SUNXI_PINCTRL_PIN_PL13	PINCTRL_PIN(SUNXI_PL_BASE + 13, "PL13")
#define SUNXI_PINCTRL_PIN_PL14	PINCTRL_PIN(SUNXI_PL_BASE + 14, "PL14")
#define SUNXI_PINCTRL_PIN_PL15	PINCTRL_PIN(SUNXI_PL_BASE + 15, "PL15")
#define SUNXI_PINCTRL_PIN_PL16	PINCTRL_PIN(SUNXI_PL_BASE + 16, "PL16")
#define SUNXI_PINCTRL_PIN_PL17	PINCTRL_PIN(SUNXI_PL_BASE + 17, "PL17")
#define SUNXI_PINCTRL_PIN_PL18	PINCTRL_PIN(SUNXI_PL_BASE + 18, "PL18")
#define SUNXI_PINCTRL_PIN_PL19	PINCTRL_PIN(SUNXI_PL_BASE + 19, "PL19")
#define SUNXI_PINCTRL_PIN_PL20	PINCTRL_PIN(SUNXI_PL_BASE + 20, "PL20")
#define SUNXI_PINCTRL_PIN_PL21	PINCTRL_PIN(SUNXI_PL_BASE + 21, "PL21")
#define SUNXI_PINCTRL_PIN_PL22	PINCTRL_PIN(SUNXI_PL_BASE + 22, "PL22")
#define SUNXI_PINCTRL_PIN_PL23	PINCTRL_PIN(SUNXI_PL_BASE + 23, "PL23")
#define SUNXI_PINCTRL_PIN_PL24	PINCTRL_PIN(SUNXI_PL_BASE + 24, "PL24")
#define SUNXI_PINCTRL_PIN_PL25	PINCTRL_PIN(SUNXI_PL_BASE + 25, "PL25")
#define SUNXI_PINCTRL_PIN_PL26	PINCTRL_PIN(SUNXI_PL_BASE + 26, "PL26")
#define SUNXI_PINCTRL_PIN_PL27	PINCTRL_PIN(SUNXI_PL_BASE + 27, "PL27")
#define SUNXI_PINCTRL_PIN_PL28	PINCTRL_PIN(SUNXI_PL_BASE + 28, "PL28")
#define SUNXI_PINCTRL_PIN_PL29	PINCTRL_PIN(SUNXI_PL_BASE + 29, "PL29")
#define SUNXI_PINCTRL_PIN_PL30	PINCTRL_PIN(SUNXI_PL_BASE + 30, "PL30")
#define SUNXI_PINCTRL_PIN_PL31	PINCTRL_PIN(SUNXI_PL_BASE + 31, "PL31")

#define SUNXI_PINCTRL_PIN_PM0	PINCTRL_PIN(SUNXI_PM_BASE + 0,  "PM0")
#define SUNXI_PINCTRL_PIN_PM1	PINCTRL_PIN(SUNXI_PM_BASE + 1,  "PM1")
#define SUNXI_PINCTRL_PIN_PM2	PINCTRL_PIN(SUNXI_PM_BASE + 2,  "PM2")
#define SUNXI_PINCTRL_PIN_PM3	PINCTRL_PIN(SUNXI_PM_BASE + 3,  "PM3")
#define SUNXI_PINCTRL_PIN_PM4	PINCTRL_PIN(SUNXI_PM_BASE + 4,  "PM4")
#define SUNXI_PINCTRL_PIN_PM5	PINCTRL_PIN(SUNXI_PM_BASE + 5,  "PM5")
#define SUNXI_PINCTRL_PIN_PM6	PINCTRL_PIN(SUNXI_PM_BASE + 6,  "PM6")
#define SUNXI_PINCTRL_PIN_PM7	PINCTRL_PIN(SUNXI_PM_BASE + 7,  "PM7")
#define SUNXI_PINCTRL_PIN_PM8	PINCTRL_PIN(SUNXI_PM_BASE + 8,  "PM8")
#define SUNXI_PINCTRL_PIN_PM9	PINCTRL_PIN(SUNXI_PM_BASE + 9,  "PM9")
#define SUNXI_PINCTRL_PIN_PM10	PINCTRL_PIN(SUNXI_PM_BASE + 10, "PM10")
#define SUNXI_PINCTRL_PIN_PM11	PINCTRL_PIN(SUNXI_PM_BASE + 11, "PM11")
#define SUNXI_PINCTRL_PIN_PM12	PINCTRL_PIN(SUNXI_PM_BASE + 12, "PM12")
#define SUNXI_PINCTRL_PIN_PM13	PINCTRL_PIN(SUNXI_PM_BASE + 13, "PM13")
#define SUNXI_PINCTRL_PIN_PM14	PINCTRL_PIN(SUNXI_PM_BASE + 14, "PM14")
#define SUNXI_PINCTRL_PIN_PM15	PINCTRL_PIN(SUNXI_PM_BASE + 15, "PM15")
#define SUNXI_PINCTRL_PIN_PM16	PINCTRL_PIN(SUNXI_PM_BASE + 16, "PM16")
#define SUNXI_PINCTRL_PIN_PM17	PINCTRL_PIN(SUNXI_PM_BASE + 17, "PM17")
#define SUNXI_PINCTRL_PIN_PM18	PINCTRL_PIN(SUNXI_PM_BASE + 18, "PM18")
#define SUNXI_PINCTRL_PIN_PM19	PINCTRL_PIN(SUNXI_PM_BASE + 19, "PM19")
#define SUNXI_PINCTRL_PIN_PM20	PINCTRL_PIN(SUNXI_PM_BASE + 20, "PM20")
#define SUNXI_PINCTRL_PIN_PM21	PINCTRL_PIN(SUNXI_PM_BASE + 21, "PM21")
#define SUNXI_PINCTRL_PIN_PM22	PINCTRL_PIN(SUNXI_PM_BASE + 22, "PM22")
#define SUNXI_PINCTRL_PIN_PM23	PINCTRL_PIN(SUNXI_PM_BASE + 23, "PM23")
#define SUNXI_PINCTRL_PIN_PM24	PINCTRL_PIN(SUNXI_PM_BASE + 24, "PM24")
#define SUNXI_PINCTRL_PIN_PM25	PINCTRL_PIN(SUNXI_PM_BASE + 25, "PM25")
#define SUNXI_PINCTRL_PIN_PM26	PINCTRL_PIN(SUNXI_PM_BASE + 26, "PM26")
#define SUNXI_PINCTRL_PIN_PM27	PINCTRL_PIN(SUNXI_PM_BASE + 27, "PM27")
#define SUNXI_PINCTRL_PIN_PM28	PINCTRL_PIN(SUNXI_PM_BASE + 28, "PM28")
#define SUNXI_PINCTRL_PIN_PM29	PINCTRL_PIN(SUNXI_PM_BASE + 29, "PM29")
#define SUNXI_PINCTRL_PIN_PM30	PINCTRL_PIN(SUNXI_PM_BASE + 30, "PM30")
#define SUNXI_PINCTRL_PIN_PM31	PINCTRL_PIN(SUNXI_PM_BASE + 31, "PM31")

#define SUNXI_PINCTRL_PIN_PN0	PINCTRL_PIN(SUNXI_PN_BASE + 0,  "PN0")
#define SUNXI_PINCTRL_PIN_PN1	PINCTRL_PIN(SUNXI_PN_BASE + 1,  "PN1")
#define SUNXI_PINCTRL_PIN_PN2	PINCTRL_PIN(SUNXI_PN_BASE + 2,  "PN2")
#define SUNXI_PINCTRL_PIN_PN3	PINCTRL_PIN(SUNXI_PN_BASE + 3,  "PN3")
#define SUNXI_PINCTRL_PIN_PN4	PINCTRL_PIN(SUNXI_PN_BASE + 4,  "PN4")
#define SUNXI_PINCTRL_PIN_PN5	PINCTRL_PIN(SUNXI_PN_BASE + 5,  "PN5")
#define SUNXI_PINCTRL_PIN_PN6	PINCTRL_PIN(SUNXI_PN_BASE + 6,  "PN6")
#define SUNXI_PINCTRL_PIN_PN7	PINCTRL_PIN(SUNXI_PN_BASE + 7,  "PN7")
#define SUNXI_PINCTRL_PIN_PN8	PINCTRL_PIN(SUNXI_PN_BASE + 8,  "PN8")
#define SUNXI_PINCTRL_PIN_PN9	PINCTRL_PIN(SUNXI_PN_BASE + 9,  "PN9")
#define SUNXI_PINCTRL_PIN_PN10	PINCTRL_PIN(SUNXI_PN_BASE + 10, "PN10")
#define SUNXI_PINCTRL_PIN_PN11	PINCTRL_PIN(SUNXI_PN_BASE + 11, "PN11")
#define SUNXI_PINCTRL_PIN_PN12	PINCTRL_PIN(SUNXI_PN_BASE + 12, "PN12")
#define SUNXI_PINCTRL_PIN_PN13	PINCTRL_PIN(SUNXI_PN_BASE + 13, "PN13")
#define SUNXI_PINCTRL_PIN_PN14	PINCTRL_PIN(SUNXI_PN_BASE + 14, "PN14")
#define SUNXI_PINCTRL_PIN_PN15	PINCTRL_PIN(SUNXI_PN_BASE + 15, "PN15")
#define SUNXI_PINCTRL_PIN_PN16	PINCTRL_PIN(SUNXI_PN_BASE + 16, "PN16")
#define SUNXI_PINCTRL_PIN_PN17	PINCTRL_PIN(SUNXI_PN_BASE + 17, "PN17")
#define SUNXI_PINCTRL_PIN_PN18	PINCTRL_PIN(SUNXI_PN_BASE + 18, "PN18")
#define SUNXI_PINCTRL_PIN_PN19	PINCTRL_PIN(SUNXI_PN_BASE + 19, "PN19")
#define SUNXI_PINCTRL_PIN_PN20	PINCTRL_PIN(SUNXI_PN_BASE + 20, "PN20")
#define SUNXI_PINCTRL_PIN_PN21	PINCTRL_PIN(SUNXI_PN_BASE + 21, "PN21")
#define SUNXI_PINCTRL_PIN_PN22	PINCTRL_PIN(SUNXI_PN_BASE + 22, "PN22")
#define SUNXI_PINCTRL_PIN_PN23	PINCTRL_PIN(SUNXI_PN_BASE + 23, "PN23")
#define SUNXI_PINCTRL_PIN_PN24	PINCTRL_PIN(SUNXI_PN_BASE + 24, "PN24")
#define SUNXI_PINCTRL_PIN_PN25	PINCTRL_PIN(SUNXI_PN_BASE + 25, "PN25")
#define SUNXI_PINCTRL_PIN_PN26	PINCTRL_PIN(SUNXI_PN_BASE + 26, "PN26")
#define SUNXI_PINCTRL_PIN_PN27	PINCTRL_PIN(SUNXI_PN_BASE + 27, "PN27")
#define SUNXI_PINCTRL_PIN_PN28	PINCTRL_PIN(SUNXI_PN_BASE + 28, "PN28")
#define SUNXI_PINCTRL_PIN_PN29	PINCTRL_PIN(SUNXI_PN_BASE + 29, "PN29")
#define SUNXI_PINCTRL_PIN_PN30	PINCTRL_PIN(SUNXI_PN_BASE + 30, "PN30")
#define SUNXI_PINCTRL_PIN_PN31	PINCTRL_PIN(SUNXI_PN_BASE + 31, "PN31")

#define BANK_MEM_SIZE		0x24
#define MUX_REGS_OFFSET		0x0
#define DATA_REGS_OFFSET	0x10
#define DLEVEL_REGS_OFFSET	0x14
#define PULL_REGS_OFFSET	0x1c

#define PINS_PER_BANK		32
#define MUX_PINS_PER_REG	8
#define MUX_PINS_BITS		4
#define MUX_PINS_MASK		0x0f
#define DATA_PINS_PER_REG	32
#define DATA_PINS_BITS		1
#define DATA_PINS_MASK		0x01
#define DLEVEL_PINS_PER_REG	16
#define DLEVEL_PINS_BITS	2
#define DLEVEL_PINS_MASK	0x03
#define PULL_PINS_PER_REG	16
#define PULL_PINS_BITS		2
#define PULL_PINS_MASK		0x03

/* pin external inerrupt */
#define BANK_EINT_SIZE		(0x20)
#define EINT_CFG_OFFSET		(0x200)
#define EINT_CTRL_OFFSET	(0x210)
#define EINT_STATUS_OFFSET	(0x214)
#define EINT_DEBOUNCE_OFFSET	(0x218)
#define EINT_CFG_PER_REG	8
#define EINT_CFG_BITS		4
#define EINT_CFG_MASK		0x0f
#define EINT_CTRL_PER_REG	32
#define EINT_CTRL_BITS		1
#define EINT_CTRL_MASK		0x01
#define EINT_STATUS_PER_REG	32
#define EINT_STATUS_BITS	1
#define EINT_STATUS_MASK	0x01

/**
 * enum sunxi_eint_type - possible external interrupt types.
 * @SUNXI_EINT_TYPE_NONE: bank does not support external interrupts.
 * @SUNXI_EINT_TYPE_GPIO: bank supportes external gpio interrupts.
 */
enum sunxi_eint_type {
	SUNXI_EINT_TYPE_NONE,
	SUNXI_EINT_TYPE_GPIO
};

struct sunxi_pin_bank {
	void __iomem            *membase;
	u32		   	pin_base;
	u8		   	nr_pins;
	enum sunxi_eint_type    eint_type;
	unsigned long           eint_en;
	unsigned int            irq;
	char		   	*name;
	struct irq_domain    	*irq_domain;
	struct sunxi_pinctrl    *pinctrl;
};

struct sunxi_desc_function {
	const char	*name;
	u8		muxval;
};

struct sunxi_desc_pin {
	struct pinctrl_pin_desc    pin;
	struct sunxi_desc_function *functions;
};

struct sunxi_pinctrl_desc {
	const struct sunxi_desc_pin	*pins;
	int				npins;
	struct pinctrl_gpio_range	*ranges;
	int				nranges;
	struct sunxi_pin_bank           *banks;
	unsigned                        nbanks;
};

struct sunxi_pinctrl_function {
	const char	*name;
	const char	**groups;
	unsigned	ngroups;
};

struct sunxi_pinctrl_group {
	const char	*name;
	unsigned	pin;
};

struct sunxi_pinctrl {
	struct gpio_chip		chip;
	struct sunxi_pinctrl_desc	*desc;
	struct device			*dev;
	struct sunxi_pinctrl_function	*functions;
	unsigned			nfunctions;
	struct sunxi_pinctrl_group	*groups;
	unsigned			ngroups;
	struct pinctrl_dev		*pctl_dev;
};

#define SUNXI_PIN(_pin, ...)					\
	{							\
		.pin = _pin,					\
		.functions = (struct sunxi_desc_function[]){	\
			__VA_ARGS__, { } },			\
	}

#define SUNXI_FUNCTION(_val, _name)				\
	{							\
		.name = _name,					\
		.muxval = _val,					\
	}

#define SUNXI_PIN_BANK(_mem_base, _pin_base, _number, _eint_type, _name, _irq)\
	{							\
		.membase = (void __iomem *)_mem_base,		\
		.pin_base = _pin_base,				\
		.nr_pins  = _number,				\
		.eint_type = _eint_type,			\
		.name     = _name,				\
		.irq      = _irq,				\
	}

/*
 * The sunXi PIO registers are organized as is:
 * 0x00 - 0x0c	Muxing values.
 *		8 pins per register, each pin having a 4bits value
 * 0x10		Pin values
 *		32 bits per register, each pin corresponding to one bit
 * 0x14 - 0x18	Drive level
 *		16 pins per register, each pin having a 2bits value
 * 0x1c - 0x20	Pull-Up values
 *		16 pins per register, each pin having a 2bits value
 *
 * This is for the first bank. Each bank will have the same layout,
 * with an offset being a multiple of 0x24.
 *
 * The following functions calculate from the pin number the register
 * and the bit offset that we should access.
 */
static inline u32 sunxi_modify_eint_pin_bais(u16 pin)
{
	u8		bank;
#if defined(CONFIG_ARCH_SUN8IW1)
	bank = pin / PINS_PER_BANK;
	if (4 == bank)
		bank = 2;
	else if( 6 == bank)
		bank = 3;
#endif
#if defined(CONFIG_ARCH_SUN8IW3)||defined(CONFIG_ARCH_SUN8IW5)
	bank = pin / PINS_PER_BANK;
	if( 6 == bank)
		bank = 2;
#endif
#if defined(CONFIG_ARCH_SUN8IW6)
	bank = pin/PINS_PER_BANK;
	if(1 == bank )
		bank = 0;
	else if(6 == bank)
		bank = 1;
	else if(7 == bank)
		bank = 2;
#endif
#if defined(CONFIG_ARCH_SUN9IW1)
	bank = pin / PINS_PER_BANK;
	if (4 == bank)
		bank = 2;
	else if(6 == bank)
		bank = 3;
	else if(7 == bank)
		bank = 4;
#endif
	return bank;
}
static inline u32 sunxi_mux_reg(u16 pin)
{
	u8 bank = pin / PINS_PER_BANK;
	u32 offset = bank * BANK_MEM_SIZE;
	offset += MUX_REGS_OFFSET;
	offset += pin % PINS_PER_BANK / MUX_PINS_PER_REG * 0x04;
	return round_down(offset, 4);
}

static inline u32 sunxi_mux_offset(u16 pin)
{
	u32 pin_num = pin % MUX_PINS_PER_REG;
	return pin_num * MUX_PINS_BITS;
}

static inline u32 sunxi_data_reg(u16 pin)
{
	u8 bank = pin / PINS_PER_BANK;
	u32 offset = bank * BANK_MEM_SIZE;
	offset += DATA_REGS_OFFSET;
	offset += pin % PINS_PER_BANK / DATA_PINS_PER_REG * 0x04;
	return round_down(offset, 4);
}

static inline u32 sunxi_data_offset(u16 pin)
{
	u32 pin_num = pin % DATA_PINS_PER_REG;
	return pin_num * DATA_PINS_BITS;
}

static inline u32 sunxi_dlevel_reg(u16 pin)
{
	u8 bank = pin / PINS_PER_BANK;
	u32 offset = bank * BANK_MEM_SIZE;
	offset += DLEVEL_REGS_OFFSET;
	offset += pin % PINS_PER_BANK / DLEVEL_PINS_PER_REG * 0x04;
	return round_down(offset, 4);
}

static inline u32 sunxi_dlevel_offset(u16 pin)
{
	u32 pin_num = pin % DLEVEL_PINS_PER_REG;
	return pin_num * DLEVEL_PINS_BITS;
}

static inline u32 sunxi_pull_reg(u16 pin)
{
	u8 bank = pin / PINS_PER_BANK;
	u32 offset = bank * BANK_MEM_SIZE;
	offset += PULL_REGS_OFFSET;
	offset += pin % PINS_PER_BANK / PULL_PINS_PER_REG * 0x04;
	return round_down(offset, 4);
}

static inline u32 sunxi_pull_offset(u16 pin)
{
	u32 pin_num = pin % PULL_PINS_PER_REG;
	return pin_num * PULL_PINS_BITS;
}

static inline u32 sunxi_eint_cfg_reg(u16 pin)
{	
	u8			bank;	
	u32			offset;
	bank = sunxi_modify_eint_pin_bais(pin);
	offset = bank * BANK_EINT_SIZE;
	offset += EINT_CFG_OFFSET;
	offset += pin % PINS_PER_BANK / EINT_CFG_PER_REG * 0x04;
	return round_down(offset, 4);
}
static inline u32 sunxi_eint_cfg_offset(u16 pin)
{
	u32 pin_num = pin % EINT_CFG_PER_REG;
	return pin_num * EINT_CFG_BITS;
}
static inline u32 sunxi_eint_ctrl_reg(u16 pin)
{
	u8			bank;
	u32			offset;
	bank = sunxi_modify_eint_pin_bais(pin);
	offset = bank * BANK_EINT_SIZE;
	offset += EINT_CTRL_OFFSET;
	offset += pin % PINS_PER_BANK / EINT_CTRL_PER_REG * 0x04;
	return round_down(offset, 4);
}

static inline u32 sunxi_eint_ctrl_offset(u16 pin)
{
	u32 pin_num = pin % EINT_CTRL_PER_REG;
	return pin_num * EINT_CTRL_BITS;
}

static inline u32 sunxi_eint_status_reg(u16 pin)
{
	u8			bank;
	u32			offset;
	bank = sunxi_modify_eint_pin_bais(pin);
	offset = bank * BANK_EINT_SIZE;
	offset += EINT_STATUS_OFFSET;
	offset += pin % PINS_PER_BANK / EINT_STATUS_PER_REG * 0x04;
	return round_down(offset, 4);
}

static inline u32 sunxi_eint_status_offset(u16 pin)
{
	u32 pin_num = pin % EINT_STATUS_PER_REG;
	return pin_num * EINT_STATUS_BITS;
}

static inline u32 sunxi_eint_debounce_reg(u16 pin)
{
	u8			bank;
	u32			offset;
	bank = sunxi_modify_eint_pin_bais(pin);
	offset = bank * BANK_EINT_SIZE;
	offset += EINT_DEBOUNCE_OFFSET;
	return round_down(offset, 4);

}
static inline void sunxi_write_reg(u32 value,void __iomem *reg)
{
	writel(value,reg);
	if(unlikely(((void __iomem *)(0xF1C208D8)) == reg))
		writel(0, (volatile void __iomem *)(0xF1C20CD8));
	else if(unlikely(((void __iomem *)(0xF1C208F8)) == reg))
		writel(0,(volatile void __iomem *)(0xF1C20CF8));
	else if(unlikely(((void __iomem *)(0xF1C20918)) == reg))
		writel(0, (volatile void __iomem *)(0xF1C20D18));
}


/* list of all exported SoC specific data */
extern struct sunxi_pinctrl_desc sun8i_w1_pinctrl_data;
extern struct sunxi_pinctrl_desc sun8i_w3_pinctrl_data;
extern struct sunxi_pinctrl_desc sun8i_w5_pinctrl_data;
extern struct sunxi_pinctrl_desc sun8i_w6_pinctrl_data;
extern struct sunxi_pinctrl_desc sun8i_w8_pinctrl_data;
extern struct sunxi_pinctrl_desc sun9i_w1_pinctrl_data;

#endif /* __PINCTRL_SUNXI_H */
