#include "clk-sun8iw6.h"
/*
 * freq table from hardware, need follow rules
 * 1)   each table  named as 
 *      factor_pll1_tbl
 *      factor_pll2_tbl
 *      ...
 * 2) for each table line 
 *      a) follow the format PLLx(n,k,m,p,d1,d2,freq), and keep the factors order
 *      b) if any factor not used, skip it
 *      c) the factor is the value to write registers, not means factor+1
 *
 *      example
 *      PLL1(9, 0, 0, 2, 60000000) means PLL1(n,k,m,p,freq)  
 *      PLLVIDEO(3, 0, 96000000)       means PLLVIDEO(n,m,freq) 
 *
 */
struct sunxi_clk_factor_freq factor_pllcpu0_tbl[] = {
PLLCPU(9,0,216000000),
PLLCPU(10,0,240000000),
PLLCPU(11,0,264000000),
PLLCPU(12,0,288000000),
PLLCPU(13,0,312000000),
PLLCPU(14,0,336000000),
PLLCPU(15,0,360000000),
PLLCPU(16,0,384000000),
PLLCPU(17,0,408000000),
PLLCPU(18,0,432000000),
PLLCPU(19,0,456000000),
PLLCPU(20,0,480000000),
PLLCPU(21,0,504000000),
PLLCPU(22,0,528000000),
PLLCPU(23,0,552000000),
PLLCPU(24,0,576000000),
PLLCPU(25,0,600000000),
PLLCPU(26,0,624000000),
PLLCPU(27,0,648000000),
PLLCPU(28,0,672000000),
PLLCPU(29,0,696000000),
PLLCPU(30,0,720000000),
PLLCPU(31,0,744000000),
PLLCPU(32,0,768000000),
PLLCPU(33,0,792000000),
PLLCPU(34,0,816000000),
PLLCPU(35,0,840000000),
PLLCPU(36,0,864000000),
PLLCPU(37,0,888000000),
PLLCPU(38,0,912000000),
PLLCPU(39,0,936000000),
PLLCPU(40,0,960000000),
PLLCPU(41,0,984000000),
PLLCPU(42,0,1008000000),
PLLCPU(43,0,1032000000),
PLLCPU(44,0,1056000000),
PLLCPU(45,0,1080000000),
PLLCPU(46,0,1104000000),
PLLCPU(47,0,1128000000),
PLLCPU(48,0,1152000000),
PLLCPU(49,0,1176000000),
PLLCPU(50,0,1200000000),
PLLCPU(51,0,1224000000),
PLLCPU(52,0,1248000000),
PLLCPU(53,0,1272000000),
PLLCPU(54,0,1296000000),
PLLCPU(55,0,1320000000),
PLLCPU(56,0,1344000000),
PLLCPU(57,0,1368000000),
PLLCPU(58,0,1392000000),
PLLCPU(59,0,1416000000),
PLLCPU(60,0,1440000000),
PLLCPU(61,0,1464000000),
PLLCPU(62,0,1488000000),
PLLCPU(63,0,1512000000),
PLLCPU(64,0,1536000000),
PLLCPU(65,0,1560000000),
PLLCPU(66,0,1584000000),
PLLCPU(67,0,1608000000),
PLLCPU(68,0,1632000000),
PLLCPU(69,0,1656000000),
PLLCPU(70,0,1680000000),
PLLCPU(71,0,1704000000),
PLLCPU(72,0,1728000000),
PLLCPU(73,0,1752000000),
PLLCPU(74,0,1776000000),
PLLCPU(75,0,1800000000),
PLLCPU(76,0,1824000000),
PLLCPU(77,0,1848000000),
PLLCPU(78,0,1872000000),
PLLCPU(79,0,1896000000),
PLLCPU(80,0,1920000000),
PLLCPU(81,0,1944000000),
PLLCPU(82,0,1968000000),
PLLCPU(83,0,1992000000),
PLLCPU(84,0,2016000000),
};
struct sunxi_clk_factor_freq factor_pllcpu1_tbl[] = {
PLLCPU(9,0,216000000),
PLLCPU(10,0,240000000),
PLLCPU(11,0,264000000),
PLLCPU(12,0,288000000),
PLLCPU(13,0,312000000),
PLLCPU(14,0,336000000),
PLLCPU(15,0,360000000),
PLLCPU(16,0,384000000),
PLLCPU(17,0,408000000),
PLLCPU(18,0,432000000),
PLLCPU(19,0,456000000),
PLLCPU(20,0,480000000),
PLLCPU(21,0,504000000),
PLLCPU(22,0,528000000),
PLLCPU(23,0,552000000),
PLLCPU(24,0,576000000),
PLLCPU(25,0,600000000),
PLLCPU(26,0,624000000),
PLLCPU(27,0,648000000),
PLLCPU(28,0,672000000),
PLLCPU(29,0,696000000),
PLLCPU(30,0,720000000),
PLLCPU(31,0,744000000),
PLLCPU(32,0,768000000),
PLLCPU(33,0,792000000),
PLLCPU(34,0,816000000),
PLLCPU(35,0,840000000),
PLLCPU(36,0,864000000),
PLLCPU(37,0,888000000),
PLLCPU(38,0,912000000),
PLLCPU(39,0,936000000),
PLLCPU(40,0,960000000),
PLLCPU(41,0,984000000),
PLLCPU(42,0,1008000000),
PLLCPU(43,0,1032000000),
PLLCPU(44,0,1056000000),
PLLCPU(45,0,1080000000),
PLLCPU(46,0,1104000000),
PLLCPU(47,0,1128000000),
PLLCPU(48,0,1152000000),
PLLCPU(49,0,1176000000),
PLLCPU(50,0,1200000000),
PLLCPU(51,0,1224000000),
PLLCPU(52,0,1248000000),
PLLCPU(53,0,1272000000),
PLLCPU(54,0,1296000000),
PLLCPU(55,0,1320000000),
PLLCPU(56,0,1344000000),
PLLCPU(57,0,1368000000),
PLLCPU(58,0,1392000000),
PLLCPU(59,0,1416000000),
PLLCPU(60,0,1440000000),
PLLCPU(61,0,1464000000),
PLLCPU(62,0,1488000000),
PLLCPU(63,0,1512000000),
PLLCPU(64,0,1536000000),
PLLCPU(65,0,1560000000),
PLLCPU(66,0,1584000000),
PLLCPU(67,0,1608000000),
PLLCPU(68,0,1632000000),
PLLCPU(69,0,1656000000),
PLLCPU(70,0,1680000000),
PLLCPU(71,0,1704000000),
PLLCPU(72,0,1728000000),
PLLCPU(73,0,1752000000),
PLLCPU(74,0,1776000000),
PLLCPU(75,0,1800000000),
PLLCPU(76,0,1824000000),
PLLCPU(77,0,1848000000),
PLLCPU(78,0,1872000000),
PLLCPU(79,0,1896000000),
PLLCPU(80,0,1920000000),
PLLCPU(81,0,1944000000),
PLLCPU(82,0,1968000000),
PLLCPU(83,0,1992000000),
PLLCPU(84,0,2016000000),
};
struct sunxi_clk_factor_freq factor_pllvideo_tbl[] = {
PLLVIDEO(9,0,0,216000000),
PLLVIDEO(10,0,0,240000000),
PLLVIDEO(11,0,0,264000000),
PLLVIDEO(12,0,0,288000000),
PLLVIDEO(13,0,0,312000000),
PLLVIDEO(14,0,0,336000000),
PLLVIDEO(15,0,0,360000000),
PLLVIDEO(16,0,0,384000000),
PLLVIDEO(17,0,0,408000000),
PLLVIDEO(18,0,0,432000000),
PLLVIDEO(19,0,0,456000000),
PLLVIDEO(20,0,0,480000000),
PLLVIDEO(21,0,0,504000000),
PLLVIDEO(22,0,0,528000000),
PLLVIDEO(23,0,0,552000000),
PLLVIDEO(24,0,0,576000000),
PLLVIDEO(25,0,0,600000000),
PLLVIDEO(26,0,0,624000000),
PLLVIDEO(27,0,0,648000000),
PLLVIDEO(28,0,0,672000000),
PLLVIDEO(29,0,0,696000000),
PLLVIDEO(30,0,0,720000000),
PLLVIDEO(31,0,0,744000000),
PLLVIDEO(32,0,0,768000000),
PLLVIDEO(33,0,0,792000000),
PLLVIDEO(34,0,0,816000000),
PLLVIDEO(35,0,0,840000000),
PLLVIDEO(36,0,0,864000000),
PLLVIDEO(37,0,0,888000000),
PLLVIDEO(38,0,0,912000000),
PLLVIDEO(39,0,0,936000000),
PLLVIDEO(40,0,0,960000000),
PLLVIDEO(41,0,0,984000000),
PLLVIDEO(42,0,0,1008000000),
PLLVIDEO(43,0,0,1032000000),
PLLVIDEO(44,0,0,1056000000),
PLLVIDEO(45,0,0,1080000000),
PLLVIDEO(46,0,0,1104000000),
PLLVIDEO(47,0,0,1128000000),
PLLVIDEO(48,0,0,1152000000),
PLLVIDEO(49,0,0,1176000000),
PLLVIDEO(50,0,0,1200000000),
PLLVIDEO(51,0,0,1224000000),
PLLVIDEO(52,0,0,1248000000),
PLLVIDEO(53,0,0,1272000000),
PLLVIDEO(54,0,0,1296000000),
PLLVIDEO(55,0,0,1320000000),
PLLVIDEO(56,0,0,1344000000),
PLLVIDEO(57,0,0,1368000000),
PLLVIDEO(58,0,0,1392000000),
PLLVIDEO(59,0,0,1416000000),
PLLVIDEO(60,0,0,1440000000),
PLLVIDEO(61,0,0,1464000000),
PLLVIDEO(62,0,0,1488000000),
PLLVIDEO(63,0,0,1512000000),
PLLVIDEO(64,0,0,1536000000),
PLLVIDEO(65,0,0,1560000000),
PLLVIDEO(66,0,0,1584000000),
PLLVIDEO(67,0,0,1608000000),
PLLVIDEO(68,0,0,1632000000),
PLLVIDEO(69,0,0,1656000000),
PLLVIDEO(70,0,0,1680000000),
PLLVIDEO(71,0,0,1704000000),
PLLVIDEO(72,0,0,1728000000),
PLLVIDEO(73,0,0,1752000000),
PLLVIDEO(74,0,0,1776000000),
PLLVIDEO(75,0,0,1800000000),
PLLVIDEO(76,0,0,1824000000),
PLLVIDEO(77,0,0,1848000000),
PLLVIDEO(78,0,0,1872000000),
PLLVIDEO(79,0,0,1896000000),
PLLVIDEO(80,0,0,1920000000),
PLLVIDEO(81,0,0,1944000000),
PLLVIDEO(82,0,0,1968000000),
PLLVIDEO(83,0,0,1992000000),
PLLVIDEO(84,0,0,2016000000),
};
struct sunxi_clk_factor_freq factor_pllve_tbl[] = {
PLLVE(9,0,0,216000000),
PLLVE(10,0,0,240000000),
PLLVE(11,0,0,264000000),
PLLVE(12,0,0,288000000),
PLLVE(13,0,0,312000000),
PLLVE(14,0,0,336000000),
PLLVE(15,0,0,360000000),
PLLVE(16,0,0,384000000),
PLLVE(17,0,0,408000000),
PLLVE(18,0,0,432000000),
PLLVE(19,0,0,456000000),
PLLVE(20,0,0,480000000),
PLLVE(21,0,0,504000000),
PLLVE(22,0,0,528000000),
PLLVE(23,0,0,552000000),
PLLVE(24,0,0,576000000),
PLLVE(25,0,0,600000000),
PLLVE(26,0,0,624000000),
PLLVE(27,0,0,648000000),
PLLVE(28,0,0,672000000),
PLLVE(29,0,0,696000000),
PLLVE(30,0,0,720000000),
PLLVE(31,0,0,744000000),
PLLVE(32,0,0,768000000),
PLLVE(33,0,0,792000000),
PLLVE(34,0,0,816000000),
PLLVE(35,0,0,840000000),
PLLVE(36,0,0,864000000),
PLLVE(37,0,0,888000000),
PLLVE(38,0,0,912000000),
PLLVE(39,0,0,936000000),
PLLVE(40,0,0,960000000),
PLLVE(41,0,0,984000000),
PLLVE(42,0,0,1008000000),
PLLVE(43,0,0,1032000000),
PLLVE(44,0,0,1056000000),
PLLVE(45,0,0,1080000000),
PLLVE(46,0,0,1104000000),
PLLVE(47,0,0,1128000000),
PLLVE(48,0,0,1152000000),
PLLVE(49,0,0,1176000000),
PLLVE(50,0,0,1200000000),
PLLVE(51,0,0,1224000000),
PLLVE(52,0,0,1248000000),
PLLVE(53,0,0,1272000000),
PLLVE(54,0,0,1296000000),
PLLVE(55,0,0,1320000000),
PLLVE(56,0,0,1344000000),
PLLVE(57,0,0,1368000000),
PLLVE(58,0,0,1392000000),
PLLVE(59,0,0,1416000000),
PLLVE(60,0,0,1440000000),
PLLVE(61,0,0,1464000000),
PLLVE(62,0,0,1488000000),
PLLVE(63,0,0,1512000000),
PLLVE(64,0,0,1536000000),
PLLVE(65,0,0,1560000000),
PLLVE(66,0,0,1584000000),
PLLVE(67,0,0,1608000000),
PLLVE(68,0,0,1632000000),
PLLVE(69,0,0,1656000000),
PLLVE(70,0,0,1680000000),
PLLVE(71,0,0,1704000000),
PLLVE(72,0,0,1728000000),
PLLVE(73,0,0,1752000000),
PLLVE(74,0,0,1776000000),
PLLVE(75,0,0,1800000000),
PLLVE(76,0,0,1824000000),
PLLVE(77,0,0,1848000000),
PLLVE(78,0,0,1872000000),
PLLVE(79,0,0,1896000000),
PLLVE(80,0,0,1920000000),
PLLVE(81,0,0,1944000000),
PLLVE(82,0,0,1968000000),
PLLVE(83,0,0,1992000000),
PLLVE(84,0,0,2016000000),
};
struct sunxi_clk_factor_freq factor_pllddr_tbl[] = {
PLLDDR(17,1,0,204000000),
PLLDDR(35,1,1,210000000),
PLLDDR(9,0,0,216000000),
PLLDDR(37,1,1,222000000),
PLLDDR(19,1,0,228000000),
PLLDDR(39,1,1,234000000),
PLLDDR(10,0,0,240000000),
PLLDDR(41,1,1,246000000),
PLLDDR(21,1,0,252000000),
PLLDDR(43,1,1,258000000),
PLLDDR(11,0,0,264000000),
PLLDDR(45,1,1,270000000),
PLLDDR(23,1,0,276000000),
PLLDDR(47,1,1,282000000),
PLLDDR(12,0,0,288000000),
PLLDDR(49,1,1,294000000),
PLLDDR(25,1,0,300000000),
PLLDDR(51,1,1,306000000),
PLLDDR(13,0,0,312000000),
PLLDDR(53,1,1,318000000),
PLLDDR(27,1,0,324000000),
PLLDDR(55,1,1,330000000),
PLLDDR(14,0,0,336000000),
PLLDDR(57,1,1,342000000),
PLLDDR(29,1,0,348000000),
PLLDDR(59,1,1,354000000),
PLLDDR(15,0,0,360000000),
PLLDDR(61,1,1,366000000),
PLLDDR(31,1,0,372000000),
PLLDDR(63,1,1,378000000),
PLLDDR(16,0,0,384000000),
PLLDDR(33,1,0,396000000),
PLLDDR(17,0,0,408000000),
PLLDDR(35,1,0,420000000),
PLLDDR(18,0,0,432000000),
PLLDDR(37,1,0,444000000),
PLLDDR(19,0,0,456000000),
PLLDDR(39,1,0,468000000),
PLLDDR(20,0,0,480000000),
PLLDDR(41,1,0,492000000),
PLLDDR(21,0,0,504000000),
PLLDDR(43,1,0,516000000),
PLLDDR(22,0,0,528000000),
PLLDDR(45,1,0,540000000),
PLLDDR(23,0,0,552000000),
PLLDDR(47,1,0,564000000),
PLLDDR(24,0,0,576000000),
PLLDDR(49,1,0,588000000),
PLLDDR(25,0,0,600000000),
PLLDDR(51,1,0,612000000),
PLLDDR(26,0,0,624000000),
PLLDDR(53,1,0,636000000),
PLLDDR(27,0,0,648000000),
PLLDDR(55,1,0,660000000),
PLLDDR(28,0,0,672000000),
PLLDDR(57,1,0,684000000),
PLLDDR(29,0,0,696000000),
PLLDDR(59,1,0,708000000),
PLLDDR(30,0,0,720000000),
PLLDDR(61,1,0,732000000),
PLLDDR(31,0,0,744000000),
PLLDDR(63,1,0,756000000),
PLLDDR(32,0,0,768000000),
PLLDDR(33,0,0,792000000),
};
struct sunxi_clk_factor_freq factor_pllperiph_tbl[] = {
PLLPERIPH(13,1,1,78000000),
PLLPERIPH(7,1,0,84000000),
PLLPERIPH(15,1,1,90000000),
PLLPERIPH(4,0,0,96000000),
PLLPERIPH(17,1,1,102000000),
PLLPERIPH(9,1,0,108000000),
PLLPERIPH(19,1,1,114000000),
PLLPERIPH(5,0,0,120000000),
PLLPERIPH(21,1,1,126000000),
PLLPERIPH(11,1,0,132000000),
PLLPERIPH(23,1,1,138000000),
PLLPERIPH(6,0,0,144000000),
PLLPERIPH(25,1,1,150000000),
PLLPERIPH(13,1,0,156000000),
PLLPERIPH(27,1,1,162000000),
PLLPERIPH(7,0,0,168000000),
PLLPERIPH(29,1,1,174000000),
PLLPERIPH(15,1,0,180000000),
PLLPERIPH(31,1,1,186000000),
PLLPERIPH(8,0,0,192000000),
PLLPERIPH(33,1,1,198000000),
PLLPERIPH(17,1,0,204000000),
PLLPERIPH(35,1,1,210000000),
PLLPERIPH(9,0,0,216000000),
PLLPERIPH(37,1,1,222000000),
PLLPERIPH(19,1,0,228000000),
PLLPERIPH(39,1,1,234000000),
PLLPERIPH(10,0,0,240000000),
PLLPERIPH(41,1,1,246000000),
PLLPERIPH(21,1,0,252000000),
PLLPERIPH(43,1,1,258000000),
PLLPERIPH(11,0,0,264000000),
PLLPERIPH(45,1,1,270000000),
PLLPERIPH(23,1,0,276000000),
PLLPERIPH(47,1,1,282000000),
PLLPERIPH(12,0,0,288000000),
PLLPERIPH(49,1,1,294000000),
PLLPERIPH(25,1,0,300000000),
PLLPERIPH(51,1,1,306000000),
PLLPERIPH(13,0,0,312000000),
PLLPERIPH(53,1,1,318000000),
PLLPERIPH(27,1,0,324000000),
PLLPERIPH(55,1,1,330000000),
PLLPERIPH(14,0,0,336000000),
PLLPERIPH(57,1,1,342000000),
PLLPERIPH(29,1,0,348000000),
PLLPERIPH(59,1,1,354000000),
PLLPERIPH(15,0,0,360000000),
PLLPERIPH(61,1,1,366000000),
PLLPERIPH(31,1,0,372000000),
PLLPERIPH(63,1,1,378000000),
PLLPERIPH(16,0,0,384000000),
PLLPERIPH(65,1,1,390000000),
PLLPERIPH(33,1,0,396000000),
PLLPERIPH(67,1,1,402000000),
PLLPERIPH(17,0,0,408000000),
PLLPERIPH(69,1,1,414000000),
PLLPERIPH(35,1,0,420000000),
PLLPERIPH(71,1,1,426000000),
PLLPERIPH(18,0,0,432000000),
PLLPERIPH(73,1,1,438000000),
PLLPERIPH(37,1,0,444000000),
PLLPERIPH(75,1,1,450000000),
PLLPERIPH(19,0,0,456000000),
PLLPERIPH(77,1,1,462000000),
PLLPERIPH(39,1,0,468000000),
PLLPERIPH(79,1,1,474000000),
PLLPERIPH(20,0,0,480000000),
PLLPERIPH(81,1,1,486000000),
PLLPERIPH(41,1,0,492000000),
PLLPERIPH(83,1,1,498000000),
PLLPERIPH(21,0,0,504000000),
PLLPERIPH(85,1,1,510000000),
PLLPERIPH(43,1,0,516000000),
PLLPERIPH(87,1,1,522000000),
PLLPERIPH(22,0,0,528000000),
PLLPERIPH(89,1,1,534000000),
PLLPERIPH(45,1,0,540000000),
PLLPERIPH(91,1,1,546000000),
PLLPERIPH(23,0,0,552000000),
PLLPERIPH(93,1,1,558000000),
PLLPERIPH(47,1,0,564000000),
PLLPERIPH(95,1,1,570000000),
PLLPERIPH(24,0,0,576000000),
PLLPERIPH(97,1,1,582000000),
PLLPERIPH(49,1,0,588000000),
PLLPERIPH(99,1,1,594000000),
PLLPERIPH(25,0,0,600000000),
PLLPERIPH(101,1,1,606000000),
PLLPERIPH(51,1,0,612000000),
PLLPERIPH(103,1,1,618000000),
PLLPERIPH(26,0,0,624000000),
PLLPERIPH(105,1,1,630000000),
PLLPERIPH(53,1,0,636000000),
PLLPERIPH(107,1,1,642000000),
PLLPERIPH(27,0,0,648000000),
PLLPERIPH(109,1,1,654000000),
PLLPERIPH(55,1,0,660000000),
PLLPERIPH(111,1,1,666000000),
PLLPERIPH(28,0,0,672000000),
PLLPERIPH(113,1,1,678000000),
PLLPERIPH(57,1,0,684000000),
PLLPERIPH(115,1,1,690000000),
PLLPERIPH(29,0,0,696000000),
PLLPERIPH(117,1,1,702000000),
PLLPERIPH(59,1,0,708000000),
PLLPERIPH(119,1,1,714000000),
PLLPERIPH(30,0,0,720000000),
};

struct sunxi_clk_factor_freq factor_pllgpu_tbl[] = {
PLLGPU(13,1,1,78000000),
PLLGPU(7,1,0,84000000),
PLLGPU(15,1,1,90000000),
PLLGPU(4,0,0,96000000),
PLLGPU(17,1,1,102000000),
PLLGPU(9,1,0,108000000),
PLLGPU(19,1,1,114000000),
PLLGPU(5,0,0,120000000),
PLLGPU(21,1,1,126000000),
PLLGPU(11,1,0,132000000),
PLLGPU(23,1,1,138000000),
PLLGPU(6,0,0,144000000),
PLLGPU(25,1,1,150000000),
PLLGPU(13,1,0,156000000),
PLLGPU(27,1,1,162000000),
PLLGPU(7,0,0,168000000),
PLLGPU(29,1,1,174000000),
PLLGPU(15,1,0,180000000),
PLLGPU(31,1,1,186000000),
PLLGPU(8,0,0,192000000),
PLLGPU(33,1,1,198000000),
PLLGPU(17,1,0,204000000),
PLLGPU(35,1,1,210000000),
PLLGPU(9,0,0,216000000),
PLLGPU(37,1,1,222000000),
PLLGPU(19,1,0,228000000),
PLLGPU(39,1,1,234000000),
PLLGPU(10,0,0,240000000),
PLLGPU(41,1,1,246000000),
PLLGPU(21,1,0,252000000),
PLLGPU(43,1,1,258000000),
PLLGPU(11,0,0,264000000),
PLLGPU(45,1,1,270000000),
PLLGPU(23,1,0,276000000),
PLLGPU(47,1,1,282000000),
PLLGPU(12,0,0,288000000),
PLLGPU(49,1,1,294000000),
PLLGPU(25,1,0,300000000),
PLLGPU(51,1,1,306000000),
PLLGPU(13,0,0,312000000),
PLLGPU(53,1,1,318000000),
PLLGPU(27,1,0,324000000),
PLLGPU(55,1,1,330000000),
PLLGPU(14,0,0,336000000),
PLLGPU(57,1,1,342000000),
PLLGPU(29,1,0,348000000),
PLLGPU(59,1,1,354000000),
PLLGPU(15,0,0,360000000),
PLLGPU(61,1,1,366000000),
PLLGPU(31,1,0,372000000),
PLLGPU(63,1,1,378000000),
PLLGPU(16,0,0,384000000),
PLLGPU(65,1,1,390000000),
PLLGPU(33,1,0,396000000),
PLLGPU(67,1,1,402000000),
PLLGPU(17,0,0,408000000),
PLLGPU(69,1,1,414000000),
PLLGPU(35,1,0,420000000),
PLLGPU(71,1,1,426000000),
PLLGPU(18,0,0,432000000),
PLLGPU(73,1,1,438000000),
PLLGPU(37,1,0,444000000),
PLLGPU(75,1,1,450000000),
PLLGPU(19,0,0,456000000),
PLLGPU(77,1,1,462000000),
PLLGPU(39,1,0,468000000),
PLLGPU(79,1,1,474000000),
PLLGPU(20,0,0,480000000),
PLLGPU(81,1,1,486000000),
PLLGPU(41,1,0,492000000),
PLLGPU(83,1,1,498000000),
PLLGPU(21,0,0,504000000),
PLLGPU(85,1,1,510000000),
PLLGPU(43,1,0,516000000),
PLLGPU(87,1,1,522000000),
PLLGPU(22,0,0,528000000),
PLLGPU(89,1,1,534000000),
PLLGPU(45,1,0,540000000),
PLLGPU(91,1,1,546000000),
PLLGPU(23,0,0,552000000),
PLLGPU(93,1,1,558000000),
PLLGPU(47,1,0,564000000),
PLLGPU(95,1,1,570000000),
PLLGPU(24,0,0,576000000),
PLLGPU(97,1,1,582000000),
PLLGPU(49,1,0,588000000),
PLLGPU(99,1,1,594000000),
PLLGPU(25,0,0,600000000),
PLLGPU(101,1,1,606000000),
PLLGPU(51,1,0,612000000),
PLLGPU(103,1,1,618000000),
PLLGPU(26,0,0,624000000),
PLLGPU(105,1,1,630000000),
PLLGPU(53,1,0,636000000),
PLLGPU(107,1,1,642000000),
PLLGPU(27,0,0,648000000),
PLLGPU(109,1,1,654000000),
PLLGPU(55,1,0,660000000),
PLLGPU(111,1,1,666000000),
PLLGPU(28,0,0,672000000),
PLLGPU(113,1,1,678000000),
PLLGPU(57,1,0,684000000),
PLLGPU(115,1,1,690000000),
PLLGPU(29,0,0,696000000),
PLLGPU(117,1,1,702000000),
PLLGPU(59,1,0,708000000),
PLLGPU(119,1,1,714000000),
PLLGPU(30,0,0,720000000),
};
struct sunxi_clk_factor_freq factor_pllhsic_tbl[] = {
PLLHSIC(13,1,1,78000000),
PLLHSIC(7,1,0,84000000),
PLLHSIC(15,1,1,90000000),
PLLHSIC(4,0,0,96000000),
PLLHSIC(17,1,1,102000000),
PLLHSIC(9,1,0,108000000),
PLLHSIC(19,1,1,114000000),
PLLHSIC(5,0,0,120000000),
PLLHSIC(21,1,1,126000000),
PLLHSIC(11,1,0,132000000),
PLLHSIC(23,1,1,138000000),
PLLHSIC(6,0,0,144000000),
PLLHSIC(25,1,1,150000000),
PLLHSIC(13,1,0,156000000),
PLLHSIC(27,1,1,162000000),
PLLHSIC(7,0,0,168000000),
PLLHSIC(29,1,1,174000000),
PLLHSIC(15,1,0,180000000),
PLLHSIC(31,1,1,186000000),
PLLHSIC(8,0,0,192000000),
PLLHSIC(33,1,1,198000000),
PLLHSIC(17,1,0,204000000),
PLLHSIC(35,1,1,210000000),
PLLHSIC(9,0,0,216000000),
PLLHSIC(37,1,1,222000000),
PLLHSIC(19,1,0,228000000),
PLLHSIC(39,1,1,234000000),
PLLHSIC(10,0,0,240000000),
PLLHSIC(41,1,1,246000000),
PLLHSIC(21,1,0,252000000),
PLLHSIC(43,1,1,258000000),
PLLHSIC(11,0,0,264000000),
PLLHSIC(45,1,1,270000000),
PLLHSIC(23,1,0,276000000),
PLLHSIC(47,1,1,282000000),
PLLHSIC(12,0,0,288000000),
PLLHSIC(49,1,1,294000000),
PLLHSIC(25,1,0,300000000),
PLLHSIC(51,1,1,306000000),
PLLHSIC(13,0,0,312000000),
PLLHSIC(53,1,1,318000000),
PLLHSIC(27,1,0,324000000),
PLLHSIC(55,1,1,330000000),
PLLHSIC(14,0,0,336000000),
PLLHSIC(57,1,1,342000000),
PLLHSIC(29,1,0,348000000),
PLLHSIC(59,1,1,354000000),
PLLHSIC(15,0,0,360000000),
PLLHSIC(61,1,1,366000000),
PLLHSIC(31,1,0,372000000),
PLLHSIC(63,1,1,378000000),
PLLHSIC(16,0,0,384000000),
PLLHSIC(65,1,1,390000000),
PLLHSIC(33,1,0,396000000),
PLLHSIC(67,1,1,402000000),
PLLHSIC(17,0,0,408000000),
PLLHSIC(69,1,1,414000000),
PLLHSIC(35,1,0,420000000),
PLLHSIC(71,1,1,426000000),
PLLHSIC(18,0,0,432000000),
PLLHSIC(73,1,1,438000000),
PLLHSIC(37,1,0,444000000),
PLLHSIC(75,1,1,450000000),
PLLHSIC(19,0,0,456000000),
PLLHSIC(77,1,1,462000000),
PLLHSIC(39,1,0,468000000),
PLLHSIC(79,1,1,474000000),
PLLHSIC(20,0,0,480000000),
PLLHSIC(81,1,1,486000000),
PLLHSIC(41,1,0,492000000),
PLLHSIC(83,1,1,498000000),
PLLHSIC(21,0,0,504000000),
PLLHSIC(85,1,1,510000000),
PLLHSIC(43,1,0,516000000),
PLLHSIC(87,1,1,522000000),
PLLHSIC(22,0,0,528000000),
PLLHSIC(89,1,1,534000000),
PLLHSIC(45,1,0,540000000),
PLLHSIC(91,1,1,546000000),
PLLHSIC(23,0,0,552000000),
PLLHSIC(93,1,1,558000000),
PLLHSIC(47,1,0,564000000),
PLLHSIC(95,1,1,570000000),
PLLHSIC(24,0,0,576000000),
PLLHSIC(97,1,1,582000000),
PLLHSIC(49,1,0,588000000),
PLLHSIC(99,1,1,594000000),
PLLHSIC(25,0,0,600000000),
PLLHSIC(101,1,1,606000000),
PLLHSIC(51,1,0,612000000),
PLLHSIC(103,1,1,618000000),
PLLHSIC(26,0,0,624000000),
PLLHSIC(105,1,1,630000000),
PLLHSIC(53,1,0,636000000),
PLLHSIC(107,1,1,642000000),
PLLHSIC(27,0,0,648000000),
PLLHSIC(109,1,1,654000000),
PLLHSIC(55,1,0,660000000),
PLLHSIC(111,1,1,666000000),
PLLHSIC(28,0,0,672000000),
PLLHSIC(113,1,1,678000000),
PLLHSIC(57,1,0,684000000),
PLLHSIC(115,1,1,690000000),
PLLHSIC(29,0,0,696000000),
PLLHSIC(117,1,1,702000000),
PLLHSIC(59,1,0,708000000),
PLLHSIC(119,1,1,714000000),
PLLHSIC(30,0,0,720000000),
};
struct sunxi_clk_factor_freq factor_pllde_tbl[] = {
PLLDE(13,1,1,78000000),
PLLDE(7,1,0,84000000),
PLLDE(15,1,1,90000000),
PLLDE(4,0,0,96000000),
PLLDE(17,1,1,102000000),
PLLDE(9,1,0,108000000),
PLLDE(19,1,1,114000000),
PLLDE(5,0,0,120000000),
PLLDE(21,1,1,126000000),
PLLDE(11,1,0,132000000),
PLLDE(23,1,1,138000000),
PLLDE(6,0,0,144000000),
PLLDE(25,1,1,150000000),
PLLDE(13,1,0,156000000),
PLLDE(27,1,1,162000000),
PLLDE(7,0,0,168000000),
PLLDE(29,1,1,174000000),
PLLDE(15,1,0,180000000),
PLLDE(31,1,1,186000000),
PLLDE(8,0,0,192000000),
PLLDE(33,1,1,198000000),
PLLDE(17,1,0,204000000),
PLLDE(35,1,1,210000000),
PLLDE(9,0,0,216000000),
PLLDE(37,1,1,222000000),
PLLDE(19,1,0,228000000),
PLLDE(39,1,1,234000000),
PLLDE(10,0,0,240000000),
PLLDE(41,1,1,246000000),
PLLDE(21,1,0,252000000),
PLLDE(43,1,1,258000000),
PLLDE(11,0,0,264000000),
PLLDE(45,1,1,270000000),
PLLDE(23,1,0,276000000),
PLLDE(47,1,1,282000000),
PLLDE(12,0,0,288000000),
PLLDE(49,1,1,294000000),
PLLDE(25,1,0,300000000),
PLLDE(51,1,1,306000000),
PLLDE(13,0,0,312000000),
PLLDE(53,1,1,318000000),
PLLDE(27,1,0,324000000),
PLLDE(55,1,1,330000000),
PLLDE(14,0,0,336000000),
PLLDE(57,1,1,342000000),
PLLDE(29,1,0,348000000),
PLLDE(59,1,1,354000000),
PLLDE(15,0,0,360000000),
PLLDE(61,1,1,366000000),
PLLDE(31,1,0,372000000),
PLLDE(63,1,1,378000000),
PLLDE(16,0,0,384000000),
PLLDE(65,1,1,390000000),
PLLDE(33,1,0,396000000),
PLLDE(67,1,1,402000000),
PLLDE(17,0,0,408000000),
PLLDE(69,1,1,414000000),
PLLDE(35,1,0,420000000),
PLLDE(71,1,1,426000000),
PLLDE(18,0,0,432000000),
PLLDE(73,1,1,438000000),
PLLDE(37,1,0,444000000),
PLLDE(75,1,1,450000000),
PLLDE(19,0,0,456000000),
PLLDE(77,1,1,462000000),
PLLDE(39,1,0,468000000),
PLLDE(79,1,1,474000000),
PLLDE(20,0,0,480000000),
PLLDE(81,1,1,486000000),
PLLDE(41,1,0,492000000),
PLLDE(83,1,1,498000000),
PLLDE(21,0,0,504000000),
PLLDE(85,1,1,510000000),
PLLDE(43,1,0,516000000),
PLLDE(87,1,1,522000000),
PLLDE(22,0,0,528000000),
PLLDE(89,1,1,534000000),
PLLDE(45,1,0,540000000),
PLLDE(91,1,1,546000000),
PLLDE(23,0,0,552000000),
PLLDE(93,1,1,558000000),
PLLDE(47,1,0,564000000),
PLLDE(95,1,1,570000000),
PLLDE(24,0,0,576000000),
PLLDE(97,1,1,582000000),
PLLDE(49,1,0,588000000),
PLLDE(99,1,1,594000000),
PLLDE(25,0,0,600000000),
PLLDE(101,1,1,606000000),
PLLDE(51,1,0,612000000),
PLLDE(103,1,1,618000000),
PLLDE(26,0,0,624000000),
PLLDE(105,1,1,630000000),
PLLDE(53,1,0,636000000),
PLLDE(107,1,1,642000000),
PLLDE(27,0,0,648000000),
PLLDE(109,1,1,654000000),
PLLDE(55,1,0,660000000),
PLLDE(111,1,1,666000000),
PLLDE(28,0,0,672000000),
PLLDE(113,1,1,678000000),
PLLDE(57,1,0,684000000),
PLLDE(115,1,1,690000000),
PLLDE(29,0,0,696000000),
PLLDE(117,1,1,702000000),
PLLDE(59,1,0,708000000),
PLLDE(119,1,1,714000000),
PLLDE(30,0,0,720000000),
};


static unsigned int pllcpu0_max,pllcpu1_max,pllvideo_max;
static unsigned int pllve_max,pllddr_max;
static unsigned int pllperiph_max,pllgpu_max;
static unsigned int pllhsic_max,pllde_max;
void sunxi_clk_factor_initlimits(void)
{
    pllcpu0_max=factor_pllcpu0_tbl[ARRAY_SIZE(factor_pllcpu0_tbl)-1].freq;
    pllcpu1_max=factor_pllcpu1_tbl[ARRAY_SIZE(factor_pllcpu1_tbl)-1].freq;
    pllvideo_max=factor_pllvideo_tbl[ARRAY_SIZE(factor_pllvideo_tbl)-1].freq;
    pllve_max=factor_pllve_tbl[ARRAY_SIZE(factor_pllve_tbl)-1].freq;
    pllddr_max=factor_pllddr_tbl[ARRAY_SIZE(factor_pllddr_tbl)-1].freq;
    pllperiph_max=factor_pllperiph_tbl[ARRAY_SIZE(factor_pllperiph_tbl)-1].freq;
    pllgpu_max=factor_pllgpu_tbl[ARRAY_SIZE(factor_pllgpu_tbl)-1].freq;
    pllhsic_max=factor_pllhsic_tbl[ARRAY_SIZE(factor_pllhsic_tbl)-1].freq;
    pllde_max=factor_pllde_tbl[ARRAY_SIZE(factor_pllde_tbl)-1].freq;
}