/*
 * Copyright (C) 2013 Allwinnertech, kevin.z.m <kevin@allwinnertech.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */
#include <linux/clk-private.h>
#include <linux/clk-provider.h>
#include <linux/clkdev.h>
#include <linux/clk/sunxi.h>
#include <mach/sys_config.h>
#include "clk-sunxi.h"
#include "clk-factors.h"
#include "clk-periph.h"
#include "clk-sun8iw3.h"


#ifndef CONFIG_EVB_PLATFORM
    #define LOCKBIT(x) 31
#else
    #define LOCKBIT(x) x
#endif
static DEFINE_SPINLOCK(clk_lock);
void __iomem *sunxi_clk_base;
void __iomem *sunxi_clk_cpus_base=0;
int	sunxi_clk_maxreg =SUNXI_CLK_MAX_REG;
int cpus_clk_maxreg = 0;
#ifdef CONFIG_SUNXI_CLK_DUMMY_DEBUG
unsigned int dummy_reg[1024]; 
unsigned int dummy_readl(unsigned int* regaddr)
{
	unsigned int val;
	val = *regaddr;
	printk("--%s-- dummy_readl to read reg 0x%x with val 0x%x\n",__func__,((unsigned int)regaddr - (unsigned int)&dummy_reg[0]),val);
	return val;
}
void  dummy_writel(unsigned int val,unsigned int* regaddr)
	{
		*regaddr = val;
		printk("--%s-- dummy_writel to write reg 0x%x with val 0x%x\n",__func__,((unsigned int)regaddr - (unsigned int)&dummy_reg[0]),val);
	}

void dummy_reg_init(void)
{
	memset(dummy_reg,0x0,sizeof(dummy_reg));				
	dummy_reg[PLL1_CFG/4]=0x00001000;
	dummy_reg[PLL2_CFG/4]=0x00035514;
	dummy_reg[PLL3_CFG/4]=0x03006207;
	dummy_reg[PLL4_CFG/4]=0x03006207;
	dummy_reg[PLL5_CFG/4]=0x00001000;
	dummy_reg[PLL6_CFG/4]=0x00041811;
	dummy_reg[PLL8_CFG/4]=0x03006207;
	dummy_reg[PLL9_CFG/4]=0x03001300;
	dummy_reg[PLL10_CFG/4]=0x03006207;
	dummy_reg[CPU_CFG/4]=0x00001000;
	dummy_reg[AHB1_CFG/4]=0x00001010;
	dummy_reg[APB2_CFG/4]=0x01000000;
	dummy_reg[ATS_CFG/4]=0x80000000;
	dummy_reg[PLL_LOCK/4]=0x000000FF;
	dummy_reg[CPU_LOCK/4]=0x000000FF;
}
#endif // of CONFIG_SUNXI_CLK_DUMMY_DEBUG

/* periph factors pll1 config table */
static struct sunxi_clk_factor_freq factor_pll1_tbl[] = {
{F_N8X5_K4X2_M0X2_P16x2( 9, 0, 0, 2),  60000000}, /* freq = (6M * 0  ), index = 0 */
{F_N8X5_K4X2_M0X2_P16x2( 9, 0, 0, 2),  60000000}, /* freq = (6M * 1  ), index = 1 */
{F_N8X5_K4X2_M0X2_P16x2( 9, 0, 0, 2),  60000000}, /* freq = (6M * 2  ), index = 2 */
{F_N8X5_K4X2_M0X2_P16x2( 9, 0, 0, 2),  60000000}, /* freq = (6M * 3  ), index = 3 */
{F_N8X5_K4X2_M0X2_P16x2( 9, 0, 0, 2),  60000000}, /* freq = (6M * 4  ), index = 4 */
{F_N8X5_K4X2_M0X2_P16x2( 9, 0, 0, 2),  60000000}, /* freq = (6M * 5  ), index = 5 */
{F_N8X5_K4X2_M0X2_P16x2( 9, 0, 0, 2),  60000000}, /* freq = (6M * 6  ), index = 6 */
{F_N8X5_K4X2_M0X2_P16x2( 9, 0, 0, 2),  60000000}, /* freq = (6M * 7  ), index = 7 */
{F_N8X5_K4X2_M0X2_P16x2( 9, 0, 0, 2),  60000000}, /* freq = (6M * 8  ), index = 8 */
{F_N8X5_K4X2_M0X2_P16x2( 9, 0, 0, 2),  60000000}, /* freq = (6M * 9  ), index = 9 */
{F_N8X5_K4X2_M0X2_P16x2( 9, 0, 0, 2),  60000000}, /* freq = (6M * 10 ), index = 10 */
{F_N8X5_K4X2_M0X2_P16x2(10, 0, 0, 2),  66000000}, /* freq = (6M * 11 ), index = 11 */
{F_N8X5_K4X2_M0X2_P16x2(11, 0, 0, 2),  72000000}, /* freq = (6M * 12 ), index = 12 */
{F_N8X5_K4X2_M0X2_P16x2(12, 0, 0, 2),  78000000}, /* freq = (6M * 13 ), index = 13 */
{F_N8X5_K4X2_M0X2_P16x2(13, 0, 0, 2),  84000000}, /* freq = (6M * 14 ), index = 14 */
{F_N8X5_K4X2_M0X2_P16x2(14, 0, 0, 2),  90000000}, /* freq = (6M * 15 ), index = 15 */
{F_N8X5_K4X2_M0X2_P16x2(15, 0, 0, 2),  96000000}, /* freq = (6M * 16 ), index = 16 */
{F_N8X5_K4X2_M0X2_P16x2(16, 0, 0, 2), 102000000}, /* freq = (6M * 17 ), index = 17 */
{F_N8X5_K4X2_M0X2_P16x2(17, 0, 0, 2), 108000000}, /* freq = (6M * 18 ), index = 18 */
{F_N8X5_K4X2_M0X2_P16x2(18, 0, 0, 2), 114000000}, /* freq = (6M * 19 ), index = 19 */
{F_N8X5_K4X2_M0X2_P16x2( 9, 0, 0, 1), 120000000}, /* freq = (6M * 20 ), index = 20 */
{F_N8X5_K4X2_M0X2_P16x2(10, 0, 0, 1), 132000000}, /* freq = (6M * 21 ), index = 21 */
{F_N8X5_K4X2_M0X2_P16x2(10, 0, 0, 1), 132000000}, /* freq = (6M * 22 ), index = 22 */
{F_N8X5_K4X2_M0X2_P16x2(11, 0, 0, 1), 144000000}, /* freq = (6M * 23 ), index = 23 */
{F_N8X5_K4X2_M0X2_P16x2(11, 0, 0, 1), 144000000}, /* freq = (6M * 24 ), index = 24 */
{F_N8X5_K4X2_M0X2_P16x2(12, 0, 0, 1), 156000000}, /* freq = (6M * 25 ), index = 25 */
{F_N8X5_K4X2_M0X2_P16x2(12, 0, 0, 1), 156000000}, /* freq = (6M * 26 ), index = 26 */
{F_N8X5_K4X2_M0X2_P16x2(13, 0, 0, 1), 168000000}, /* freq = (6M * 27 ), index = 27 */
{F_N8X5_K4X2_M0X2_P16x2(13, 0, 0, 1), 168000000}, /* freq = (6M * 28 ), index = 28 */
{F_N8X5_K4X2_M0X2_P16x2(14, 0, 0, 1), 180000000}, /* freq = (6M * 29 ), index = 29 */
{F_N8X5_K4X2_M0X2_P16x2(14, 0, 0, 1), 180000000}, /* freq = (6M * 30 ), index = 30 */
{F_N8X5_K4X2_M0X2_P16x2(15, 0, 0, 1), 192000000}, /* freq = (6M * 31 ), index = 31 */
{F_N8X5_K4X2_M0X2_P16x2(15, 0, 0, 1), 192000000}, /* freq = (6M * 32 ), index = 32 */
{F_N8X5_K4X2_M0X2_P16x2(16, 0, 0, 1), 204000000}, /* freq = (6M * 33 ), index = 33 */
{F_N8X5_K4X2_M0X2_P16x2(16, 0, 0, 1), 204000000}, /* freq = (6M * 34 ), index = 34 */
{F_N8X5_K4X2_M0X2_P16x2(17, 0, 0, 1), 216000000}, /* freq = (6M * 35 ), index = 35 */
{F_N8X5_K4X2_M0X2_P16x2(17, 0, 0, 1), 216000000}, /* freq = (6M * 36 ), index = 36 */
{F_N8X5_K4X2_M0X2_P16x2(18, 0, 0, 1), 228000000}, /* freq = (6M * 37 ), index = 37 */
{F_N8X5_K4X2_M0X2_P16x2(18, 0, 0, 1), 228000000}, /* freq = (6M * 38 ), index = 38 */
{F_N8X5_K4X2_M0X2_P16x2( 9, 0, 0, 0), 240000000}, /* freq = (6M * 39 ), index = 39 */
{F_N8X5_K4X2_M0X2_P16x2( 9, 0, 0, 0), 240000000}, /* freq = (6M * 40 ), index = 40 */
{F_N8X5_K4X2_M0X2_P16x2(10, 0, 0, 0), 264000000}, /* freq = (6M * 41 ), index = 41 */
{F_N8X5_K4X2_M0X2_P16x2(10, 0, 0, 0), 264000000}, /* freq = (6M * 42 ), index = 42 */
{F_N8X5_K4X2_M0X2_P16x2(10, 0, 0, 0), 264000000}, /* freq = (6M * 43 ), index = 43 */
{F_N8X5_K4X2_M0X2_P16x2(10, 0, 0, 0), 264000000}, /* freq = (6M * 44 ), index = 44 */
{F_N8X5_K4X2_M0X2_P16x2(11, 0, 0, 0), 288000000}, /* freq = (6M * 45 ), index = 45 */
{F_N8X5_K4X2_M0X2_P16x2(11, 0, 0, 0), 288000000}, /* freq = (6M * 46 ), index = 46 */
{F_N8X5_K4X2_M0X2_P16x2(11, 0, 0, 0), 288000000}, /* freq = (6M * 47 ), index = 47 */
{F_N8X5_K4X2_M0X2_P16x2(11, 0, 0, 0), 288000000}, /* freq = (6M * 48 ), index = 48 */
{F_N8X5_K4X2_M0X2_P16x2(12, 0, 0, 0), 312000000}, /* freq = (6M * 49 ), index = 49 */
{F_N8X5_K4X2_M0X2_P16x2(12, 0, 0, 0), 312000000}, /* freq = (6M * 50 ), index = 50 */
{F_N8X5_K4X2_M0X2_P16x2(12, 0, 0, 0), 312000000}, /* freq = (6M * 51 ), index = 51 */
{F_N8X5_K4X2_M0X2_P16x2(12, 0, 0, 0), 312000000}, /* freq = (6M * 52 ), index = 52 */
{F_N8X5_K4X2_M0X2_P16x2(13, 0, 0, 0), 336000000}, /* freq = (6M * 53 ), index = 53 */
{F_N8X5_K4X2_M0X2_P16x2(13, 0, 0, 0), 336000000}, /* freq = (6M * 54 ), index = 54 */
{F_N8X5_K4X2_M0X2_P16x2(13, 0, 0, 0), 336000000}, /* freq = (6M * 55 ), index = 55 */
{F_N8X5_K4X2_M0X2_P16x2(13, 0, 0, 0), 336000000}, /* freq = (6M * 56 ), index = 56 */
{F_N8X5_K4X2_M0X2_P16x2(14, 0, 0, 0), 360000000}, /* freq = (6M * 57 ), index = 57 */
{F_N8X5_K4X2_M0X2_P16x2(14, 0, 0, 0), 360000000}, /* freq = (6M * 58 ), index = 58 */
{F_N8X5_K4X2_M0X2_P16x2(14, 0, 0, 0), 360000000}, /* freq = (6M * 59 ), index = 59 */
{F_N8X5_K4X2_M0X2_P16x2(14, 0, 0, 0), 360000000}, /* freq = (6M * 60 ), index = 60 */
{F_N8X5_K4X2_M0X2_P16x2(15, 0, 0, 0), 384000000}, /* freq = (6M * 61 ), index = 61 */
{F_N8X5_K4X2_M0X2_P16x2(15, 0, 0, 0), 384000000}, /* freq = (6M * 62 ), index = 62 */
{F_N8X5_K4X2_M0X2_P16x2(15, 0, 0, 0), 384000000}, /* freq = (6M * 63 ), index = 63 */
{F_N8X5_K4X2_M0X2_P16x2(15, 0, 0, 0), 384000000}, /* freq = (6M * 64 ), index = 64 */
{F_N8X5_K4X2_M0X2_P16x2(16, 0, 0, 0), 408000000}, /* freq = (6M * 65 ), index = 65 */
{F_N8X5_K4X2_M0X2_P16x2(16, 0, 0, 0), 408000000}, /* freq = (6M * 66 ), index = 66 */
{F_N8X5_K4X2_M0X2_P16x2(16, 0, 0, 0), 408000000}, /* freq = (6M * 67 ), index = 67 */
{F_N8X5_K4X2_M0X2_P16x2(16, 0, 0, 0), 408000000}, /* freq = (6M * 68 ), index = 68 */
{F_N8X5_K4X2_M0X2_P16x2(17, 0, 0, 0), 432000000}, /* freq = (6M * 69 ), index = 69 */
{F_N8X5_K4X2_M0X2_P16x2(17, 0, 0, 0), 432000000}, /* freq = (6M * 70 ), index = 70 */
{F_N8X5_K4X2_M0X2_P16x2(17, 0, 0, 0), 432000000}, /* freq = (6M * 71 ), index = 71 */
{F_N8X5_K4X2_M0X2_P16x2(17, 0, 0, 0), 432000000}, /* freq = (6M * 72 ), index = 72 */
{F_N8X5_K4X2_M0X2_P16x2(18, 0, 0, 0), 456000000}, /* freq = (6M * 73 ), index = 73 */
{F_N8X5_K4X2_M0X2_P16x2(18, 0, 0, 0), 456000000}, /* freq = (6M * 74 ), index = 74 */
{F_N8X5_K4X2_M0X2_P16x2(18, 0, 0, 0), 456000000}, /* freq = (6M * 75 ), index = 75 */
{F_N8X5_K4X2_M0X2_P16x2(18, 0, 0, 0), 456000000}, /* freq = (6M * 76 ), index = 76 */
{F_N8X5_K4X2_M0X2_P16x2(19, 0, 0, 0), 480000000}, /* freq = (6M * 77 ), index = 77 */
{F_N8X5_K4X2_M0X2_P16x2(19, 0, 0, 0), 480000000}, /* freq = (6M * 78 ), index = 78 */
{F_N8X5_K4X2_M0X2_P16x2(19, 0, 0, 0), 480000000}, /* freq = (6M * 79 ), index = 79 */
{F_N8X5_K4X2_M0X2_P16x2(19, 0, 0, 0), 480000000}, /* freq = (6M * 80 ), index = 80 */
{F_N8X5_K4X2_M0X2_P16x2(20, 0, 0, 0), 504000000}, /* freq = (6M * 81 ), index = 81 */
{F_N8X5_K4X2_M0X2_P16x2(20, 0, 0, 0), 504000000}, /* freq = (6M * 82 ), index = 82 */
{F_N8X5_K4X2_M0X2_P16x2(20, 0, 0, 0), 504000000}, /* freq = (6M * 83 ), index = 83 */
{F_N8X5_K4X2_M0X2_P16x2(20, 0, 0, 0), 504000000}, /* freq = (6M * 84 ), index = 84 */
{F_N8X5_K4X2_M0X2_P16x2(21, 0, 0, 0), 528000000}, /* freq = (6M * 85 ), index = 85 */
{F_N8X5_K4X2_M0X2_P16x2(21, 0, 0, 0), 528000000}, /* freq = (6M * 86 ), index = 86 */
{F_N8X5_K4X2_M0X2_P16x2(21, 0, 0, 0), 528000000}, /* freq = (6M * 87 ), index = 87 */
{F_N8X5_K4X2_M0X2_P16x2(21, 0, 0, 0), 528000000}, /* freq = (6M * 88 ), index = 88 */
{F_N8X5_K4X2_M0X2_P16x2(22, 0, 0, 0), 552000000}, /* freq = (6M * 89 ), index = 89 */
{F_N8X5_K4X2_M0X2_P16x2(22, 0, 0, 0), 552000000}, /* freq = (6M * 90 ), index = 90 */
{F_N8X5_K4X2_M0X2_P16x2(22, 0, 0, 0), 552000000}, /* freq = (6M * 91 ), index = 91 */
{F_N8X5_K4X2_M0X2_P16x2(22, 0, 0, 0), 552000000}, /* freq = (6M * 92 ), index = 92 */
{F_N8X5_K4X2_M0X2_P16x2(23, 0, 0, 0), 576000000}, /* freq = (6M * 93 ), index = 93 */
{F_N8X5_K4X2_M0X2_P16x2(23, 0, 0, 0), 576000000}, /* freq = (6M * 94 ), index = 94 */
{F_N8X5_K4X2_M0X2_P16x2(23, 0, 0, 0), 576000000}, /* freq = (6M * 95 ), index = 95 */
{F_N8X5_K4X2_M0X2_P16x2(23, 0, 0, 0), 576000000}, /* freq = (6M * 96 ), index = 96 */
{F_N8X5_K4X2_M0X2_P16x2(24, 0, 0, 0), 600000000}, /* freq = (6M * 97 ), index = 97 */
{F_N8X5_K4X2_M0X2_P16x2(24, 0, 0, 0), 600000000}, /* freq = (6M * 98 ), index = 98 */
{F_N8X5_K4X2_M0X2_P16x2(24, 0, 0, 0), 600000000}, /* freq = (6M * 99 ), index = 99 */
{F_N8X5_K4X2_M0X2_P16x2(24, 0, 0, 0), 600000000}, /* freq = (6M * 100), index = 100 */
{F_N8X5_K4X2_M0X2_P16x2(25, 0, 0, 0), 624000000}, /* freq = (6M * 101), index = 101 */
{F_N8X5_K4X2_M0X2_P16x2(25, 0, 0, 0), 624000000}, /* freq = (6M * 102), index = 102 */
{F_N8X5_K4X2_M0X2_P16x2(25, 0, 0, 0), 624000000}, /* freq = (6M * 103), index = 103 */
{F_N8X5_K4X2_M0X2_P16x2(25, 0, 0, 0), 624000000}, /* freq = (6M * 104), index = 104 */
{F_N8X5_K4X2_M0X2_P16x2(26, 0, 0, 0), 648000000}, /* freq = (6M * 105), index = 105 */
{F_N8X5_K4X2_M0X2_P16x2(26, 0, 0, 0), 648000000}, /* freq = (6M * 106), index = 106 */
{F_N8X5_K4X2_M0X2_P16x2(26, 0, 0, 0), 648000000}, /* freq = (6M * 107), index = 107 */
{F_N8X5_K4X2_M0X2_P16x2(26, 0, 0, 0), 648000000}, /* freq = (6M * 108), index = 108 */
{F_N8X5_K4X2_M0X2_P16x2(27, 0, 0, 0), 672000000}, /* freq = (6M * 109), index = 109 */
{F_N8X5_K4X2_M0X2_P16x2(27, 0, 0, 0), 672000000}, /* freq = (6M * 110), index = 110 */
{F_N8X5_K4X2_M0X2_P16x2(27, 0, 0, 0), 672000000}, /* freq = (6M * 111), index = 111 */
{F_N8X5_K4X2_M0X2_P16x2(27, 0, 0, 0), 672000000}, /* freq = (6M * 112), index = 112 */
{F_N8X5_K4X2_M0X2_P16x2(28, 0, 0, 0), 696000000}, /* freq = (6M * 113), index = 113 */
{F_N8X5_K4X2_M0X2_P16x2(28, 0, 0, 0), 696000000}, /* freq = (6M * 114), index = 114 */
{F_N8X5_K4X2_M0X2_P16x2(28, 0, 0, 0), 696000000}, /* freq = (6M * 115), index = 115 */
{F_N8X5_K4X2_M0X2_P16x2(28, 0, 0, 0), 696000000}, /* freq = (6M * 116), index = 116 */
{F_N8X5_K4X2_M0X2_P16x2(29, 0, 0, 0), 720000000}, /* freq = (6M * 117), index = 117 */
{F_N8X5_K4X2_M0X2_P16x2(29, 0, 0, 0), 720000000}, /* freq = (6M * 118), index = 118 */
{F_N8X5_K4X2_M0X2_P16x2(29, 0, 0, 0), 720000000}, /* freq = (6M * 119), index = 119 */
{F_N8X5_K4X2_M0X2_P16x2(29, 0, 0, 0), 720000000}, /* freq = (6M * 120), index = 120 */
{F_N8X5_K4X2_M0X2_P16x2(15, 1, 0, 0), 768000000}, /* freq = (6M * 121), index = 121 */
{F_N8X5_K4X2_M0X2_P16x2(15, 1, 0, 0), 768000000}, /* freq = (6M * 122), index = 122 */
{F_N8X5_K4X2_M0X2_P16x2(15, 1, 0, 0), 768000000}, /* freq = (6M * 123), index = 123 */
{F_N8X5_K4X2_M0X2_P16x2(15, 1, 0, 0), 768000000}, /* freq = (6M * 124), index = 124 */
{F_N8X5_K4X2_M0X2_P16x2(15, 1, 0, 0), 768000000}, /* freq = (6M * 125), index = 125 */
{F_N8X5_K4X2_M0X2_P16x2(15, 1, 0, 0), 768000000}, /* freq = (6M * 126), index = 126 */
{F_N8X5_K4X2_M0X2_P16x2(15, 1, 0, 0), 768000000}, /* freq = (6M * 127), index = 127 */
{F_N8X5_K4X2_M0X2_P16x2(15, 1, 0, 0), 768000000}, /* freq = (6M * 128), index = 128 */
{F_N8X5_K4X2_M0X2_P16x2(10, 2, 0, 0), 792000000}, /* freq = (6M * 129), index = 129 */
{F_N8X5_K4X2_M0X2_P16x2(10, 2, 0, 0), 792000000}, /* freq = (6M * 130), index = 130 */
{F_N8X5_K4X2_M0X2_P16x2(10, 2, 0, 0), 792000000}, /* freq = (6M * 131), index = 131 */
{F_N8X5_K4X2_M0X2_P16x2(10, 2, 0, 0), 792000000}, /* freq = (6M * 132), index = 132 */
{F_N8X5_K4X2_M0X2_P16x2(16, 1, 0, 0), 816000000}, /* freq = (6M * 133), index = 133 */
{F_N8X5_K4X2_M0X2_P16x2(16, 1, 0, 0), 816000000}, /* freq = (6M * 134), index = 134 */
{F_N8X5_K4X2_M0X2_P16x2(16, 1, 0, 0), 816000000}, /* freq = (6M * 135), index = 135 */
{F_N8X5_K4X2_M0X2_P16x2(16, 1, 0, 0), 816000000}, /* freq = (6M * 136), index = 136 */
{F_N8X5_K4X2_M0X2_P16x2(17, 1, 0, 0), 864000000}, /* freq = (6M * 137), index = 137 */
{F_N8X5_K4X2_M0X2_P16x2(17, 1, 0, 0), 864000000}, /* freq = (6M * 138), index = 138 */
{F_N8X5_K4X2_M0X2_P16x2(17, 1, 0, 0), 864000000}, /* freq = (6M * 139), index = 139 */
{F_N8X5_K4X2_M0X2_P16x2(17, 1, 0, 0), 864000000}, /* freq = (6M * 140), index = 140 */
{F_N8X5_K4X2_M0X2_P16x2(17, 1, 0, 0), 864000000}, /* freq = (6M * 141), index = 141 */
{F_N8X5_K4X2_M0X2_P16x2(17, 1, 0, 0), 864000000}, /* freq = (6M * 142), index = 142 */
{F_N8X5_K4X2_M0X2_P16x2(17, 1, 0, 0), 864000000}, /* freq = (6M * 143), index = 143 */
{F_N8X5_K4X2_M0X2_P16x2(17, 1, 0, 0), 864000000}, /* freq = (6M * 144), index = 144 */
{F_N8X5_K4X2_M0X2_P16x2(18, 1, 0, 0), 912000000}, /* freq = (6M * 145), index = 145 */
{F_N8X5_K4X2_M0X2_P16x2(18, 1, 0, 0), 912000000}, /* freq = (6M * 146), index = 146 */
{F_N8X5_K4X2_M0X2_P16x2(18, 1, 0, 0), 912000000}, /* freq = (6M * 147), index = 147 */
{F_N8X5_K4X2_M0X2_P16x2(18, 1, 0, 0), 912000000}, /* freq = (6M * 148), index = 148 */
{F_N8X5_K4X2_M0X2_P16x2(18, 1, 0, 0), 912000000}, /* freq = (6M * 149), index = 149 */
{F_N8X5_K4X2_M0X2_P16x2(18, 1, 0, 0), 912000000}, /* freq = (6M * 150), index = 150 */
{F_N8X5_K4X2_M0X2_P16x2(18, 1, 0, 0), 912000000}, /* freq = (6M * 151), index = 151 */
{F_N8X5_K4X2_M0X2_P16x2(18, 1, 0, 0), 912000000}, /* freq = (6M * 152), index = 152 */
{F_N8X5_K4X2_M0X2_P16x2(12, 2, 0, 0), 936000000}, /* freq = (6M * 153), index = 153 */
{F_N8X5_K4X2_M0X2_P16x2(12, 2, 0, 0), 936000000}, /* freq = (6M * 154), index = 154 */
{F_N8X5_K4X2_M0X2_P16x2(12, 2, 0, 0), 936000000}, /* freq = (6M * 155), index = 155 */
{F_N8X5_K4X2_M0X2_P16x2(12, 2, 0, 0), 936000000}, /* freq = (6M * 156), index = 156 */
{F_N8X5_K4X2_M0X2_P16x2(19, 1, 0, 0), 960000000}, /* freq = (6M * 157), index = 157 */
{F_N8X5_K4X2_M0X2_P16x2(19, 1, 0, 0), 960000000}, /* freq = (6M * 158), index = 158 */
{F_N8X5_K4X2_M0X2_P16x2(19, 1, 0, 0), 960000000}, /* freq = (6M * 159), index = 159 */
{F_N8X5_K4X2_M0X2_P16x2(19, 1, 0, 0), 960000000}, /* freq = (6M * 160), index = 160 */
{F_N8X5_K4X2_M0X2_P16x2(20, 1, 0, 0),1008000000}, /* freq = (6M * 161), index = 161 */
{F_N8X5_K4X2_M0X2_P16x2(20, 1, 0, 0),1008000000}, /* freq = (6M * 162), index = 162 */
{F_N8X5_K4X2_M0X2_P16x2(20, 1, 0, 0),1008000000}, /* freq = (6M * 163), index = 163 */
{F_N8X5_K4X2_M0X2_P16x2(20, 1, 0, 0),1008000000}, /* freq = (6M * 164), index = 164 */
{F_N8X5_K4X2_M0X2_P16x2(20, 1, 0, 0),1008000000}, /* freq = (6M * 165), index = 165 */
{F_N8X5_K4X2_M0X2_P16x2(20, 1, 0, 0),1008000000}, /* freq = (6M * 166), index = 166 */
{F_N8X5_K4X2_M0X2_P16x2(20, 1, 0, 0),1008000000}, /* freq = (6M * 167), index = 167 */
{F_N8X5_K4X2_M0X2_P16x2(20, 1, 0, 0),1008000000}, /* freq = (6M * 168), index = 168 */
{F_N8X5_K4X2_M0X2_P16x2(21, 1, 0, 0),1056000000}, /* freq = (6M * 169), index = 169 */
{F_N8X5_K4X2_M0X2_P16x2(21, 1, 0, 0),1056000000}, /* freq = (6M * 170), index = 170 */
{F_N8X5_K4X2_M0X2_P16x2(21, 1, 0, 0),1056000000}, /* freq = (6M * 171), index = 171 */
{F_N8X5_K4X2_M0X2_P16x2(21, 1, 0, 0),1056000000}, /* freq = (6M * 172), index = 172 */
{F_N8X5_K4X2_M0X2_P16x2(21, 1, 0, 0),1056000000}, /* freq = (6M * 173), index = 173 */
{F_N8X5_K4X2_M0X2_P16x2(21, 1, 0, 0),1056000000}, /* freq = (6M * 174), index = 174 */
{F_N8X5_K4X2_M0X2_P16x2(21, 1, 0, 0),1056000000}, /* freq = (6M * 175), index = 175 */
{F_N8X5_K4X2_M0X2_P16x2(21, 1, 0, 0),1056000000}, /* freq = (6M * 176), index = 176 */
{F_N8X5_K4X2_M0X2_P16x2(14, 2, 0, 0),1080000000}, /* freq = (6M * 177), index = 177 */
{F_N8X5_K4X2_M0X2_P16x2(14, 2, 0, 0),1080000000}, /* freq = (6M * 178), index = 178 */
{F_N8X5_K4X2_M0X2_P16x2(14, 2, 0, 0),1080000000}, /* freq = (6M * 179), index = 179 */
{F_N8X5_K4X2_M0X2_P16x2(14, 2, 0, 0),1080000000}, /* freq = (6M * 180), index = 180 */
{F_N8X5_K4X2_M0X2_P16x2(22, 1, 0, 0),1104000000}, /* freq = (6M * 181), index = 181 */
{F_N8X5_K4X2_M0X2_P16x2(22, 1, 0, 0),1104000000}, /* freq = (6M * 182), index = 182 */
{F_N8X5_K4X2_M0X2_P16x2(22, 1, 0, 0),1104000000}, /* freq = (6M * 183), index = 183 */
{F_N8X5_K4X2_M0X2_P16x2(22, 1, 0, 0),1104000000}, /* freq = (6M * 184), index = 184 */
{F_N8X5_K4X2_M0X2_P16x2(23, 1, 0, 0),1152000000}, /* freq = (6M * 185), index = 185 */
{F_N8X5_K4X2_M0X2_P16x2(23, 1, 0, 0),1152000000}, /* freq = (6M * 186), index = 186 */
{F_N8X5_K4X2_M0X2_P16x2(23, 1, 0, 0),1152000000}, /* freq = (6M * 187), index = 187 */
{F_N8X5_K4X2_M0X2_P16x2(23, 1, 0, 0),1152000000}, /* freq = (6M * 188), index = 188 */
{F_N8X5_K4X2_M0X2_P16x2(23, 1, 0, 0),1152000000}, /* freq = (6M * 189), index = 189 */
{F_N8X5_K4X2_M0X2_P16x2(23, 1, 0, 0),1152000000}, /* freq = (6M * 190), index = 190 */
{F_N8X5_K4X2_M0X2_P16x2(23, 1, 0, 0),1152000000}, /* freq = (6M * 191), index = 191 */
{F_N8X5_K4X2_M0X2_P16x2(23, 1, 0, 0),1152000000}, /* freq = (6M * 192), index = 192 */
{F_N8X5_K4X2_M0X2_P16x2(24, 1, 0, 0),1200000000}, /* freq = (6M * 193), index = 193 */
{F_N8X5_K4X2_M0X2_P16x2(24, 1, 0, 0),1200000000}, /* freq = (6M * 194), index = 194 */
{F_N8X5_K4X2_M0X2_P16x2(24, 1, 0, 0),1200000000}, /* freq = (6M * 195), index = 195 */
{F_N8X5_K4X2_M0X2_P16x2(24, 1, 0, 0),1200000000}, /* freq = (6M * 196), index = 196 */
{F_N8X5_K4X2_M0X2_P16x2(24, 1, 0, 0),1200000000}, /* freq = (6M * 197), index = 197 */
{F_N8X5_K4X2_M0X2_P16x2(24, 1, 0, 0),1200000000}, /* freq = (6M * 198), index = 198 */
{F_N8X5_K4X2_M0X2_P16x2(24, 1, 0, 0),1200000000}, /* freq = (6M * 199), index = 199 */
{F_N8X5_K4X2_M0X2_P16x2(24, 1, 0, 0),1200000000}, /* freq = (6M * 200), index = 200 */
{F_N8X5_K4X2_M0X2_P16x2(16, 2, 0, 0),1224000000}, /* freq = (6M * 201), index = 201 */
{F_N8X5_K4X2_M0X2_P16x2(16, 2, 0, 0),1224000000}, /* freq = (6M * 202), index = 202 */
{F_N8X5_K4X2_M0X2_P16x2(16, 2, 0, 0),1224000000}, /* freq = (6M * 203), index = 203 */
{F_N8X5_K4X2_M0X2_P16x2(16, 2, 0, 0),1224000000}, /* freq = (6M * 204), index = 204 */
{F_N8X5_K4X2_M0X2_P16x2(25, 1, 0, 0),1248000000}, /* freq = (6M * 205), index = 205 */
{F_N8X5_K4X2_M0X2_P16x2(25, 1, 0, 0),1248000000}, /* freq = (6M * 206), index = 206 */
{F_N8X5_K4X2_M0X2_P16x2(25, 1, 0, 0),1248000000}, /* freq = (6M * 207), index = 207 */
{F_N8X5_K4X2_M0X2_P16x2(25, 1, 0, 0),1248000000}, /* freq = (6M * 208), index = 208 */
{F_N8X5_K4X2_M0X2_P16x2(26, 1, 0, 0),1296000000}, /* freq = (6M * 209), index = 209 */
{F_N8X5_K4X2_M0X2_P16x2(26, 1, 0, 0),1296000000}, /* freq = (6M * 210), index = 210 */
{F_N8X5_K4X2_M0X2_P16x2(26, 1, 0, 0),1296000000}, /* freq = (6M * 211), index = 211 */
{F_N8X5_K4X2_M0X2_P16x2(26, 1, 0, 0),1296000000}, /* freq = (6M * 212), index = 212 */
{F_N8X5_K4X2_M0X2_P16x2(26, 1, 0, 0),1296000000}, /* freq = (6M * 213), index = 213 */
{F_N8X5_K4X2_M0X2_P16x2(26, 1, 0, 0),1296000000}, /* freq = (6M * 214), index = 214 */
{F_N8X5_K4X2_M0X2_P16x2(26, 1, 0, 0),1296000000}, /* freq = (6M * 215), index = 215 */
{F_N8X5_K4X2_M0X2_P16x2(26, 1, 0, 0),1296000000}, /* freq = (6M * 216), index = 216 */
{F_N8X5_K4X2_M0X2_P16x2(27, 1, 0, 0),1344000000}, /* freq = (6M * 217), index = 217 */
{F_N8X5_K4X2_M0X2_P16x2(27, 1, 0, 0),1344000000}, /* freq = (6M * 218), index = 218 */
{F_N8X5_K4X2_M0X2_P16x2(27, 1, 0, 0),1344000000}, /* freq = (6M * 219), index = 219 */
{F_N8X5_K4X2_M0X2_P16x2(27, 1, 0, 0),1344000000}, /* freq = (6M * 220), index = 220 */
{F_N8X5_K4X2_M0X2_P16x2(27, 1, 0, 0),1344000000}, /* freq = (6M * 221), index = 221 */
{F_N8X5_K4X2_M0X2_P16x2(27, 1, 0, 0),1344000000}, /* freq = (6M * 222), index = 222 */
{F_N8X5_K4X2_M0X2_P16x2(27, 1, 0, 0),1344000000}, /* freq = (6M * 223), index = 223 */
{F_N8X5_K4X2_M0X2_P16x2(27, 1, 0, 0),1344000000}, /* freq = (6M * 224), index = 224 */
{F_N8X5_K4X2_M0X2_P16x2(18, 2, 0, 0),1368000000}, /* freq = (6M * 225), index = 225 */
{F_N8X5_K4X2_M0X2_P16x2(18, 2, 0, 0),1368000000}, /* freq = (6M * 226), index = 226 */
{F_N8X5_K4X2_M0X2_P16x2(18, 2, 0, 0),1368000000}, /* freq = (6M * 227), index = 227 */
{F_N8X5_K4X2_M0X2_P16x2(18, 2, 0, 0),1368000000}, /* freq = (6M * 228), index = 228 */
{F_N8X5_K4X2_M0X2_P16x2(19, 2, 0, 0),1440000000}, /* freq = (6M * 229), index = 229 */
{F_N8X5_K4X2_M0X2_P16x2(19, 2, 0, 0),1440000000}, /* freq = (6M * 230), index = 230 */
{F_N8X5_K4X2_M0X2_P16x2(19, 2, 0, 0),1440000000}, /* freq = (6M * 231), index = 231 */
{F_N8X5_K4X2_M0X2_P16x2(19, 2, 0, 0),1440000000}, /* freq = (6M * 232), index = 232 */
{F_N8X5_K4X2_M0X2_P16x2(19, 2, 0, 0),1440000000}, /* freq = (6M * 233), index = 233 */
{F_N8X5_K4X2_M0X2_P16x2(19, 2, 0, 0),1440000000}, /* freq = (6M * 234), index = 234 */
{F_N8X5_K4X2_M0X2_P16x2(19, 2, 0, 0),1440000000}, /* freq = (6M * 235), index = 235 */
{F_N8X5_K4X2_M0X2_P16x2(19, 2, 0, 0),1440000000}, /* freq = (6M * 236), index = 236 */
{F_N8X5_K4X2_M0X2_P16x2(19, 2, 0, 0),1440000000}, /* freq = (6M * 237), index = 237 */
{F_N8X5_K4X2_M0X2_P16x2(19, 2, 0, 0),1440000000}, /* freq = (6M * 238), index = 238 */
{F_N8X5_K4X2_M0X2_P16x2(19, 2, 0, 0),1440000000}, /* freq = (6M * 239), index = 239 */
{F_N8X5_K4X2_M0X2_P16x2(19, 2, 0, 0),1440000000}, /* freq = (6M * 240), index = 240 */
{F_N8X5_K4X2_M0X2_P16x2(20, 2, 0, 0),1512000000}, /* freq = (6M * 241), index = 241 */
{F_N8X5_K4X2_M0X2_P16x2(20, 2, 0, 0),1512000000}, /* freq = (6M * 242), index = 242 */
{F_N8X5_K4X2_M0X2_P16x2(20, 2, 0, 0),1512000000}, /* freq = (6M * 243), index = 243 */
{F_N8X5_K4X2_M0X2_P16x2(20, 2, 0, 0),1512000000}, /* freq = (6M * 244), index = 244 */
{F_N8X5_K4X2_M0X2_P16x2(20, 2, 0, 0),1512000000}, /* freq = (6M * 245), index = 245 */
{F_N8X5_K4X2_M0X2_P16x2(20, 2, 0, 0),1512000000}, /* freq = (6M * 246), index = 246 */
{F_N8X5_K4X2_M0X2_P16x2(20, 2, 0, 0),1512000000}, /* freq = (6M * 247), index = 247 */
{F_N8X5_K4X2_M0X2_P16x2(20, 2, 0, 0),1512000000}, /* freq = (6M * 248), index = 248 */
{F_N8X5_K4X2_M0X2_P16x2(20, 2, 0, 0),1512000000}, /* freq = (6M * 249), index = 249 */
{F_N8X5_K4X2_M0X2_P16x2(20, 2, 0, 0),1512000000}, /* freq = (6M * 250), index = 250 */
{F_N8X5_K4X2_M0X2_P16x2(20, 2, 0, 0),1512000000}, /* freq = (6M * 251), index = 251 */
{F_N8X5_K4X2_M0X2_P16x2(20, 2, 0, 0),1512000000}, /* freq = (6M * 252), index = 252 */
{F_N8X5_K4X2_M0X2_P16x2(15, 3, 0, 0),1536000000}, /* freq = (6M * 253), index = 253 */
{F_N8X5_K4X2_M0X2_P16x2(15, 3, 0, 0),1536000000}, /* freq = (6M * 254), index = 254 */
{F_N8X5_K4X2_M0X2_P16x2(15, 3, 0, 0),1536000000}, /* freq = (6M * 255), index = 255 */
{F_N8X5_K4X2_M0X2_P16x2(15, 3, 0, 0),1536000000}, /* freq = (6M * 256), index = 256 */
{F_N8X5_K4X2_M0X2_P16x2(21, 2, 0, 0),1584000000}, /* freq = (6M * 257), index = 257 */
{F_N8X5_K4X2_M0X2_P16x2(21, 2, 0, 0),1584000000}, /* freq = (6M * 258), index = 258 */
{F_N8X5_K4X2_M0X2_P16x2(21, 2, 0, 0),1584000000}, /* freq = (6M * 259), index = 259 */
{F_N8X5_K4X2_M0X2_P16x2(21, 2, 0, 0),1584000000}, /* freq = (6M * 260), index = 260 */
{F_N8X5_K4X2_M0X2_P16x2(21, 2, 0, 0),1584000000}, /* freq = (6M * 261), index = 261 */
{F_N8X5_K4X2_M0X2_P16x2(21, 2, 0, 0),1584000000}, /* freq = (6M * 262), index = 262 */
{F_N8X5_K4X2_M0X2_P16x2(21, 2, 0, 0),1584000000}, /* freq = (6M * 263), index = 263 */
{F_N8X5_K4X2_M0X2_P16x2(21, 2, 0, 0),1584000000}, /* freq = (6M * 264), index = 264 */
{F_N8X5_K4X2_M0X2_P16x2(16, 3, 0, 0),1632000000}, /* freq = (6M * 265), index = 265 */
{F_N8X5_K4X2_M0X2_P16x2(16, 3, 0, 0),1632000000}, /* freq = (6M * 266), index = 266 */
{F_N8X5_K4X2_M0X2_P16x2(16, 3, 0, 0),1632000000}, /* freq = (6M * 267), index = 267 */
{F_N8X5_K4X2_M0X2_P16x2(16, 3, 0, 0),1632000000}, /* freq = (6M * 268), index = 268 */
{F_N8X5_K4X2_M0X2_P16x2(16, 3, 0, 0),1632000000}, /* freq = (6M * 269), index = 269 */
{F_N8X5_K4X2_M0X2_P16x2(16, 3, 0, 0),1632000000}, /* freq = (6M * 270), index = 270 */
{F_N8X5_K4X2_M0X2_P16x2(16, 3, 0, 0),1632000000}, /* freq = (6M * 271), index = 271 */
{F_N8X5_K4X2_M0X2_P16x2(16, 3, 0, 0),1632000000}, /* freq = (6M * 272), index = 272 */
{F_N8X5_K4X2_M0X2_P16x2(22, 2, 0, 0),1656000000}, /* freq = (6M * 273), index = 273 */
{F_N8X5_K4X2_M0X2_P16x2(22, 2, 0, 0),1656000000}, /* freq = (6M * 274), index = 274 */
{F_N8X5_K4X2_M0X2_P16x2(22, 2, 0, 0),1656000000}, /* freq = (6M * 275), index = 275 */
{F_N8X5_K4X2_M0X2_P16x2(22, 2, 0, 0),1656000000}, /* freq = (6M * 276), index = 276 */
{F_N8X5_K4X2_M0X2_P16x2(23, 2, 0, 0),1728000000}, /* freq = (6M * 277), index = 277 */
{F_N8X5_K4X2_M0X2_P16x2(23, 2, 0, 0),1728000000}, /* freq = (6M * 278), index = 278 */
{F_N8X5_K4X2_M0X2_P16x2(23, 2, 0, 0),1728000000}, /* freq = (6M * 279), index = 279 */
{F_N8X5_K4X2_M0X2_P16x2(23, 2, 0, 0),1728000000}, /* freq = (6M * 280), index = 280 */
{F_N8X5_K4X2_M0X2_P16x2(23, 2, 0, 0),1728000000}, /* freq = (6M * 281), index = 281 */
{F_N8X5_K4X2_M0X2_P16x2(23, 2, 0, 0),1728000000}, /* freq = (6M * 282), index = 282 */
{F_N8X5_K4X2_M0X2_P16x2(23, 2, 0, 0),1728000000}, /* freq = (6M * 283), index = 283 */
{F_N8X5_K4X2_M0X2_P16x2(23, 2, 0, 0),1728000000}, /* freq = (6M * 284), index = 284 */
{F_N8X5_K4X2_M0X2_P16x2(23, 2, 0, 0),1728000000}, /* freq = (6M * 285), index = 285 */
{F_N8X5_K4X2_M0X2_P16x2(23, 2, 0, 0),1728000000}, /* freq = (6M * 286), index = 286 */
{F_N8X5_K4X2_M0X2_P16x2(23, 2, 0, 0),1728000000}, /* freq = (6M * 287), index = 287 */
{F_N8X5_K4X2_M0X2_P16x2(23, 2, 0, 0),1728000000}, /* freq = (6M * 288), index = 288 */
{F_N8X5_K4X2_M0X2_P16x2(24, 2, 0, 0),1800000000}, /* freq = (6M * 289), index = 289 */
{F_N8X5_K4X2_M0X2_P16x2(24, 2, 0, 0),1800000000}, /* freq = (6M * 290), index = 290 */
{F_N8X5_K4X2_M0X2_P16x2(24, 2, 0, 0),1800000000}, /* freq = (6M * 291), index = 291 */
{F_N8X5_K4X2_M0X2_P16x2(24, 2, 0, 0),1800000000}, /* freq = (6M * 292), index = 292 */
{F_N8X5_K4X2_M0X2_P16x2(24, 2, 0, 0),1800000000}, /* freq = (6M * 293), index = 293 */
{F_N8X5_K4X2_M0X2_P16x2(24, 2, 0, 0),1800000000}, /* freq = (6M * 294), index = 294 */
{F_N8X5_K4X2_M0X2_P16x2(24, 2, 0, 0),1800000000}, /* freq = (6M * 295), index = 295 */
{F_N8X5_K4X2_M0X2_P16x2(24, 2, 0, 0),1800000000}, /* freq = (6M * 296), index = 296 */
{F_N8X5_K4X2_M0X2_P16x2(24, 2, 0, 0),1800000000}, /* freq = (6M * 297), index = 297 */
{F_N8X5_K4X2_M0X2_P16x2(24, 2, 0, 0),1800000000}, /* freq = (6M * 298), index = 298 */
{F_N8X5_K4X2_M0X2_P16x2(24, 2, 0, 0),1800000000}, /* freq = (6M * 299), index = 299 */
{F_N8X5_K4X2_M0X2_P16x2(24, 2, 0, 0),1800000000}, /* freq = (6M * 300), index = 300 */
{F_N8X5_K4X2_M0X2_P16x2(25, 2, 0, 0),1872000000}, /* freq = (6M * 301), index = 301 */
{F_N8X5_K4X2_M0X2_P16x2(25, 2, 0, 0),1872000000}, /* freq = (6M * 302), index = 302 */
{F_N8X5_K4X2_M0X2_P16x2(25, 2, 0, 0),1872000000}, /* freq = (6M * 303), index = 303 */
{F_N8X5_K4X2_M0X2_P16x2(25, 2, 0, 0),1872000000}, /* freq = (6M * 304), index = 304 */
{F_N8X5_K4X2_M0X2_P16x2(25, 2, 0, 0),1872000000}, /* freq = (6M * 305), index = 305 */
{F_N8X5_K4X2_M0X2_P16x2(25, 2, 0, 0),1872000000}, /* freq = (6M * 306), index = 306 */
{F_N8X5_K4X2_M0X2_P16x2(25, 2, 0, 0),1872000000}, /* freq = (6M * 307), index = 307 */
{F_N8X5_K4X2_M0X2_P16x2(25, 2, 0, 0),1872000000}, /* freq = (6M * 308), index = 308 */
{F_N8X5_K4X2_M0X2_P16x2(25, 2, 0, 0),1872000000}, /* freq = (6M * 309), index = 309 */
{F_N8X5_K4X2_M0X2_P16x2(25, 2, 0, 0),1872000000}, /* freq = (6M * 310), index = 310 */
{F_N8X5_K4X2_M0X2_P16x2(25, 2, 0, 0),1872000000}, /* freq = (6M * 311), index = 311 */
{F_N8X5_K4X2_M0X2_P16x2(25, 2, 0, 0),1872000000}, /* freq = (6M * 312), index = 312 */
{F_N8X5_K4X2_M0X2_P16x2(26, 2, 0, 0),1944000000}, /* freq = (6M * 313), index = 313 */
{F_N8X5_K4X2_M0X2_P16x2(26, 2, 0, 0),1944000000}, /* freq = (6M * 314), index = 314 */
{F_N8X5_K4X2_M0X2_P16x2(26, 2, 0, 0),1944000000}, /* freq = (6M * 315), index = 315 */
{F_N8X5_K4X2_M0X2_P16x2(26, 2, 0, 0),1944000000}, /* freq = (6M * 316), index = 316 */
{F_N8X5_K4X2_M0X2_P16x2(26, 2, 0, 0),1944000000}, /* freq = (6M * 317), index = 317 */
{F_N8X5_K4X2_M0X2_P16x2(26, 2, 0, 0),1944000000}, /* freq = (6M * 318), index = 318 */
{F_N8X5_K4X2_M0X2_P16x2(26, 2, 0, 0),1944000000}, /* freq = (6M * 319), index = 319 */
{F_N8X5_K4X2_M0X2_P16x2(26, 2, 0, 0),1944000000}, /* freq = (6M * 320), index = 320 */
{F_N8X5_K4X2_M0X2_P16x2(26, 2, 0, 0),1944000000}, /* freq = (6M * 321), index = 321 */
{F_N8X5_K4X2_M0X2_P16x2(26, 2, 0, 0),1944000000}, /* freq = (6M * 322), index = 322 */
{F_N8X5_K4X2_M0X2_P16x2(26, 2, 0, 0),1944000000}, /* freq = (6M * 323), index = 323 */
{F_N8X5_K4X2_M0X2_P16x2(26, 2, 0, 0),1944000000}, /* freq = (6M * 324), index = 324 */
{F_N8X5_K4X2_M0X2_P16x2(27, 2, 0, 0),2016000000}, /* freq = (6M * 325), index = 325 */
{F_N8X5_K4X2_M0X2_P16x2(27, 2, 0, 0),2016000000}, /* freq = (6M * 326), index = 326 */
{F_N8X5_K4X2_M0X2_P16x2(27, 2, 0, 0),2016000000}, /* freq = (6M * 327), index = 327 */
{F_N8X5_K4X2_M0X2_P16x2(27, 2, 0, 0),2016000000}, /* freq = (6M * 328), index = 328 */
{F_N8X5_K4X2_M0X2_P16x2(27, 2, 0, 0),2016000000}, /* freq = (6M * 329), index = 329 */
{F_N8X5_K4X2_M0X2_P16x2(27, 2, 0, 0),2016000000}, /* freq = (6M * 330), index = 330 */
{F_N8X5_K4X2_M0X2_P16x2(27, 2, 0, 0),2016000000}, /* freq = (6M * 331), index = 331 */
{F_N8X5_K4X2_M0X2_P16x2(27, 2, 0, 0),2016000000}, /* freq = (6M * 332), index = 332 */
{F_N8X5_K4X2_M0X2_P16x2(27, 2, 0, 0),2016000000}, /* freq = (6M * 333), index = 333 */
{F_N8X5_K4X2_M0X2_P16x2(27, 2, 0, 0),2016000000}, /* freq = (6M * 334), index = 334 */
{F_N8X5_K4X2_M0X2_P16x2(27, 2, 0, 0),2016000000}, /* freq = (6M * 335), index = 335 */
{F_N8X5_K4X2_M0X2_P16x2(27, 2, 0, 0),2016000000}, /* freq = (6M * 336), index = 336 */
};

/* periph factors config table */
static struct sunxi_clk_factor_freq    factor_pll5_tbl[] = {
{F_N8X5_K4X2_M0X2(8 , 0, 3), 54000000  }, /* freq = (6M * 0  ), index = 0  */
{F_N8X5_K4X2_M0X2(8 , 0, 3), 54000000  }, /* freq = (6M * 1  ), index = 1  */
{F_N8X5_K4X2_M0X2(8 , 0, 3), 54000000  }, /* freq = (6M * 2  ), index = 2  */
{F_N8X5_K4X2_M0X2(8 , 0, 3), 54000000  }, /* freq = (6M * 3  ), index = 3  */
{F_N8X5_K4X2_M0X2(8 , 0, 3), 54000000  }, /* freq = (6M * 4  ), index = 4  */
{F_N8X5_K4X2_M0X2(8 , 0, 3), 54000000  }, /* freq = (6M * 5  ), index = 5  */
{F_N8X5_K4X2_M0X2(8 , 0, 3), 54000000  }, /* freq = (6M * 6  ), index = 6  */
{F_N8X5_K4X2_M0X2(8 , 0, 3), 54000000  }, /* freq = (6M * 7  ), index = 7  */
{F_N8X5_K4X2_M0X2(8 , 0, 3), 54000000  }, /* freq = (6M * 8  ), index = 8  */
{F_N8X5_K4X2_M0X2(8 , 0, 3), 54000000  }, /* freq = (6M * 9  ), index = 9  */
{F_N8X5_K4X2_M0X2(9 , 0, 3), 60000000  }, /* freq = (6M * 10 ), index = 10 */
{F_N8X5_K4X2_M0X2(10, 0, 3), 66000000  }, /* freq = (6M * 11 ), index = 11 */
{F_N8X5_K4X2_M0X2(8 , 0, 2), 72000000  }, /* freq = (6M * 12 ), index = 12 */
{F_N8X5_K4X2_M0X2(12, 0, 3), 78000000  }, /* freq = (6M * 13 ), index = 13 */
{F_N8X5_K4X2_M0X2(13, 0, 3), 84000000  }, /* freq = (6M * 14 ), index = 14 */
{F_N8X5_K4X2_M0X2(14, 0, 3), 90000000  }, /* freq = (6M * 15 ), index = 15 */
{F_N8X5_K4X2_M0X2(11, 0, 2), 96000000  }, /* freq = (6M * 16 ), index = 16 */
{F_N8X5_K4X2_M0X2(16, 0, 3), 102000000 }, /* freq = (6M * 17 ), index = 17 */
{F_N8X5_K4X2_M0X2(8 , 0, 1), 108000000 }, /* freq = (6M * 18 ), index = 18 */
{F_N8X5_K4X2_M0X2(18, 0, 3), 114000000 }, /* freq = (6M * 19 ), index = 19 */
{F_N8X5_K4X2_M0X2(9 , 0, 1), 120000000 }, /* freq = (6M * 20 ), index = 20 */
{F_N8X5_K4X2_M0X2(20, 0, 3), 126000000 }, /* freq = (6M * 21 ), index = 21 */
{F_N8X5_K4X2_M0X2(10, 0, 1), 132000000 }, /* freq = (6M * 22 ), index = 22 */
{F_N8X5_K4X2_M0X2(22, 0, 3), 138000000 }, /* freq = (6M * 23 ), index = 23 */
{F_N8X5_K4X2_M0X2(11, 0, 1), 144000000 }, /* freq = (6M * 24 ), index = 24 */
{F_N8X5_K4X2_M0X2(24, 0, 3), 150000000 }, /* freq = (6M * 25 ), index = 25 */
{F_N8X5_K4X2_M0X2(12, 0, 1), 156000000 }, /* freq = (6M * 26 ), index = 26 */
{F_N8X5_K4X2_M0X2(26, 0, 3), 162000000 }, /* freq = (6M * 27 ), index = 27 */
{F_N8X5_K4X2_M0X2(13, 0, 1), 168000000 }, /* freq = (6M * 28 ), index = 28 */
{F_N8X5_K4X2_M0X2(28, 0, 3), 174000000 }, /* freq = (6M * 29 ), index = 29 */
{F_N8X5_K4X2_M0X2(14, 0, 1), 180000000 }, /* freq = (6M * 30 ), index = 30 */
{F_N8X5_K4X2_M0X2(30, 0, 3), 186000000 }, /* freq = (6M * 31 ), index = 31 */
{F_N8X5_K4X2_M0X2(15, 0, 1), 192000000 }, /* freq = (6M * 32 ), index = 32 */
{F_N8X5_K4X2_M0X2(10, 2, 3), 198000000 }, /* freq = (6M * 33 ), index = 33 */
{F_N8X5_K4X2_M0X2(16, 0, 1), 204000000 }, /* freq = (6M * 34 ), index = 34 */
{F_N8X5_K4X2_M0X2(25, 0, 2), 208000000 }, /* freq = (6M * 35 ), index = 35 */
{F_N8X5_K4X2_M0X2(8 , 0, 0), 216000000 }, /* freq = (6M * 36 ), index = 36 */
{F_N8X5_K4X2_M0X2(27, 0, 2), 224000000 }, /* freq = (6M * 37 ), index = 37 */
{F_N8X5_K4X2_M0X2(18, 0, 1), 228000000 }, /* freq = (6M * 38 ), index = 38 */
{F_N8X5_K4X2_M0X2(12, 2, 3), 234000000 }, /* freq = (6M * 39 ), index = 39 */
{F_N8X5_K4X2_M0X2(9 , 0, 0), 240000000 }, /* freq = (6M * 40 ), index = 40 */
{F_N8X5_K4X2_M0X2(30, 0, 2), 248000000 }, /* freq = (6M * 41 ), index = 41 */
{F_N8X5_K4X2_M0X2(20, 0, 1), 252000000 }, /* freq = (6M * 42 ), index = 42 */
{F_N8X5_K4X2_M0X2(31, 0, 2), 256000000 }, /* freq = (6M * 43 ), index = 43 */
{F_N8X5_K4X2_M0X2(10, 0, 0), 264000000 }, /* freq = (6M * 44 ), index = 44 */
{F_N8X5_K4X2_M0X2(14, 2, 3), 270000000 }, /* freq = (6M * 45 ), index = 45 */
{F_N8X5_K4X2_M0X2(22, 0, 1), 276000000 }, /* freq = (6M * 46 ), index = 46 */
{F_N8X5_K4X2_M0X2(22, 1, 3), 276000000 }, /* freq = (6M * 47 ), index = 47 */
{F_N8X5_K4X2_M0X2(11, 0, 0), 288000000 }, /* freq = (6M * 48 ), index = 48 */
{F_N8X5_K4X2_M0X2(5 , 1, 0), 288000000 }, /* freq = (6M * 49 ), index = 49 */
{F_N8X5_K4X2_M0X2(24, 0, 1), 300000000 }, /* freq = (6M * 50 ), index = 50 */
{F_N8X5_K4X2_M0X2(16, 2, 3), 306000000 }, /* freq = (6M * 51 ), index = 51 */
{F_N8X5_K4X2_M0X2(12, 0, 0), 312000000 }, /* freq = (6M * 52 ), index = 52 */
{F_N8X5_K4X2_M0X2(19, 1, 2), 320000000 }, /* freq = (6M * 53 ), index = 53 */
{F_N8X5_K4X2_M0X2(26, 0, 1), 324000000 }, /* freq = (6M * 54 ), index = 54 */
{F_N8X5_K4X2_M0X2(8 , 2, 1), 324000000 }, /* freq = (6M * 55 ), index = 55 */
{F_N8X5_K4X2_M0X2(13, 0, 0), 336000000 }, /* freq = (6M * 56 ), index = 56 */
{F_N8X5_K4X2_M0X2(18, 2, 3), 342000000 }, /* freq = (6M * 57 ), index = 57 */
{F_N8X5_K4X2_M0X2(28, 0, 1), 348000000 }, /* freq = (6M * 58 ), index = 58 */
{F_N8X5_K4X2_M0X2(21, 1, 2), 352000000 }, /* freq = (6M * 59 ), index = 59 */
{F_N8X5_K4X2_M0X2(14, 0, 0), 360000000 }, /* freq = (6M * 60 ), index = 60 */
{F_N8X5_K4X2_M0X2(22, 1, 2), 368000000 }, /* freq = (6M * 61 ), index = 61 */
{F_N8X5_K4X2_M0X2(30, 0, 1), 372000000 }, /* freq = (6M * 62 ), index = 62 */
{F_N8X5_K4X2_M0X2(20, 2, 3), 378000000 }, /* freq = (6M * 63 ), index = 63 */
{F_N8X5_K4X2_M0X2(15, 0, 0), 384000000 }, /* freq = (6M * 64 ), index = 64 */
{F_N8X5_K4X2_M0X2(7 , 1, 0), 384000000 }, /* freq = (6M * 65 ), index = 65 */
{F_N8X5_K4X2_M0X2(10, 2, 1), 396000000 }, /* freq = (6M * 66 ), index = 66 */
{F_N8X5_K4X2_M0X2(24, 1, 2), 400000000 }, /* freq = (6M * 67 ), index = 67 */
{F_N8X5_K4X2_M0X2(16, 0, 0), 408000000 }, /* freq = (6M * 68 ), index = 68 */
{F_N8X5_K4X2_M0X2(22, 2, 3), 414000000 }, /* freq = (6M * 69 ), index = 69 */
{F_N8X5_K4X2_M0X2(25, 1, 2), 416000000 }, /* freq = (6M * 70 ), index = 70 */
{F_N8X5_K4X2_M0X2(12, 3, 2), 416000000 }, /* freq = (6M * 71 ), index = 71 */
{F_N8X5_K4X2_M0X2(17, 0, 0), 432000000 }, /* freq = (6M * 72 ), index = 72 */
{F_N8X5_K4X2_M0X2(8 , 1, 0), 432000000 }, /* freq = (6M * 73 ), index = 73 */
{F_N8X5_K4X2_M0X2(27, 1, 2), 448000000 }, /* freq = (6M * 74 ), index = 74 */
{F_N8X5_K4X2_M0X2(24, 2, 3), 450000000 }, /* freq = (6M * 75 ), index = 75 */
{F_N8X5_K4X2_M0X2(18, 0, 0), 456000000 }, /* freq = (6M * 76 ), index = 76 */
{F_N8X5_K4X2_M0X2(28, 1, 2), 464000000 }, /* freq = (6M * 77 ), index = 77 */
{F_N8X5_K4X2_M0X2(12, 2, 1), 468000000 }, /* freq = (6M * 78 ), index = 78 */
{F_N8X5_K4X2_M0X2(25, 2, 3), 468000000 }, /* freq = (6M * 79 ), index = 79 */
{F_N8X5_K4X2_M0X2(19, 0, 0), 480000000 }, /* freq = (6M * 80 ), index = 80 */
{F_N8X5_K4X2_M0X2(19, 2, 2), 480000000 }, /* freq = (6M * 81 ), index = 81 */
{F_N8X5_K4X2_M0X2(14, 3, 2), 480000000 }, /* freq = (6M * 82 ), index = 82 */
{F_N8X5_K4X2_M0X2(30, 1, 2), 496000000 }, /* freq = (6M * 83 ), index = 83 */
{F_N8X5_K4X2_M0X2(20, 0, 0), 504000000 }, /* freq = (6M * 84 ), index = 84 */
{F_N8X5_K4X2_M0X2(31, 1, 2), 512000000 }, /* freq = (6M * 85 ), index = 85 */
{F_N8X5_K4X2_M0X2(15, 3, 2), 512000000 }, /* freq = (6M * 86 ), index = 86 */
{F_N8X5_K4X2_M0X2(15, 3, 2), 512000000 }, /* freq = (6M * 87 ), index = 87 */
{F_N8X5_K4X2_M0X2(21, 0, 0), 528000000 }, /* freq = (6M * 88 ), index = 88 */
{F_N8X5_K4X2_M0X2(10, 1, 0), 528000000 }, /* freq = (6M * 89 ), index = 89 */
{F_N8X5_K4X2_M0X2(14, 2, 1), 540000000 }, /* freq = (6M * 90 ), index = 90 */
{F_N8X5_K4X2_M0X2(16, 3, 2), 544000000 }, /* freq = (6M * 91 ), index = 91 */
{F_N8X5_K4X2_M0X2(22, 0, 0), 552000000 }, /* freq = (6M * 92 ), index = 92 */
{F_N8X5_K4X2_M0X2(22, 1, 1), 552000000 }, /* freq = (6M * 93 ), index = 93 */
{F_N8X5_K4X2_M0X2(23, 0, 0), 576000000 }, /* freq = (6M * 94 ), index = 94 */
{F_N8X5_K4X2_M0X2(11, 1, 0), 576000000 }, /* freq = (6M * 95 ), index = 95 */
{F_N8X5_K4X2_M0X2(7 , 2, 0), 576000000 }, /* freq = (6M * 96 ), index = 96 */
{F_N8X5_K4X2_M0X2(5 , 3, 0), 576000000 }, /* freq = (6M * 97 ), index = 97 */
{F_N8X5_K4X2_M0X2(23, 1, 1), 576000000 }, /* freq = (6M * 98 ), index = 98 */
{F_N8X5_K4X2_M0X2(15, 2, 1), 576000000 }, /* freq = (6M * 99 ), index = 99 */
{F_N8X5_K4X2_M0X2(24, 0, 0), 600000000 }, /* freq = (6M * 100), index = 100*/
{F_N8X5_K4X2_M0X2(18, 3, 2), 608000000 }, /* freq = (6M * 101), index = 101*/
{F_N8X5_K4X2_M0X2(16, 2, 1), 612000000 }, /* freq = (6M * 102), index = 102*/
{F_N8X5_K4X2_M0X2(25, 0, 0), 624000000 }, /* freq = (6M * 103), index = 103*/
{F_N8X5_K4X2_M0X2(12, 1, 0), 624000000 }, /* freq = (6M * 104), index = 104*/
{F_N8X5_K4X2_M0X2(25, 1, 1), 624000000 }, /* freq = (6M * 105), index = 105*/
{F_N8X5_K4X2_M0X2(12, 3, 1), 624000000 }, /* freq = (6M * 106), index = 106*/
{F_N8X5_K4X2_M0X2(12, 1, 1), 624000000 }, /* freq = (6M * 107), index = 107*/
{F_N8X5_K4X2_M0X2(26, 0, 0), 648000000 }, /* freq = (6M * 108), index = 108*/
{F_N8X5_K4X2_M0X2(8 , 2, 0), 648000000 }, /* freq = (6M * 109), index = 109*/
{F_N8X5_K4X2_M0X2(26, 1, 1), 648000000 }, /* freq = (6M * 110), index = 110*/
{F_N8X5_K4X2_M0X2(17, 2, 1), 648000000 }, /* freq = (6M * 111), index = 111*/
{F_N8X5_K4X2_M0X2(27, 0, 0), 672000000 }, /* freq = (6M * 112), index = 112*/
{F_N8X5_K4X2_M0X2(13, 1, 0), 672000000 }, /* freq = (6M * 113), index = 113*/
{F_N8X5_K4X2_M0X2(18, 2, 1), 684000000 }, /* freq = (6M * 114), index = 114*/
{F_N8X5_K4X2_M0X2(28, 0, 0), 696000000 }, /* freq = (6M * 115), index = 115*/
{F_N8X5_K4X2_M0X2(28, 1, 1), 696000000 }, /* freq = (6M * 116), index = 116*/
{F_N8X5_K4X2_M0X2(28, 1, 1), 696000000 }, /* freq = (6M * 117), index = 117*/
{F_N8X5_K4X2_M0X2(28, 1, 1), 696000000 }, /* freq = (6M * 118), index = 118*/
{F_N8X5_K4X2_M0X2(29, 0, 0), 720000000 }, /* freq = (6M * 119), index = 119*/
{F_N8X5_K4X2_M0X2(14, 1, 0), 720000000 }, /* freq = (6M * 120), index = 120*/
{F_N8X5_K4X2_M0X2(9 , 2, 0), 720000000 }, /* freq = (6M * 121), index = 121*/
{F_N8X5_K4X2_M0X2(29, 1, 1), 720000000 }, /* freq = (6M * 122), index = 122*/
{F_N8X5_K4X2_M0X2(19, 2, 1), 720000000 }, /* freq = (6M * 123), index = 123*/
{F_N8X5_K4X2_M0X2(30, 0, 0), 744000000 }, /* freq = (6M * 124), index = 124*/
{F_N8X5_K4X2_M0X2(30, 1, 1), 744000000 }, /* freq = (6M * 125), index = 125*/
{F_N8X5_K4X2_M0X2(20, 2, 1), 756000000 }, /* freq = (6M * 126), index = 126*/
{F_N8X5_K4X2_M0X2(31, 0, 0), 768000000 }, /* freq = (6M * 127), index = 127*/
{F_N8X5_K4X2_M0X2(15, 1, 0), 768000000 }, /* freq = (6M * 128), index = 128*/
{F_N8X5_K4X2_M0X2(7 , 3, 0), 768000000 }, /* freq = (6M * 129), index = 129*/
{F_N8X5_K4X2_M0X2(31, 1, 1), 768000000 }, /* freq = (6M * 130), index = 130*/
{F_N8X5_K4X2_M0X2(15, 3, 1), 768000000 }, /* freq = (6M * 131), index = 131*/
{F_N8X5_K4X2_M0X2(10, 2, 0), 792000000 }, /* freq = (6M * 132), index = 132*/
{F_N8X5_K4X2_M0X2(21, 2, 1), 792000000 }, /* freq = (6M * 133), index = 133*/
{F_N8X5_K4X2_M0X2(21, 2, 1), 792000000 }, /* freq = (6M * 134), index = 134*/
{F_N8X5_K4X2_M0X2(16, 1, 0), 816000000 }, /* freq = (6M * 135), index = 135*/
{F_N8X5_K4X2_M0X2(16, 3, 1), 816000000 }, /* freq = (6M * 136), index = 136*/
{F_N8X5_K4X2_M0X2(16, 3, 1), 816000000 }, /* freq = (6M * 137), index = 137*/
{F_N8X5_K4X2_M0X2(22, 2, 1), 828000000 }, /* freq = (6M * 138), index = 138*/
{F_N8X5_K4X2_M0X2(22, 2, 1), 828000000 }, /* freq = (6M * 139), index = 139*/
{F_N8X5_K4X2_M0X2(17, 1, 0), 864000000 }, /* freq = (6M * 140), index = 140*/
{F_N8X5_K4X2_M0X2(11, 2, 0), 864000000 }, /* freq = (6M * 141), index = 141*/
{F_N8X5_K4X2_M0X2(8 , 3, 0), 864000000 }, /* freq = (6M * 142), index = 142*/
{F_N8X5_K4X2_M0X2(23, 2, 1), 864000000 }, /* freq = (6M * 143), index = 143*/
{F_N8X5_K4X2_M0X2(17, 3, 1), 864000000 }, /* freq = (6M * 144), index = 144*/
{F_N8X5_K4X2_M0X2(23, 2, 1), 864000000 }, /* freq = (6M * 145), index = 145*/
{F_N8X5_K4X2_M0X2(23, 2, 1), 864000000 }, /* freq = (6M * 146), index = 146*/
{F_N8X5_K4X2_M0X2(23, 2, 1), 864000000 }, /* freq = (6M * 147), index = 147*/
{F_N8X5_K4X2_M0X2(23, 2, 1), 864000000 }, /* freq = (6M * 148), index = 148*/
{F_N8X5_K4X2_M0X2(23, 2, 1), 864000000 }, /* freq = (6M * 149), index = 149*/
{F_N8X5_K4X2_M0X2(24, 2, 1), 900000000 }, /* freq = (6M * 150), index = 150*/
{F_N8X5_K4X2_M0X2(24, 2, 1), 900000000 }, /* freq = (6M * 151), index = 151*/
{F_N8X5_K4X2_M0X2(18, 1, 0), 912000000 }, /* freq = (6M * 152), index = 152*/
{F_N8X5_K4X2_M0X2(18, 3, 1), 912000000 }, /* freq = (6M * 153), index = 153*/
{F_N8X5_K4X2_M0X2(18, 3, 1), 912000000 }, /* freq = (6M * 154), index = 154*/
{F_N8X5_K4X2_M0X2(18, 3, 1), 912000000 }, /* freq = (6M * 155), index = 155*/
{F_N8X5_K4X2_M0X2(12, 2, 1), 936000000 }, /* freq = (6M * 156), index = 156*/
{F_N8X5_K4X2_M0X2(25, 2, 1), 936000000 }, /* freq = (6M * 157), index = 157*/
{F_N8X5_K4X2_M0X2(25, 2, 1), 936000000 }, /* freq = (6M * 158), index = 158*/
{F_N8X5_K4X2_M0X2(25, 2, 1), 936000000 }, /* freq = (6M * 159), index = 159*/
{F_N8X5_K4X2_M0X2(19, 1, 0), 960000000 }, /* freq = (6M * 160), index = 160*/
{F_N8X5_K4X2_M0X2(9 , 3, 0), 960000000 }, /* freq = (6M * 161), index = 161*/
{F_N8X5_K4X2_M0X2(9 , 3, 0), 960000000 }, /* freq = (6M * 162), index = 162*/
{F_N8X5_K4X2_M0X2(19, 1, 0), 960000000 }, /* freq = (6M * 163), index = 163*/
{F_N8X5_K4X2_M0X2(9 , 3, 0), 960000000 }, /* freq = (6M * 164), index = 164*/
{F_N8X5_K4X2_M0X2(9 , 3, 0), 960000000 }, /* freq = (6M * 165), index = 165*/
{F_N8X5_K4X2_M0X2(19, 1, 0), 960000000 }, /* freq = (6M * 166), index = 166*/
{F_N8X5_K4X2_M0X2(9 , 3, 0), 960000000 }, /* freq = (6M * 167), index = 167*/
{F_N8X5_K4X2_M0X2(20, 1, 0), 1008000000}, /* freq = (6M * 168), index = 168*/
{F_N8X5_K4X2_M0X2(13, 2, 0), 1008000000}, /* freq = (6M * 169), index = 169*/
{F_N8X5_K4X2_M0X2(20, 1, 0), 1008000000}, /* freq = (6M * 170), index = 170*/
{F_N8X5_K4X2_M0X2(13, 2, 0), 1008000000}, /* freq = (6M * 171), index = 171*/
{F_N8X5_K4X2_M0X2(20, 1, 0), 1008000000}, /* freq = (6M * 172), index = 172*/
{F_N8X5_K4X2_M0X2(13, 2, 0), 1008000000}, /* freq = (6M * 173), index = 173*/
{F_N8X5_K4X2_M0X2(13, 2, 0), 1008000000}, /* freq = (6M * 174), index = 174*/
{F_N8X5_K4X2_M0X2(21, 1, 0), 1056000000}, /* freq = (6M * 175), index = 175*/
{F_N8X5_K4X2_M0X2(10, 3, 0), 1056000000}, /* freq = (6M * 176), index = 176*/
{F_N8X5_K4X2_M0X2(21, 1, 0), 1056000000}, /* freq = (6M * 177), index = 177*/
{F_N8X5_K4X2_M0X2(10, 3, 0), 1056000000}, /* freq = (6M * 178), index = 178*/
{F_N8X5_K4X2_M0X2(21, 1, 0), 1056000000}, /* freq = (6M * 179), index = 179*/
{F_N8X5_K4X2_M0X2(14, 2, 0), 1080000000}, /* freq = (6M * 180), index = 180*/
{F_N8X5_K4X2_M0X2(14, 2, 0), 1080000000}, /* freq = (6M * 181), index = 181*/
{F_N8X5_K4X2_M0X2(14, 2, 0), 1080000000}, /* freq = (6M * 182), index = 182*/
{F_N8X5_K4X2_M0X2(14, 2, 0), 1080000000}, /* freq = (6M * 183), index = 183*/
{F_N8X5_K4X2_M0X2(22, 1, 0), 1104000000}, /* freq = (6M * 184), index = 184*/
{F_N8X5_K4X2_M0X2(22, 1, 0), 1104000000}, /* freq = (6M * 185), index = 185*/
{F_N8X5_K4X2_M0X2(22, 1, 0), 1104000000}, /* freq = (6M * 186), index = 186*/
{F_N8X5_K4X2_M0X2(22, 1, 0), 1104000000}, /* freq = (6M * 187), index = 187*/
{F_N8X5_K4X2_M0X2(22, 1, 0), 1104000000}, /* freq = (6M * 188), index = 188*/
{F_N8X5_K4X2_M0X2(22, 1, 0), 1104000000}, /* freq = (6M * 189), index = 189*/
{F_N8X5_K4X2_M0X2(22, 1, 0), 1104000000}, /* freq = (6M * 190), index = 190*/
{F_N8X5_K4X2_M0X2(22, 1, 0), 1104000000}, /* freq = (6M * 191), index = 191*/
{F_N8X5_K4X2_M0X2(23, 1, 0), 1152000000}, /* freq = (6M * 192), index = 192*/
{F_N8X5_K4X2_M0X2(15, 2, 0), 1152000000}, /* freq = (6M * 193), index = 193*/
{F_N8X5_K4X2_M0X2(11, 3, 0), 1152000000}, /* freq = (6M * 194), index = 194*/
{F_N8X5_K4X2_M0X2(23, 1, 0), 1152000000}, /* freq = (6M * 195), index = 195*/
{F_N8X5_K4X2_M0X2(15, 2, 0), 1152000000}, /* freq = (6M * 196), index = 196*/
{F_N8X5_K4X2_M0X2(11, 3, 0), 1152000000}, /* freq = (6M * 197), index = 197*/
{F_N8X5_K4X2_M0X2(23, 1, 0), 1152000000}, /* freq = (6M * 198), index = 198*/
{F_N8X5_K4X2_M0X2(15, 2, 0), 1152000000}, /* freq = (6M * 199), index = 199*/
{F_N8X5_K4X2_M0X2(24, 1, 0), 1200000000}, /* freq = (6M * 200), index = 200*/
{F_N8X5_K4X2_M0X2(24, 1, 0), 1200000000}, /* freq = (6M * 201), index = 201*/
{F_N8X5_K4X2_M0X2(24, 1, 0), 1200000000}, /* freq = (6M * 202), index = 202*/
{F_N8X5_K4X2_M0X2(24, 1, 0), 1200000000}, /* freq = (6M * 203), index = 203*/
{F_N8X5_K4X2_M0X2(16, 2, 0), 1224000000}, /* freq = (6M * 204), index = 204*/
{F_N8X5_K4X2_M0X2(16, 2, 0), 1224000000}, /* freq = (6M * 205), index = 205*/
{F_N8X5_K4X2_M0X2(16, 2, 0), 1224000000}, /* freq = (6M * 206), index = 206*/
{F_N8X5_K4X2_M0X2(16, 2, 0), 1224000000}, /* freq = (6M * 207), index = 207*/
{F_N8X5_K4X2_M0X2(25, 1, 0), 1248000000}, /* freq = (6M * 208), index = 208*/
{F_N8X5_K4X2_M0X2(12, 3, 0), 1248000000}, /* freq = (6M * 209), index = 209*/
{F_N8X5_K4X2_M0X2(25, 1, 0), 1248000000}, /* freq = (6M * 210), index = 210*/
{F_N8X5_K4X2_M0X2(12, 3, 0), 1248000000}, /* freq = (6M * 211), index = 211*/
{F_N8X5_K4X2_M0X2(25, 1, 0), 1248000000}, /* freq = (6M * 212), index = 212*/
{F_N8X5_K4X2_M0X2(12, 3, 0), 1248000000}, /* freq = (6M * 213), index = 213*/
{F_N8X5_K4X2_M0X2(25, 1, 0), 1248000000}, /* freq = (6M * 214), index = 214*/
{F_N8X5_K4X2_M0X2(12, 3, 0), 1248000000}, /* freq = (6M * 215), index = 215*/
{F_N8X5_K4X2_M0X2(26, 1, 0), 1296000000}, /* freq = (6M * 216), index = 216*/
{F_N8X5_K4X2_M0X2(17, 2, 0), 1296000000}, /* freq = (6M * 217), index = 217*/
{F_N8X5_K4X2_M0X2(26, 1, 0), 1296000000}, /* freq = (6M * 218), index = 218*/
{F_N8X5_K4X2_M0X2(17, 2, 0), 1296000000}, /* freq = (6M * 219), index = 219*/
{F_N8X5_K4X2_M0X2(26, 1, 0), 1296000000}, /* freq = (6M * 220), index = 220*/
{F_N8X5_K4X2_M0X2(17, 2, 0), 1296000000}, /* freq = (6M * 221), index = 221*/
{F_N8X5_K4X2_M0X2(26, 1, 0), 1296000000}, /* freq = (6M * 222), index = 222*/
{F_N8X5_K4X2_M0X2(17, 2, 0), 1296000000}, /* freq = (6M * 223), index = 223*/
{F_N8X5_K4X2_M0X2(27, 1, 0), 1344000000}, /* freq = (6M * 224), index = 224*/
{F_N8X5_K4X2_M0X2(13, 3, 0), 1344000000}, /* freq = (6M * 225), index = 225*/
{F_N8X5_K4X2_M0X2(13, 3, 0), 1344000000}, /* freq = (6M * 226), index = 226*/
{F_N8X5_K4X2_M0X2(13, 3, 0), 1344000000}, /* freq = (6M * 227), index = 227*/
{F_N8X5_K4X2_M0X2(18, 2, 0), 1368000000}, /* freq = (6M * 228), index = 228*/
{F_N8X5_K4X2_M0X2(18, 2, 0), 1368000000}, /* freq = (6M * 229), index = 229*/
{F_N8X5_K4X2_M0X2(18, 2, 0), 1368000000}, /* freq = (6M * 230), index = 230*/
{F_N8X5_K4X2_M0X2(18, 2, 0), 1368000000}, /* freq = (6M * 231), index = 231*/
{F_N8X5_K4X2_M0X2(28, 1, 0), 1392000000}, /* freq = (6M * 232), index = 232*/
{F_N8X5_K4X2_M0X2(28, 1, 0), 1392000000}, /* freq = (6M * 233), index = 233*/
{F_N8X5_K4X2_M0X2(28, 1, 0), 1392000000}, /* freq = (6M * 234), index = 234*/
{F_N8X5_K4X2_M0X2(28, 1, 0), 1392000000}, /* freq = (6M * 235), index = 235*/
{F_N8X5_K4X2_M0X2(28, 1, 0), 1392000000}, /* freq = (6M * 236), index = 236*/
{F_N8X5_K4X2_M0X2(28, 1, 0), 1392000000}, /* freq = (6M * 237), index = 237*/
{F_N8X5_K4X2_M0X2(28, 1, 0), 1392000000}, /* freq = (6M * 238), index = 238*/
{F_N8X5_K4X2_M0X2(28, 1, 0), 1392000000}, /* freq = (6M * 239), index = 239*/
{F_N8X5_K4X2_M0X2(29, 1, 0), 1440000000}, /* freq = (6M * 240), index = 240*/
};

static struct sunxi_clk_factor_freq    factor_pll6_tbl[] = {
{F_N8X5_K4X2(0 , 0), 12000000 }, /* freq = (12M * 0  ), index = 0  */
{F_N8X5_K4X2(0 , 0), 12000000 }, /* freq = (12M * 1  ), index = 1  */
{F_N8X5_K4X2(1 , 0), 24000000 }, /* freq = (12M * 2  ), index = 2  */
{F_N8X5_K4X2(2 , 0), 36000000 }, /* freq = (12M * 3  ), index = 3  */
{F_N8X5_K4X2(3 , 0), 48000000 }, /* freq = (12M * 4  ), index = 4  */
{F_N8X5_K4X2(4 , 0), 60000000 }, /* freq = (12M * 5  ), index = 5  */
{F_N8X5_K4X2(5 , 0), 72000000 }, /* freq = (12M * 6  ), index = 6  */
{F_N8X5_K4X2(6 , 0), 84000000 }, /* freq = (12M * 7  ), index = 7  */
{F_N8X5_K4X2(7 , 0), 96000000 }, /* freq = (12M * 8  ), index = 8  */
{F_N8X5_K4X2(8 , 0), 108000000 }, /* freq = (12M * 9  ), index = 9  */
{F_N8X5_K4X2(9 , 0), 120000000 }, /* freq = (12M * 10 ), index = 10 */
{F_N8X5_K4X2(10 , 0),132000000 }, /* freq = (12M * 11 ), index = 11 */
{F_N8X5_K4X2(11 , 0),144000000 }, /* freq = (12M * 12 ), index = 12 */
{F_N8X5_K4X2(12 , 0),156000000 }, /* freq = (12M * 13 ), index = 13 */
{F_N8X5_K4X2(13 , 0),168000000 }, /* freq = (12M * 14 ), index = 14 */
{F_N8X5_K4X2(14 , 0),180000000 }, /* freq = (12M * 15 ), index = 15 */
{F_N8X5_K4X2(15 , 0),192000000 }, /* freq = (12M * 16 ), index = 16 */
{F_N8X5_K4X2(16 , 0),204000000 }, /* freq = (12M * 17 ), index = 17 */
{F_N8X5_K4X2(17 , 0),216000000 }, /* freq = (12M * 18 ), index = 18 */
{F_N8X5_K4X2(18 , 0),228000000 }, /* freq = (12M * 19 ), index = 19 */
{F_N8X5_K4X2(19 , 0),240000000 }, /* freq = (12M * 20 ), index = 20 */
{F_N8X5_K4X2(20 , 0),252000000 }, /* freq = (12M * 21 ), index = 21 */
{F_N8X5_K4X2(21, 0), 264000000 }, /* freq = (12M * 22 ), index = 22 */
{F_N8X5_K4X2(22, 0), 276000000 }, /* freq = (12M * 23 ), index = 23 */
{F_N8X5_K4X2(23 , 0),288000000 }, /* freq = (12M * 24 ), index = 24 */
{F_N8X5_K4X2(24 , 0),300000000 }, /* freq = (12M * 25 ), index = 25 */
{F_N8X5_K4X2(25, 0), 312000000 }, /* freq = (12M * 26 ), index = 26 */
{F_N8X5_K4X2(26, 0), 324000000 }, /* freq = (12M * 27 ), index = 27 */
{F_N8X5_K4X2(27 , 0),336000000 }, /* freq = (12M * 28 ), index = 28 */
{F_N8X5_K4X2(28, 0), 348000000 }, /* freq = (12M * 29 ), index = 29 */
{F_N8X5_K4X2(29, 0), 360000000 }, /* freq = (12M * 30 ), index = 30 */
{F_N8X5_K4X2(30, 0), 372000000 }, /* freq = (12M * 31 ), index = 31 */
{F_N8X5_K4X2(31 , 0),	384000000 }, /* freq = (12M * 32 ), index = 32 */
{F_N8X5_K4X2(10 , 2),	396000000 }, /* freq = (12M * 33 ), index = 33 */
{F_N8X5_K4X2(16, 1), 408000000}, /* freq = (12M * 34 ), index = 34 */
{F_N8X5_K4X2(16, 1), 408000000}, /* freq = (12M * 35 ), index = 35 */
{F_N8X5_K4X2(17 ,1), 432000000}, /* freq = (12M * 36 ), index = 36 */
{F_N8X5_K4X2(17 ,1), 432000000}, /* freq = (12M * 37 ), index = 37 */
{F_N8X5_K4X2(18, 1), 444000000}, /* freq = (12M * 38 ), index = 38 */
{F_N8X5_K4X2(12 , 2),468000000}, /* freq = (12M * 39 ), index = 39 */
{F_N8X5_K4X2(19 , 1),480000000}, /* freq = (12M * 40 ), index = 40 */
{F_N8X5_K4X2(19 , 1),480000000}, /* freq = (12M * 41 ), index = 41 */
{F_N8X5_K4X2(20, 1), 504000000}, /* freq = (12M * 42 ), index = 42 */
{F_N8X5_K4X2(20, 1), 504000000}, /* freq = (12M * 43 ), index = 43 */
{F_N8X5_K4X2(21, 1), 528000000}, /* freq = (12M * 44 ), index = 44 */
{F_N8X5_K4X2(14, 2), 540000000}, /* freq = (12M * 45 ), index = 45 */
{F_N8X5_K4X2(22, 1), 552000000}, /* freq = (12M * 46 ), index = 46 */
{F_N8X5_K4X2(22, 1), 552000000}, /* freq = (12M * 47 ), index = 47 */
{F_N8X5_K4X2(23 ,1), 576000000}, /* freq = (12M * 48 ), index = 48 */
{F_N8X5_K4X2(23 ,1), 576000000}, /* freq = (12M * 49 ), index = 49 */
{F_N8X5_K4X2(24, 1), 600000000}, /* freq = (12M * 50 ), index = 50 */
};

/* media factors config table, frequency = 24*N/M */
static struct sunxi_clk_factor_freq factor_m_tbl[] = {
{F_N8X7_M0X4(0 , 3), 6000000  }, /* freq = (3M * 0  ), index = 0  */
{F_N8X7_M0X4(0 , 3), 6000000  }, /* freq = (3M * 1  ), index = 1  */
{F_N8X7_M0X4(0 , 3), 6000000  }, /* freq = (3M * 2  ), index = 2  */
{F_N8X7_M0X4(0 , 2), 8000000  }, /* freq = (3M * 3  ), index = 3  */
{F_N8X7_M0X4(1 , 3), 12000000 }, /* freq = (3M * 4  ), index = 4  */
{F_N8X7_M0X4(1 , 2), 16000000 }, /* freq = (3M * 5  ), index = 5  */
{F_N8X7_M0X4(2 , 3), 18000000 }, /* freq = (3M * 6  ), index = 6  */
{F_N8X7_M0X4(2 , 3), 18000000 }, /* freq = (3M * 7  ), index = 7  */
{F_N8X7_M0X4(0 , 0), 24000000 }, /* freq = (3M * 8  ), index = 8  */
{F_N8X7_M0X4(2 , 2), 24000000 }, /* freq = (3M * 9  ), index = 9  */
{F_N8X7_M0X4(4 , 3), 30000000 }, /* freq = (3M * 10 ), index = 10 */
{F_N8X7_M0X4(3 , 2), 32000000 }, /* freq = (3M * 11 ), index = 11 */
{F_N8X7_M0X4(5 , 3), 36000000 }, /* freq = (3M * 12 ), index = 12 */
{F_N8X7_M0X4(4 , 2), 40000000 }, /* freq = (3M * 13 ), index = 13 */
{F_N8X7_M0X4(6 , 3), 42000000 }, /* freq = (3M * 14 ), index = 14 */
{F_N8X7_M0X4(6 , 3), 42000000 }, /* freq = (3M * 15 ), index = 15 */
{F_N8X7_M0X4(1 , 0), 48000000 }, /* freq = (3M * 16 ), index = 16 */
{F_N8X7_M0X4(1 , 0), 48000000 }, /* freq = (3M * 17 ), index = 17 */
{F_N8X7_M0X4(8 , 3), 54000000 }, /* freq = (3M * 18 ), index = 18 */
{F_N8X7_M0X4(6 , 2), 56000000 }, /* freq = (3M * 19 ), index = 19 */
{F_N8X7_M0X4(4 , 1), 60000000 }, /* freq = (3M * 20 ), index = 20 */
{F_N8X7_M0X4(8 , 2), 64000000 }, /* freq = (3M * 21 ), index = 21 */
{F_N8X7_M0X4(10, 3), 66000000 }, /* freq = (3M * 22 ), index = 22 */
{F_N8X7_M0X4(10, 3), 66000000 }, /* freq = (3M * 23 ), index = 23 */
{F_N8X7_M0X4(2 , 0), 72000000 }, /* freq = (3M * 24 ), index = 24 */
{F_N8X7_M0X4(2 , 0), 72000000 }, /* freq = (3M * 25 ), index = 25 */
{F_N8X7_M0X4(12, 3), 78000000 }, /* freq = (3M * 26 ), index = 26 */
{F_N8X7_M0X4(12, 3), 78000000 }, /* freq = (3M * 27 ), index = 27 */
{F_N8X7_M0X4(6 , 1), 84000000 }, /* freq = (3M * 28 ), index = 28 */
{F_N8X7_M0X4(14, 3), 90000000 }, /* freq = (3M * 29 ), index = 29 */
{F_N8X7_M0X4(14, 3), 90000000 }, /* freq = (3M * 30 ), index = 30 */
{F_N8X7_M0X4(14, 3), 90000000 }, /* freq = (3M * 31 ), index = 31 */
{F_N8X7_M0X4(3 , 0), 96000000 }, /* freq = (3M * 32 ), index = 32 */
{F_N8X7_M0X4(3 , 0), 96000000 }, /* freq = (3M * 33 ), index = 33 */
{F_N8X7_M0X4(16, 3), 102000000}, /* freq = (3M * 34 ), index = 34 */
{F_N8X7_M0X4(16, 3), 102000000}, /* freq = (3M * 35 ), index = 35 */
{F_N8X7_M0X4(8 , 1), 108000000}, /* freq = (3M * 36 ), index = 36 */
{F_N8X7_M0X4(8 , 1), 108000000}, /* freq = (3M * 37 ), index = 37 */
{F_N8X7_M0X4(18, 3), 114000000}, /* freq = (3M * 38 ), index = 38 */
{F_N8X7_M0X4(4 , 0), 120000000}, /* freq = (3M * 39 ), index = 39 */
{F_N8X7_M0X4(4 , 0), 120000000}, /* freq = (3M * 40 ), index = 40 */
{F_N8X7_M0X4(4 , 0), 120000000}, /* freq = (3M * 41 ), index = 41 */
{F_N8X7_M0X4(20, 3), 126000000}, /* freq = (3M * 42 ), index = 42 */
{F_N8X7_M0X4(20, 3), 126000000}, /* freq = (3M * 43 ), index = 43 */
{F_N8X7_M0X4(10, 1), 132000000}, /* freq = (3M * 44 ), index = 44 */
{F_N8X7_M0X4(10, 1), 132000000}, /* freq = (3M * 45 ), index = 45 */
{F_N8X7_M0X4(22, 3), 138000000}, /* freq = (3M * 46 ), index = 46 */
{F_N8X7_M0X4(22, 3), 138000000}, /* freq = (3M * 47 ), index = 47 */
{F_N8X7_M0X4(5 , 0), 144000000}, /* freq = (3M * 48 ), index = 48 */
{F_N8X7_M0X4(5 , 0), 144000000}, /* freq = (3M * 49 ), index = 49 */
{F_N8X7_M0X4(24, 3), 150000000}, /* freq = (3M * 50 ), index = 50 */
{F_N8X7_M0X4(24, 3), 150000000}, /* freq = (3M * 51 ), index = 51 */
{F_N8X7_M0X4(12, 1), 156000000}, /* freq = (3M * 52 ), index = 52 */
{F_N8X7_M0X4(12, 1), 156000000}, /* freq = (3M * 53 ), index = 53 */
{F_N8X7_M0X4(12, 1), 156000000}, /* freq = (3M * 54 ), index = 54 */
{F_N8X7_M0X4(6 , 0), 168000000}, /* freq = (3M * 55 ), index = 55 */
{F_N8X7_M0X4(6 , 0), 168000000}, /* freq = (3M * 56 ), index = 56 */
{F_N8X7_M0X4(6 , 0), 168000000}, /* freq = (3M * 57 ), index = 57 */
{F_N8X7_M0X4(6 , 0), 168000000}, /* freq = (3M * 58 ), index = 58 */
{F_N8X7_M0X4(14, 1), 180000000}, /* freq = (3M * 59 ), index = 59 */
{F_N8X7_M0X4(14, 1), 180000000}, /* freq = (3M * 60 ), index = 60 */
{F_N8X7_M0X4(14, 1), 180000000}, /* freq = (3M * 61 ), index = 61 */
{F_N8X7_M0X4(14, 1), 180000000}, /* freq = (3M * 62 ), index = 62 */
{F_N8X7_M0X4(7 , 0), 192000000}, /* freq = (3M * 63 ), index = 63 */
{F_N8X7_M0X4(7 , 0), 192000000}, /* freq = (3M * 64 ), index = 64 */
{F_N8X7_M0X4(7 , 0), 192000000}, /* freq = (3M * 65 ), index = 65 */
{F_N8X7_M0X4(24, 2), 200000000}, /* freq = (3M * 66 ), index = 66 */
{F_N8X7_M0X4(24, 2), 200000000}, /* freq = (3M * 67 ), index = 67 */
{F_N8X7_M0X4(16, 1), 204000000}, /* freq = (3M * 68 ), index = 68 */
{F_N8X7_M0X4(16, 1), 204000000}, /* freq = (3M * 69 ), index = 69 */
{F_N8X7_M0X4(16, 1), 204000000}, /* freq = (3M * 70 ), index = 70 */
{F_N8X7_M0X4(8 , 0), 216000000}, /* freq = (3M * 71 ), index = 71 */
{F_N8X7_M0X4(8 , 0), 216000000}, /* freq = (3M * 72 ), index = 72 */
{F_N8X7_M0X4(8 , 0), 216000000}, /* freq = (3M * 73 ), index = 73 */
{F_N8X7_M0X4(8 , 0), 216000000}, /* freq = (3M * 74 ), index = 74 */
{F_N8X7_M0X4(18, 1), 228000000}, /* freq = (3M * 75 ), index = 75 */
{F_N8X7_M0X4(18, 1), 228000000}, /* freq = (3M * 76 ), index = 76 */
{F_N8X7_M0X4(18, 1), 228000000}, /* freq = (3M * 77 ), index = 77 */
{F_N8X7_M0X4(18, 1), 228000000}, /* freq = (3M * 78 ), index = 78 */
{F_N8X7_M0X4(9 , 0), 240000000}, /* freq = (3M * 79 ), index = 79 */
{F_N8X7_M0X4(9 , 0), 240000000}, /* freq = (3M * 80 ), index = 80 */
{F_N8X7_M0X4(9 , 0), 240000000}, /* freq = (3M * 81 ), index = 81 */
{F_N8X7_M0X4(9 , 0), 240000000}, /* freq = (3M * 82 ), index = 82 */
{F_N8X7_M0X4(20, 1), 252000000}, /* freq = (3M * 83 ), index = 83 */
{F_N8X7_M0X4(20, 1), 252000000}, /* freq = (3M * 84 ), index = 84 */
{F_N8X7_M0X4(20, 1), 252000000}, /* freq = (3M * 85 ), index = 85 */
{F_N8X7_M0X4(20, 1), 252000000}, /* freq = (3M * 86 ), index = 86 */
{F_N8X7_M0X4(10, 0), 264000000}, /* freq = (3M * 87 ), index = 87 */
{F_N8X7_M0X4(10, 0), 264000000}, /* freq = (3M * 88 ), index = 88 */
{F_N8X7_M0X4(22, 1), 276000000}, /* freq = (3M * 89 ), index = 89 */
{F_N8X7_M0X4(10, 0), 270000000}, /* freq = (3M * 90 ), index = 90 */
{F_N8X7_M0X4(22, 1), 276000000}, /* freq = (3M * 91 ), index = 91 */
{F_N8X7_M0X4(22, 1), 276000000}, /* freq = (3M * 92 ), index = 92 */
{F_N8X7_M0X4(11, 0), 288000000}, /* freq = (3M * 93 ), index = 93 */
{F_N8X7_M0X4(11, 0), 288000000}, /* freq = (3M * 94 ), index = 94 */
{F_N8X7_M0X4(11, 0), 288000000}, /* freq = (3M * 95 ), index = 95 */
{F_N8X7_M0X4(11, 0), 288000000}, /* freq = (3M * 96 ), index = 96 */
{F_N8X7_M0X4(11, 0), 288000000}, /* freq = (3M * 97 ), index = 97 */
{F_N8X7_M0X4(11, 0), 288000000}, /* freq = (3M * 98 ), index = 98 */
{F_N8X7_M0X4(98, 7), 297000000}, /* freq = (3M * 99 ), index = 99 */
{F_N8X7_M0X4(24, 1), 300000000}, /* freq = (3M * 100), index = 100*/
{F_N8X7_M0X4(24, 1), 300000000}, /* freq = (3M * 101), index = 101*/
{F_N8X7_M0X4(24, 1), 300000000}, /* freq = (3M * 102), index = 102*/
{F_N8X7_M0X4(12, 0), 312000000}, /* freq = (3M * 103), index = 103*/
{F_N8X7_M0X4(12, 0), 312000000}, /* freq = (3M * 104), index = 104*/
{F_N8X7_M0X4(12, 0), 312000000}, /* freq = (3M * 105), index = 105*/
{F_N8X7_M0X4(12, 0), 312000000}, /* freq = (3M * 106), index = 106*/
{F_N8X7_M0X4(12, 0), 312000000}, /* freq = (3M * 107), index = 107*/
{F_N8X7_M0X4(12, 0), 312000000}, /* freq = (3M * 108), index = 108*/
{F_N8X7_M0X4(12, 0), 312000000}, /* freq = (3M * 109), index = 109*/
{F_N8X7_M0X4(13, 0), 336000000}, /* freq = (3M * 110), index = 110*/
{F_N8X7_M0X4(13, 0), 336000000}, /* freq = (3M * 111), index = 111*/
{F_N8X7_M0X4(13, 0), 336000000}, /* freq = (3M * 112), index = 112*/
{F_N8X7_M0X4(13, 0), 336000000}, /* freq = (3M * 113), index = 113*/
{F_N8X7_M0X4(13, 0), 336000000}, /* freq = (3M * 114), index = 114*/
{F_N8X7_M0X4(13, 0), 336000000}, /* freq = (3M * 115), index = 115*/
{F_N8X7_M0X4(13, 0), 336000000}, /* freq = (3M * 116), index = 116*/
{F_N8X7_M0X4(13, 0), 336000000}, /* freq = (3M * 117), index = 117*/
{F_N8X7_M0X4(14, 0), 360000000}, /* freq = (3M * 118), index = 118*/
{F_N8X7_M0X4(14, 0), 360000000}, /* freq = (3M * 119), index = 119*/
{F_N8X7_M0X4(14, 0), 360000000}, /* freq = (3M * 120), index = 120*/
{F_N8X7_M0X4(14, 0), 360000000}, /* freq = (3M * 121), index = 121*/
{F_N8X7_M0X4(14, 0), 360000000}, /* freq = (3M * 122), index = 122*/
{F_N8X7_M0X4(14, 0), 360000000}, /* freq = (3M * 123), index = 123*/
{F_N8X7_M0X4(14, 0), 360000000}, /* freq = (3M * 124), index = 124*/
{F_N8X7_M0X4(14, 0), 360000000}, /* freq = (3M * 125), index = 125*/
{F_N8X7_M0X4(15, 0), 384000000}, /* freq = (3M * 126), index = 126*/
{F_N8X7_M0X4(15, 0), 384000000}, /* freq = (3M * 127), index = 127*/
{F_N8X7_M0X4(15, 0), 384000000}, /* freq = (3M * 128), index = 128*/
{F_N8X7_M0X4(15, 0), 384000000}, /* freq = (3M * 129), index = 129*/
{F_N8X7_M0X4(15, 0), 384000000}, /* freq = (3M * 130), index = 130*/
{F_N8X7_M0X4(15, 0), 384000000}, /* freq = (3M * 131), index = 131*/
{F_N8X7_M0X4(15, 0), 384000000}, /* freq = (3M * 132), index = 132*/
{F_N8X7_M0X4(16, 0), 408000000}, /* freq = (3M * 133), index = 133*/
{F_N8X7_M0X4(16, 0), 408000000}, /* freq = (3M * 134), index = 134*/
{F_N8X7_M0X4(16, 0), 408000000}, /* freq = (3M * 135), index = 135*/
{F_N8X7_M0X4(16, 0), 408000000}, /* freq = (3M * 136), index = 136*/
{F_N8X7_M0X4(16, 0), 408000000}, /* freq = (3M * 137), index = 137*/
{F_N8X7_M0X4(16, 0), 408000000}, /* freq = (3M * 138), index = 138*/
{F_N8X7_M0X4(16, 0), 408000000}, /* freq = (3M * 139), index = 139*/
{F_N8X7_M0X4(16, 0), 408000000}, /* freq = (3M * 140), index = 140*/
{F_N8X7_M0X4(16, 0), 408000000}, /* freq = (3M * 141), index = 141*/
{F_N8X7_M0X4(17, 0), 432000000}, /* freq = (3M * 142), index = 142*/
{F_N8X7_M0X4(17, 0), 432000000}, /* freq = (3M * 143), index = 143*/
{F_N8X7_M0X4(17, 0), 432000000}, /* freq = (3M * 144), index = 144*/
{F_N8X7_M0X4(17, 0), 432000000}, /* freq = (3M * 145), index = 145*/
{F_N8X7_M0X4(17, 0), 432000000}, /* freq = (3M * 146), index = 146*/
{F_N8X7_M0X4(17, 0), 432000000}, /* freq = (3M * 147), index = 147*/
{F_N8X7_M0X4(17, 0), 432000000}, /* freq = (3M * 148), index = 148*/
{F_N8X7_M0X4(17, 0), 432000000}, /* freq = (3M * 149), index = 149*/
{F_N8X7_M0X4(18, 0), 456000000}, /* freq = (3M * 150), index = 150*/
{F_N8X7_M0X4(18, 0), 456000000}, /* freq = (3M * 151), index = 151*/
{F_N8X7_M0X4(18, 0), 456000000}, /* freq = (3M * 152), index = 152*/
{F_N8X7_M0X4(18, 0), 456000000}, /* freq = (3M * 153), index = 153*/
{F_N8X7_M0X4(18, 0), 456000000}, /* freq = (3M * 154), index = 154*/
{F_N8X7_M0X4(18, 0), 456000000}, /* freq = (3M * 155), index = 155*/
{F_N8X7_M0X4(38, 1), 468000000}, /* freq = (3M * 156), index = 156*/
{F_N8X7_M0X4(19, 0), 480000000}, /* freq = (3M * 157), index = 157*/
{F_N8X7_M0X4(19, 0), 480000000}, /* freq = (3M * 158), index = 158*/
{F_N8X7_M0X4(19, 0), 480000000}, /* freq = (3M * 159), index = 159*/
{F_N8X7_M0X4(19, 0), 480000000}, /* freq = (3M * 160), index = 160*/
{F_N8X7_M0X4(19, 0), 480000000}, /* freq = (3M * 161), index = 161*/
{F_N8X7_M0X4(19, 0), 480000000}, /* freq = (3M * 162), index = 162*/
{F_N8X7_M0X4(19, 0), 480000000}, /* freq = (3M * 163), index = 163*/
{F_N8X7_M0X4(20, 0), 504000000}, /* freq = (3M * 164), index = 164*/
{F_N8X7_M0X4(20, 0), 504000000}, /* freq = (3M * 165), index = 165*/
{F_N8X7_M0X4(20, 0), 504000000}, /* freq = (3M * 166), index = 166*/
{F_N8X7_M0X4(20, 0), 504000000}, /* freq = (3M * 167), index = 167*/
{F_N8X7_M0X4(20, 0), 504000000}, /* freq = (3M * 168), index = 168*/
{F_N8X7_M0X4(20, 0), 504000000}, /* freq = (3M * 169), index = 169*/
{F_N8X7_M0X4(20, 0), 504000000}, /* freq = (3M * 170), index = 170*/
{F_N8X7_M0X4(20, 0), 504000000}, /* freq = (3M * 171), index = 171*/
{F_N8X7_M0X4(20, 0), 504000000}, /* freq = (3M * 172), index = 172*/
{F_N8X7_M0X4(20, 0), 504000000}, /* freq = (3M * 173), index = 173*/
{F_N8X7_M0X4(21, 0), 528000000}, /* freq = (3M * 174), index = 174*/
{F_N8X7_M0X4(21, 0), 528000000}, /* freq = (3M * 175), index = 175*/
{F_N8X7_M0X4(21, 0), 528000000}, /* freq = (3M * 176), index = 176*/
{F_N8X7_M0X4(21, 0), 528000000}, /* freq = (3M * 177), index = 177*/
{F_N8X7_M0X4(21, 0), 528000000}, /* freq = (3M * 178), index = 178*/
{F_N8X7_M0X4(21, 0), 528000000}, /* freq = (3M * 179), index = 179*/
{F_N8X7_M0X4(22, 0), 552000000}, /* freq = (3M * 180), index = 180*/
{F_N8X7_M0X4(22, 0), 552000000}, /* freq = (3M * 181), index = 181*/
{F_N8X7_M0X4(22, 0), 552000000}, /* freq = (3M * 182), index = 182*/
{F_N8X7_M0X4(22, 0), 552000000}, /* freq = (3M * 183), index = 183*/
{F_N8X7_M0X4(22, 0), 552000000}, /* freq = (3M * 184), index = 184*/
{F_N8X7_M0X4(22, 0), 552000000}, /* freq = (3M * 185), index = 185*/
{F_N8X7_M0X4(22, 0), 552000000}, /* freq = (3M * 186), index = 186*/
{F_N8X7_M0X4(22, 0), 552000000}, /* freq = (3M * 187), index = 187*/
{F_N8X7_M0X4(22, 0), 552000000}, /* freq = (3M * 188), index = 188*/
{F_N8X7_M0X4(22, 0), 552000000}, /* freq = (3M * 189), index = 189*/
{F_N8X7_M0X4(23, 0), 576000000}, /* freq = (3M * 190), index = 190*/
{F_N8X7_M0X4(23, 0), 576000000}, /* freq = (3M * 191), index = 191*/
{F_N8X7_M0X4(23, 0), 576000000}, /* freq = (3M * 192), index = 192*/
{F_N8X7_M0X4(23, 0), 576000000}, /* freq = (3M * 193), index = 193*/
{F_N8X7_M0X4(23, 0), 576000000}, /* freq = (3M * 194), index = 194*/
{F_N8X7_M0X4(23, 0), 576000000}, /* freq = (3M * 195), index = 195*/
{F_N8X7_M0X4(23, 0), 576000000}, /* freq = (3M * 196), index = 196*/
{F_N8X7_M0X4(24, 0), 600000000}, /* freq = (3M * 197), index = 197*/
{F_N8X7_M0X4(24, 0), 600000000}, /* freq = (3M * 198), index = 198*/
{F_N8X7_M0X4(24, 0), 600000000}, /* freq = (3M * 199), index = 199*/
{F_N8X7_M0X4(99 , 3), 600000000}, /* freq = (3M * 200), index = 200*/
{F_N8X7_M0X4(99 , 3), 600000000}, /* freq = (3M * 201), index = 201*/
{F_N8X7_M0X4(100, 3), 606000000}, /* freq = (3M * 202), index = 202*/
{F_N8X7_M0X4(100, 3), 606000000}, /* freq = (3M * 203), index = 203*/
{F_N8X7_M0X4(101, 3), 612000000}, /* freq = (3M * 204), index = 204*/
{F_N8X7_M0X4(101, 3), 612000000}, /* freq = (3M * 205), index = 205*/
{F_N8X7_M0X4(102, 3), 618000000}, /* freq = (3M * 206), index = 206*/
{F_N8X7_M0X4(102, 3), 618000000}, /* freq = (3M * 207), index = 207*/
{F_N8X7_M0X4(103, 3), 624000000}, /* freq = (3M * 208), index = 208*/
{F_N8X7_M0X4(103, 3), 624000000}, /* freq = (3M * 209), index = 209*/
{F_N8X7_M0X4(104, 3), 630000000}, /* freq = (3M * 210), index = 210*/
{F_N8X7_M0X4(104, 3), 630000000}, /* freq = (3M * 211), index = 211*/
{F_N8X7_M0X4(105, 3), 636000000}, /* freq = (3M * 212), index = 212*/
{F_N8X7_M0X4(105, 3), 636000000}, /* freq = (3M * 213), index = 213*/
{F_N8X7_M0X4(106, 3), 642000000}, /* freq = (3M * 214), index = 214*/
{F_N8X7_M0X4(106, 3), 642000000}, /* freq = (3M * 215), index = 215*/
{F_N8X7_M0X4(107, 3), 648000000}, /* freq = (3M * 216), index = 216*/
{F_N8X7_M0X4(107, 3), 648000000}, /* freq = (3M * 217), index = 217*/
{F_N8X7_M0X4(108, 3), 654000000}, /* freq = (3M * 218), index = 218*/
{F_N8X7_M0X4(108, 3), 654000000}, /* freq = (3M * 219), index = 219*/
{F_N8X7_M0X4(109, 3), 660000000}, /* freq = (3M * 220), index = 220*/
{F_N8X7_M0X4(109, 3), 660000000}, /* freq = (3M * 221), index = 221*/
{F_N8X7_M0X4(110, 3), 666000000}, /* freq = (3M * 222), index = 222*/
{F_N8X7_M0X4(110, 3), 666000000}, /* freq = (3M * 223), index = 223*/
{F_N8X7_M0X4(111, 3), 672000000}, /* freq = (3M * 224), index = 224*/
{F_N8X7_M0X4(111, 3), 672000000}, /* freq = (3M * 225), index = 225*/
{F_N8X7_M0X4(112, 3), 678000000}, /* freq = (3M * 226), index = 226*/
{F_N8X7_M0X4(112, 3), 678000000}, /* freq = (3M * 227), index = 227*/
{F_N8X7_M0X4(113, 3), 684000000}, /* freq = (3M * 228), index = 228*/
{F_N8X7_M0X4(113, 3), 684000000}, /* freq = (3M * 229), index = 229*/
{F_N8X7_M0X4(114, 3), 690000000}, /* freq = (3M * 230), index = 230*/
{F_N8X7_M0X4(114, 3), 690000000}, /* freq = (3M * 231), index = 231*/
{F_N8X7_M0X4(115, 3), 696000000}, /* freq = (3M * 232), index = 232*/
{F_N8X7_M0X4(115, 3), 696000000}, /* freq = (3M * 233), index = 233*/
{F_N8X7_M0X4(116, 3), 702000000}, /* freq = (3M * 224), index = 234*/
{F_N8X7_M0X4(116, 3), 702000000}, /* freq = (3M * 225), index = 235*/
{F_N8X7_M0X4(117, 3), 708000000}, /* freq = (3M * 226), index = 236*/
{F_N8X7_M0X4(117, 3), 708000000}, /* freq = (3M * 227), index = 237*/
{F_N8X7_M0X4(118, 3), 714000000}, /* freq = (3M * 226), index = 238*/
{F_N8X7_M0X4(118, 3), 714000000}, /* freq = (3M * 227), index = 239*/  
{F_N8X7_M0X4(119, 3), 720000000}, /* freq = (3M * 240), index = 240*/  
};

/*                        ns  nw  ks  kw  ms  mw  ps  pw  d1s  d1w  d2s  d2w  {frac  out  mode}  en-s   sdmss  sdmsw  sdmpat      sdmval*/
SUNXI_CLK_FACTORS(pll1,   8,  5,  4,  2,  0,  2,  16, 2,  0,   0,   0,   0,    0,    0,   0,     31,    0,     0,       0,        0);
SUNXI_CLK_FACTORS(pll2,   8,  7,  0,  0,  0,  5,  16, 4,  0,   0,   0,   0,    0,    0,   0,     31,    0,     0,       0,        0);
SUNXI_CLK_FACTORS(video,  8,  7,  0,  0,  0,  4,  0,  0,  0,   0,   0,   0,    1,    25,  24,    31,    0,     0,       PLL_VIDEOPAT,0xd1303333);
SUNXI_CLK_FACTORS(media,  8,  7,  0,  0,  0,  4,  0,  0,  0,   0,   0,   0,    1,    25,  24,    31,    0,     0,       0,        0);
SUNXI_CLK_FACTORS(pll5,   8,  5,  4,  2,  0,  2,  0,  0,  0,   0,   0,   0,    0,    0,   0,     31,    0,     0,       0,        0);
SUNXI_CLK_FACTORS(pll6,   8,  5,  4,  2,  0,  0,  0,  0,  0,   0,   0,   0,    0,    0,   0,     31,    0,     0,       0,        0);
SUNXI_CLK_FACTORS(mipi,   8,  4,  4,  2,  0,  4,  0,  0,  0,   0,   0,   0,    0,    0,   0,     31,    0,     0,       PLL_MIPIPAT, 0xd1303333);

static int get_factors_pll1(u32 rate, u32 parent_rate, struct clk_factors_value *factor)
{
   int index;
    u64 tmp_rate;
    if(!factor)
        return -1;
    tmp_rate = rate>2016000000 ? 2016000000 : rate;
    do_div(tmp_rate, 6000000);
    index = tmp_rate;
 		if(sunxi_clk_get_common_factors(&sunxi_clk_factor_pll1,factor, factor_pll1_tbl,index,sizeof(factor_pll1_tbl)))
 			return -1;
    return 0;
}

static int get_factors_pll5(u32 rate, u32 parent_rate, struct clk_factors_value *factor)
{
	int index;
	u64 tmp_rate;
	if (!factor)
		return -1;
	tmp_rate = rate > 1440000000 ? 1440000000 : rate;
	do_div(tmp_rate, 6000000);
	index = tmp_rate;
	if (sunxi_clk_get_common_factors(&sunxi_clk_factor_pll5, factor,
					 factor_pll5_tbl, index,
					 sizeof(factor_pll5_tbl)))
		return -1;

	return 0;
}

static int get_factors_pll6(u32 rate, u32 parent_rate, struct clk_factors_value *factor)
{
   int index;
    u64 tmp_rate;
    if(!factor)
        return -1;
    tmp_rate = rate>600000000 ? 600000000 : rate;
    do_div(tmp_rate, 12000000);
    index = tmp_rate;
        if(sunxi_clk_get_common_factors(&sunxi_clk_factor_pll6,factor, factor_pll6_tbl,index,sizeof(factor_pll6_tbl)))
 			return -1;
    return 0;
}
static int get_factors_pll2(u32 rate, u32 parent_rate, struct clk_factors_value *factor)
{
    if(rate == 22579200) {
        factor->factorn = 78;
        factor->factorm = 20;
        factor->factorp = 3;
    } else if(rate == 24576000) {
        factor->factorn = 85;
        factor->factorm = 20;
        factor->factorp = 3;
    } else
        return -1;

    return 0;
}

static int get_factors_media(u32 rate, u32 parent_rate, struct clk_factors_value *factor)
{
    u64 tmp_rate;	
    int index;    
    if(!factor)
        return -1;

    tmp_rate = rate>720000000 ? 7200000000 : rate;
    do_div(tmp_rate, 3000000);
    index = tmp_rate;
 		if(sunxi_clk_get_common_factors(&sunxi_clk_factor_media,factor, factor_m_tbl,index,sizeof(factor_m_tbl)))
 			return -1;
    if(rate == 297000000) {
        factor->frac_mode = 0;
        factor->frac_freq = 1;
    }
    else if(rate == 270000000) {
        factor->frac_mode = 0;
        factor->frac_freq = 0;
    } else {
        factor->frac_mode = 1;
        factor->frac_freq = 0;
    }

    return 0;
}
static int get_factors_mipi(u32 rate, u32 parent_rate, struct clk_factors_value *factor)
{

    u64 tmp_rate;
    u32 delta1,delta2,want_rate,new_rate,save_rate=0;
    int n,k,m;
    if(!factor)
        return -1;
    tmp_rate = rate>1440000000 ? 1440000000 : rate;
    do_div(tmp_rate, 1000000);
    want_rate = tmp_rate;
    for(m=1;			m <=16;	m++)
		for(k=1;			k <=4;	k++)
            for(n=1;			n <=16;	n++)
            {
                new_rate = (parent_rate/1000000)*k*n/m;
                delta1 = (new_rate > want_rate)?(new_rate - want_rate):(want_rate - new_rate);
                delta2 =  (save_rate > want_rate)?(save_rate - want_rate):(want_rate - save_rate);
                if(delta1 < delta2)
                {
                    factor->factorn = n-1;
                    factor->factork = k-1;
                    factor->factorm = m-1;
                    save_rate = new_rate;
                }
            }

    return 0;
}
static unsigned long calc_rate_pll1(u32 parent_rate, struct clk_factors_value *factor)
{
    u64 tmp_rate = (parent_rate?parent_rate:24000000);
    tmp_rate = tmp_rate * (factor->factorn+1) * (factor->factork+1);
    do_div(tmp_rate, (factor->factorm+1)*(1 << factor->factorp));
    return (unsigned long)tmp_rate;
}

static unsigned long calc_rate_pll2(u32 parent_rate, struct clk_factors_value *factor)
{
    u64 tmp_rate = (parent_rate?parent_rate:24000000);
    if((factor->factorn == 78) && (factor->factorm == 20) && (factor->factorp == 3))
        return 22579200;
    else if((factor->factorn == 85) && (factor->factorm == 20) && (factor->factorp == 3))
        return 24576000;
    else
    {
        tmp_rate = tmp_rate * (factor->factorn+1);
        do_div(tmp_rate, (factor->factorm+1) * (factor->factorp+1));;
        return (unsigned long)tmp_rate;
    }
}

static unsigned long calc_rate_media(u32 parent_rate, struct clk_factors_value *factor)
{
    u64 tmp_rate = (parent_rate?parent_rate:24000000);
    if(factor->frac_mode == 0)
    {
        if(factor->frac_freq == 1)
          return 297000000;
        else
          return 270000000;
    }
    else
    {
        tmp_rate = tmp_rate * (factor->factorn+1);
        do_div(tmp_rate, factor->factorm+1);
        return (unsigned long)tmp_rate;
    }
}

static unsigned long calc_rate_pll5(u32 parent_rate, struct clk_factors_value *factor)
{
    u64 tmp_rate = (parent_rate?parent_rate:24000000);
    tmp_rate = tmp_rate * (factor->factorn+1) * (factor->factork+1);
    do_div(tmp_rate, factor->factorm+1);
    return (unsigned long)tmp_rate;
}

static unsigned long calc_rate_pll6(u32 parent_rate, struct clk_factors_value *factor)
{
    return (unsigned long)(parent_rate?(parent_rate/2):12000000) * (factor->factorn+1) * (factor->factork+1);
}
static unsigned long calc_rate_mipi(u32 parent_rate, struct clk_factors_value *factor)
{
    u64 tmp_rate = (parent_rate?parent_rate:24000000);
    tmp_rate = tmp_rate * (factor->factorn+1) * (factor->factork+1);
    do_div(tmp_rate, factor->factorm+1);
    return (unsigned long)tmp_rate;
}
u8 get_parent_mipi(struct clk_hw *hw)
{
    u8 parent;
    unsigned long reg;
	struct sunxi_clk_factors *factor = to_clk_factor(hw);

    if(!factor->reg)
        return 0;
    reg = readl(factor->reg);
    parent = GET_BITS(21, 1, reg);

    return parent;
}


int set_parent_mipi(struct clk_hw *hw, u8 index)
{
    unsigned long reg;
	struct sunxi_clk_factors *factor = to_clk_factor(hw);

    if(!factor->reg)
        return 0;
    reg = readl(factor->reg);
    reg = SET_BITS(21, 1, reg, index);
    writel(reg, factor->reg);
    return 0;
}
static const char *hosc_parents[] = {"hosc"};
static const char *mipi_parents[] = {"pll3",""};
struct clk_ops mipi_ops;
//pll1:cpu,      pll2:audio, pll3:video,   pll4:ve,     pll5:ddr
//pll6:periph0,  pll8:gpu,   pll9:hsic,    pll10:de
struct factor_init_data sunxi_factos[] = {
    /* name  parent        parent_num, flags       reg       lock_reg   lock_bit    config                     get_factors          calc_rate       priv_ops*/
    {"pll1", hosc_parents, 1,CLK_GET_RATE_NOCACHE, PLL1_CFG, PLL1_CFG,  LOCKBIT(28),&sunxi_clk_factor_pll1,  &get_factors_pll1,   &calc_rate_pll1  ,(struct clk_ops*)NULL},
    {"pll2", hosc_parents, 1,          0,          PLL2_CFG, PLL2_CFG,  LOCKBIT(28),&sunxi_clk_factor_pll2,  &get_factors_pll2,   &calc_rate_pll2  ,(struct clk_ops*)NULL},
    {"pll3", hosc_parents, 1,          0,          PLL3_CFG, PLL3_CFG,  LOCKBIT(28),&sunxi_clk_factor_video, &get_factors_media,  &calc_rate_media ,(struct clk_ops*)NULL},
    {"pll4", hosc_parents, 1,          0,          PLL4_CFG, PLL4_CFG,  LOCKBIT(28),&sunxi_clk_factor_media, &get_factors_media,  &calc_rate_media ,(struct clk_ops*)NULL},
    {"pll5", hosc_parents, 1,CLK_GET_RATE_NOCACHE, PLL5_CFG, PLL5_CFG,  LOCKBIT(28),&sunxi_clk_factor_pll5,  &get_factors_pll5,   &calc_rate_pll5  ,(struct clk_ops*)NULL},
    {"pll6", hosc_parents, 1,          0,          PLL6_CFG, PLL6_CFG,  LOCKBIT(28),&sunxi_clk_factor_pll6,	 &get_factors_pll6,   &calc_rate_pll6  ,(struct clk_ops*)NULL},
    {"pll8", hosc_parents, 1,          0,          PLL8_CFG, PLL8_CFG,  LOCKBIT(28),&sunxi_clk_factor_media, &get_factors_media,  &calc_rate_media ,(struct clk_ops*)NULL},
    {"pll9", hosc_parents, 1,          0,          PLL9_CFG, PLL9_CFG,  LOCKBIT(28),&sunxi_clk_factor_media, &get_factors_media,  &calc_rate_media ,(struct clk_ops*)NULL},
    {"pll10",hosc_parents, 1,          0,          PLL10_CFG,PLL10_CFG, LOCKBIT(28),&sunxi_clk_factor_media, &get_factors_media,  &calc_rate_media ,(struct clk_ops*)NULL},
    {"pll_mipi",mipi_parents,2,        0,          MIPI_PLL, MIPI_PLL,  LOCKBIT(28),&sunxi_clk_factor_mipi,  &get_factors_mipi,   &calc_rate_mipi  ,&mipi_ops},
};


struct periph_init_data {
    const char          *name;
    unsigned long       flags;        
    const char          **parent_names;
    int                 num_parents;
    struct sunxi_clk_periph *periph;
};

static const char *cpu_parents[] = {"losc", "hosc", "pll1", "pll1"};
static const char *axi_parents[] = {"cpu"};
static const char *pll6ahb1_parents[] = {"pll6"};
static const char *ahb1_parents[] = {"losc", "hosc", "axi", "pll6ahb1"};
static const char *apb1_parents[] = {"ahb1"};
static const char *apb2_parents[] = {"losc", "hosc", "pll6", "pll6"};
static const char *perph1_parents[] = {"hosc", "pll6"};
static const char *i2s_parents[] = {"pll2x8", "pll2x4", "pll2x2", "pll2"};
static const char *display_parents[] = {"pll3", "", "pll6x2", "pll8", "", "pll10"};
static const char *lcd_parents[] = {"pll3", "", "pll3x2", "", "pll_mipi"};
static const char *csi_s_parents[] = {"pll3", "", "", "pll10", "pll_mipi", "pll4"};
static const char *csi_m_parents[] = {"pll3", "", "", "", "", "hosc"};
static const char *mbus_parents[] = {"hosc", "pll6x2", "pll5"};
static const char *mipidsi_parents[] = {"pll3", "", "pll3x2"};
static const char *mipidphy_parents[] = {"pll3", "", "pll6"};
static const char *adda_parents[] = {"pll2"};
static const char *ve_parents[] = {"pll4"};
static const char *lvds_parents[] = {"lcd0ch0"};
static const char *gpu_parents[] = {"pll8"};
static const char *ahb1mod_parents[] = {"ahb1"};
static const char *apb1mod_parents[] = {"apb1"};
static const char *apb2mod_parents[] = {"apb2"};
static const char *losc_parents[] = {"losc"};
static const char *hoscd2_parents[] = {"hoscd2"};
static const char* hsic_parents[] =  {"pll9"};
struct sunxi_clk_comgate com_gates[]={
{"csi",      0,  0x3,    BUS_GATE_SHARE|RST_GATE_SHARE|MBUS_GATE_SHARE, 0},
{"mipi_dsi", 0,  0x3,    BUS_GATE_SHARE|RST_GATE_SHARE,                 0},
};
/*
SUNXI_CLK_PERIPH(name,    mux_reg,    mux_shift, mux_width, div_reg,    div_mshift, div_mwidth, div_nshift, div_nwidth, gate_flags, enable_reg, reset_reg, bus_gate_reg, drm_gate_reg, enable_shift, reset_shift, bus_gate_shift, dram_gate_shift, lock,com_gate,com_gate_off)
*/
SUNXI_CLK_PERIPH(cpu,     CPU_CFG,    16,        2,         0,          0,          0,          0,          0,          0,          0,          0,         0,            0,            0,            0,           0,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(axi,     0,           0,        0,         CPU_CFG,    0,          2,          0,          0,          0,          0,          0,         0,            0,            0,            0,           0,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(pll6ahb1,0,           0,        0,         AHB1_CFG,   6,          2,          0,          0,          0,          0,          0,         0,            0,            0,            0,           0,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(ahb1,    AHB1_CFG,   12,        2,         AHB1_CFG,   0,          0,          4,          2,          0,          0,          0,         0,            0,            0,            0,           0,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(apb1,    0,           0,        0,         AHB1_CFG,   0,          0,          8,          2,          0,          0,          0,         0,            0,            0,            0,           0,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(apb2,    APB2_CFG,   24,        2,         APB2_CFG,   0,          5,          16,         2,          0,          0,          0,         0,            0,            0,            0,           0,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(nand,    NAND_CFG,   24,        2,         NAND_CFG,   0,          4,          16,         2,          0,          NAND_CFG,   AHB1_RST0, AHB1_GATE0,   0,           31,           13,          13,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(sdmmc0,  SD0_CFG,    24,        2,         SD0_CFG,    0,          4,          16,         2,          0,          SD0_CFG,    AHB1_RST0, AHB1_GATE0,   0,           31,            8,           8,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(sdmmc1,  SD1_CFG,    24,        2,         SD1_CFG,    0,          4,          16,         2,          0,          SD1_CFG,    AHB1_RST0, AHB1_GATE0,   0,           31,            9,           9,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(sdmmc2,  SD2_CFG,    24,        2,         SD2_CFG,    0,          4,          16,         2,          0,          SD2_CFG,    AHB1_RST0, AHB1_GATE0,   0,           31,           10,          10,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(spi0,    SPI0_CFG,   24,        2,         SPI0_CFG,   0,          4,          16,         2,          0,          SPI0_CFG,   AHB1_RST0, AHB1_GATE0,   0,           31,           20,          20,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(spi1,    SPI1_CFG,   24,        2,         SPI1_CFG,   0,          4,          16,         2,          0,          SPI1_CFG,   AHB1_RST0, AHB1_GATE0,   0,           31,           21,          21,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(i2s0,    I2S0_CFG,   16,        2,         0,          0,          0,          0,          0,          0,          I2S0_CFG,   APB1_RST,  APB1_GATE,    0,           31,           12,          12,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(i2s1,    I2S1_CFG,   16,        2,         0,          0,          0,          0,          0,          0,          I2S1_CFG,   APB1_RST,  APB1_GATE,    0,           31,           13,          13,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(usbohci, 0,           0,        0,         0,          0,          0,          0,          0,          0,          USB_CFG,    AHB1_RST0, AHB1_GATE0,   0,           16,           29,          29,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(usbhsic, 0,           0,        0,         0,          0,          0,          0,          0,          0,          USB_CFG,    USB_CFG,   0,            0,           10,            2,           0,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(usbhsic12m,0,         0,        0,         0,          0,          0,          0,          0,          0,          USB_CFG,    0,         0,            0,           11,            0,           0,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(usbehci, 0,           0,        0,         0,          0,          0,          0,          0,          0,          0,          AHB1_RST0, AHB1_GATE0,   0,            0,           26,          26,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(usbotg,  0,           0,        0,         0,          0,          0,          0,          0,          0,          0,          AHB1_RST0, AHB1_GATE0,   0,            0,           24,          24,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(usbphy0, 0,           0,        0,         0,          0,          0,          0,          0,          0,          USB_CFG,    USB_CFG,   0,            0,            8,            0,           0,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(usbphy1, 0,           0,        0,         0,          0,          0,          0,          0,          0,          USB_CFG,    USB_CFG,   0,            0,            9,            1,           0,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(debe0,   BE_CFG,     24,        3,         BE_CFG,     0,          4,          0,          0,          0,          BE_CFG,     AHB1_RST1, AHB1_GATE1,   DRAM_GATE,   31,           12,          12,             26,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(defe0,   FE_CFG,     24,        3,         FE_CFG,     0,          4,          0,          0,          0,          FE_CFG,     AHB1_RST1, AHB1_GATE1,   DRAM_GATE,   31,           14,          14,             24,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(lcd0ch0, LCD_CH0,    24,        3,         0,          0,          0,          0,          0,          0,          LCD_CH0,    AHB1_RST1, AHB1_GATE1,   0,           31,            4,           4,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(csi_s,   CSI_CFG,    24,        3,         CSI_CFG,    16,         4,          0,          0,          0,          CSI_CFG,    AHB1_RST1,  AHB1_GATE1,  DRAM_GATE,   31,            8,           8,              1,               &clk_lock,&com_gates[0],    0);
SUNXI_CLK_PERIPH(csi_m,   CSI_CFG,     8,        3,         CSI_CFG,    0,          4,          0,          0,          0,          CSI_CFG,    AHB1_RST1,  AHB1_GATE1,  DRAM_GATE,   15,            8,           8,              1,               &clk_lock,&com_gates[0],    1);
SUNXI_CLK_PERIPH(ve,      0,           0,        0,         VE_CFG,     16,         3,          0,          0,          0,          VE_CFG,     AHB1_RST1,  AHB1_GATE1,  DRAM_GATE,   31,            0,           0,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(lvds,    0,           0,        0,         0,          0,          0,          0,          0,          0,          0,          AHB1_RST2,  0,           0,            0,            0,           0,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(adda,    0,           0,        0,         0,          0,          0,          0,          0,          0,          ADDA_CFG,   APB1_RST,   APB1_GATE,   0,           31,            0,           0,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(avs,     0,           0,        0,         0,          0,          0,          0,          0,          0,          AVS_CFG,    0,          0,           0,           31,            0,           0,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(mbus,    MBUS_CFG,   24,        2,         MBUS_CFG,   0,          3,          0,          0,          0,          MBUS_CFG,   0,          0,           0,           31,            0,           0,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(mipidsi, MIPI_DSI,   24,        2,         MIPI_DSI,   16,         4,          0,          0,          0,          MIPI_DSI,   AHB1_RST0,  AHB1_GATE0,  0,           31,            1,           1,              0,               &clk_lock,&com_gates[1],    0);
SUNXI_CLK_PERIPH(mipidphy,MIPI_DSI,    8,        2,         MIPI_DSI,   0,          4,          0,          0,          0,          MIPI_DSI,   AHB1_RST0,  AHB1_GATE0,  0,           31,            1,           1,              0,               &clk_lock,&com_gates[1],    1);
SUNXI_CLK_PERIPH(drc0,    DRC_CFG,    24,        3,         DRC_CFG,    0,          4,          0,          0,          0,          DRC_CFG,    AHB1_RST1,  AHB1_GATE1,  DRAM_GATE,   31,           25,          25,             16,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(gpu,     0,           0,        0,         GPU_CFG,    0,          3,          0,          0,          0,          GPU_CFG,    AHB1_RST1,  AHB1_GATE1,  0,           31,           20,          20,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(ats,     ATS_CFG,    24,        2,         ATS_CFG,    0,          3,          0,          0,          0,          ATS_CFG,    0,          0,           0,           31,            0,           0,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(spinlock,0,           0,        0,         0,          0,          0,          0,          0,          0,          0,          AHB1_RST1,  AHB1_GATE1,  0,            0,           22,          22,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(msgbox,  0,           0,        0,         0,          0,          0,          0,          0,          0,          0,          AHB1_RST1,  AHB1_GATE1,  0,            0,           21,          21,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(dma,     0,           0,        0,         0,          0,          0,          0,          0,          0,          0,          AHB1_RST0,  AHB1_GATE0,  0,            0,            6,           6,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(pio,     0,           0,        0,         0,          0,          0,          0,          0,          0,          0,          0,          APB1_GATE,   0,            0,            0,           5,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(twi0,    0,           0,        0,         0,          0,          0,          0,          0,          0,          0,          APB2_RST,   APB2_GATE,   0,            0,            0,           0,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(twi1,    0,           0,        0,         0,          0,          0,          0,          0,          0,          0,          APB2_RST,   APB2_GATE,   0,            0,            1,           1,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(twi2,    0,           0,        0,         0,          0,          0,          0,          0,          0,          0,          APB2_RST,   APB2_GATE,   0,            0,            2,           2,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(uart0,   0,           0,        0,         0,          0,          0,          0,          0,          0,          0,          APB2_RST,   APB2_GATE,   0,            0,           16,          16,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(uart1,   0,           0,        0,         0,          0,          0,          0,          0,          0,          0,          APB2_RST,   APB2_GATE,   0,            0,           17,          17,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(uart2,   0,           0,        0,         0,          0,          0,          0,          0,          0,          0,          APB2_RST,   APB2_GATE,   0,            0,           18,          18,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(uart3,   0,           0,        0,         0,          0,          0,          0,          0,          0,          0,          APB2_RST,   APB2_GATE,   0,            0,           19,          19,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(uart4,   0,           0,        0,         0,          0,          0,          0,          0,          0,          0,          APB2_RST,   APB2_GATE,   0,            0,           20,          20,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(losc_out,0,           0,        0,         0,          0,          0,          0,          0,          0,          0,          0,          LOSC_OUT_GATE,0,           0,            0,           0,              0,               &clk_lock,NULL,             0);

struct periph_init_data sunxi_periphs_init[] = {
    {"cpu",      CLK_GET_RATE_NOCACHE,	cpu_parents,      ARRAY_SIZE(cpu_parents),      &sunxi_clk_periph_cpu},
    {"axi",      0,       				axi_parents,      ARRAY_SIZE(axi_parents),      &sunxi_clk_periph_axi},
    {"pll6ahb1", CLK_IGNORE_SYNCBOOT,   pll6ahb1_parents, ARRAY_SIZE(pll6ahb1_parents),  &sunxi_clk_periph_pll6ahb1},
    {"ahb1",     0,       				ahb1_parents,     ARRAY_SIZE(ahb1_parents),     &sunxi_clk_periph_ahb1},
    {"apb1",     0,       				apb1_parents,     ARRAY_SIZE(apb1_parents),     &sunxi_clk_periph_apb1},
    {"apb2",     0,       				apb2_parents,     ARRAY_SIZE(apb2_parents),     &sunxi_clk_periph_apb2},
    {"nand",     0,       				perph1_parents,   ARRAY_SIZE(perph1_parents),   &sunxi_clk_periph_nand},
    {"sdmmc0",   0,       				perph1_parents,   ARRAY_SIZE(perph1_parents),   &sunxi_clk_periph_sdmmc0},
    {"sdmmc1",   0,       				perph1_parents,   ARRAY_SIZE(perph1_parents),   &sunxi_clk_periph_sdmmc1},
    {"sdmmc2",   0,       				perph1_parents,   ARRAY_SIZE(perph1_parents),   &sunxi_clk_periph_sdmmc2},
    {"spi0",     0,       				perph1_parents,   ARRAY_SIZE(perph1_parents),   &sunxi_clk_periph_spi0},
    {"spi1",     0,       				perph1_parents,   ARRAY_SIZE(perph1_parents),   &sunxi_clk_periph_spi1},
    {"i2s0",     0,       				i2s_parents,      ARRAY_SIZE(i2s_parents),      &sunxi_clk_periph_i2s0},
    {"i2s1",     0,       				i2s_parents,      ARRAY_SIZE(i2s_parents),      &sunxi_clk_periph_i2s1},
    {"usbohci",  0,       				ahb1mod_parents,  ARRAY_SIZE(ahb1mod_parents),  &sunxi_clk_periph_usbohci},
    {"usbhsic",  0,       				hsic_parents,     ARRAY_SIZE(hsic_parents),     &sunxi_clk_periph_usbhsic},
    {"usbhsic12m",0,       				hoscd2_parents,   ARRAY_SIZE(hoscd2_parents),   &sunxi_clk_periph_usbhsic12m},         
    {"usbehci",  0,       				ahb1mod_parents,  ARRAY_SIZE(ahb1mod_parents),  &sunxi_clk_periph_usbehci},
    {"usbotg",   0,       				ahb1mod_parents,  ARRAY_SIZE(ahb1mod_parents),  &sunxi_clk_periph_usbotg},
    {"usbphy0",  0,       				hosc_parents,     ARRAY_SIZE(hosc_parents),     &sunxi_clk_periph_usbphy0},
    {"usbphy1",  0,       				hosc_parents,     ARRAY_SIZE(hosc_parents),     &sunxi_clk_periph_usbphy1},
    {"debe0",    0,       				display_parents,  ARRAY_SIZE(display_parents),  &sunxi_clk_periph_debe0},
    {"defe0",    0,       				display_parents,  ARRAY_SIZE(display_parents),  &sunxi_clk_periph_defe0},
    {"lcd0ch0",  0,       				lcd_parents,      ARRAY_SIZE(lcd_parents),      &sunxi_clk_periph_lcd0ch0},
    {"csi_s",    0,       				csi_s_parents,    ARRAY_SIZE(csi_s_parents),    &sunxi_clk_periph_csi_s},
    {"csi_m",    0,       				csi_m_parents,    ARRAY_SIZE(csi_m_parents),    &sunxi_clk_periph_csi_m},
    {"ve",       0,       				ve_parents,       ARRAY_SIZE(ve_parents),       &sunxi_clk_periph_ve},
    {"lvds",       0,       			lvds_parents,     ARRAY_SIZE(lvds_parents),     &sunxi_clk_periph_lvds},
    {"adda",     0,       				adda_parents,     ARRAY_SIZE(adda_parents),     &sunxi_clk_periph_adda},
    {"avs",      0,       				hosc_parents,     ARRAY_SIZE(hosc_parents),     &sunxi_clk_periph_avs},
    {"mbus",     0,       				mbus_parents,     ARRAY_SIZE(mbus_parents),     &sunxi_clk_periph_mbus},
    {"mipidsi",  0,       				mipidsi_parents,  ARRAY_SIZE(mipidsi_parents),  &sunxi_clk_periph_mipidsi},
    {"mipidphy", 0,       				mipidphy_parents, ARRAY_SIZE(mipidphy_parents), &sunxi_clk_periph_mipidphy},
    {"drc0",     0,       				display_parents,  ARRAY_SIZE(display_parents),  &sunxi_clk_periph_drc0},
    {"gpu",      0,       				gpu_parents,      ARRAY_SIZE(gpu_parents),      &sunxi_clk_periph_gpu},
    {"ats",      0,       				perph1_parents,   ARRAY_SIZE(perph1_parents),   &sunxi_clk_periph_ats},
    {"spinlock", 0,       				ahb1mod_parents,  ARRAY_SIZE(ahb1mod_parents),  &sunxi_clk_periph_spinlock},
    {"msgbox",   0,       				ahb1mod_parents,  ARRAY_SIZE(ahb1mod_parents),  &sunxi_clk_periph_msgbox},
    {"dma",      0,       				ahb1mod_parents,  ARRAY_SIZE(ahb1mod_parents),  &sunxi_clk_periph_dma},
    {"pio",      0,       				apb1mod_parents,  ARRAY_SIZE(apb1mod_parents),  &sunxi_clk_periph_pio},
    {"twi0",     0,       				apb2mod_parents,  ARRAY_SIZE(apb2mod_parents),  &sunxi_clk_periph_twi0},
    {"twi1",     0,       				apb2mod_parents,  ARRAY_SIZE(apb2mod_parents),  &sunxi_clk_periph_twi1},
    {"twi2",     0,       				apb2mod_parents,  ARRAY_SIZE(apb2mod_parents),  &sunxi_clk_periph_twi2},
    {"uart0",    0,       				apb2mod_parents,  ARRAY_SIZE(apb2mod_parents),  &sunxi_clk_periph_uart0},
    {"uart1",    0,       				apb2mod_parents,  ARRAY_SIZE(apb2mod_parents),  &sunxi_clk_periph_uart1},
    {"uart2",    0,       				apb2mod_parents,  ARRAY_SIZE(apb2mod_parents),  &sunxi_clk_periph_uart2},
    {"uart3",    0,       				apb2mod_parents,  ARRAY_SIZE(apb2mod_parents),  &sunxi_clk_periph_uart3},
    {"uart4",    0,       				apb2mod_parents,  ARRAY_SIZE(apb2mod_parents),  &sunxi_clk_periph_uart4},
	{"losc_out",    0,       			losc_parents,     ARRAY_SIZE(losc_parents),     &sunxi_clk_periph_losc_out},    
};


void __init sunxi_init_clocks(void)
{
    int     i;
	struct clk *clk;
    struct factor_init_data *factor;
    struct periph_init_data *periph;
#ifdef CONFIG_SUNXI_CLK_DUMMY_DEBUG
		sunxi_clk_base = &dummy_reg[0]; 
		dummy_reg_init();
#else
    /* get clk register base address */
    sunxi_clk_base = IO_ADDRESS(0x01c20000);
#endif

    /* register oscs */
    clk = clk_register_fixed_rate(NULL, "losc", NULL, CLK_IS_ROOT, 32768);
    clk_register_clkdev(clk, "losc", NULL);

    clk = clk_register_fixed_rate(NULL, "hosc", NULL, CLK_IS_ROOT, 24000000);
    clk_register_clkdev(clk, "hosc", NULL);

    sunxi_clk_get_factors_ops(&mipi_ops);
    mipi_ops.get_parent = get_parent_mipi;
    mipi_ops.set_parent = set_parent_mipi;
    /* register normal factors, based on sunxi factor framework */
    for(i=0; i<ARRAY_SIZE(sunxi_factos); i++) {
        factor = &sunxi_factos[i];
        clk = sunxi_clk_register_factors(NULL,  sunxi_clk_base, &clk_lock,factor);
        clk_register_clkdev(clk, factor->name, NULL);
    }

    /* register fixed factors, based on clk-fixed-factor framework, such as pllx2 for ex. */
    clk = clk_register_fixed_factor(NULL, "pll2x8", "pll2", 0, 8, 1);
    clk_register_clkdev(clk, "pll2x8", NULL);

    clk = clk_register_fixed_factor(NULL, "pll2x4", "pll2", 0, 8, 2);
    clk_register_clkdev(clk, "pll2x4", NULL);

    clk = clk_register_fixed_factor(NULL, "pll2x2", "pll2", 0, 8, 4);
    clk_register_clkdev(clk, "pll2x2", NULL);

    clk = clk_register_fixed_factor(NULL, "pll3x2", "pll3", 0, 2, 1);
    clk_register_clkdev(clk, "pll3x2", NULL);

    clk = clk_register_fixed_factor(NULL, "pll6x2", "pll6", 0, 2, 1);
    clk_register_clkdev(clk, "pll6x2", NULL);

    clk = clk_register_fixed_factor(NULL, "hoscd2", "hosc", 0, 1, 2);
    clk_register_clkdev(clk, "hoscd2", NULL);

    /* register periph clock */
    for(i=0; i<ARRAY_SIZE(sunxi_periphs_init); i++) {
        periph = &sunxi_periphs_init[i];
		if((unsigned int)periph->periph->gate.bus == (unsigned int)LOSC_OUT_GATE)
			clk = sunxi_clk_register_periph(periph->name, periph->parent_names,
					periph->num_parents,periph->flags, IO_ADDRESS(0x00000000), periph->periph);
		else
			clk = sunxi_clk_register_periph(periph->name, periph->parent_names,
					periph->num_parents,periph->flags, sunxi_clk_base, periph->periph);
        clk_register_clkdev(clk, periph->name, NULL);
    }
}

