/*
 * linux/arch/arm/mach-sunxi/sun9i-chip.c
 *
 * Copyright(c) 2014-2016 Allwinnertech Co., Ltd.
 *         http://www.allwinnertech.com
 *
 * Author: sunny <sunny@allwinnertech.com>
 *
 * allwinner sunxi soc chip version and chip id manager.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#ifndef __SUNXI_MACH_SUNXI_CHIP_H
#define __SUNXI_MACH_SUNXI_CHIP_H

#define SUNXI_CHIP_REV(p, v)  (p + v)

/* sunxi platform chip version policy:
 * high 16bit value: platfrom number(Such as: sun8i/sun9i/..)
 * low  16bit value: chip version (Such as: VERSION_A,VERSION_B)
 */
#define SUNXI_CHIP_MASK      (0xFFFF0000)
#define SUNXI_CHIP_SUN8IW1P1 (0x16330000)
#define SUNXI_CHIP_SUN8IW3P1 (0x16500000)
#define SUNXI_CHIP_SUN8IW5P1 (0x16670000)
#define SUNXI_CHIP_SUN8IW6P1 (0x16730000)
#define SUNXI_CHIP_SUN9IW1P1 (0x16390000)

/* sunxi chip versions define */
#define SUN8IW1P1_REV_A SUNXI_CHIP_REV(SUNXI_CHIP_SUN8IW1P1, 0)
#define SUN8IW1P1_REV_B SUNXI_CHIP_REV(SUNXI_CHIP_SUN8IW1P1, 1)
#define SUN8IW1P1_REV_C SUNXI_CHIP_REV(SUNXI_CHIP_SUN8IW1P1, 2)
#define SUN8IW1P1_REV_D SUNXI_CHIP_REV(SUNXI_CHIP_SUN8IW1P1, 3)

#define SUN8IW3P1_REV_A SUNXI_CHIP_REV(SUNXI_CHIP_SUN8IW3P1, 0)
#define SUN8IW3P1_REV_B SUNXI_CHIP_REV(SUNXI_CHIP_SUN8IW3P1, 1)

#define SUN8IW5P1_REV_A SUNXI_CHIP_REV(SUNXI_CHIP_SUN8IW5P1, 0)
#define SUN8IW5P1_REV_B SUNXI_CHIP_REV(SUNXI_CHIP_SUN8IW5P1, 1)

#define SUN8IW6P1_REV_A SUNXI_CHIP_REV(SUNXI_CHIP_SUN8IW6P1, 0)
#define SUN8IW6P1_REV_B SUNXI_CHIP_REV(SUNXI_CHIP_SUN8IW6P1, 1)

#define SUN9IW1P1_REV_A SUNXI_CHIP_REV(SUNXI_CHIP_SUN9IW1P1, 0)
#define SUN9IW1P1_REV_B SUNXI_CHIP_REV(SUNXI_CHIP_SUN9IW1P1, 1)

extern unsigned int sunxi_get_soc_ver(void);
extern int sunxi_get_soc_chipid(u8 *chipid);
extern int sunxi_get_pmu_chipid(u8 *chipid);
extern int sunxi_get_serial(u8 *serial);

/* sunxi platform init functions */
void __init sunxi_soc_ver_init(void);
void __init sunxi_chip_id_init(void);

#endif  /* __SUNXI_MACH_SUNXI_CHIP_H */
