/*
 * arch/arm/mach-sunxi/include/mach/sun9i/irqs-sun9iw1p1.h
 *
 * Copyright(c) 2013-2015 Allwinnertech Co., Ltd.
 *      http://www.allwinnertech.com
 *
 * Author: liugang <liugang@allwinnertech.com>
 *
 * sun9i irq defination header file
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#ifndef __IRQS_SUN9I_W1P1_H
#define __IRQS_SUN9I_W1P1_H

#define SUNXI_IRQ_MAX           (SUNXI_GIC_START + 256)

#if  (defined CONFIG_EVB_PLATFORM) || (defined CONFIG_FPGA_V7_PLATFORM)

#define SUNXI_IRQ_UART0                           (SUNXI_GIC_START + 0  )
#define SUNXI_IRQ_UART1                           (SUNXI_GIC_START + 1  )
#define SUNXI_IRQ_UART2                           (SUNXI_GIC_START + 2  )
#define SUNXI_IRQ_UART3                           (SUNXI_GIC_START + 3  )
#define SUNXI_IRQ_UART4                           (SUNXI_GIC_START + 4  )
#define SUNXI_IRQ_UART5                           (SUNXI_GIC_START + 5  )
#define SUNXI_IRQ_TWI0                            (SUNXI_GIC_START + 6  )
#define SUNXI_IRQ_TWI1                            (SUNXI_GIC_START + 7  )
#define SUNXI_IRQ_TWI2                            (SUNXI_GIC_START + 8  )
#define SUNXI_IRQ_TWI3                            (SUNXI_GIC_START + 9  )
#define SUNXI_IRQ_TWI4                            (SUNXI_GIC_START + 10 )
#define SUNXI_IRQ_EINTA                           (SUNXI_GIC_START + 11 )
#define SUNXI_IRQ_SPDIF                           (SUNXI_GIC_START + 12 )
#define SUNXI_IRQ_DAUDIO_0                        (SUNXI_GIC_START + 13 )
#define SUNXI_IRQ_DAUDIO_1                        (SUNXI_GIC_START + 14 )
#define SUNXI_IRQ_EINTB                           (SUNXI_GIC_START + 15 )
#define SUNXI_IRQ_EINTE                           (SUNXI_GIC_START + 16 )
#define SUNXI_IRQ_EINTG                           (SUNXI_GIC_START + 17 )
#define SUNXI_IRQ_TIMER0                          (SUNXI_GIC_START + 18 )
#define SUNXI_IRQ_TIMER1                          (SUNXI_GIC_START + 19 )
#define SUNXI_IRQ_TIMER2                          (SUNXI_GIC_START + 20 )
#define SUNXI_IRQ_TIMER3                          (SUNXI_GIC_START + 21 )
#define SUNXI_IRQ_TIMER4                          (SUNXI_GIC_START + 22 )
#define SUNXI_IRQ_TIMER5                          (SUNXI_GIC_START + 23 )
#define SUNXI_IRQ_WATCHDOG                        (SUNXI_GIC_START + 24 )
#define SUNXI_IRQ_LRADC                           (SUNXI_GIC_START + 30 )
#define SUNXI_IRQ_NMI                             (SUNXI_GIC_START + 32 )
#define SUNXI_IRQ_R_TIMER0                        (SUNXI_GIC_START + 33 )
#define SUNXI_IRQ_R_TIMER1                        (SUNXI_GIC_START + 34 )
#define SUNXI_IRQ_R_DMA                           (SUNXI_GIC_START + 35 )
#define SUNXI_IRQ_R_WATCHDOG                      (SUNXI_GIC_START + 36 )
#define SUNXI_IRQ_R_CIR_RX                        (SUNXI_GIC_START + 37 )
#define SUNXI_IRQ_R_UART                          (SUNXI_GIC_START + 38 )
#define SUNXI_IRQ_R_RSB                           (SUNXI_GIC_START + 39 )
#define SUNXI_IRQ_R_PS2_0                         (SUNXI_GIC_START + 40 )
#define SUNXI_IRQ_R_PS2_1                         (SUNXI_GIC_START + 41 )
#define SUNXI_IRQ_R_DAUDIO                        (SUNXI_GIC_START + 42 )
#define SUNXI_IRQ_R_ONE_WIRE                      (SUNXI_GIC_START + 43 )
#define SUNXI_IRQ_R_TWI0                          (SUNXI_GIC_START + 44 )
#define SUNXI_IRQ_R_EINTL                         (SUNXI_GIC_START + 45 )
#define SUNXI_IRQ_R_EINTM                         (SUNXI_GIC_START + 46 )
#define SUNXI_IRQ_R_TWI1                          (SUNXI_GIC_START + 47 )
#define SUNXI_IRQ_MBOX                            (SUNXI_GIC_START + 49 )
#define SUNXI_IRQ_DMA                             (SUNXI_GIC_START + 50 )
#define SUNXI_IRQ_HSTIMER0                        (SUNXI_GIC_START + 51 )
#define SUNXI_IRQ_HSTIMER1                        (SUNXI_GIC_START + 52 )
#define SUNXI_IRQ_HSTIMER2                        (SUNXI_GIC_START + 53 )
#define SUNXI_IRQ_HSTIMER3                        (SUNXI_GIC_START + 54 )
#define SUNXI_IRQ_HSTIMER4                        (SUNXI_GIC_START + 55 )
#define SUNXI_IRQ_TZASC                           (SUNXI_GIC_START + 56 )
#define SUNXI_IRQ_VE                              (SUNXI_GIC_START + 58 )
#define SUNXI_IRQ_SDMMC0                          (SUNXI_GIC_START + 60 )
#define SUNXI_IRQ_SDMMC1                          (SUNXI_GIC_START + 61 )
#define SUNXI_IRQ_SDMMC2                          (SUNXI_GIC_START + 62 )
#define SUNXI_IRQ_SDMMC3                          (SUNXI_GIC_START + 63 )
#define SUNXI_IRQ_SPI0                            (SUNXI_GIC_START + 65 )
#define SUNXI_IRQ_SPI1                            (SUNXI_GIC_START + 66 )
#define SUNXI_IRQ_SPI2                            (SUNXI_GIC_START + 67 )
#define SUNXI_IRQ_SPI3                            (SUNXI_GIC_START + 68 )
#define SUNXI_IRQ_NAND1                           (SUNXI_GIC_START + 69 )
#define SUNXI_IRQ_NAND0                           (SUNXI_GIC_START + 70 )

#define SUNXI_IRQ_USB_OTG                         (SUNXI_GIC_START + 71 )
#define SUNXI_IRQ_USB_EHCI0                       (SUNXI_GIC_START + 72 )
#define SUNXI_IRQ_USB_OHCI0                       (SUNXI_GIC_START + 73 )
#define SUNXI_IRQ_USB_EHCI1                       (SUNXI_GIC_START + 74 )
#define SUNXI_IRQ_USB_OHCI1                       (SUNXI_GIC_START + 75 )
#define SUNXI_IRQ_USB_EHCI2                       (SUNXI_GIC_START + 76 )
#define SUNXI_IRQ_USB_OHCI2                       (SUNXI_GIC_START + 77 )
#define SUNXI_IRQ_SS                              (SUNXI_GIC_START + 80 )
#define SUNXI_IRQ_TS                              (SUNXI_GIC_START + 81 )
#define SUNXI_IRQ_GMAC                            (SUNXI_GIC_START + 82 )
#define SUNXI_IRQ_MP                              (SUNXI_GIC_START + 83 )
#define SUNXI_IRQ_CSI0                            (SUNXI_GIC_START + 84 )
#define SUNXI_IRQ_CSI1                            (SUNXI_GIC_START + 85 )
#define SUNXI_IRQ_LCD0                            (SUNXI_GIC_START + 86 )
#define SUNXI_IRQ_LCD1                            (SUNXI_GIC_START + 87 )
#define SUNXI_IRQ_HDMI                            (SUNXI_GIC_START + 88 )
#define SUNXI_IRQ_MIPIDSI                         (SUNXI_GIC_START + 89 )
#define SUNXI_IRQ_MIPI_CSI                        (SUNXI_GIC_START + 90 )
#define SUNXI_IRQ_DRC01                           (SUNXI_GIC_START + 91 )
#define SUNXI_IRQ_DEU01                           (SUNXI_GIC_START + 92 )
#define SUNXI_IRQ_DEFE0                           (SUNXI_GIC_START + 93 )
#define SUNXI_IRQ_DEFE1                           (SUNXI_GIC_START + 94 )
#define SUNXI_IRQ_DEBE0                           (SUNXI_GIC_START + 95 )
#define SUNXI_IRQ_DEBE1                           (SUNXI_GIC_START + 96 )
#define SUNXI_IRQ_GPU                             (SUNXI_GIC_START + 97 )
#define SUNXI_IRQ_GPU_PWR                         (SUNXI_GIC_START + 98 )
#define SUNXI_IRQ_FD                              (SUNXI_GIC_START + 108)
#define SUNXI_IRQ_GPADC                           (SUNXI_GIC_START + 109)
#define SUNXI_IRQ_SATA                            (SUNXI_GIC_START + 110)
#define SUNXI_IRQ_MIPI_HSI                        (SUNXI_GIC_START + 111)
#define SUNXI_IRQ_AC97                            (SUNXI_GIC_START + 112)
#define SUNXI_IRQ_CIR_TX                          (SUNXI_GIC_START + 113)
#define SUNXI_IRQ_THS                             (SUNXI_GIC_START + 115)
#define SUNXI_IRQ_DEBE2                           (SUNXI_GIC_START + 116)
#define SUNXI_IRQ_DEFE2                           (SUNXI_GIC_START + 117)
#define SUNXI_IRQ_EDP                             (SUNXI_GIC_START + 118)
#define SUNXI_IRQ_TWD                             (SUNXI_GIC_START + 119)
#define SUNXI_IRQ_EINTH                           (SUNXI_GIC_START + 120)
#define SUNXI_IRQ_CSI0_CCI                        (SUNXI_GIC_START + 122)
#define SUNXI_IRQ_CSI1_CCI                        (SUNXI_GIC_START + 123)
#define SUNXI_IRQ_AXI_ERR                         (SUNXI_GIC_START + 129)
#define SUNXI_IRQ_PMU                             (SUNXI_GIC_START + 130)
#define SUNXI_IRQ_CTI                             (SUNXI_GIC_START + 131)
#define SUNXI_IRQ_CCI400                          (SUNXI_GIC_START + 134)
#define SUNXI_IRQ_MMU400_0                        (SUNXI_GIC_START + 135)
#define SUNXI_IRQ_MMU400_1                        (SUNXI_GIC_START + 136)
#define SUNXI_IRQ_MMU400_2                        (SUNXI_GIC_START + 137)

#elif defined CONFIG_FPGA_V4_PLATFORM

#define SUNXI_IRQ_UART0                           (SUNXI_GIC_START + 22 )
//#define SUNXI_IRQ_UART1                           (SUNXI_GIC_START + 1  )
//#define SUNXI_IRQ_UART2                           (SUNXI_GIC_START + 2  )
//#define SUNXI_IRQ_UART3                           (SUNXI_GIC_START + 3  )
//#define SUNXI_IRQ_UART4                           (SUNXI_GIC_START + 4  )
//#define SUNXI_IRQ_UART5                           (SUNXI_GIC_START + 5  )
#define SUNXI_IRQ_TWI0                            (SUNXI_GIC_START + 16 )
#define SUNXI_IRQ_TWI1                            (SUNXI_GIC_START + 16 )
#define SUNXI_IRQ_TWI2                            (SUNXI_GIC_START + 16 )
#define SUNXI_IRQ_TWI3                            (SUNXI_GIC_START + 16 )
#define SUNXI_IRQ_TWI4                            (SUNXI_GIC_START + 16 )
#define SUNXI_IRQ_EINTA                           (SUNXI_GIC_START + 29 )
#define SUNXI_IRQ_SPDIF                           (SUNXI_GIC_START + 18 )
#define SUNXI_IRQ_DAUDIO_0                        (SUNXI_GIC_START + 18 )
#define SUNXI_IRQ_DAUDIO_1                        (SUNXI_GIC_START + 18 )
#define SUNXI_IRQ_EINTB                           (SUNXI_GIC_START + 29 )
#define SUNXI_IRQ_EINTE                           (SUNXI_GIC_START + 29 )
#define SUNXI_IRQ_EINTG                           (SUNXI_GIC_START + 29 )
#define SUNXI_IRQ_TIMER0                          (SUNXI_GIC_START + 23 )
//#define SUNXI_IRQ_TIMER1                          (SUNXI_GIC_START + 19 )
//#define SUNXI_IRQ_TIMER2                          (SUNXI_GIC_START + 20 )
//#define SUNXI_IRQ_TIMER3                          (SUNXI_GIC_START + 21 )
#define SUNXI_IRQ_TIMER4                          (SUNXI_GIC_START + 23 )
//#define SUNXI_IRQ_TIMER5                          (SUNXI_GIC_START + 23 )
#define SUNXI_IRQ_WATCHDOG                        (SUNXI_GIC_START + 23 )
//#define SUNXI_IRQ_LRADC                           (SUNXI_GIC_START + 30 )
//#define SUNXI_IRQ_NMI                             (SUNXI_GIC_START + 32 )
#define SUNXI_IRQ_R_TIMER0                        (SUNXI_GIC_START + 27 )
#define SUNXI_IRQ_R_TIMER1                        (SUNXI_GIC_START + 27 )
#define SUNXI_IRQ_R_DMA                           (SUNXI_GIC_START + 26 )
#define SUNXI_IRQ_R_WATCHDOG                      (SUNXI_GIC_START + 27 )
#define SUNXI_IRQ_R_CIR_RX                        (SUNXI_GIC_START + 22 )
#define SUNXI_IRQ_R_UART                          (SUNXI_GIC_START + 22 )
#define SUNXI_IRQ_R_RSB                           (SUNXI_GIC_START + 20 )
//#define SUNXI_IRQ_R_PS2_0                         (SUNXI_GIC_START + 40 )
//#define SUNXI_IRQ_R_PS2_1                         (SUNXI_GIC_START + 41 )
//#define SUNXI_IRQ_R_DAUDIO                        (SUNXI_GIC_START + 42 )
#define SUNXI_IRQ_R_ONE_WIRE                      (SUNXI_GIC_START + 22 )
#define SUNXI_IRQ_R_TWI0                          (SUNXI_GIC_START + 21 )
#define SUNXI_IRQ_R_EINTL                         (SUNXI_GIC_START + 29 )
#define SUNXI_IRQ_R_EINTM                         (SUNXI_GIC_START + 29 )
#define SUNXI_IRQ_R_TWI1                          (SUNXI_GIC_START + 21 )
#define SUNXI_IRQ_MBOX                            (SUNXI_GIC_START + 27 )
#define SUNXI_IRQ_DMA                             (SUNXI_GIC_START + 24 )
#define SUNXI_IRQ_HSTIMER0                        (SUNXI_GIC_START + 25 )
#define SUNXI_IRQ_HSTIMER1                        (SUNXI_GIC_START + 25 )
#define SUNXI_IRQ_HSTIMER2                        (SUNXI_GIC_START + 25 )
#define SUNXI_IRQ_HSTIMER3                        (SUNXI_GIC_START + 25 )
#define SUNXI_IRQ_HSTIMER4                        (SUNXI_GIC_START + 25 )
#define SUNXI_IRQ_TZASC                           (SUNXI_GIC_START + 30 )
#define SUNXI_IRQ_VE                              (SUNXI_GIC_START + 7  )
#define SUNXI_IRQ_SDMMC0                          (SUNXI_GIC_START + 11 )
#define SUNXI_IRQ_SDMMC1                          (SUNXI_GIC_START + 11 )
#define SUNXI_IRQ_SDMMC2                          (SUNXI_GIC_START + 11 )
#define SUNXI_IRQ_SDMMC3                          (SUNXI_GIC_START + 11 )
#define SUNXI_IRQ_SPI0                            (SUNXI_GIC_START + 17 )
#define SUNXI_IRQ_SPI1                            (SUNXI_GIC_START + 17 )
#define SUNXI_IRQ_SPI2                            (SUNXI_GIC_START + 17 )
#define SUNXI_IRQ_SPI3                            (SUNXI_GIC_START + 17 )
#define SUNXI_IRQ_NAND1                           (SUNXI_GIC_START + 9  )
#define SUNXI_IRQ_NAND0                           (SUNXI_GIC_START + 10 )
#define SUNXI_IRQ_USB_OTG                         (SUNXI_GIC_START + 12 )
#define SUNXI_IRQ_USB_EHCI0                       (SUNXI_GIC_START + 13 )
#define SUNXI_IRQ_USB_OHCI0                       (SUNXI_GIC_START + 14 )
#define SUNXI_IRQ_USB_EHCI1                       (SUNXI_GIC_START + 13 )
#define SUNXI_IRQ_USB_OHCI1                       (SUNXI_GIC_START + 14 )
#define SUNXI_IRQ_USB_EHCI2                       (SUNXI_GIC_START + 13 )
#define SUNXI_IRQ_USB_OHCI2                       (SUNXI_GIC_START + 14 )
#define SUNXI_IRQ_SS                              (SUNXI_GIC_START + 19 )
#define SUNXI_IRQ_TS                              (SUNXI_GIC_START + 15 )
#define SUNXI_IRQ_GMAC                            (SUNXI_GIC_START + 15 )
//#define SUNXI_IRQ_MP                              (SUNXI_GIC_START + 83 )
#define SUNXI_IRQ_CSI0                            (SUNXI_GIC_START + 4  )
#define SUNXI_IRQ_CSI1                            (SUNXI_GIC_START + 4  )
#define SUNXI_IRQ_LCD0                            (SUNXI_GIC_START + 0  )
#define SUNXI_IRQ_LCD1                            (SUNXI_GIC_START + 0  )
//#define SUNXI_IRQ_HDMI                            (SUNXI_GIC_START + 88 )
#define SUNXI_IRQ_MIPIDSI                         (SUNXI_GIC_START + 5  )
#define SUNXI_IRQ_MIPI_CSI                        (SUNXI_GIC_START + 4  )
#define SUNXI_IRQ_DRC01                           (SUNXI_GIC_START + 3  )
#define SUNXI_IRQ_DEU01                           (SUNXI_GIC_START + 3  )
#define SUNXI_IRQ_DEFE0                           (SUNXI_GIC_START + 2  )
#define SUNXI_IRQ_DEFE1                           (SUNXI_GIC_START + 2  )
#define SUNXI_IRQ_DEBE0                           (SUNXI_GIC_START + 1  )
#define SUNXI_IRQ_DEBE1                           (SUNXI_GIC_START + 1  )
#define SUNXI_IRQ_GPU                             (SUNXI_GIC_START + 6  )
#define SUNXI_IRQ_GPU_PWR                         (SUNXI_GIC_START + 31 )
#define SUNXI_IRQ_FD                              (SUNXI_GIC_START + 8  )
//#define SUNXI_IRQ_GPADC                           (SUNXI_GIC_START + 109)
//#define SUNXI_IRQ_SATA                            (SUNXI_GIC_START + 110)
#define SUNXI_IRQ_MIPI_HSI                        (SUNXI_GIC_START + 15 )
#define SUNXI_IRQ_AC97                            (SUNXI_GIC_START + 18 )
#define SUNXI_IRQ_CIR_TX                          (SUNXI_GIC_START + 19 )
//#define SUNXI_IRQ_THS                             (SUNXI_GIC_START + 115)
#define SUNXI_IRQ_DEBE2                           (SUNXI_GIC_START + 1  )
#define SUNXI_IRQ_DEFE2                           (SUNXI_GIC_START + 2  )
#define SUNXI_IRQ_EDP                             (SUNXI_GIC_START + 0  )
#define SUNXI_IRQ_TWD                             (SUNXI_GIC_START + 28 )
//#define SUNXI_IRQ_EINTH                           (SUNXI_GIC_START + 120)
//#define SUNXI_IRQ_CSI0_CCI                        (SUNXI_GIC_START + 122)
//#define SUNXI_IRQ_CSI1_CCI                        (SUNXI_GIC_START + 123)
//#define SUNXI_IRQ_AXI_ERR                         (SUNXI_GIC_START + 129)
//#define SUNXI_IRQ_PMU                             (SUNXI_GIC_START + 130)
//#define SUNXI_IRQ_CTI                             (SUNXI_GIC_START + 131)
//#define SUNXI_IRQ_CCI400                          (SUNXI_GIC_START + 134)
//#define SUNXI_IRQ_MMU400_0                        (SUNXI_GIC_START + 135)
//#define SUNXI_IRQ_MMU400_1                        (SUNXI_GIC_START + 136)
//#define SUNXI_IRQ_MMU400_2                        (SUNXI_GIC_START + 137)

#endif

#endif    /* __IRQS_SUN9I_W1P1_H */
